/* structure_model.c generated by valac 0.31.1.17-440e, the Vala compiler
 * generated from structure_model.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2011-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gee.h>


#define TYPE_STRUCT_DATA (struct_data_get_type ())

#define TYPE_STRUCT_TYPE (struct_type_get_type ())
typedef struct _StructData StructData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())

#define TYPE_STRUCT_LIST_COLUMN (struct_list_column_get_type ())

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;
typedef struct _StructureModelPrivate StructureModelPrivate;
#define __g_node_destroy__struct_data_free0_0(var) ((var == NULL) ? NULL : (var = (_g_node_destroy__struct_data_free0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

typedef enum  {
	STRUCT_TYPE_BEGIN_COMMON_TYPES,
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_END_COMMON_TYPES,
	STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_FIGURE,
	STRUCT_TYPE_END_FIGURE,
	STRUCT_TYPE_BEGIN_TABLE,
	STRUCT_TYPE_END_TABLE,
	STRUCT_TYPE_BEGIN_VERBATIM,
	STRUCT_TYPE_END_VERBATIM,
	STRUCT_TYPE_END_DOCUMENT,
	STRUCT_TYPE_CAPTION,
	STRUCT_TYPE_END_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_END_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_NB_TYPES
} StructType;

struct _StructData {
	StructType type;
	gchar* text;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
};

typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;

typedef enum  {
	STRUCT_LIST_COLUMN_PIXBUF,
	STRUCT_LIST_COLUMN_TEXT,
	STRUCT_LIST_COLUMN_TOOLTIP,
	STRUCT_LIST_COLUMN_N_COLUMNS
} StructListColumn;

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()
struct _StructureModel {
	GObject parent_instance;
	StructureModelPrivate * priv;
};

struct _StructureModelClass {
	GObjectClass parent_class;
};

struct _StructureModelPrivate {
	gboolean _emit_signals;
	GType* _column_types;
	gint _column_types_length1;
	gint __column_types_size_;
	GNode* _tree;
	gint _stamp;
	guint _nb_nodes;
	GNode* _end_node;
	GeeArrayList* _list_labels;
	GeeArrayList* _list_includes;
	GeeArrayList* _list_tables;
	GeeArrayList* _list_figures;
	GeeArrayList* _list_todos_and_fixmes;
};


static gpointer structure_model_parent_class = NULL;
static GtkTreeModelIface* structure_model_gtk_tree_model_parent_iface = NULL;

GType struct_data_get_type (void) G_GNUC_CONST;
GType struct_type_get_type (void) G_GNUC_CONST;
StructData* struct_data_dup (const StructData* self);
void struct_data_free (StructData* self);
void struct_data_copy (const StructData* self, StructData* dest);
void struct_data_destroy (StructData* self);
GType struct_column_get_type (void) G_GNUC_CONST;
GType struct_list_column_get_type (void) G_GNUC_CONST;
GQuark struct_error_quark (void);
GType structure_model_get_type (void) G_GNUC_CONST;
#define STRUCTURE_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STRUCTURE_MODEL, StructureModelPrivate))
enum  {
	STRUCTURE_MODEL_DUMMY_PROPERTY,
	STRUCTURE_MODEL_EMIT_SIGNALS
};
static void _struct_data_free0_ (gpointer var);
static void _g_node_destroy__struct_data_free0_ (GNode* self);
static void _g_node_destroy__struct_data_free0_ (GNode* self);
StructureModel* structure_model_new (void);
StructureModel* structure_model_construct (GType object_type);
static void structure_model_new_stamp (StructureModel* self);
static void structure_model_reset_simple_lists (StructureModel* self);
static GtkTreeIter* structure_model_create_iter_at_node (StructureModel* self, GNode* node);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
static gboolean structure_model_iter_is_valid (StructureModel* self, GtkTreeIter* iter);
static GNode* structure_model_get_node_from_iter (StructureModel* self, GtkTreeIter* iter);
static gboolean structure_model_column_is_valid (StructureModel* self, gint index);
static GType structure_model_real_get_column_type (GtkTreeModel* base, gint index);
static gint structure_model_real_get_n_columns (GtkTreeModel* base);
static GtkTreeModelFlags structure_model_real_get_flags (GtkTreeModel* base);
static gboolean structure_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter);
static gint structure_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter);
static void structure_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* val);
gchar* structure_get_icon_from_type (StructType type);
gchar* structure_get_type_name (StructType type);
static gboolean structure_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent);
static gboolean structure_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean structure_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n);
static gboolean structure_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child);
static gboolean structure_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path);
static GtkTreePath* structure_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter);
guint structure_model_get_nb_items (StructureModel* self);
GtkTreeIter* structure_model_add_item_at_end (StructureModel* self, StructData* item);
static void structure_model_search_end_node (StructureModel* self);
gboolean structure_is_section (StructType type);
static GtkTreeIter* structure_model_insert_item_after (StructureModel* self, GNode* parent, GNode* sibling, StructData* item);
GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self, GtkTreeIter* section_iter, GError** error);
void structure_model_delete (StructureModel* self, GtkTreeIter* iter);
static GNode* structure_model_delete_node (StructureModel* self, GNode* node);
static void structure_model_regenerate_simple_lists (StructureModel* self);
void structure_model_modify_data (StructureModel* self, GtkTreePath* path, const gchar* text, GtkTextMark* end_mark);
gboolean structure_model_get_emit_signals (StructureModel* self);
static void structure_model_make_children_between_marks (StructureModel* self, GNode* node);
void structure_model_shift_right (StructureModel* self, GtkTreeIter* iter);
static void structure_model_shift_node (StructureModel* self, GNode* node, gboolean shift_right);
static void structure_model_reinsert_node (StructureModel* self, GNode* node, gboolean force_first_child);
void structure_model_shift_left (StructureModel* self, GtkTreeIter* iter);
gboolean structure_model_item_contains_subparagraph (StructureModel* self, GtkTreeIter* iter);
static gboolean structure_model_node_contains_subparagraph (StructureModel* self, GNode* node);
static void structure_model_insert_node (StructureModel* self, GNode* node, gboolean force_first_child);
static void structure_model_insert_node_in_list (StructureModel* self, GNode* node);
static gint structure_model_compare_nodes (GtkTextMark* mark1, GtkTextMark* mark2);
void structure_model_populate_list (StructureModel* self, GtkListStore* store, StructType type);
static GeeArrayList* structure_model_get_list (StructureModel* self, StructType type);
GtkTreePath* structure_model_get_tree_path_from_list_num (StructureModel* self, StructType list_type, gint num);
gint structure_model_get_list_num_from_tree_iter (StructureModel* self, GtkTreeIter* tree_iter);
static gboolean __lambda49_ (StructureModel* self, GNode* node);
static gboolean ___lambda49__gnode_traverse_func (GNode* node, gpointer self);
void structure_model_set_emit_signals (StructureModel* self, gboolean value);
static void structure_model_finalize (GObject* obj);
static void _vala_structure_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_structure_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void struct_data_copy (const StructData* self, StructData* dest) {
	StructType _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkTextMark* _tmp3_ = NULL;
	GtkTextMark* _tmp4_ = NULL;
	GtkTextMark* _tmp5_ = NULL;
	GtkTextMark* _tmp6_ = NULL;
	_tmp0_ = (*self).type;
	(*dest).type = _tmp0_;
	_tmp1_ = (*self).text;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).text);
	(*dest).text = _tmp2_;
	_tmp3_ = (*self).start_mark;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 ((*dest).start_mark);
	(*dest).start_mark = _tmp4_;
	_tmp5_ = (*self).end_mark;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 ((*dest).end_mark);
	(*dest).end_mark = _tmp6_;
}


void struct_data_destroy (StructData* self) {
	_g_free0 ((*self).text);
	_g_object_unref0 ((*self).start_mark);
	_g_object_unref0 ((*self).end_mark);
}


StructData* struct_data_dup (const StructData* self) {
	StructData* dup;
	dup = g_new0 (StructData, 1);
	struct_data_copy (self, dup);
	return dup;
}


void struct_data_free (StructData* self) {
	struct_data_destroy (self);
	g_free (self);
}


GType struct_data_get_type (void) {
	static volatile gsize struct_data_type_id__volatile = 0;
	if (g_once_init_enter (&struct_data_type_id__volatile)) {
		GType struct_data_type_id;
		struct_data_type_id = g_boxed_type_register_static ("StructData", (GBoxedCopyFunc) struct_data_dup, (GBoxedFreeFunc) struct_data_free);
		g_once_init_leave (&struct_data_type_id__volatile, struct_data_type_id);
	}
	return struct_data_type_id__volatile;
}


GType struct_column_get_type (void) {
	static volatile gsize struct_column_type_id__volatile = 0;
	if (g_once_init_enter (&struct_column_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCT_COLUMN_PIXBUF, "STRUCT_COLUMN_PIXBUF", "pixbuf"}, {STRUCT_COLUMN_TEXT, "STRUCT_COLUMN_TEXT", "text"}, {STRUCT_COLUMN_TOOLTIP, "STRUCT_COLUMN_TOOLTIP", "tooltip"}, {STRUCT_COLUMN_START_MARK, "STRUCT_COLUMN_START_MARK", "start-mark"}, {STRUCT_COLUMN_END_MARK, "STRUCT_COLUMN_END_MARK", "end-mark"}, {STRUCT_COLUMN_TYPE, "STRUCT_COLUMN_TYPE", "type"}, {STRUCT_COLUMN_N_COLUMNS, "STRUCT_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType struct_column_type_id;
		struct_column_type_id = g_enum_register_static ("StructColumn", values);
		g_once_init_leave (&struct_column_type_id__volatile, struct_column_type_id);
	}
	return struct_column_type_id__volatile;
}


GType struct_list_column_get_type (void) {
	static volatile gsize struct_list_column_type_id__volatile = 0;
	if (g_once_init_enter (&struct_list_column_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCT_LIST_COLUMN_PIXBUF, "STRUCT_LIST_COLUMN_PIXBUF", "pixbuf"}, {STRUCT_LIST_COLUMN_TEXT, "STRUCT_LIST_COLUMN_TEXT", "text"}, {STRUCT_LIST_COLUMN_TOOLTIP, "STRUCT_LIST_COLUMN_TOOLTIP", "tooltip"}, {STRUCT_LIST_COLUMN_N_COLUMNS, "STRUCT_LIST_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType struct_list_column_type_id;
		struct_list_column_type_id = g_enum_register_static ("StructListColumn", values);
		g_once_init_leave (&struct_list_column_type_id__volatile, struct_list_column_type_id);
	}
	return struct_list_column_type_id__volatile;
}


GQuark struct_error_quark (void) {
	return g_quark_from_static_string ("struct_error-quark");
}


static void _struct_data_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (struct_data_free (var), NULL));
}


static gboolean _g_node_destroy__struct_data_free0__node (GNode* node, gpointer unused) {
	_struct_data_free0_ (node->data);
	return FALSE;
}


static void _g_node_destroy__struct_data_free0_ (GNode* self) {
	g_node_traverse (self, G_POST_ORDER, G_TRAVERSE_ALL, -1, _g_node_destroy__struct_data_free0__node, NULL);
	g_node_destroy (self);
}


static gpointer _struct_data_dup0 (gpointer self) {
	return self ? struct_data_dup (self) : NULL;
}


StructureModel* structure_model_construct (GType object_type) {
	StructureModel * self = NULL;
	GType* _tmp0_ = NULL;
	GType* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GType _tmp2_ = 0UL;
	GType* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GType _tmp4_ = 0UL;
	GType* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GType _tmp6_ = 0UL;
	GType* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GType _tmp8_ = 0UL;
	GType* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	GType _tmp10_ = 0UL;
	GType* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GType _tmp12_ = 0UL;
	StructData empty_data = {0};
	StructData _tmp13_ = {0};
	StructData _tmp14_ = {0};
	StructData _tmp15_ = {0};
	StructData* _tmp16_ = NULL;
	GNode* _tmp17_ = NULL;
	self = (StructureModel*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (GType, STRUCT_COLUMN_N_COLUMNS);
	self->priv->_column_types = (g_free (self->priv->_column_types), NULL);
	self->priv->_column_types = _tmp0_;
	self->priv->_column_types_length1 = STRUCT_COLUMN_N_COLUMNS;
	self->priv->__column_types_size_ = self->priv->_column_types_length1;
	_tmp1_ = self->priv->_column_types;
	_tmp1__length1 = self->priv->_column_types_length1;
	_tmp1_[STRUCT_COLUMN_PIXBUF] = G_TYPE_STRING;
	_tmp2_ = _tmp1_[STRUCT_COLUMN_PIXBUF];
	_tmp3_ = self->priv->_column_types;
	_tmp3__length1 = self->priv->_column_types_length1;
	_tmp3_[STRUCT_COLUMN_TEXT] = G_TYPE_STRING;
	_tmp4_ = _tmp3_[STRUCT_COLUMN_TEXT];
	_tmp5_ = self->priv->_column_types;
	_tmp5__length1 = self->priv->_column_types_length1;
	_tmp5_[STRUCT_COLUMN_TOOLTIP] = G_TYPE_STRING;
	_tmp6_ = _tmp5_[STRUCT_COLUMN_TOOLTIP];
	_tmp7_ = self->priv->_column_types;
	_tmp7__length1 = self->priv->_column_types_length1;
	_tmp7_[STRUCT_COLUMN_START_MARK] = gtk_text_mark_get_type ();
	_tmp8_ = _tmp7_[STRUCT_COLUMN_START_MARK];
	_tmp9_ = self->priv->_column_types;
	_tmp9__length1 = self->priv->_column_types_length1;
	_tmp9_[STRUCT_COLUMN_END_MARK] = gtk_text_mark_get_type ();
	_tmp10_ = _tmp9_[STRUCT_COLUMN_END_MARK];
	_tmp11_ = self->priv->_column_types;
	_tmp11__length1 = self->priv->_column_types_length1;
	_tmp11_[STRUCT_COLUMN_TYPE] = TYPE_STRUCT_TYPE;
	_tmp12_ = _tmp11_[STRUCT_COLUMN_TYPE];
	empty_data = _tmp13_;
	_tmp14_ = empty_data;
	_tmp15_ = _tmp14_;
	_tmp16_ = _struct_data_dup0 (&_tmp15_);
	_tmp17_ = g_node_new (_tmp16_);
	__g_node_destroy__struct_data_free0_0 (self->priv->_tree);
	self->priv->_tree = _tmp17_;
	structure_model_new_stamp (self);
	structure_model_reset_simple_lists (self);
	struct_data_destroy (&empty_data);
	return self;
}


StructureModel* structure_model_new (void) {
	return structure_model_construct (TYPE_STRUCTURE_MODEL);
}


static void structure_model_new_stamp (StructureModel* self) {
	guint32 _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_random_int ();
	self->priv->_stamp = (gint) _tmp0_;
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static GtkTreeIter* structure_model_create_iter_at_node (StructureModel* self, GNode* node) {
	GtkTreeIter* result = NULL;
	GNode* _tmp0_ = NULL;
	GNode* _tmp1_ = NULL;
	GtkTreeIter new_iter = {0};
	gint _tmp2_ = 0;
	GNode* _tmp3_ = NULL;
	GtkTreeIter* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = self->priv->_tree;
	g_return_val_if_fail (_tmp0_ != _tmp1_, NULL);
	memset (&new_iter, 0, sizeof (GtkTreeIter));
	_tmp2_ = self->priv->_stamp;
	new_iter.stamp = _tmp2_;
	_tmp3_ = node;
	new_iter.user_data = _tmp3_;
	_tmp4_ = __gtk_tree_iter_dup0 (&new_iter);
	result = _tmp4_;
	return result;
}


static gboolean structure_model_iter_is_valid (StructureModel* self, GtkTreeIter* iter) {
	gboolean result = FALSE;
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkTreeIter _tmp3_ = {0};
	void* _tmp4_ = NULL;
	GNode* node = NULL;
	GtkTreeIter _tmp5_ = {0};
	GNode* _tmp6_ = NULL;
	GNode* _tmp7_ = NULL;
	gconstpointer _tmp8_ = NULL;
	StructData data = {0};
	GNode* _tmp9_ = NULL;
	gconstpointer _tmp10_ = NULL;
	StructData _tmp11_ = {0};
	StructData _tmp12_ = {0};
	const gchar* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_tmp1_ = _tmp0_.stamp;
	_tmp2_ = self->priv->_stamp;
	if (_tmp1_ != _tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = *iter;
	_tmp4_ = _tmp3_.user_data;
	if (_tmp4_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp5_ = *iter;
	_tmp6_ = structure_model_get_node_from_iter (self, &_tmp5_);
	node = _tmp6_;
	_tmp7_ = node;
	_tmp8_ = _tmp7_->data;
	if (((StructData*) _tmp8_) == NULL) {
		result = FALSE;
		return result;
	}
	_tmp9_ = node;
	_tmp10_ = _tmp9_->data;
	struct_data_copy ((StructData*) _tmp10_, &_tmp11_);
	data = _tmp11_;
	_tmp12_ = data;
	_tmp13_ = _tmp12_.text;
	if (_tmp13_ == NULL) {
		result = FALSE;
		struct_data_destroy (&data);
		return result;
	}
	result = TRUE;
	struct_data_destroy (&data);
	return result;
}


static gboolean structure_model_column_is_valid (StructureModel* self, gint index) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = index;
	if (0 <= _tmp1_) {
		gint _tmp2_ = 0;
		_tmp2_ = index;
		_tmp0_ = _tmp2_ < ((gint) STRUCT_COLUMN_N_COLUMNS);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static GNode* structure_model_get_node_from_iter (StructureModel* self, GtkTreeIter* iter) {
	GNode* result = NULL;
	GtkTreeIter _tmp0_ = {0};
	void* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	_tmp1_ = _tmp0_.user_data;
	result = (GNode*) _tmp1_;
	return result;
}


/*************************************************************************/
static GType structure_model_real_get_column_type (GtkTreeModel* base, gint index) {
	StructureModel * self;
	GType result = 0UL;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	GType* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	GType _tmp4_ = 0UL;
	self = (StructureModel*) base;
	_tmp0_ = index;
	_tmp1_ = structure_model_column_is_valid (self, _tmp0_);
	g_return_val_if_fail (_tmp1_, G_TYPE_INVALID);
	_tmp2_ = self->priv->_column_types;
	_tmp2__length1 = self->priv->_column_types_length1;
	_tmp3_ = index;
	_tmp4_ = _tmp2_[_tmp3_];
	result = _tmp4_;
	return result;
}


static gint structure_model_real_get_n_columns (GtkTreeModel* base) {
	StructureModel * self;
	gint result = 0;
	self = (StructureModel*) base;
	result = (gint) STRUCT_COLUMN_N_COLUMNS;
	return result;
}


static GtkTreeModelFlags structure_model_real_get_flags (GtkTreeModel* base) {
	StructureModel * self;
	GtkTreeModelFlags result = 0;
	self = (StructureModel*) base;
	result = 0;
	return result;
}


static gboolean structure_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter) {
	StructureModel * self;
	gboolean result = FALSE;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	GNode* node = NULL;
	GtkTreeIter _tmp2_ = {0};
	GNode* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (StructureModel*) base;
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_tmp1_ = structure_model_iter_is_valid (self, &_tmp0_);
	g_return_val_if_fail (_tmp1_, FALSE);
	_tmp2_ = *iter;
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
	node = _tmp3_;
	_tmp4_ = G_NODE_IS_LEAF (node);
	result = !_tmp4_;
	return result;
}


static gint structure_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter) {
	StructureModel * self;
	gint result = 0;
	GNode* node = NULL;
	GtkTreeIter* _tmp0_ = NULL;
	GNode* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	self = (StructureModel*) base;
	_tmp0_ = iter;
	if (_tmp0_ == NULL) {
		GNode* _tmp1_ = NULL;
		_tmp1_ = self->priv->_tree;
		node = _tmp1_;
	} else {
		GtkTreeIter* _tmp2_ = NULL;
		GtkTreeIter _tmp3_ = {0};
		gboolean _tmp4_ = FALSE;
		GtkTreeIter* _tmp5_ = NULL;
		GtkTreeIter _tmp6_ = {0};
		GNode* _tmp7_ = NULL;
		_tmp2_ = iter;
		_tmp3_ = *_tmp2_;
		_tmp4_ = structure_model_iter_is_valid (self, &_tmp3_);
		g_return_val_if_fail (_tmp4_, -1);
		_tmp5_ = iter;
		_tmp6_ = *_tmp5_;
		_tmp7_ = structure_model_get_node_from_iter (self, &_tmp6_);
		node = _tmp7_;
	}
	_tmp8_ = node;
	_tmp9_ = g_node_n_children (_tmp8_);
	result = (gint) _tmp9_;
	return result;
}


static void structure_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* val) {
	StructureModel * self;
	GValue _vala_val = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	GNode* node = NULL;
	GtkTreeIter _tmp4_ = {0};
	GNode* _tmp5_ = NULL;
	StructData data = {0};
	GNode* _tmp6_ = NULL;
	gconstpointer _tmp7_ = NULL;
	StructData _tmp8_ = {0};
	gint _tmp9_ = 0;
	self = (StructureModel*) base;
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	_tmp1_ = structure_model_iter_is_valid (self, &_tmp0_);
	g_return_if_fail (_tmp1_);
	_tmp2_ = column;
	_tmp3_ = structure_model_column_is_valid (self, _tmp2_);
	g_return_if_fail (_tmp3_);
	_tmp4_ = *iter;
	_tmp5_ = structure_model_get_node_from_iter (self, &_tmp4_);
	node = _tmp5_;
	_tmp6_ = node;
	_tmp7_ = _tmp6_->data;
	struct_data_copy ((StructData*) _tmp7_, &_tmp8_);
	data = _tmp8_;
	_tmp9_ = column;
	switch (_tmp9_) {
		case STRUCT_COLUMN_TEXT:
		{
			StructData _tmp10_ = {0};
			const gchar* _tmp11_ = NULL;
			GValue _tmp12_ = {0};
			_tmp10_ = data;
			_tmp11_ = _tmp10_.text;
			g_value_init (&_tmp12_, G_TYPE_STRING);
			g_value_set_string (&_tmp12_, _tmp11_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp12_;
			break;
		}
		case STRUCT_COLUMN_START_MARK:
		{
			StructData _tmp13_ = {0};
			GtkTextMark* _tmp14_ = NULL;
			GValue _tmp15_ = {0};
			_tmp13_ = data;
			_tmp14_ = _tmp13_.start_mark;
			g_value_init (&_tmp15_, gtk_text_mark_get_type ());
			g_value_set_object (&_tmp15_, _tmp14_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp15_;
			break;
		}
		case STRUCT_COLUMN_END_MARK:
		{
			StructData _tmp16_ = {0};
			GtkTextMark* _tmp17_ = NULL;
			GValue _tmp18_ = {0};
			_tmp16_ = data;
			_tmp17_ = _tmp16_.end_mark;
			g_value_init (&_tmp18_, gtk_text_mark_get_type ());
			g_value_set_object (&_tmp18_, _tmp17_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp18_;
			break;
		}
		case STRUCT_COLUMN_TYPE:
		{
			StructData _tmp19_ = {0};
			StructType _tmp20_ = 0;
			GValue _tmp21_ = {0};
			_tmp19_ = data;
			_tmp20_ = _tmp19_.type;
			g_value_init (&_tmp21_, TYPE_STRUCT_TYPE);
			g_value_set_enum (&_tmp21_, _tmp20_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp21_;
			break;
		}
		case STRUCT_COLUMN_PIXBUF:
		{
			StructData _tmp22_ = {0};
			StructType _tmp23_ = 0;
			gchar* _tmp24_ = NULL;
			GValue _tmp25_ = {0};
			_tmp22_ = data;
			_tmp23_ = _tmp22_.type;
			_tmp24_ = structure_get_icon_from_type (_tmp23_);
			g_value_init (&_tmp25_, G_TYPE_STRING);
			g_value_take_string (&_tmp25_, _tmp24_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp25_;
			break;
		}
		case STRUCT_COLUMN_TOOLTIP:
		{
			StructData _tmp26_ = {0};
			StructType _tmp27_ = 0;
			gchar* _tmp28_ = NULL;
			GValue _tmp29_ = {0};
			_tmp26_ = data;
			_tmp27_ = _tmp26_.type;
			_tmp28_ = structure_get_type_name (_tmp27_);
			g_value_init (&_tmp29_, G_TYPE_STRING);
			g_value_take_string (&_tmp29_, _tmp28_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp29_;
			break;
		}
		default:
		{
			g_return_if_reached ();
		}
	}
	struct_data_destroy (&data);
	if (val) {
		*val = _vala_val;
	} else {
		G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
	}
}


static gboolean structure_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent) {
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	GNode* node = NULL;
	GtkTreeIter* _tmp0_ = NULL;
	GNode* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GNode* _tmp10_ = NULL;
	GNode* _tmp11_ = NULL;
	GtkTreeIter* _tmp12_ = NULL;
	GtkTreeIter* _tmp13_ = NULL;
	self = (StructureModel*) base;
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	_tmp0_ = parent;
	if (_tmp0_ == NULL) {
		GNode* _tmp1_ = NULL;
		_tmp1_ = self->priv->_tree;
		node = _tmp1_;
	} else {
		GtkTreeIter* _tmp2_ = NULL;
		GtkTreeIter _tmp3_ = {0};
		gboolean _tmp4_ = FALSE;
		GtkTreeIter* _tmp5_ = NULL;
		GtkTreeIter _tmp6_ = {0};
		GNode* _tmp7_ = NULL;
		_tmp2_ = parent;
		_tmp3_ = *_tmp2_;
		_tmp4_ = structure_model_iter_is_valid (self, &_tmp3_);
		g_return_val_if_fail (_tmp4_, FALSE);
		_tmp5_ = parent;
		_tmp6_ = *_tmp5_;
		_tmp7_ = structure_model_get_node_from_iter (self, &_tmp6_);
		node = _tmp7_;
	}
	_tmp8_ = node;
	_tmp9_ = G_NODE_IS_LEAF (_tmp8_);
	if (_tmp9_) {
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp10_ = node;
	_tmp11_ = g_node_first_child (_tmp10_);
	_tmp12_ = structure_model_create_iter_at_node (self, _tmp11_);
	_tmp13_ = _tmp12_;
	_vala_iter = *_tmp13_;
	_g_free0 (_tmp13_);
	result = TRUE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


static gboolean structure_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter) {
	StructureModel * self;
	gboolean result = FALSE;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	GNode* node = NULL;
	GtkTreeIter _tmp2_ = {0};
	GNode* _tmp3_ = NULL;
	GNode* next_node = NULL;
	GNode* _tmp4_ = NULL;
	GNode* _tmp5_ = NULL;
	GNode* _tmp6_ = NULL;
	GNode* _tmp7_ = NULL;
	GtkTreeIter* _tmp8_ = NULL;
	GtkTreeIter* _tmp9_ = NULL;
	self = (StructureModel*) base;
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_tmp1_ = structure_model_iter_is_valid (self, &_tmp0_);
	g_return_val_if_fail (_tmp1_, FALSE);
	_tmp2_ = *iter;
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
	node = _tmp3_;
	_tmp4_ = node;
	_tmp5_ = g_node_next_sibling (_tmp4_);
	next_node = _tmp5_;
	_tmp6_ = next_node;
	if (_tmp6_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp7_ = next_node;
	_tmp8_ = structure_model_create_iter_at_node (self, _tmp7_);
	_tmp9_ = _tmp8_;
	*iter = *_tmp9_;
	_g_free0 (_tmp9_);
	result = TRUE;
	return result;
}


static gboolean structure_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n) {
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	GNode* node = NULL;
	GtkTreeIter* _tmp0_ = NULL;
	GNode* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_ = 0;
	GNode* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	GNode* _tmp17_ = NULL;
	GtkTreeIter* _tmp18_ = NULL;
	GtkTreeIter* _tmp19_ = NULL;
	self = (StructureModel*) base;
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	_tmp0_ = parent;
	if (_tmp0_ == NULL) {
		GNode* _tmp1_ = NULL;
		_tmp1_ = self->priv->_tree;
		node = _tmp1_;
	} else {
		GtkTreeIter* _tmp2_ = NULL;
		GtkTreeIter _tmp3_ = {0};
		gboolean _tmp4_ = FALSE;
		GtkTreeIter* _tmp5_ = NULL;
		GtkTreeIter _tmp6_ = {0};
		GNode* _tmp7_ = NULL;
		_tmp2_ = parent;
		_tmp3_ = *_tmp2_;
		_tmp4_ = structure_model_iter_is_valid (self, &_tmp3_);
		g_return_val_if_fail (_tmp4_, FALSE);
		_tmp5_ = parent;
		_tmp6_ = *_tmp5_;
		_tmp7_ = structure_model_get_node_from_iter (self, &_tmp6_);
		node = _tmp7_;
	}
	_tmp8_ = node;
	_tmp9_ = G_NODE_IS_LEAF (_tmp8_);
	if (_tmp9_) {
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp11_ = n;
	if (_tmp11_ < 0) {
		_tmp10_ = TRUE;
	} else {
		GNode* _tmp12_ = NULL;
		guint _tmp13_ = 0U;
		gint _tmp14_ = 0;
		_tmp12_ = node;
		_tmp13_ = g_node_n_children (_tmp12_);
		_tmp14_ = n;
		_tmp10_ = _tmp13_ <= ((guint) _tmp14_);
	}
	if (_tmp10_) {
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp15_ = node;
	_tmp16_ = n;
	_tmp17_ = g_node_nth_child (_tmp15_, (guint) _tmp16_);
	_tmp18_ = structure_model_create_iter_at_node (self, _tmp17_);
	_tmp19_ = _tmp18_;
	_vala_iter = *_tmp19_;
	_g_free0 (_tmp19_);
	result = TRUE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


static gboolean structure_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child) {
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	GNode* node = NULL;
	GtkTreeIter _tmp2_ = {0};
	GNode* _tmp3_ = NULL;
	GNode* parent_node = NULL;
	GNode* _tmp4_ = NULL;
	GNode* _tmp5_ = NULL;
	GNode* _tmp6_ = NULL;
	GNode* _tmp7_ = NULL;
	GNode* _tmp8_ = NULL;
	GNode* _tmp9_ = NULL;
	GtkTreeIter* _tmp10_ = NULL;
	GtkTreeIter* _tmp11_ = NULL;
	self = (StructureModel*) base;
	g_return_val_if_fail (child != NULL, FALSE);
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	_tmp0_ = *child;
	_tmp1_ = structure_model_iter_is_valid (self, &_tmp0_);
	g_return_val_if_fail (_tmp1_, FALSE);
	_tmp2_ = *child;
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
	node = _tmp3_;
	_tmp4_ = node;
	_tmp5_ = _tmp4_->parent;
	parent_node = _tmp5_;
	_tmp6_ = parent_node;
	g_return_val_if_fail (_tmp6_ != NULL, FALSE);
	_tmp7_ = parent_node;
	_tmp8_ = self->priv->_tree;
	if (_tmp7_ == _tmp8_) {
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp9_ = parent_node;
	_tmp10_ = structure_model_create_iter_at_node (self, _tmp9_);
	_tmp11_ = _tmp10_;
	_vala_iter = *_tmp11_;
	_g_free0 (_tmp11_);
	result = TRUE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


static gboolean structure_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path) {
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gint depth = 0;
	GtkTreePath* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint* indices = NULL;
	GtkTreePath* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint* _tmp5_ = NULL;
	gint indices_length1 = 0;
	gint _indices_size_ = 0;
	GNode* node = NULL;
	GNode* _tmp6_ = NULL;
	GNode* _tmp22_ = NULL;
	GtkTreeIter* _tmp23_ = NULL;
	GtkTreeIter* _tmp24_ = NULL;
	self = (StructureModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	_tmp0_ = path;
	_tmp1_ = gtk_tree_path_get_depth (_tmp0_);
	depth = _tmp1_;
	_tmp2_ = depth;
	g_return_val_if_fail (1 <= _tmp2_, FALSE);
	_tmp3_ = path;
	_tmp5_ = gtk_tree_path_get_indices_with_depth (_tmp3_, &_tmp4_);
	indices = _tmp5_;
	indices_length1 = _tmp4_;
	_indices_size_ = indices_length1;
	_tmp6_ = self->priv->_tree;
	node = _tmp6_;
	{
		gint cur_depth = 0;
		cur_depth = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint indice = 0;
				gint* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gboolean _tmp14_ = FALSE;
				gint _tmp15_ = 0;
				GNode* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				GNode* _tmp21_ = NULL;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = cur_depth;
					cur_depth = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = cur_depth;
				_tmp10_ = depth;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = indices;
				_tmp11__length1 = indices_length1;
				_tmp12_ = cur_depth;
				_tmp13_ = _tmp11_[_tmp12_];
				indice = _tmp13_;
				_tmp15_ = indice;
				if (_tmp15_ < 0) {
					_tmp14_ = TRUE;
				} else {
					GNode* _tmp16_ = NULL;
					guint _tmp17_ = 0U;
					gint _tmp18_ = 0;
					_tmp16_ = node;
					_tmp17_ = g_node_n_children (_tmp16_);
					_tmp18_ = indice;
					_tmp14_ = _tmp17_ <= ((guint) _tmp18_);
				}
				if (_tmp14_) {
					result = FALSE;
					if (iter) {
						*iter = _vala_iter;
					}
					return result;
				}
				_tmp19_ = node;
				_tmp20_ = indice;
				_tmp21_ = g_node_nth_child (_tmp19_, (guint) _tmp20_);
				node = _tmp21_;
			}
		}
	}
	_tmp22_ = node;
	_tmp23_ = structure_model_create_iter_at_node (self, _tmp22_);
	_tmp24_ = _tmp23_;
	_vala_iter = *_tmp24_;
	_g_free0 (_tmp24_);
	result = TRUE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


static GtkTreePath* structure_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter) {
	StructureModel * self;
	GtkTreePath* result = NULL;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp2_ = NULL;
	GNode* node = NULL;
	GtkTreeIter _tmp3_ = {0};
	GNode* _tmp4_ = NULL;
	self = (StructureModel*) base;
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	_tmp1_ = structure_model_iter_is_valid (self, &_tmp0_);
	g_return_val_if_fail (_tmp1_, NULL);
	_tmp2_ = gtk_tree_path_new ();
	path = _tmp2_;
	_tmp3_ = *iter;
	_tmp4_ = structure_model_get_node_from_iter (self, &_tmp3_);
	node = _tmp4_;
	while (TRUE) {
		GNode* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gint pos = 0;
		GNode* _tmp7_ = NULL;
		GNode* _tmp8_ = NULL;
		GNode* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		GtkTreePath* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		GNode* _tmp13_ = NULL;
		GNode* _tmp14_ = NULL;
		_tmp5_ = node;
		_tmp6_ = G_NODE_IS_ROOT (_tmp5_);
		if (!(!_tmp6_)) {
			break;
		}
		_tmp7_ = node;
		_tmp8_ = _tmp7_->parent;
		_tmp9_ = node;
		_tmp10_ = g_node_child_position (_tmp8_, _tmp9_);
		pos = _tmp10_;
		_tmp11_ = path;
		_tmp12_ = pos;
		gtk_tree_path_prepend_index (_tmp11_, _tmp12_);
		_tmp13_ = node;
		_tmp14_ = _tmp13_->parent;
		node = _tmp14_;
	}
	result = path;
	return result;
}


/*************************************************************************/
guint structure_model_get_nb_items (StructureModel* self) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_nb_nodes;
	result = _tmp0_;
	return result;
}


GtkTreeIter* structure_model_add_item_at_end (StructureModel* self, StructData* item) {
	GtkTreeIter* result = NULL;
	GNode* _tmp0_ = NULL;
	StructType item_depth = 0;
	StructData _tmp1_ = {0};
	StructType _tmp2_ = 0;
	GNode* parent = NULL;
	GNode* _tmp3_ = NULL;
	GNode* prev_sibling = NULL;
	GtkTreeIter* end_iter = NULL;
	GNode* _tmp17_ = NULL;
	GNode* _tmp18_ = NULL;
	StructData _tmp19_ = {0};
	GtkTreeIter* _tmp20_ = NULL;
	GtkTreeIter* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = self->priv->_end_node;
	if (_tmp0_ == NULL) {
		structure_model_search_end_node (self);
	}
	_tmp1_ = *item;
	_tmp2_ = _tmp1_.type;
	item_depth = _tmp2_;
	_tmp3_ = self->priv->_end_node;
	parent = _tmp3_;
	prev_sibling = NULL;
	while (TRUE) {
		GNode* _tmp4_ = NULL;
		GNode* _tmp5_ = NULL;
		StructType cur_depth = 0;
		GNode* _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		StructType _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		StructType _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
		GNode* _tmp14_ = NULL;
		GNode* _tmp15_ = NULL;
		GNode* _tmp16_ = NULL;
		_tmp4_ = parent;
		_tmp5_ = self->priv->_tree;
		if (_tmp4_ == _tmp5_) {
			break;
		}
		_tmp6_ = parent;
		_tmp7_ = _tmp6_->data;
		_tmp8_ = (*((StructData*) _tmp7_)).type;
		cur_depth = _tmp8_;
		_tmp10_ = cur_depth;
		_tmp11_ = structure_is_section (_tmp10_);
		if (_tmp11_) {
			StructType _tmp12_ = 0;
			StructType _tmp13_ = 0;
			_tmp12_ = cur_depth;
			_tmp13_ = item_depth;
			_tmp9_ = _tmp12_ < _tmp13_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			break;
		}
		_tmp14_ = parent;
		prev_sibling = _tmp14_;
		_tmp15_ = parent;
		_tmp16_ = _tmp15_->parent;
		parent = _tmp16_;
	}
	_tmp17_ = parent;
	_tmp18_ = prev_sibling;
	_tmp19_ = *item;
	_tmp20_ = structure_model_insert_item_after (self, _tmp17_, _tmp18_, &_tmp19_);
	end_iter = _tmp20_;
	_tmp21_ = end_iter;
	if (_tmp21_ != NULL) {
		GtkTreeIter* _tmp22_ = NULL;
		GtkTreeIter _tmp23_ = {0};
		GNode* _tmp24_ = NULL;
		_tmp22_ = end_iter;
		_tmp23_ = *_tmp22_;
		_tmp24_ = structure_model_get_node_from_iter (self, &_tmp23_);
		self->priv->_end_node = _tmp24_;
	}
	result = end_iter;
	return result;
}


GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self, GtkTreeIter* section_iter, GError** error) {
	GtkTreeIter* result = NULL;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	GNode* cur_node = NULL;
	GtkTreeIter _tmp3_ = {0};
	GNode* _tmp4_ = NULL;
	GNode* _tmp5_ = NULL;
	gconstpointer _tmp6_ = NULL;
	StructType _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (section_iter != NULL, NULL);
	_tmp0_ = *section_iter;
	_tmp1_ = structure_model_iter_is_valid (self, &_tmp0_);
	if (!_tmp1_) {
		GError* _tmp2_ = NULL;
		_tmp2_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, "iter is not valid.");
		_inner_error_ = _tmp2_;
		if (_inner_error_->domain == STRUCT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = *section_iter;
	_tmp4_ = structure_model_get_node_from_iter (self, &_tmp3_);
	cur_node = _tmp4_;
	_tmp5_ = cur_node;
	_tmp6_ = _tmp5_->data;
	_tmp7_ = (*((StructData*) _tmp6_)).type;
	_tmp8_ = structure_is_section (_tmp7_);
	if (!_tmp8_) {
		GError* _tmp9_ = NULL;
		_tmp9_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, "iter is not a section.");
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == STRUCT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		gboolean _tmp10_ = FALSE;
		GNode* _tmp11_ = NULL;
		GNode* next_sibling_node = NULL;
		GNode* _tmp14_ = NULL;
		GNode* _tmp15_ = NULL;
		GNode* _tmp16_ = NULL;
		GNode* _tmp19_ = NULL;
		GNode* _tmp20_ = NULL;
		_tmp11_ = cur_node;
		if (_tmp11_ != NULL) {
			GNode* _tmp12_ = NULL;
			GNode* _tmp13_ = NULL;
			_tmp12_ = cur_node;
			_tmp13_ = self->priv->_tree;
			_tmp10_ = _tmp12_ != _tmp13_;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			break;
		}
		_tmp14_ = cur_node;
		_tmp15_ = g_node_next_sibling (_tmp14_);
		next_sibling_node = _tmp15_;
		_tmp16_ = next_sibling_node;
		if (_tmp16_ != NULL) {
			GNode* _tmp17_ = NULL;
			GtkTreeIter* _tmp18_ = NULL;
			_tmp17_ = next_sibling_node;
			_tmp18_ = structure_model_create_iter_at_node (self, _tmp17_);
			result = _tmp18_;
			return result;
		}
		_tmp19_ = cur_node;
		_tmp20_ = _tmp19_->parent;
		cur_node = _tmp20_;
	}
	result = NULL;
	return result;
}


void structure_model_delete (StructureModel* self, GtkTreeIter* iter) {
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	GNode* node = NULL;
	GtkTreeIter _tmp2_ = {0};
	GNode* _tmp3_ = NULL;
	GNode* _tmp4_ = NULL;
	GNode* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	_tmp1_ = structure_model_iter_is_valid (self, &_tmp0_);
	g_return_if_fail (_tmp1_);
	_tmp2_ = *iter;
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
	node = _tmp3_;
	_tmp4_ = structure_model_delete_node (self, node);
	_tmp5_ = _tmp4_;
	__g_node_destroy__struct_data_free0_0 (_tmp5_);
	self->priv->_end_node = NULL;
	structure_model_regenerate_simple_lists (self);
}


void structure_model_modify_data (StructureModel* self, GtkTreePath* path, const gchar* text, GtkTextMark* end_mark) {
	GtkTreeIter iter = {0};
	gboolean iter_is_valid = FALSE;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GNode* node = NULL;
	GtkTreeIter _tmp4_ = {0};
	GNode* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GNode* _tmp8_ = NULL;
	gconstpointer _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GNode* _tmp11_ = NULL;
	gconstpointer _tmp12_ = NULL;
	GtkTextMark* _tmp13_ = NULL;
	GtkTextMark* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	GNode* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (end_mark != NULL);
	_tmp0_ = path;
	_tmp2_ = gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp1_, _tmp0_);
	iter = _tmp1_;
	iter_is_valid = _tmp2_;
	_tmp3_ = iter_is_valid;
	g_return_if_fail (_tmp3_);
	_tmp4_ = iter;
	_tmp5_ = structure_model_get_node_from_iter (self, &_tmp4_);
	node = _tmp5_;
	structure_model_new_stamp (self);
	_tmp7_ = text;
	_tmp6_ = _tmp7_;
	if (_tmp6_ == NULL) {
		_tmp6_ = "";
	}
	_tmp8_ = node;
	_tmp9_ = _tmp8_->data;
	_tmp10_ = g_strdup (_tmp6_);
	_g_free0 ((*((StructData*) _tmp9_)).text);
	(*((StructData*) _tmp9_)).text = _tmp10_;
	_tmp11_ = node;
	_tmp12_ = _tmp11_->data;
	_tmp13_ = end_mark;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 ((*((StructData*) _tmp12_)).end_mark);
	(*((StructData*) _tmp12_)).end_mark = _tmp14_;
	_tmp15_ = self->priv->_emit_signals;
	if (_tmp15_) {
		GtkTreePath* _tmp16_ = NULL;
		GtkTreeIter _tmp17_ = {0};
		_tmp16_ = path;
		_tmp17_ = iter;
		gtk_tree_model_row_changed ((GtkTreeModel*) self, _tmp16_, &_tmp17_);
	}
	_tmp18_ = node;
	structure_model_make_children_between_marks (self, _tmp18_);
}


void structure_model_shift_right (StructureModel* self, GtkTreeIter* iter) {
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	GNode* node = NULL;
	GtkTreeIter _tmp2_ = {0};
	GNode* _tmp3_ = NULL;
	StructType type = 0;
	GNode* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	StructType _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	StructType _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	StructType new_type = 0;
	StructType _tmp11_ = 0;
	GNode* new_parent = NULL;
	GNode* _tmp12_ = NULL;
	GNode* _tmp13_ = NULL;
	gint new_pos = 0;
	gboolean _tmp14_ = FALSE;
	GNode* _tmp15_ = NULL;
	GNode* node_unlinked = NULL;
	GNode* _tmp25_ = NULL;
	GNode* _tmp26_ = NULL;
	GNode* _tmp27_ = NULL;
	GNode* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	GNode* _tmp30_ = NULL;
	GNode* _tmp31_ = NULL;
	GNode* _tmp32_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	_tmp1_ = structure_model_iter_is_valid (self, &_tmp0_);
	g_return_if_fail (_tmp1_);
	_tmp2_ = *iter;
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
	node = _tmp3_;
	_tmp4_ = node;
	_tmp5_ = _tmp4_->data;
	_tmp6_ = (*((StructData*) _tmp5_)).type;
	type = _tmp6_;
	_tmp8_ = type;
	_tmp9_ = structure_is_section (_tmp8_);
	if (_tmp9_) {
		StructType _tmp10_ = 0;
		_tmp10_ = type;
		_tmp7_ = _tmp10_ != STRUCT_TYPE_SUBPARAGRAPH;
	} else {
		_tmp7_ = FALSE;
	}
	g_return_if_fail (_tmp7_);
	_tmp11_ = type;
	new_type = _tmp11_ + 1;
	_tmp12_ = node;
	_tmp13_ = g_node_prev_sibling (_tmp12_);
	new_parent = _tmp13_;
	_tmp15_ = new_parent;
	if (_tmp15_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		StructType _tmp16_ = 0;
		GNode* _tmp17_ = NULL;
		gconstpointer _tmp18_ = NULL;
		StructType _tmp19_ = 0;
		_tmp16_ = new_type;
		_tmp17_ = new_parent;
		_tmp18_ = _tmp17_->data;
		_tmp19_ = (*((StructData*) _tmp18_)).type;
		_tmp14_ = _tmp16_ <= _tmp19_;
	}
	if (_tmp14_) {
		GNode* _tmp20_ = NULL;
		GNode* _tmp21_ = NULL;
		GNode* _tmp22_ = NULL;
		GNode* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		_tmp20_ = node;
		_tmp21_ = _tmp20_->parent;
		new_parent = _tmp21_;
		_tmp22_ = new_parent;
		_tmp23_ = node;
		_tmp24_ = g_node_child_position (_tmp22_, _tmp23_);
		new_pos = _tmp24_;
	} else {
		new_pos = -1;
	}
	_tmp25_ = node;
	_tmp26_ = structure_model_delete_node (self, _tmp25_);
	node_unlinked = _tmp26_;
	_tmp27_ = node_unlinked;
	structure_model_shift_node (self, _tmp27_, TRUE);
	_tmp28_ = new_parent;
	_tmp29_ = new_pos;
	_tmp30_ = node_unlinked;
	node_unlinked = NULL;
	_tmp31_ = g_node_insert (_tmp28_, _tmp29_, _tmp30_);
	node = _tmp31_;
	_tmp32_ = node;
	structure_model_reinsert_node (self, _tmp32_, FALSE);
	__g_node_destroy__struct_data_free0_0 (node_unlinked);
}


void structure_model_shift_left (StructureModel* self, GtkTreeIter* iter) {
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	GNode* node = NULL;
	GtkTreeIter _tmp2_ = {0};
	GNode* _tmp3_ = NULL;
	StructType type = 0;
	GNode* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	StructType _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	StructType _tmp8_ = 0;
	StructType new_type = 0;
	StructType _tmp10_ = 0;
	GNode* new_parent = NULL;
	gint new_pos = 0;
	GNode* parent = NULL;
	GNode* _tmp11_ = NULL;
	GNode* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GNode* _tmp14_ = NULL;
	GNode* _tmp15_ = NULL;
	GNode* sibling = NULL;
	GNode* _tmp29_ = NULL;
	GNode* _tmp30_ = NULL;
	GNode* node_unlinked = NULL;
	GNode* _tmp31_ = NULL;
	GNode* _tmp32_ = NULL;
	GNode* _tmp33_ = NULL;
	GNode* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	GNode* _tmp48_ = NULL;
	GNode* _tmp49_ = NULL;
	GNode* _tmp50_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	_tmp1_ = structure_model_iter_is_valid (self, &_tmp0_);
	g_return_if_fail (_tmp1_);
	_tmp2_ = *iter;
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
	node = _tmp3_;
	_tmp4_ = node;
	_tmp5_ = _tmp4_->data;
	_tmp6_ = (*((StructData*) _tmp5_)).type;
	type = _tmp6_;
	_tmp8_ = type;
	if (STRUCT_TYPE_PART < _tmp8_) {
		StructType _tmp9_ = 0;
		_tmp9_ = type;
		_tmp7_ = _tmp9_ <= STRUCT_TYPE_SUBPARAGRAPH;
	} else {
		_tmp7_ = FALSE;
	}
	g_return_if_fail (_tmp7_);
	_tmp10_ = type;
	new_type = _tmp10_ - 1;
	_tmp11_ = node;
	_tmp12_ = _tmp11_->parent;
	parent = _tmp12_;
	_tmp14_ = parent;
	_tmp15_ = self->priv->_tree;
	if (_tmp14_ == _tmp15_) {
		_tmp13_ = TRUE;
	} else {
		GNode* _tmp16_ = NULL;
		gconstpointer _tmp17_ = NULL;
		StructType _tmp18_ = 0;
		StructType _tmp19_ = 0;
		_tmp16_ = parent;
		_tmp17_ = _tmp16_->data;
		_tmp18_ = (*((StructData*) _tmp17_)).type;
		_tmp19_ = new_type;
		_tmp13_ = _tmp18_ < _tmp19_;
	}
	if (_tmp13_) {
		GNode* _tmp20_ = NULL;
		GNode* _tmp21_ = NULL;
		GNode* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		_tmp20_ = parent;
		new_parent = _tmp20_;
		_tmp21_ = parent;
		_tmp22_ = node;
		_tmp23_ = g_node_child_position (_tmp21_, _tmp22_);
		new_pos = _tmp23_;
	} else {
		GNode* _tmp24_ = NULL;
		GNode* _tmp25_ = NULL;
		GNode* _tmp26_ = NULL;
		GNode* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		_tmp24_ = parent;
		_tmp25_ = _tmp24_->parent;
		new_parent = _tmp25_;
		_tmp26_ = new_parent;
		_tmp27_ = parent;
		_tmp28_ = g_node_child_position (_tmp26_, _tmp27_);
		new_pos = _tmp28_ + 1;
	}
	_tmp29_ = node;
	_tmp30_ = g_node_next_sibling (_tmp29_);
	sibling = _tmp30_;
	_tmp31_ = node;
	_tmp32_ = structure_model_delete_node (self, _tmp31_);
	node_unlinked = _tmp32_;
	_tmp33_ = node_unlinked;
	structure_model_shift_node (self, _tmp33_, FALSE);
	while (TRUE) {
		GNode* _tmp34_ = NULL;
		GNode* _tmp35_ = NULL;
		gconstpointer _tmp36_ = NULL;
		StructType _tmp37_ = 0;
		StructType _tmp38_ = 0;
		GNode* next_sibling = NULL;
		GNode* _tmp39_ = NULL;
		GNode* _tmp40_ = NULL;
		GNode* new_child = NULL;
		GNode* _tmp41_ = NULL;
		GNode* _tmp42_ = NULL;
		GNode* _tmp43_ = NULL;
		GNode* _tmp44_ = NULL;
		GNode* _tmp45_ = NULL;
		_tmp34_ = sibling;
		if (!(_tmp34_ != NULL)) {
			break;
		}
		_tmp35_ = sibling;
		_tmp36_ = _tmp35_->data;
		_tmp37_ = (*((StructData*) _tmp36_)).type;
		_tmp38_ = new_type;
		if (_tmp37_ <= _tmp38_) {
			break;
		}
		_tmp39_ = sibling;
		_tmp40_ = g_node_next_sibling (_tmp39_);
		next_sibling = _tmp40_;
		_tmp41_ = sibling;
		_tmp42_ = structure_model_delete_node (self, _tmp41_);
		new_child = _tmp42_;
		_tmp43_ = node_unlinked;
		_tmp44_ = new_child;
		new_child = NULL;
		g_node_append (_tmp43_, _tmp44_);
		_tmp45_ = next_sibling;
		sibling = _tmp45_;
		__g_node_destroy__struct_data_free0_0 (new_child);
	}
	_tmp46_ = new_parent;
	_tmp47_ = new_pos;
	_tmp48_ = node_unlinked;
	node_unlinked = NULL;
	_tmp49_ = g_node_insert (_tmp46_, _tmp47_, _tmp48_);
	node = _tmp49_;
	_tmp50_ = node;
	structure_model_reinsert_node (self, _tmp50_, FALSE);
	__g_node_destroy__struct_data_free0_0 (node_unlinked);
}


gboolean structure_model_item_contains_subparagraph (StructureModel* self, GtkTreeIter* iter) {
	gboolean result = FALSE;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	GNode* node = NULL;
	GtkTreeIter _tmp2_ = {0};
	GNode* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_tmp1_ = structure_model_iter_is_valid (self, &_tmp0_);
	g_return_val_if_fail (_tmp1_, FALSE);
	_tmp2_ = *iter;
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
	node = _tmp3_;
	_tmp4_ = structure_model_node_contains_subparagraph (self, node);
	result = _tmp4_;
	return result;
}


static gboolean structure_model_node_contains_subparagraph (StructureModel* self, GNode* node) {
	gboolean result = FALSE;
	StructType type = 0;
	GNode* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	StructType _tmp2_ = 0;
	StructType _tmp3_ = 0;
	StructType _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	GNode* child = NULL;
	GNode* _tmp6_ = NULL;
	GNode* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node;
	_tmp1_ = _tmp0_->data;
	_tmp2_ = (*((StructData*) _tmp1_)).type;
	type = _tmp2_;
	_tmp3_ = type;
	if (_tmp3_ == STRUCT_TYPE_SUBPARAGRAPH) {
		result = TRUE;
		return result;
	}
	_tmp4_ = type;
	_tmp5_ = structure_is_section (_tmp4_);
	if (!_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = node;
	_tmp7_ = g_node_first_child (_tmp6_);
	child = _tmp7_;
	while (TRUE) {
		GNode* _tmp8_ = NULL;
		GNode* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		GNode* _tmp11_ = NULL;
		GNode* _tmp12_ = NULL;
		_tmp8_ = child;
		if (!(_tmp8_ != NULL)) {
			break;
		}
		_tmp9_ = child;
		_tmp10_ = structure_model_node_contains_subparagraph (self, _tmp9_);
		if (_tmp10_) {
			result = TRUE;
			return result;
		}
		_tmp11_ = child;
		_tmp12_ = g_node_next_sibling (_tmp11_);
		child = _tmp12_;
	}
	result = FALSE;
	return result;
}


static void structure_model_insert_node (StructureModel* self, GNode* node, gboolean force_first_child) {
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	GtkTreeIter item_iter = {0};
	GNode* _tmp2_ = NULL;
	GtkTreeIter* _tmp3_ = NULL;
	GtkTreeIter* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GtkTreePath* item_path = NULL;
	GtkTreeIter _tmp6_ = {0};
	GtkTreePath* _tmp7_ = NULL;
	GtkTreePath* _tmp8_ = NULL;
	GtkTreeIter _tmp9_ = {0};
	GNode* parent = NULL;
	GNode* _tmp10_ = NULL;
	GNode* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GNode* _tmp13_ = NULL;
	GNode* _tmp14_ = NULL;
	gboolean first_child = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	structure_model_new_stamp (self);
	_tmp0_ = self->priv->_nb_nodes;
	self->priv->_nb_nodes = _tmp0_ + 1;
	_tmp1_ = self->priv->_emit_signals;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = node;
	_tmp3_ = structure_model_create_iter_at_node (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = *_tmp4_;
	_g_free0 (_tmp4_);
	item_iter = _tmp5_;
	_tmp6_ = item_iter;
	_tmp7_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp6_);
	item_path = _tmp7_;
	_tmp8_ = item_path;
	_tmp9_ = item_iter;
	gtk_tree_model_row_inserted ((GtkTreeModel*) self, _tmp8_, &_tmp9_);
	_tmp10_ = node;
	_tmp11_ = _tmp10_->parent;
	parent = _tmp11_;
	_tmp13_ = parent;
	_tmp14_ = self->priv->_tree;
	if (_tmp13_ != _tmp14_) {
		GNode* _tmp15_ = NULL;
		GNode* _tmp16_ = NULL;
		GNode* _tmp17_ = NULL;
		_tmp15_ = parent;
		_tmp16_ = _tmp15_->children;
		_tmp17_ = node;
		_tmp12_ = _tmp16_ == _tmp17_;
	} else {
		_tmp12_ = FALSE;
	}
	first_child = _tmp12_;
	_tmp19_ = force_first_child;
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		gboolean _tmp20_ = FALSE;
		_tmp20_ = first_child;
		_tmp18_ = _tmp20_;
	}
	if (_tmp18_) {
		GtkTreeIter parent_iter = {0};
		GNode* _tmp21_ = NULL;
		GtkTreeIter* _tmp22_ = NULL;
		GtkTreeIter* _tmp23_ = NULL;
		GtkTreeIter _tmp24_ = {0};
		GtkTreePath* parent_path = NULL;
		GtkTreeIter _tmp25_ = {0};
		GtkTreePath* _tmp26_ = NULL;
		GtkTreePath* _tmp27_ = NULL;
		GtkTreeIter _tmp28_ = {0};
		_tmp21_ = parent;
		_tmp22_ = structure_model_create_iter_at_node (self, _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = *_tmp23_;
		_g_free0 (_tmp23_);
		parent_iter = _tmp24_;
		_tmp25_ = parent_iter;
		_tmp26_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp25_);
		parent_path = _tmp26_;
		_tmp27_ = parent_path;
		_tmp28_ = parent_iter;
		gtk_tree_model_row_has_child_toggled ((GtkTreeModel*) self, _tmp27_, &_tmp28_);
		_gtk_tree_path_free0 (parent_path);
	}
	_gtk_tree_path_free0 (item_path);
}


static GNode* g_node_unlink_vala (GNode* self) {
	GNode* result = NULL;
	void* ptr = NULL;
	void* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	ptr = self;
	g_node_unlink (self);
	_tmp0_ = ptr;
	ptr = NULL;
	result = (GNode*) _tmp0_;
	return result;
}


static GNode* structure_model_delete_node (StructureModel* self, GNode* node) {
	GNode* result = NULL;
	GtkTreePath* path = NULL;
	GNode* parent = NULL;
	gboolean _tmp0_ = FALSE;
	GNode* node_unlinked = NULL;
	GNode* _tmp9_ = NULL;
	GNode* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	GNode* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	gboolean _tmp14_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	structure_model_new_stamp (self);
	path = NULL;
	parent = NULL;
	_tmp0_ = self->priv->_emit_signals;
	if (_tmp0_) {
		GtkTreeIter* iter = NULL;
		GNode* _tmp1_ = NULL;
		GtkTreeIter* _tmp2_ = NULL;
		GtkTreeIter* _tmp3_ = NULL;
		GtkTreeIter* _tmp4_ = NULL;
		GtkTreeIter _tmp5_ = {0};
		GtkTreePath* _tmp6_ = NULL;
		GNode* _tmp7_ = NULL;
		GNode* _tmp8_ = NULL;
		_tmp1_ = node;
		_tmp2_ = structure_model_create_iter_at_node (self, _tmp1_);
		iter = _tmp2_;
		_tmp3_ = iter;
		g_return_val_if_fail (_tmp3_ != NULL, NULL);
		_tmp4_ = iter;
		_tmp5_ = *_tmp4_;
		_tmp6_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp5_);
		_gtk_tree_path_free0 (path);
		path = _tmp6_;
		_tmp7_ = node;
		_tmp8_ = _tmp7_->parent;
		parent = _tmp8_;
		_g_free0 (iter);
	}
	_tmp9_ = node;
	_tmp10_ = g_node_unlink_vala (_tmp9_);
	node_unlinked = _tmp10_;
	_tmp11_ = self->priv->_nb_nodes;
	_tmp12_ = node_unlinked;
	_tmp13_ = g_node_n_nodes (_tmp12_, G_TRAVERSE_ALL);
	self->priv->_nb_nodes = _tmp11_ - _tmp13_;
	_tmp14_ = self->priv->_emit_signals;
	if (_tmp14_) {
		GtkTreePath* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		GNode* _tmp17_ = NULL;
		GNode* _tmp18_ = NULL;
		_tmp15_ = path;
		gtk_tree_model_row_deleted ((GtkTreeModel*) self, _tmp15_);
		_tmp17_ = parent;
		_tmp18_ = self->priv->_tree;
		if (_tmp17_ != _tmp18_) {
			GNode* _tmp19_ = NULL;
			GNode* _tmp20_ = NULL;
			_tmp19_ = parent;
			_tmp20_ = _tmp19_->children;
			_tmp16_ = _tmp20_ == NULL;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			GtkTreeIter parent_iter = {0};
			GNode* _tmp21_ = NULL;
			GtkTreeIter* _tmp22_ = NULL;
			GtkTreeIter* _tmp23_ = NULL;
			GtkTreeIter _tmp24_ = {0};
			GtkTreePath* parent_path = NULL;
			GtkTreeIter _tmp25_ = {0};
			GtkTreePath* _tmp26_ = NULL;
			GtkTreePath* _tmp27_ = NULL;
			GtkTreeIter _tmp28_ = {0};
			_tmp21_ = parent;
			_tmp22_ = structure_model_create_iter_at_node (self, _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = *_tmp23_;
			_g_free0 (_tmp23_);
			parent_iter = _tmp24_;
			_tmp25_ = parent_iter;
			_tmp26_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp25_);
			parent_path = _tmp26_;
			_tmp27_ = parent_path;
			_tmp28_ = parent_iter;
			gtk_tree_model_row_has_child_toggled ((GtkTreeModel*) self, _tmp27_, &_tmp28_);
			_gtk_tree_path_free0 (parent_path);
		}
	}
	result = node_unlinked;
	_gtk_tree_path_free0 (path);
	return result;
}


static void structure_model_shift_node (StructureModel* self, GNode* node, gboolean shift_right) {
	GNode* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	StructType _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GNode* child = NULL;
	GNode* _tmp21_ = NULL;
	GNode* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = _tmp0_->data;
	_tmp2_ = (*((StructData*) _tmp1_)).type;
	_tmp3_ = structure_is_section (_tmp2_);
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = shift_right;
	if (_tmp4_) {
		GNode* _tmp5_ = NULL;
		gconstpointer _tmp6_ = NULL;
		StructType _tmp7_ = 0;
		_tmp5_ = node;
		_tmp6_ = _tmp5_->data;
		_tmp7_ = (*((StructData*) _tmp6_)).type;
		if (_tmp7_ != STRUCT_TYPE_SUBPARAGRAPH) {
			GNode* _tmp8_ = NULL;
			gconstpointer _tmp9_ = NULL;
			GNode* _tmp10_ = NULL;
			gconstpointer _tmp11_ = NULL;
			StructType _tmp12_ = 0;
			_tmp8_ = node;
			_tmp9_ = _tmp8_->data;
			_tmp10_ = node;
			_tmp11_ = _tmp10_->data;
			_tmp12_ = (*((StructData*) _tmp11_)).type;
			(*((StructData*) _tmp11_)).type = _tmp12_ + 1;
		}
	} else {
		GNode* _tmp13_ = NULL;
		gconstpointer _tmp14_ = NULL;
		StructType _tmp15_ = 0;
		_tmp13_ = node;
		_tmp14_ = _tmp13_->data;
		_tmp15_ = (*((StructData*) _tmp14_)).type;
		if (_tmp15_ != STRUCT_TYPE_PART) {
			GNode* _tmp16_ = NULL;
			gconstpointer _tmp17_ = NULL;
			GNode* _tmp18_ = NULL;
			gconstpointer _tmp19_ = NULL;
			StructType _tmp20_ = 0;
			_tmp16_ = node;
			_tmp17_ = _tmp16_->data;
			_tmp18_ = node;
			_tmp19_ = _tmp18_->data;
			_tmp20_ = (*((StructData*) _tmp19_)).type;
			(*((StructData*) _tmp19_)).type = _tmp20_ - 1;
		}
	}
	_tmp21_ = node;
	_tmp22_ = g_node_first_child (_tmp21_);
	child = _tmp22_;
	while (TRUE) {
		GNode* _tmp23_ = NULL;
		GNode* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
		GNode* _tmp26_ = NULL;
		GNode* _tmp27_ = NULL;
		_tmp23_ = child;
		if (!(_tmp23_ != NULL)) {
			break;
		}
		_tmp24_ = child;
		_tmp25_ = shift_right;
		structure_model_shift_node (self, _tmp24_, _tmp25_);
		_tmp26_ = child;
		_tmp27_ = g_node_next_sibling (_tmp26_);
		child = _tmp27_;
	}
}


static void structure_model_reinsert_node (StructureModel* self, GNode* node, gboolean force_first_child) {
	GNode* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GNode* child = NULL;
	GNode* _tmp2_ = NULL;
	GNode* _tmp3_ = NULL;
	gboolean first_child = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = force_first_child;
	structure_model_insert_node (self, _tmp0_, _tmp1_);
	_tmp2_ = node;
	_tmp3_ = g_node_first_child (_tmp2_);
	child = _tmp3_;
	first_child = TRUE;
	while (TRUE) {
		GNode* _tmp4_ = NULL;
		GNode* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		GNode* _tmp7_ = NULL;
		GNode* _tmp8_ = NULL;
		_tmp4_ = child;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = child;
		_tmp6_ = first_child;
		structure_model_reinsert_node (self, _tmp5_, _tmp6_);
		_tmp7_ = child;
		_tmp8_ = g_node_next_sibling (_tmp7_);
		child = _tmp8_;
		first_child = FALSE;
	}
}


static GtkTreeIter* structure_model_insert_item_after (StructureModel* self, GNode* parent, GNode* sibling, StructData* item) {
	GtkTreeIter* result = NULL;
	StructData _tmp0_ = {0};
	const gchar* _tmp1_ = NULL;
	GNode* new_node = NULL;
	GNode* _tmp2_ = NULL;
	GNode* _tmp3_ = NULL;
	StructData _tmp4_ = {0};
	StructData _tmp5_ = {0};
	StructData* _tmp6_ = NULL;
	GNode* _tmp7_ = NULL;
	GNode* _tmp8_ = NULL;
	GtkTreeIter* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = *item;
	_tmp1_ = _tmp0_.text;
	g_return_val_if_fail (_tmp1_ != NULL, NULL);
	_tmp2_ = parent;
	_tmp3_ = sibling;
	_tmp4_ = *item;
	_tmp5_ = _tmp4_;
	_tmp6_ = _struct_data_dup0 (&_tmp5_);
	_tmp7_ = g_node_new (_tmp6_);
	_tmp8_ = g_node_insert_after (_tmp2_, _tmp3_, _tmp7_);
	new_node = _tmp8_;
	structure_model_insert_node (self, new_node, FALSE);
	structure_model_insert_node_in_list (self, new_node);
	_tmp9_ = structure_model_create_iter_at_node (self, new_node);
	result = _tmp9_;
	return result;
}


static void structure_model_make_children_between_marks (StructureModel* self, GNode* node) {
	StructData data = {0};
	GNode* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	StructData _tmp2_ = {0};
	StructData _tmp3_ = {0};
	GtkTextMark* _tmp4_ = NULL;
	GNode* sibling = NULL;
	GNode* _tmp5_ = NULL;
	GNode* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = _tmp0_->data;
	struct_data_copy ((StructData*) _tmp1_, &_tmp2_);
	data = _tmp2_;
	_tmp3_ = data;
	_tmp4_ = _tmp3_.end_mark;
	if (_tmp4_ == NULL) {
		struct_data_destroy (&data);
		return;
	}
	_tmp5_ = node;
	_tmp6_ = g_node_next_sibling (_tmp5_);
	sibling = _tmp6_;
	while (TRUE) {
		GNode* _tmp7_ = NULL;
		StructData sibling_data = {0};
		GNode* _tmp8_ = NULL;
		gconstpointer _tmp9_ = NULL;
		StructData _tmp10_ = {0};
		StructData _tmp11_ = {0};
		StructType _tmp12_ = 0;
		gboolean _tmp13_ = FALSE;
		StructData _tmp14_ = {0};
		GtkTextMark* _tmp15_ = NULL;
		StructData _tmp16_ = {0};
		GtkTextMark* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		GNode* sibling_unlinked = NULL;
		GNode* _tmp19_ = NULL;
		GNode* _tmp20_ = NULL;
		GNode* new_child = NULL;
		GNode* _tmp21_ = NULL;
		GNode* _tmp22_ = NULL;
		GNode* _tmp23_ = NULL;
		GNode* _tmp24_ = NULL;
		GNode* _tmp25_ = NULL;
		GNode* _tmp26_ = NULL;
		_tmp7_ = sibling;
		if (!(_tmp7_ != NULL)) {
			break;
		}
		_tmp8_ = sibling;
		_tmp9_ = _tmp8_->data;
		struct_data_copy ((StructData*) _tmp9_, &_tmp10_);
		sibling_data = _tmp10_;
		_tmp11_ = sibling_data;
		_tmp12_ = _tmp11_.type;
		_tmp13_ = structure_is_section (_tmp12_);
		if (_tmp13_) {
			struct_data_destroy (&sibling_data);
			break;
		}
		_tmp14_ = data;
		_tmp15_ = _tmp14_.end_mark;
		_tmp16_ = sibling_data;
		_tmp17_ = _tmp16_.start_mark;
		_tmp18_ = structure_model_compare_nodes (_tmp15_, _tmp17_);
		if (_tmp18_ <= 0) {
			struct_data_destroy (&sibling_data);
			break;
		}
		_tmp19_ = sibling;
		_tmp20_ = structure_model_delete_node (self, _tmp19_);
		sibling_unlinked = _tmp20_;
		_tmp21_ = node;
		_tmp22_ = sibling_unlinked;
		sibling_unlinked = NULL;
		_tmp23_ = g_node_append (_tmp21_, _tmp22_);
		new_child = _tmp23_;
		_tmp24_ = new_child;
		structure_model_insert_node (self, _tmp24_, FALSE);
		_tmp25_ = node;
		_tmp26_ = g_node_next_sibling (_tmp25_);
		sibling = _tmp26_;
		__g_node_destroy__struct_data_free0_0 (sibling_unlinked);
		struct_data_destroy (&sibling_data);
	}
	struct_data_destroy (&data);
}


static void structure_model_search_end_node (StructureModel* self) {
	GNode* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_tree;
	self->priv->_end_node = _tmp0_;
	while (TRUE) {
		GNode* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		GNode* _tmp3_ = NULL;
		GNode* _tmp4_ = NULL;
		_tmp1_ = self->priv->_end_node;
		_tmp2_ = G_NODE_IS_LEAF (_tmp1_);
		if (!(!_tmp2_)) {
			break;
		}
		_tmp3_ = self->priv->_end_node;
		_tmp4_ = g_node_last_child (_tmp3_);
		self->priv->_end_node = _tmp4_;
	}
}


static gint structure_model_compare_nodes (GtkTextMark* mark1, GtkTextMark* mark2) {
	gint result = 0;
	GtkTextBuffer* doc = NULL;
	GtkTextMark* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextMark* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextIter iter1 = {0};
	GtkTextIter iter2 = {0};
	GtkTextMark* _tmp5_ = NULL;
	GtkTextIter _tmp6_ = {0};
	GtkTextMark* _tmp7_ = NULL;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gint _tmp10_ = 0;
	g_return_val_if_fail (mark1 != NULL, 0);
	g_return_val_if_fail (mark2 != NULL, 0);
	_tmp0_ = mark1;
	_tmp1_ = gtk_text_mark_get_buffer (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	doc = _tmp2_;
	_tmp3_ = mark2;
	_tmp4_ = gtk_text_mark_get_buffer (_tmp3_);
	g_return_val_if_fail (doc == _tmp4_, 0);
	_tmp5_ = mark1;
	gtk_text_buffer_get_iter_at_mark (doc, &_tmp6_, _tmp5_);
	iter1 = _tmp6_;
	_tmp7_ = mark2;
	gtk_text_buffer_get_iter_at_mark (doc, &_tmp8_, _tmp7_);
	iter2 = _tmp8_;
	_tmp9_ = iter2;
	_tmp10_ = gtk_text_iter_compare (&iter1, &_tmp9_);
	result = _tmp10_;
	_g_object_unref0 (doc);
	return result;
}


/*************************************************************************/
void structure_model_populate_list (StructureModel* self, GtkListStore* store, StructType type) {
	GeeArrayList* list = NULL;
	StructType _tmp0_ = 0;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = type;
	_tmp1_ = structure_model_get_list (self, _tmp0_);
	list = _tmp1_;
	_tmp2_ = list;
	g_return_if_fail (_tmp2_ != NULL);
	{
		GeeArrayList* _node_list = NULL;
		GeeArrayList* _tmp3_ = NULL;
		GeeArrayList* _tmp4_ = NULL;
		gint _node_size = 0;
		GeeArrayList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _node_index = 0;
		_tmp3_ = list;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_node_list = _tmp4_;
		_tmp5_ = _node_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_node_size = _tmp7_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			GNode* node = NULL;
			GeeArrayList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gpointer _tmp13_ = NULL;
			StructData data = {0};
			GNode* _tmp14_ = NULL;
			gconstpointer _tmp15_ = NULL;
			StructData _tmp16_ = {0};
			GtkTreeIter iter = {0};
			GtkListStore* _tmp17_ = NULL;
			GtkTreeIter _tmp18_ = {0};
			GtkListStore* _tmp19_ = NULL;
			GtkTreeIter _tmp20_ = {0};
			StructData _tmp21_ = {0};
			StructType _tmp22_ = 0;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			StructData _tmp25_ = {0};
			const gchar* _tmp26_ = NULL;
			StructData _tmp27_ = {0};
			StructType _tmp28_ = 0;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			_tmp8_ = _node_index;
			_node_index = _tmp8_ + 1;
			_tmp9_ = _node_index;
			_tmp10_ = _node_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _node_list;
			_tmp12_ = _node_index;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
			node = (GNode*) _tmp13_;
			_tmp14_ = node;
			_tmp15_ = _tmp14_->data;
			struct_data_copy ((StructData*) _tmp15_, &_tmp16_);
			data = _tmp16_;
			_tmp17_ = store;
			gtk_list_store_append (_tmp17_, &_tmp18_);
			iter = _tmp18_;
			_tmp19_ = store;
			_tmp20_ = iter;
			_tmp21_ = data;
			_tmp22_ = _tmp21_.type;
			_tmp23_ = structure_get_icon_from_type (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = data;
			_tmp26_ = _tmp25_.text;
			_tmp27_ = data;
			_tmp28_ = _tmp27_.type;
			_tmp29_ = structure_get_type_name (_tmp28_);
			_tmp30_ = _tmp29_;
			gtk_list_store_set (_tmp19_, &_tmp20_, STRUCT_LIST_COLUMN_PIXBUF, _tmp24_, STRUCT_LIST_COLUMN_TEXT, _tmp26_, STRUCT_LIST_COLUMN_TOOLTIP, _tmp30_, -1);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp24_);
			struct_data_destroy (&data);
		}
		_g_object_unref0 (_node_list);
	}
	_g_object_unref0 (list);
}


GtkTreePath* structure_model_get_tree_path_from_list_num (StructureModel* self, StructType list_type, gint num) {
	GtkTreePath* result = NULL;
	GeeArrayList* list = NULL;
	StructType _tmp0_ = 0;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	GeeArrayList* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gpointer _tmp11_ = NULL;
	GtkTreeIter* _tmp12_ = NULL;
	GtkTreeIter* _tmp13_ = NULL;
	GtkTreeIter _tmp14_ = {0};
	GtkTreePath* _tmp15_ = NULL;
	GtkTreePath* _tmp16_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = list_type;
	_tmp1_ = structure_model_get_list (self, _tmp0_);
	list = _tmp1_;
	_tmp2_ = list;
	g_return_val_if_fail (_tmp2_ != NULL, NULL);
	_tmp4_ = num;
	if (0 <= _tmp4_) {
		gint _tmp5_ = 0;
		GeeArrayList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp5_ = num;
		_tmp6_ = list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp3_ = _tmp5_ < _tmp8_;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	_tmp9_ = list;
	_tmp10_ = num;
	_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
	_tmp12_ = structure_model_create_iter_at_node (self, (GNode*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = *_tmp13_;
	_tmp15_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp13_);
	result = _tmp16_;
	_g_object_unref0 (list);
	return result;
}


gint structure_model_get_list_num_from_tree_iter (StructureModel* self, GtkTreeIter* tree_iter) {
	gint result = 0;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	GNode* node = NULL;
	GtkTreeIter _tmp2_ = {0};
	GNode* _tmp3_ = NULL;
	GeeArrayList* list = NULL;
	GNode* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	StructType _tmp6_ = 0;
	GeeArrayList* _tmp7_ = NULL;
	GeeArrayList* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (tree_iter != NULL, 0);
	_tmp0_ = *tree_iter;
	_tmp1_ = structure_model_iter_is_valid (self, &_tmp0_);
	g_return_val_if_fail (_tmp1_, -1);
	_tmp2_ = *tree_iter;
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
	node = _tmp3_;
	_tmp4_ = node;
	_tmp5_ = _tmp4_->data;
	_tmp6_ = (*((StructData*) _tmp5_)).type;
	_tmp7_ = structure_model_get_list (self, _tmp6_);
	list = _tmp7_;
	_tmp8_ = list;
	g_return_val_if_fail (_tmp8_ != NULL, -1);
	{
		gint num = 0;
		num = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp11_ = 0;
				GeeArrayList* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				GeeArrayList* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gpointer _tmp17_ = NULL;
				GNode* _tmp18_ = NULL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = num;
					num = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = num;
				_tmp12_ = list;
				_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				if (!(_tmp11_ < _tmp14_)) {
					break;
				}
				_tmp15_ = list;
				_tmp16_ = num;
				_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
				_tmp18_ = node;
				if (((GNode*) _tmp17_) == _tmp18_) {
					result = num;
					_g_object_unref0 (list);
					return result;
				}
			}
		}
	}
	g_return_val_if_reached (-1);
	_g_object_unref0 (list);
}


static void structure_model_insert_node_in_list (StructureModel* self, GNode* node) {
	StructData item = {0};
	GNode* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	StructData _tmp2_ = {0};
	GeeArrayList* list = NULL;
	StructData _tmp3_ = {0};
	StructType _tmp4_ = 0;
	GeeArrayList* _tmp5_ = NULL;
	GeeArrayList* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = _tmp0_->data;
	struct_data_copy ((StructData*) _tmp1_, &_tmp2_);
	item = _tmp2_;
	_tmp3_ = item;
	_tmp4_ = _tmp3_.type;
	_tmp5_ = structure_model_get_list (self, _tmp4_);
	list = _tmp5_;
	_tmp6_ = list;
	if (_tmp6_ != NULL) {
		GeeArrayList* _tmp7_ = NULL;
		GNode* _tmp8_ = NULL;
		_tmp7_ = list;
		_tmp8_ = node;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
	}
	_g_object_unref0 (list);
	struct_data_destroy (&item);
}


static gboolean __lambda49_ (StructureModel* self, GNode* node) {
	gboolean result = FALSE;
	GNode* _tmp0_ = NULL;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node;
	structure_model_insert_node_in_list (self, _tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda49__gnode_traverse_func (GNode* node, gpointer self) {
	gboolean result;
	result = __lambda49_ ((StructureModel*) self, node);
	return result;
}


static void structure_model_regenerate_simple_lists (StructureModel* self) {
	GNode* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	structure_model_reset_simple_lists (self);
	_tmp0_ = self->priv->_tree;
	g_node_traverse (_tmp0_, G_PRE_ORDER, G_TRAVERSE_ALL, -1, ___lambda49__gnode_traverse_func, self);
}


static void structure_model_reset_simple_lists (StructureModel* self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_labels);
	self->priv->_list_labels = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_includes);
	self->priv->_list_includes = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_tables);
	self->priv->_list_tables = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_figures);
	self->priv->_list_figures = _tmp3_;
	_tmp4_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_todos_and_fixmes);
	self->priv->_list_todos_and_fixmes = _tmp4_;
}


static GeeArrayList* structure_model_get_list (StructureModel* self, StructType type) {
	GeeArrayList* result = NULL;
	StructType _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	StructType _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = type;
	_tmp1_ = structure_is_section (_tmp0_);
	if (_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = type;
	switch (_tmp2_) {
		case STRUCT_TYPE_LABEL:
		{
			GeeArrayList* _tmp3_ = NULL;
			GeeArrayList* _tmp4_ = NULL;
			_tmp3_ = self->priv->_list_labels;
			_tmp4_ = _g_object_ref0 (_tmp3_);
			result = _tmp4_;
			return result;
		}
		case STRUCT_TYPE_INCLUDE:
		{
			GeeArrayList* _tmp5_ = NULL;
			GeeArrayList* _tmp6_ = NULL;
			_tmp5_ = self->priv->_list_includes;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case STRUCT_TYPE_TABLE:
		{
			GeeArrayList* _tmp7_ = NULL;
			GeeArrayList* _tmp8_ = NULL;
			_tmp7_ = self->priv->_list_tables;
			_tmp8_ = _g_object_ref0 (_tmp7_);
			result = _tmp8_;
			return result;
		}
		case STRUCT_TYPE_FIGURE:
		case STRUCT_TYPE_IMAGE:
		{
			GeeArrayList* _tmp9_ = NULL;
			GeeArrayList* _tmp10_ = NULL;
			_tmp9_ = self->priv->_list_figures;
			_tmp10_ = _g_object_ref0 (_tmp9_);
			result = _tmp10_;
			return result;
		}
		case STRUCT_TYPE_TODO:
		case STRUCT_TYPE_FIXME:
		{
			GeeArrayList* _tmp11_ = NULL;
			GeeArrayList* _tmp12_ = NULL;
			_tmp11_ = self->priv->_list_todos_and_fixmes;
			_tmp12_ = _g_object_ref0 (_tmp11_);
			result = _tmp12_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}


gboolean structure_model_get_emit_signals (StructureModel* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_emit_signals;
	result = _tmp0_;
	return result;
}


void structure_model_set_emit_signals (StructureModel* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_emit_signals = _tmp0_;
	g_object_notify ((GObject *) self, "emit-signals");
}


static void structure_model_class_init (StructureModelClass * klass) {
	structure_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StructureModelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_structure_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_structure_model_set_property;
	G_OBJECT_CLASS (klass)->finalize = structure_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), STRUCTURE_MODEL_EMIT_SIGNALS, g_param_spec_boolean ("emit-signals", "emit-signals", "emit-signals", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void structure_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface) {
	structure_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_column_type = (GType (*)(GtkTreeModel*, gint)) structure_model_real_get_column_type;
	iface->get_n_columns = (gint (*)(GtkTreeModel*)) structure_model_real_get_n_columns;
	iface->get_flags = (GtkTreeModelFlags (*)(GtkTreeModel*)) structure_model_real_get_flags;
	iface->iter_has_child = (gboolean (*)(GtkTreeModel*, GtkTreeIter*)) structure_model_real_iter_has_child;
	iface->iter_n_children = (gint (*)(GtkTreeModel*, GtkTreeIter*)) structure_model_real_iter_n_children;
	iface->get_value = (void (*)(GtkTreeModel*, GtkTreeIter*, gint, GValue*)) structure_model_real_get_value;
	iface->iter_children = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) structure_model_real_iter_children;
	iface->iter_next = (gboolean (*)(GtkTreeModel*, GtkTreeIter*)) structure_model_real_iter_next;
	iface->iter_nth_child = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*, gint)) structure_model_real_iter_nth_child;
	iface->iter_parent = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) structure_model_real_iter_parent;
	iface->get_iter = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreePath*)) structure_model_real_get_iter;
	iface->get_path = (GtkTreePath* (*)(GtkTreeModel*, GtkTreeIter*)) structure_model_real_get_path;
}


static void structure_model_instance_init (StructureModel * self) {
	self->priv = STRUCTURE_MODEL_GET_PRIVATE (self);
	self->priv->_emit_signals = FALSE;
	self->priv->_nb_nodes = (guint) 0;
	self->priv->_end_node = NULL;
}


static void structure_model_finalize (GObject* obj) {
	StructureModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STRUCTURE_MODEL, StructureModel);
	self->priv->_column_types = (g_free (self->priv->_column_types), NULL);
	__g_node_destroy__struct_data_free0_0 (self->priv->_tree);
	_g_object_unref0 (self->priv->_list_labels);
	_g_object_unref0 (self->priv->_list_includes);
	_g_object_unref0 (self->priv->_list_tables);
	_g_object_unref0 (self->priv->_list_figures);
	_g_object_unref0 (self->priv->_list_todos_and_fixmes);
	G_OBJECT_CLASS (structure_model_parent_class)->finalize (obj);
}


GType structure_model_get_type (void) {
	static volatile gsize structure_model_type_id__volatile = 0;
	if (g_once_init_enter (&structure_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StructureModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) structure_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StructureModel), 0, (GInstanceInitFunc) structure_model_instance_init, NULL };
		static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) structure_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType structure_model_type_id;
		structure_model_type_id = g_type_register_static (G_TYPE_OBJECT, "StructureModel", &g_define_type_info, 0);
		g_type_add_interface_static (structure_model_type_id, GTK_TYPE_TREE_MODEL, &gtk_tree_model_info);
		g_once_init_leave (&structure_model_type_id__volatile, structure_model_type_id);
	}
	return structure_model_type_id__volatile;
}


static void _vala_structure_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	StructureModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_STRUCTURE_MODEL, StructureModel);
	switch (property_id) {
		case STRUCTURE_MODEL_EMIT_SIGNALS:
		g_value_set_boolean (value, structure_model_get_emit_signals (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_structure_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	StructureModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_STRUCTURE_MODEL, StructureModel);
	switch (property_id) {
		case STRUCTURE_MODEL_EMIT_SIGNALS:
		structure_model_set_emit_signals (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



