/* file_browser.c generated by valac 0.39.1.3-7091, the Vala compiler
 * generated from file_browser.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012, 2017 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <latexila.h>
#include <tepl/tepl.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define TYPE_FILE_BROWSER (file_browser_get_type ())
#define FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_BROWSER, FileBrowser))
#define FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_BROWSER, FileBrowserClass))
#define IS_FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_BROWSER))
#define IS_FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))
#define FILE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_BROWSER, FileBrowserClass))

typedef struct _FileBrowser FileBrowser;
typedef struct _FileBrowserClass FileBrowserClass;
typedef struct _FileBrowserPrivate FileBrowserPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
enum  {
	FILE_BROWSER_0_PROPERTY,
	FILE_BROWSER_NUM_PROPERTIES
};
static GParamSpec* file_browser_properties[FILE_BROWSER_NUM_PROPERTIES];

#define FILE_BROWSER_TYPE_PARENT_DIR_COLUMN (file_browser_parent_dir_column_get_type ())

#define FILE_BROWSER_TYPE_FILE_COLUMN (file_browser_file_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;

struct _FileBrowser {
	GtkGrid parent_instance;
	FileBrowserPrivate * priv;
};

struct _FileBrowserClass {
	GtkGridClass parent_class;
};

struct _FileBrowserPrivate {
	MainWindow* _main_window;
	GtkListStore* _parent_dir_store;
	GtkComboBox* _combo_box;
	GtkListStore* _list_store;
	GtkTreeView* _list_view;
	GFile* _current_directory;
	GFileMonitor* _monitor;
	GtkToolButton* _parent_button;
	GSettings* _settings;
	GSettings* _latex_settings;
	guint _timeout_id;
};

typedef enum  {
	FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF,
	FILE_BROWSER_PARENT_DIR_COLUMN_NAME,
	FILE_BROWSER_PARENT_DIR_COLUMN_FILE,
	FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS
} FileBrowserParentDirColumn;

typedef enum  {
	FILE_BROWSER_FILE_COLUMN_PIXBUF,
	FILE_BROWSER_FILE_COLUMN_NAME,
	FILE_BROWSER_FILE_COLUMN_IS_DIR,
	FILE_BROWSER_FILE_COLUMN_N_COLUMNS
} FileBrowserFileColumn;

struct _Block19Data {
	int _ref_count_;
	FileBrowser* self;
	GtkMenu* menu;
	GtkToolButton* button;
};

struct _Block20Data {
	int _ref_count_;
	FileBrowser* self;
	GtkMenu* menu;
	GtkToolButton* button;
};


static gpointer file_browser_parent_class = NULL;

GType file_browser_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define FILE_BROWSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FILE_BROWSER, FileBrowserPrivate))
static GType file_browser_parent_dir_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType file_browser_file_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
FileBrowser* file_browser_new (MainWindow* main_window);
FileBrowser* file_browser_construct (GType object_type, 
                                     MainWindow* main_window);
static void file_browser_init_settings (FileBrowser* self);
static void file_browser_init_combo_box (FileBrowser* self);
static void file_browser_init_toolbar (FileBrowser* self);
static void file_browser_init_list (FileBrowser* self);
static void file_browser_set_directory (FileBrowser* self, 
                                 GFile* directory, 
                                 gboolean force);
static GFile* file_browser_get_default_directory (FileBrowser* self);
static void file_browser_refresh (FileBrowser* self);
static void _file_browser_refresh_g_settings_changed (GSettings* _sender, 
                                               const gchar* key, 
                                               gpointer self);
static void file_browser_delayed_refresh (FileBrowser* self);
static void _file_browser_delayed_refresh_g_settings_changed (GSettings* _sender, 
                                                       const gchar* key, 
                                                       gpointer self);
static void __lambda73_ (FileBrowser* self);
static void ___lambda73__gtk_combo_box_changed (GtkComboBox* _sender, 
                                         gpointer self);
static gint file_browser_on_sort (FileBrowser* self, 
                           GtkTreeModel* model, 
                           GtkTreeIter* a, 
                           GtkTreeIter* b);
static gint _file_browser_on_sort_gtk_tree_iter_compare_func (GtkTreeModel* model, 
                                                       GtkTreeIter* a, 
                                                       GtkTreeIter* b, 
                                                       gpointer self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static void __lambda81_ (FileBrowser* self, 
                  GtkTreePath* path);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_open_document (MainWindow* self, 
                                        GFile* location, 
                                        gboolean jump_to);
static void ___lambda81__gtk_tree_view_row_activated (GtkTreeView* _sender, 
                                               GtkTreePath* path, 
                                               GtkTreeViewColumn* column, 
                                               gpointer self);
static GtkToolButton* file_browser_get_home_button (FileBrowser* self);
static GtkToolButton* file_browser_get_parent_button (FileBrowser* self);
static GtkToolButton* file_browser_get_jump_button (FileBrowser* self);
static GtkToolButton* file_browser_get_open_directory_button (FileBrowser* self);
static GtkToolButton* file_browser_get_properties_button (FileBrowser* self);
static void __lambda74_ (FileBrowser* self);
static void ___lambda74__gtk_tool_button_clicked (GtkToolButton* _sender, 
                                           gpointer self);
static void __lambda75_ (FileBrowser* self);
static void ___lambda75__gtk_tool_button_clicked (GtkToolButton* _sender, 
                                           gpointer self);
static void __lambda76_ (FileBrowser* self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
static void ___lambda76__gtk_tool_button_clicked (GtkToolButton* _sender, 
                                           gpointer self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static GtkMenuItem* file_browser_get_open_directory_menu (FileBrowser* self);
static GtkMenuItem* file_browser_get_open_terminal_menu (FileBrowser* self);
static void __lambda79_ (Block19Data* _data19_);
static void ___lambda79__gtk_tool_button_clicked (GtkToolButton* _sender, 
                                           gpointer self);
static void __lambda77_ (FileBrowser* self);
static void file_browser_handle_error (FileBrowser* self, 
                                GError* _error_);
static void ___lambda77__gtk_menu_item_activate (GtkMenuItem* _sender, 
                                          gpointer self);
static void __lambda78_ (FileBrowser* self);
static void ___lambda78__gtk_menu_item_activate (GtkMenuItem* _sender, 
                                          gpointer self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static void __lambda80_ (Block20Data* _data20_);
static void ___lambda80__gtk_tool_button_clicked (GtkToolButton* _sender, 
                                           gpointer self);
static void file_browser_update_parent_directories (FileBrowser* self);
static void file_browser_update_list (FileBrowser* self);
static void file_browser_insert_file (FileBrowser* self, 
                               gboolean is_dir, 
                               const gchar* icon_name, 
                               const gchar* basename);
static gchar* file_browser_get_extension_icon_name (FileBrowser* self, 
                                             const gchar* file_extension);
static void file_browser_monitor_directory (FileBrowser* self);
static void _file_browser_refresh_g_file_monitor_changed (GFileMonitor* _sender, 
                                                   GFile* file, 
                                                   GFile* other_file, 
                                                   GFileMonitorEvent event_type, 
                                                   gpointer self);
static gboolean __lambda72_ (FileBrowser* self);
static gboolean ___lambda72__gsource_func (gpointer self);
static void file_browser_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType
file_browser_parent_dir_column_get_type (void)
{
	static volatile gsize file_browser_parent_dir_column_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_parent_dir_column_type_id__volatile)) {
		static const GEnumValue values[] = {{FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, "FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF", "pixbuf"}, {FILE_BROWSER_PARENT_DIR_COLUMN_NAME, "FILE_BROWSER_PARENT_DIR_COLUMN_NAME", "name"}, {FILE_BROWSER_PARENT_DIR_COLUMN_FILE, "FILE_BROWSER_PARENT_DIR_COLUMN_FILE", "file"}, {FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS, "FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType file_browser_parent_dir_column_type_id;
		file_browser_parent_dir_column_type_id = g_enum_register_static ("FileBrowserParentDirColumn", values);
		g_once_init_leave (&file_browser_parent_dir_column_type_id__volatile, file_browser_parent_dir_column_type_id);
	}
	return file_browser_parent_dir_column_type_id__volatile;
}


static GType
file_browser_file_column_get_type (void)
{
	static volatile gsize file_browser_file_column_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_file_column_type_id__volatile)) {
		static const GEnumValue values[] = {{FILE_BROWSER_FILE_COLUMN_PIXBUF, "FILE_BROWSER_FILE_COLUMN_PIXBUF", "pixbuf"}, {FILE_BROWSER_FILE_COLUMN_NAME, "FILE_BROWSER_FILE_COLUMN_NAME", "name"}, {FILE_BROWSER_FILE_COLUMN_IS_DIR, "FILE_BROWSER_FILE_COLUMN_IS_DIR", "is-dir"}, {FILE_BROWSER_FILE_COLUMN_N_COLUMNS, "FILE_BROWSER_FILE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType file_browser_file_column_type_id;
		file_browser_file_column_type_id = g_enum_register_static ("FileBrowserFileColumn", values);
		g_once_init_leave (&file_browser_file_column_type_id__volatile, file_browser_file_column_type_id);
	}
	return file_browser_file_column_type_id__volatile;
}


FileBrowser*
file_browser_construct (GType object_type, 
                        MainWindow* main_window)
{
	FileBrowser * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (FileBrowser*) g_object_new (object_type, NULL);
	self->priv->_main_window = main_window;
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	file_browser_init_settings (self);
	file_browser_init_combo_box (self);
	file_browser_init_toolbar (self);
	file_browser_init_list (self);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp0_ = file_browser_get_default_directory (self);
	_tmp1_ = _tmp0_;
	file_browser_set_directory (self, _tmp1_, FALSE);
	_g_object_unref0 (_tmp1_);
	return self;
}


FileBrowser*
file_browser_new (MainWindow* main_window)
{
	return file_browser_construct (TYPE_FILE_BROWSER, main_window);
}


/*************************************************************************/
static void
_file_browser_refresh_g_settings_changed (GSettings* _sender, 
                                          const gchar* key, 
                                          gpointer self)
{
	file_browser_refresh ((FileBrowser*) self);
}


static void
_file_browser_delayed_refresh_g_settings_changed (GSettings* _sender, 
                                                  const gchar* key, 
                                                  gpointer self)
{
	file_browser_delayed_refresh ((FileBrowser*) self);
}


static void
file_browser_init_settings (FileBrowser* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.file-browser");
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	_tmp1_ = self->priv->_settings;
	g_signal_connect_object (_tmp1_, "changed::show-build-files", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
	_tmp2_ = self->priv->_settings;
	g_signal_connect_object (_tmp2_, "changed::show-hidden-files", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
	_tmp3_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	_g_object_unref0 (self->priv->_latex_settings);
	self->priv->_latex_settings = _tmp3_;
	_tmp4_ = self->priv->_latex_settings;
	g_signal_connect_object (_tmp4_, "changed::clean-extensions", (GCallback) _file_browser_delayed_refresh_g_settings_changed, self, 0);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
__lambda73_ (FileBrowser* self)
{
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	_tmp0_ = self->priv->_combo_box;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkTreeModel* model = NULL;
		GtkComboBox* _tmp3_;
		GtkTreeModel* _tmp4_;
		GtkTreeModel* _tmp5_;
		GFile* file = NULL;
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
		GFile* _tmp8_;
		_tmp3_ = self->priv->_combo_box;
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		model = _tmp5_;
		_tmp6_ = model;
		_tmp7_ = iter;
		gtk_tree_model_get (_tmp6_, &_tmp7_, FILE_BROWSER_PARENT_DIR_COLUMN_FILE, &file, -1);
		_tmp8_ = file;
		file_browser_set_directory (self, _tmp8_, FALSE);
		_g_object_unref0 (file);
		_g_object_unref0 (model);
	}
}


static void
___lambda73__gtk_combo_box_changed (GtkComboBox* _sender, 
                                    gpointer self)
{
	__lambda73_ ((FileBrowser*) self);
}


static void
file_browser_init_combo_box (FileBrowser* self)
{
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkComboBox* _tmp7_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkComboBox* _tmp10_;
	GtkComboBox* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, g_file_get_type (), -1);
	_g_object_unref0 (self->priv->_parent_dir_store);
	self->priv->_parent_dir_store = _tmp0_;
	_tmp1_ = self->priv->_parent_dir_store;
	_tmp2_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->_combo_box);
	self->priv->_combo_box = _tmp2_;
	_tmp3_ = self->priv->_combo_box;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp3_, 3);
	_tmp4_ = self->priv->_combo_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
	_tmp5_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp5_);
	pixbuf_renderer = _tmp5_;
	_tmp6_ = self->priv->_combo_box;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp6_, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	_tmp7_ = self->priv->_combo_box;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp7_, (GtkCellRenderer*) pixbuf_renderer, "icon-name", FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, NULL);
	_tmp8_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp8_);
	text_renderer = _tmp8_;
	_tmp9_ = self->priv->_combo_box;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) text_renderer, TRUE);
	_tmp10_ = self->priv->_combo_box;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp10_, (GtkCellRenderer*) text_renderer, "text", FILE_BROWSER_PARENT_DIR_COLUMN_NAME, NULL);
	g_object_set (text_renderer, "ellipsize-set", TRUE, NULL);
	g_object_set (text_renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp11_ = self->priv->_combo_box;
	g_signal_connect_object (_tmp11_, "changed", (GCallback) ___lambda73__gtk_combo_box_changed, self, 0);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
}


static gint
_file_browser_on_sort_gtk_tree_iter_compare_func (GtkTreeModel* model, 
                                                  GtkTreeIter* a, 
                                                  GtkTreeIter* b, 
                                                  gpointer self)
{
	gint result;
	result = file_browser_on_sort ((FileBrowser*) self, model, a, b);
	return result;
}


static void
__lambda81_ (FileBrowser* self, 
             GtkTreePath* path)
{
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	gchar* basename = NULL;
	gboolean is_dir = FALSE;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GFile* file = NULL;
	GFile* _tmp7_;
	const gchar* _tmp8_;
	GFile* _tmp9_;
	gboolean _tmp10_;
	gchar* extension = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->_list_store;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp0_) : NULL);
	model = _tmp1_;
	_tmp2_ = model;
	_tmp4_ = gtk_tree_model_get_iter (_tmp2_, &_tmp3_, path);
	iter = _tmp3_;
	if (!_tmp4_) {
		_g_object_unref0 (model);
		return;
	}
	_tmp5_ = model;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, FILE_BROWSER_FILE_COLUMN_NAME, &basename, FILE_BROWSER_FILE_COLUMN_IS_DIR, &is_dir, -1);
	_tmp7_ = self->priv->_current_directory;
	_tmp8_ = basename;
	_tmp9_ = g_file_get_child (_tmp7_, _tmp8_);
	file = _tmp9_;
	_tmp10_ = is_dir;
	if (_tmp10_) {
		GFile* _tmp11_;
		_tmp11_ = file;
		file_browser_set_directory (self, _tmp11_, FALSE);
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_object_unref0 (model);
		return;
	}
	_tmp12_ = basename;
	_tmp13_ = latexila_utils_get_extension (_tmp12_);
	extension = _tmp13_;
	_tmp16_ = extension;
	if (g_strcmp0 (_tmp16_, ".dvi") != 0) {
		const gchar* _tmp17_;
		_tmp17_ = extension;
		_tmp15_ = g_strcmp0 (_tmp17_, ".pdf") != 0;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp18_;
		_tmp18_ = extension;
		_tmp14_ = g_strcmp0 (_tmp18_, ".ps") != 0;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		MainWindow* _tmp19_;
		GFile* _tmp20_;
		DocumentTab* _tmp21_;
		DocumentTab* _tmp22_;
		_tmp19_ = self->priv->_main_window;
		_tmp20_ = file;
		_tmp21_ = main_window_open_document (_tmp19_, _tmp20_, TRUE);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp22_);
		_g_free0 (extension);
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_object_unref0 (model);
		return;
	}
	{
		GFile* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp23_ = file;
		_tmp24_ = g_file_get_uri (_tmp23_);
		_tmp25_ = _tmp24_;
		latexila_utils_show_uri ((GtkWidget*) self, _tmp25_, (guint32) GDK_CURRENT_TIME, &_inner_error_);
		_g_free0 (_tmp25_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch19_g_error;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GFile* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = file;
		_tmp27_ = g_file_get_uri (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_warning ("file_browser.vala:194: Impossible to open the file '%s': %s", _tmp28_, _tmp30_);
		_g_free0 (_tmp28_);
		_g_error_free0 (e);
	}
	__finally19:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (extension);
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_object_unref0 (model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (extension);
	_g_object_unref0 (file);
	_g_free0 (basename);
	_g_object_unref0 (model);
}


static void
___lambda81__gtk_tree_view_row_activated (GtkTreeView* _sender, 
                                          GtkTreePath* path, 
                                          GtkTreeViewColumn* column, 
                                          gpointer self)
{
	__lambda81_ ((FileBrowser*) self, path);
}


static void
file_browser_init_list (FileBrowser* self)
{
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GtkListStore* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeView* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkTreeView* _tmp7_;
	GtkScrolledWindow* _tmp8_;
	GtkTreeViewColumn* column = NULL;
	GtkTreeViewColumn* _tmp9_;
	GtkTreeView* _tmp10_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp11_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp12_;
	GtkTreeView* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) FILE_BROWSER_FILE_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, -1);
	_g_object_unref0 (self->priv->_list_store);
	self->priv->_list_store = _tmp0_;
	_tmp1_ = self->priv->_list_store;
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) _tmp1_, 0, _file_browser_on_sort_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	_tmp2_ = self->priv->_list_store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp2_, 0, GTK_SORT_ASCENDING);
	_tmp3_ = self->priv->_list_store;
	_tmp4_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->_list_view);
	self->priv->_list_view = _tmp4_;
	_tmp5_ = self->priv->_list_view;
	gtk_tree_view_set_headers_visible (_tmp5_, FALSE);
	_tmp6_ = self->priv->_list_view;
	g_object_set ((GtkWidget*) _tmp6_, "expand", TRUE, NULL);
	_tmp7_ = self->priv->_list_view;
	_tmp8_ = utils_add_scrollbar ((GtkWidget*) _tmp7_);
	scrolled_window = _tmp8_;
	gtk_scrolled_window_set_shadow_type (scrolled_window, GTK_SHADOW_IN);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) scrolled_window);
	_tmp9_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp9_);
	column = _tmp9_;
	_tmp10_ = self->priv->_list_view;
	gtk_tree_view_append_column (_tmp10_, column);
	_tmp11_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp11_);
	pixbuf_renderer = _tmp11_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) pixbuf_renderer, "icon-name", FILE_BROWSER_FILE_COLUMN_PIXBUF, NULL);
	_tmp12_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp12_);
	text_renderer = _tmp12_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) text_renderer, "text", FILE_BROWSER_FILE_COLUMN_NAME, NULL);
	_tmp13_ = self->priv->_list_view;
	g_signal_connect_object (_tmp13_, "row-activated", (GCallback) ___lambda81__gtk_tree_view_row_activated, self, 0);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (scrolled_window);
}


static void
file_browser_init_toolbar (FileBrowser* self)
{
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp0_;
	GtkToolButton* _tmp1_;
	GtkToolButton* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolButton* _tmp6_;
	GtkToolButton* _tmp7_;
	GtkToolButton* _tmp8_;
	GtkToolButton* _tmp9_;
	GtkToolButton* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp0_);
	toolbar = _tmp0_;
	gtk_toolbar_set_icon_size (toolbar, GTK_ICON_SIZE_MENU);
	gtk_toolbar_set_style (toolbar, GTK_TOOLBAR_ICONS);
	_tmp1_ = file_browser_get_home_button (self);
	_tmp2_ = _tmp1_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp2_, -1);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = file_browser_get_parent_button (self);
	_tmp4_ = _tmp3_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp4_, -1);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = file_browser_get_jump_button (self);
	_tmp6_ = _tmp5_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp6_, -1);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = file_browser_get_open_directory_button (self);
	_tmp8_ = _tmp7_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp8_, -1);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = file_browser_get_properties_button (self);
	_tmp10_ = _tmp9_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp10_, -1);
	_g_object_unref0 (_tmp10_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) toolbar);
	_g_object_unref0 (toolbar);
}


static void
__lambda74_ (FileBrowser* self)
{
	GFile* home_dir = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	home_dir = _tmp1_;
	file_browser_set_directory (self, home_dir, FALSE);
	_g_object_unref0 (home_dir);
}


static void
___lambda74__gtk_tool_button_clicked (GtkToolButton* _sender, 
                                      gpointer self)
{
	__lambda74_ ((FileBrowser*) self);
}


static GtkToolButton*
file_browser_get_home_button (FileBrowser* self)
{
	GtkToolButton* result = NULL;
	GtkToolButton* home_button = NULL;
	GtkToolButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	home_button = _tmp0_;
	gtk_tool_button_set_icon_name (home_button, "go-home");
	gtk_widget_set_tooltip_text ((GtkWidget*) home_button, _ ("Go to the home directory"));
	g_signal_connect_object (home_button, "clicked", (GCallback) ___lambda74__gtk_tool_button_clicked, self, 0);
	result = home_button;
	return result;
}


static void
__lambda75_ (FileBrowser* self)
{
	GFile* parent = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	_tmp0_ = self->priv->_current_directory;
	_tmp1_ = g_file_get_parent (_tmp0_);
	parent = _tmp1_;
	g_return_if_fail (parent != NULL);
	file_browser_set_directory (self, parent, FALSE);
	_g_object_unref0 (parent);
}


static void
___lambda75__gtk_tool_button_clicked (GtkToolButton* _sender, 
                                      gpointer self)
{
	__lambda75_ ((FileBrowser*) self);
}


static GtkToolButton*
file_browser_get_parent_button (FileBrowser* self)
{
	GtkToolButton* result = NULL;
	GtkToolButton* _tmp0_;
	GtkToolButton* _tmp1_;
	GtkToolButton* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* _tmp4_;
	GtkToolButton* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_parent_button);
	self->priv->_parent_button = _tmp0_;
	_tmp1_ = self->priv->_parent_button;
	gtk_tool_button_set_icon_name (_tmp1_, "go-up");
	_tmp2_ = self->priv->_parent_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _ ("Go to the parent directory"));
	_tmp3_ = self->priv->_parent_button;
	g_signal_connect_object (_tmp3_, "clicked", (GCallback) ___lambda75__gtk_tool_button_clicked, self, 0);
	_tmp4_ = self->priv->_parent_button;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	result = _tmp5_;
	return result;
}


static void
__lambda76_ (FileBrowser* self)
{
	gboolean _tmp0_ = FALSE;
	MainWindow* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	_tmp1_ = self->priv->_main_window;
	_tmp2_ = main_window_get_active_document (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		MainWindow* _tmp4_;
		Document* _tmp5_;
		Document* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		_tmp4_ = self->priv->_main_window;
		_tmp5_ = main_window_get_active_document (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = document_get_location (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		MainWindow* _tmp9_;
		Document* _tmp10_;
		Document* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		_tmp9_ = self->priv->_main_window;
		_tmp10_ = main_window_get_active_document (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = document_get_location (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_file_get_parent (_tmp13_);
		_tmp15_ = _tmp14_;
		file_browser_set_directory (self, _tmp15_, FALSE);
		_g_object_unref0 (_tmp15_);
	}
}


static void
___lambda76__gtk_tool_button_clicked (GtkToolButton* _sender, 
                                      gpointer self)
{
	__lambda76_ ((FileBrowser*) self);
}


static GtkToolButton*
file_browser_get_jump_button (FileBrowser* self)
{
	GtkToolButton* result = NULL;
	GtkToolButton* jump_button = NULL;
	GtkToolButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	jump_button = _tmp0_;
	gtk_tool_button_set_icon_name (jump_button, "go-jump");
	gtk_widget_set_tooltip_text ((GtkWidget*) jump_button, _ ("Go to the active document directory"));
	g_signal_connect_object (jump_button, "clicked", (GCallback) ___lambda76__gtk_tool_button_clicked, self, 0);
	result = jump_button;
	return result;
}


static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}


static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		FileBrowser* self;
		self = _data19_->self;
		_g_object_unref0 (_data19_->button);
		_g_object_unref0 (_data19_->menu);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}


static void
__lambda79_ (Block19Data* _data19_)
{
	FileBrowser* self;
	self = _data19_->self;
	gtk_menu_popup_at_widget (_data19_->menu, (GtkWidget*) _data19_->button, GDK_GRAVITY_SOUTH_WEST, GDK_GRAVITY_NORTH_WEST, NULL);
}


static void
___lambda79__gtk_tool_button_clicked (GtkToolButton* _sender, 
                                      gpointer self)
{
	__lambda79_ (self);
}


static GtkToolButton*
file_browser_get_open_directory_button (FileBrowser* self)
{
	GtkToolButton* result = NULL;
	Block19Data* _data19_;
	GtkMenu* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkMenuItem* _tmp3_;
	GtkMenuItem* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolButton* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = g_object_ref (self);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_data19_->menu = _tmp0_;
	_tmp1_ = file_browser_get_open_directory_menu (self);
	_tmp2_ = _tmp1_;
	gtk_menu_shell_append ((GtkMenuShell*) _data19_->menu, (GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = file_browser_get_open_terminal_menu (self);
	_tmp4_ = _tmp3_;
	gtk_menu_shell_append ((GtkMenuShell*) _data19_->menu, (GtkWidget*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	gtk_widget_show_all ((GtkWidget*) _data19_->menu);
	_tmp5_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp5_);
	_data19_->button = _tmp5_;
	gtk_tool_button_set_icon_name (_data19_->button, "document-open");
	g_signal_connect_data (_data19_->button, "clicked", (GCallback) ___lambda79__gtk_tool_button_clicked, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_tmp6_ = _g_object_ref0 (_data19_->button);
	result = _tmp6_;
	block19_data_unref (_data19_);
	_data19_ = NULL;
	return result;
}


static void
__lambda77_ (FileBrowser* self)
{
	GFile* _tmp0_;
	GError * _inner_error_ = NULL;
	_tmp0_ = self->priv->_current_directory;
	g_return_if_fail (_tmp0_ != NULL);
	{
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->_current_directory;
		_tmp2_ = g_file_get_uri (_tmp1_);
		_tmp3_ = _tmp2_;
		latexila_utils_show_uri ((GtkWidget*) self, _tmp3_, (guint32) GDK_CURRENT_TIME, &_inner_error_);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _error_;
		file_browser_handle_error (self, _tmp4_);
		_g_error_free0 (_error_);
	}
	__finally20:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
___lambda77__gtk_menu_item_activate (GtkMenuItem* _sender, 
                                     gpointer self)
{
	__lambda77_ ((FileBrowser*) self);
}


static GtkMenuItem*
file_browser_get_open_directory_menu (FileBrowser* self)
{
	GtkMenuItem* result = NULL;
	GtkMenuItem* open_directory = NULL;
	GtkMenuItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Open in a file manager"));
	g_object_ref_sink (_tmp0_);
	open_directory = _tmp0_;
	gtk_widget_set_tooltip_text ((GtkWidget*) open_directory, _ ("Open the current directory in a file manager"));
	g_signal_connect_object (open_directory, "activate", (GCallback) ___lambda77__gtk_menu_item_activate, self, 0);
	result = open_directory;
	return result;
}


static void
__lambda78_ (FileBrowser* self)
{
	GFile* _tmp0_;
	GSettings* terminal_settings = NULL;
	GSettings* _tmp1_;
	gchar* name_term = NULL;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	_tmp0_ = self->priv->_current_directory;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = g_settings_new ("org.gnome.desktop.default-applications.terminal");
	terminal_settings = _tmp1_;
	_tmp2_ = terminal_settings;
	_tmp3_ = g_settings_get_string (_tmp2_, "exec");
	name_term = _tmp3_;
	_tmp4_ = name_term;
	g_return_if_fail (_tmp4_ != NULL);
	{
		gchar* exec_cmd = NULL;
		const gchar* _tmp5_;
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GAppInfo* app_info = NULL;
		const gchar* _tmp11_;
		GAppInfo* _tmp12_;
		GAppInfo* _tmp13_;
		_tmp5_ = name_term;
		_tmp6_ = self->priv->_current_directory;
		_tmp7_ = g_file_get_path (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("%s --working-directory=\"%s\"", _tmp5_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		exec_cmd = _tmp10_;
		_tmp11_ = exec_cmd;
		_tmp12_ = g_app_info_create_from_commandline (_tmp11_, "", 0, &_inner_error_);
		app_info = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (exec_cmd);
			goto __catch21_g_error;
		}
		_tmp13_ = app_info;
		g_app_info_launch (_tmp13_, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (app_info);
			_g_free0 (exec_cmd);
			goto __catch21_g_error;
		}
		_g_object_unref0 (app_info);
		_g_free0 (exec_cmd);
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp14_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = _error_;
		file_browser_handle_error (self, _tmp14_);
		_g_error_free0 (_error_);
	}
	__finally21:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (name_term);
		_g_object_unref0 (terminal_settings);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (name_term);
	_g_object_unref0 (terminal_settings);
}


static void
___lambda78__gtk_menu_item_activate (GtkMenuItem* _sender, 
                                     gpointer self)
{
	__lambda78_ ((FileBrowser*) self);
}


static GtkMenuItem*
file_browser_get_open_terminal_menu (FileBrowser* self)
{
	GtkMenuItem* result = NULL;
	GtkMenuItem* open_terminal = NULL;
	GtkMenuItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Open in a terminal"));
	g_object_ref_sink (_tmp0_);
	open_terminal = _tmp0_;
	gtk_widget_set_tooltip_text ((GtkWidget*) open_terminal, _ ("Open the current directory in a terminal"));
	g_signal_connect_object (open_terminal, "activate", (GCallback) ___lambda78__gtk_menu_item_activate, self, 0);
	result = open_terminal;
	return result;
}


static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		FileBrowser* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->button);
		_g_object_unref0 (_data20_->menu);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}


static void
__lambda80_ (Block20Data* _data20_)
{
	FileBrowser* self;
	self = _data20_->self;
	gtk_menu_popup_at_widget (_data20_->menu, (GtkWidget*) _data20_->button, GDK_GRAVITY_SOUTH_WEST, GDK_GRAVITY_NORTH_WEST, NULL);
}


static void
___lambda80__gtk_tool_button_clicked (GtkToolButton* _sender, 
                                      gpointer self)
{
	__lambda80_ (self);
}


static GtkToolButton*
file_browser_get_properties_button (FileBrowser* self)
{
	GtkToolButton* result = NULL;
	Block20Data* _data20_;
	GtkCheckMenuItem* show_build_files = NULL;
	GtkCheckMenuItem* _tmp0_;
	GSettings* _tmp1_;
	GtkCheckMenuItem* show_hidden_files = NULL;
	GtkCheckMenuItem* _tmp2_;
	GSettings* _tmp3_;
	GtkMenu* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolButton* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	_tmp0_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Show build files"));
	g_object_ref_sink (_tmp0_);
	show_build_files = _tmp0_;
	_tmp1_ = self->priv->_settings;
	g_settings_bind (_tmp1_, "show-build-files", (GObject*) show_build_files, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp2_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Show hidden files"));
	g_object_ref_sink (_tmp2_);
	show_hidden_files = _tmp2_;
	_tmp3_ = self->priv->_settings;
	g_settings_bind (_tmp3_, "show-hidden-files", (GObject*) show_hidden_files, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp4_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp4_);
	_data20_->menu = _tmp4_;
	gtk_menu_shell_append ((GtkMenuShell*) _data20_->menu, (GtkWidget*) ((GtkMenuItem*) show_build_files));
	gtk_menu_shell_append ((GtkMenuShell*) _data20_->menu, (GtkWidget*) ((GtkMenuItem*) show_hidden_files));
	gtk_widget_show_all ((GtkWidget*) _data20_->menu);
	_tmp5_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp5_);
	_data20_->button = _tmp5_;
	gtk_tool_button_set_icon_name (_data20_->button, "document-properties");
	g_signal_connect_data (_data20_->button, "clicked", (GCallback) ___lambda80__gtk_tool_button_clicked, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
	_tmp6_ = _g_object_ref0 (_data20_->button);
	result = _tmp6_;
	_g_object_unref0 (show_hidden_files);
	_g_object_unref0 (show_build_files);
	block20_data_unref (_data20_);
	_data20_ = NULL;
	return result;
}


/*************************************************************************/
static void
file_browser_update_parent_directories (FileBrowser* self)
{
	GtkListStore* _tmp0_;
	GeeList* parent_dirs = NULL;
	GeeLinkedList* _tmp1_;
	GeeList* _tmp2_;
	GFile* _tmp3_;
	GFile* parent = NULL;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gint depth = 0;
	GtkComboBox* _tmp43_;
	gint _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_parent_dir_store;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = gee_linked_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	parent_dirs = (GeeList*) _tmp1_;
	_tmp2_ = parent_dirs;
	_tmp3_ = self->priv->_current_directory;
	gee_collection_add ((GeeCollection*) _tmp2_, _tmp3_);
	_tmp4_ = self->priv->_current_directory;
	_tmp5_ = g_file_get_parent (_tmp4_);
	parent = _tmp5_;
	while (TRUE) {
		GFile* _tmp6_;
		GeeList* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		_tmp6_ = parent;
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp7_ = parent_dirs;
		_tmp8_ = parent;
		gee_list_insert (_tmp7_, 0, _tmp8_);
		_tmp9_ = parent;
		_tmp10_ = g_file_get_parent (_tmp9_);
		_g_object_unref0 (parent);
		parent = _tmp10_;
	}
	depth = 0;
	{
		GeeList* _parent_dir_list = NULL;
		GeeList* _tmp11_;
		GeeList* _tmp12_;
		gint _parent_dir_size = 0;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _parent_dir_index = 0;
		_tmp11_ = parent_dirs;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_parent_dir_list = _tmp12_;
		_tmp13_ = _parent_dir_list;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_parent_dir_size = _tmp15_;
		_parent_dir_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			GFile* parent_dir = NULL;
			GeeList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			gchar* basename = NULL;
			gint _tmp22_;
			gchar* pixbuf = NULL;
			gint _tmp26_;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp35_;
			GtkTreeIter _tmp36_ = {0};
			GtkListStore* _tmp37_;
			GtkTreeIter _tmp38_;
			GFile* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			gint _tmp42_;
			_tmp16_ = _parent_dir_index;
			_parent_dir_index = _tmp16_ + 1;
			_tmp17_ = _parent_dir_index;
			_tmp18_ = _parent_dir_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _parent_dir_list;
			_tmp20_ = _parent_dir_index;
			_tmp21_ = gee_list_get (_tmp19_, _tmp20_);
			parent_dir = (GFile*) _tmp21_;
			_tmp22_ = depth;
			if (_tmp22_ == 0) {
				gchar* _tmp23_;
				_tmp23_ = g_strdup (_ ("File System"));
				_g_free0 (basename);
				basename = _tmp23_;
			} else {
				GFile* _tmp24_;
				gchar* _tmp25_;
				_tmp24_ = parent_dir;
				_tmp25_ = g_file_get_basename (_tmp24_);
				_g_free0 (basename);
				basename = _tmp25_;
			}
			_tmp26_ = depth;
			if (_tmp26_ == 0) {
				gchar* _tmp27_;
				_tmp27_ = g_strdup ("drive-harddisk");
				_g_free0 (pixbuf);
				pixbuf = _tmp27_;
			} else {
				const gchar* _tmp28_;
				GFile* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gboolean _tmp32_;
				_tmp28_ = g_get_home_dir ();
				_tmp29_ = parent_dir;
				_tmp30_ = g_file_get_path (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = g_strcmp0 (_tmp28_, _tmp31_) == 0;
				_g_free0 (_tmp31_);
				if (_tmp32_) {
					gchar* _tmp33_;
					_tmp33_ = g_strdup ("go-home");
					_g_free0 (pixbuf);
					pixbuf = _tmp33_;
				} else {
					gchar* _tmp34_;
					_tmp34_ = g_strdup ("folder");
					_g_free0 (pixbuf);
					pixbuf = _tmp34_;
				}
			}
			_tmp35_ = self->priv->_parent_dir_store;
			gtk_list_store_append (_tmp35_, &_tmp36_);
			iter = _tmp36_;
			_tmp37_ = self->priv->_parent_dir_store;
			_tmp38_ = iter;
			_tmp39_ = parent_dir;
			_tmp40_ = basename;
			_tmp41_ = pixbuf;
			gtk_list_store_set (_tmp37_, &_tmp38_, FILE_BROWSER_PARENT_DIR_COLUMN_FILE, _tmp39_, FILE_BROWSER_PARENT_DIR_COLUMN_NAME, _tmp40_, FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, _tmp41_, -1);
			_tmp42_ = depth;
			depth = _tmp42_ + 1;
			_g_free0 (pixbuf);
			_g_free0 (basename);
			_g_object_unref0 (parent_dir);
		}
		_g_object_unref0 (_parent_dir_list);
	}
	_tmp43_ = self->priv->_combo_box;
	_tmp44_ = depth;
	gtk_combo_box_set_active (_tmp43_, _tmp44_ - 1);
	_g_object_unref0 (parent);
	_g_object_unref0 (parent_dirs);
}


static gchar
string_get (const gchar* self, 
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static void
file_browser_update_list (FileBrowser* self)
{
	GtkListStore* _tmp0_;
	GtkTreeView* _tmp1_;
	gboolean show_build_files = FALSE;
	GSettings* _tmp2_;
	gboolean show_hidden_files = FALSE;
	GSettings* _tmp3_;
	gchar* exts = NULL;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	gchar** clean_extensions = NULL;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint clean_extensions_length1;
	gint _clean_extensions_size_;
	GFileEnumerator* enumerator = NULL;
	GtkListStore* _tmp41_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_list_store;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = self->priv->_list_view;
	gtk_tree_view_columns_autosize (_tmp1_);
	_tmp2_ = self->priv->_settings;
	show_build_files = g_settings_get_boolean (_tmp2_, "show-build-files");
	_tmp3_ = self->priv->_settings;
	show_hidden_files = g_settings_get_boolean (_tmp3_, "show-hidden-files");
	_tmp4_ = self->priv->_latex_settings;
	_tmp5_ = g_settings_get_string (_tmp4_, "clean-extensions");
	exts = _tmp5_;
	_tmp6_ = exts;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, " ", 0);
	clean_extensions = _tmp8_;
	clean_extensions_length1 = _vala_array_length (_tmp7_);
	_clean_extensions_size_ = clean_extensions_length1;
	{
		GFileEnumerator* _tmp9_ = NULL;
		GFile* _tmp10_;
		GFileEnumerator* _tmp11_;
		GFileEnumerator* _tmp12_;
		_tmp10_ = self->priv->_current_directory;
		_tmp11_ = g_file_enumerate_children (_tmp10_, "standard::type,standard::display-name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch22_g_error;
		}
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		_g_object_unref0 (enumerator);
		enumerator = _tmp12_;
		_g_object_unref0 (_tmp9_);
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp13_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = _error_;
		file_browser_handle_error (self, _tmp13_);
		_g_error_free0 (_error_);
		_g_object_unref0 (enumerator);
		clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (exts);
		return;
	}
	__finally22:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (enumerator);
		clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (exts);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	while (TRUE) {
		GFileInfo* info = NULL;
		GFileInfo* _tmp19_;
		gchar* basename = NULL;
		GFileInfo* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gboolean _tmp23_ = FALSE;
		const gchar* _tmp24_;
		GFileType type = 0;
		GFileInfo* _tmp26_;
		GFileType _tmp27_;
		gboolean _tmp29_;
		gchar* extension = NULL;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* icon_name = NULL;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		{
			GFileInfo* _tmp14_ = NULL;
			GFileEnumerator* _tmp15_;
			GFileInfo* _tmp16_;
			GFileInfo* _tmp17_;
			_tmp15_ = enumerator;
			_tmp16_ = g_file_enumerator_next_file (_tmp15_, NULL, &_inner_error_);
			_tmp14_ = _tmp16_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch23_g_error;
			}
			_tmp17_ = _tmp14_;
			_tmp14_ = NULL;
			_g_object_unref0 (info);
			info = _tmp17_;
			_g_object_unref0 (_tmp14_);
		}
		goto __finally23;
		__catch23_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp18_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp18_ = _error_;
			file_browser_handle_error (self, _tmp18_);
			_g_error_free0 (_error_);
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (exts);
			return;
		}
		__finally23:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (exts);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp19_ = info;
		if (_tmp19_ == NULL) {
			_g_object_unref0 (info);
			break;
		}
		_tmp20_ = info;
		_tmp21_ = g_file_info_get_display_name (_tmp20_);
		_tmp22_ = g_strdup (_tmp21_);
		basename = _tmp22_;
		_tmp24_ = basename;
		if (string_get (_tmp24_, (glong) 0) == '.') {
			gboolean _tmp25_;
			_tmp25_ = show_hidden_files;
			_tmp23_ = !_tmp25_;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			_g_free0 (basename);
			_g_object_unref0 (info);
			continue;
		}
		_tmp26_ = info;
		type = g_file_info_get_file_type (_tmp26_);
		_tmp27_ = type;
		if (_tmp27_ == G_FILE_TYPE_DIRECTORY) {
			const gchar* _tmp28_;
			_tmp28_ = basename;
			file_browser_insert_file (self, TRUE, "folder", _tmp28_);
			_g_free0 (basename);
			_g_object_unref0 (info);
			continue;
		}
		_tmp29_ = show_build_files;
		if (!_tmp29_) {
			gboolean is_build_file = FALSE;
			gchar** _tmp30_;
			gint _tmp30__length1;
			gboolean _tmp34_;
			is_build_file = FALSE;
			_tmp30_ = clean_extensions;
			_tmp30__length1 = clean_extensions_length1;
			{
				gchar** ext_collection = NULL;
				gint ext_collection_length1 = 0;
				gint _ext_collection_size_ = 0;
				gint ext_it = 0;
				ext_collection = _tmp30_;
				ext_collection_length1 = _tmp30__length1;
				for (ext_it = 0; ext_it < _tmp30__length1; ext_it = ext_it + 1) {
					gchar* _tmp31_;
					gchar* ext = NULL;
					_tmp31_ = g_strdup (ext_collection[ext_it]);
					ext = _tmp31_;
					{
						const gchar* _tmp32_;
						const gchar* _tmp33_;
						_tmp32_ = basename;
						_tmp33_ = ext;
						if (g_str_has_suffix (_tmp32_, _tmp33_)) {
							is_build_file = TRUE;
							_g_free0 (ext);
							break;
						}
						_g_free0 (ext);
					}
				}
			}
			_tmp34_ = is_build_file;
			if (_tmp34_) {
				_g_free0 (basename);
				_g_object_unref0 (info);
				continue;
			}
		}
		_tmp35_ = basename;
		_tmp36_ = latexila_utils_get_extension (_tmp35_);
		extension = _tmp36_;
		_tmp37_ = extension;
		_tmp38_ = file_browser_get_extension_icon_name (self, _tmp37_);
		icon_name = _tmp38_;
		_tmp39_ = icon_name;
		_tmp40_ = basename;
		file_browser_insert_file (self, FALSE, _tmp39_, _tmp40_);
		_g_free0 (icon_name);
		_g_free0 (extension);
		_g_free0 (basename);
		_g_object_unref0 (info);
	}
	_tmp41_ = self->priv->_list_store;
	gtk_tree_sortable_sort_column_changed ((GtkTreeSortable*) _tmp41_);
	_g_object_unref0 (enumerator);
	clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (exts);
}


static void
file_browser_handle_error (FileBrowser* self, 
                           GError* _error_)
{
	const gchar* _tmp0_;
	GtkMessageDialog* dialog = NULL;
	MainWindow* _tmp1_;
	GtkMessageDialog* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _error_->message;
	g_warning ("file_browser.vala:517: File browser: %s", _tmp0_);
	_tmp1_ = self->priv->_main_window;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp1_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_CLOSE, "%s", _ ("File Browser"));
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	_tmp3_ = _error_->message;
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp3_);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


static void
file_browser_insert_file (FileBrowser* self, 
                          gboolean is_dir, 
                          const gchar* icon_name, 
                          const gchar* basename)
{
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	g_return_if_fail (basename != NULL);
	_tmp0_ = self->priv->_list_store;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->_list_store;
	_tmp3_ = iter;
	gtk_list_store_set (_tmp2_, &_tmp3_, FILE_BROWSER_FILE_COLUMN_IS_DIR, is_dir, FILE_BROWSER_FILE_COLUMN_PIXBUF, icon_name, FILE_BROWSER_FILE_COLUMN_NAME, basename, -1);
}


static void
_file_browser_refresh_g_file_monitor_changed (GFileMonitor* _sender, 
                                              GFile* file, 
                                              GFile* other_file, 
                                              GFileMonitorEvent event_type, 
                                              gpointer self)
{
	file_browser_refresh ((FileBrowser*) self);
}


static void
file_browser_monitor_directory (FileBrowser* self)
{
	GFile* _tmp0_;
	GFileMonitor* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_directory;
	if (_tmp0_ == NULL) {
		_g_object_unref0 (self->priv->_monitor);
		self->priv->_monitor = NULL;
		return;
	}
	{
		GFileMonitor* _tmp1_ = NULL;
		GFile* _tmp2_;
		GFileMonitor* _tmp3_;
		GFileMonitor* _tmp4_;
		_tmp2_ = self->priv->_current_directory;
		_tmp3_ = g_file_monitor_directory (_tmp2_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch24_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->_monitor);
		self->priv->_monitor = _tmp4_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally24;
	__catch24_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("file_browser.vala:556: Can not refresh automatically the file browser:" \
" %s", _tmp6_);
		_g_error_free0 (e);
		return;
	}
	__finally24:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = self->priv->_monitor;
	g_signal_connect_object (_tmp7_, "changed", (GCallback) _file_browser_refresh_g_file_monitor_changed, self, 0);
}


/*************************************************************************/
static void
file_browser_refresh (FileBrowser* self)
{
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_directory;
	file_browser_set_directory (self, _tmp0_, TRUE);
}


static gboolean
__lambda72_ (FileBrowser* self)
{
	gboolean result = FALSE;
	self->priv->_timeout_id = (guint) 0;
	file_browser_refresh (self);
	result = FALSE;
	return result;
}


static gboolean
___lambda72__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda72_ ((FileBrowser*) self);
	return result;
}


static void
file_browser_delayed_refresh (FileBrowser* self)
{
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_timeout_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->_timeout_id;
		g_source_remove (_tmp1_);
	}
	self->priv->_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda72__gsource_func, g_object_ref (self), g_object_unref);
}


static GFile*
file_browser_get_default_directory (FileBrowser* self)
{
	GFile* result = NULL;
	gchar* uri = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp8_;
	GFile* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "current-directory");
	uri = _tmp1_;
	_tmp3_ = uri;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = uri;
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GFile* directory = NULL;
		const gchar* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp5_ = uri;
		_tmp6_ = g_file_new_for_uri (_tmp5_);
		directory = _tmp6_;
		_tmp7_ = directory;
		if (g_file_query_exists (_tmp7_, NULL)) {
			result = directory;
			_g_free0 (uri);
			return result;
		}
		_g_object_unref0 (directory);
	}
	_tmp8_ = g_get_home_dir ();
	_tmp9_ = g_file_new_for_path (_tmp8_);
	result = _tmp9_;
	_g_free0 (uri);
	return result;
}


static void
file_browser_set_directory (FileBrowser* self, 
                            GFile* directory, 
                            gboolean force)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp2_;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkToolButton* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	if (!force) {
		GFile* _tmp1_;
		_tmp1_ = self->priv->_current_directory;
		_tmp0_ = _tmp1_ == directory;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp2_ = _g_object_ref0 (directory);
	_g_object_unref0 (self->priv->_current_directory);
	self->priv->_current_directory = _tmp2_;
	_tmp3_ = self->priv->_settings;
	_tmp4_ = g_file_get_uri (directory);
	_tmp5_ = _tmp4_;
	g_settings_set_string (_tmp3_, "current-directory", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->_parent_button;
	_tmp7_ = g_file_get_parent (directory);
	_tmp8_ = _tmp7_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, _tmp8_ != NULL);
	_g_object_unref0 (_tmp8_);
	file_browser_update_parent_directories (self);
	file_browser_update_list (self);
	file_browser_monitor_directory (self);
}


static gint
file_browser_on_sort (FileBrowser* self, 
                      GtkTreeModel* model, 
                      GtkTreeIter* a, 
                      GtkTreeIter* b)
{
	gint result = 0;
	gboolean a_is_dir = FALSE;
	gboolean b_is_dir = FALSE;
	GtkTreeIter _tmp0_;
	GtkTreeIter _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint _tmp8_ = 0;
	gboolean _tmp9_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = *a;
	gtk_tree_model_get (model, &_tmp0_, FILE_BROWSER_FILE_COLUMN_IS_DIR, &a_is_dir, -1);
	_tmp1_ = *b;
	gtk_tree_model_get (model, &_tmp1_, FILE_BROWSER_FILE_COLUMN_IS_DIR, &b_is_dir, -1);
	_tmp2_ = a_is_dir;
	_tmp3_ = b_is_dir;
	if (_tmp2_ == _tmp3_) {
		gchar* a_name = NULL;
		gchar* b_name = NULL;
		GtkTreeIter _tmp4_;
		GtkTreeIter _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = *a;
		gtk_tree_model_get (model, &_tmp4_, FILE_BROWSER_FILE_COLUMN_NAME, &a_name, -1);
		_tmp5_ = *b;
		gtk_tree_model_get (model, &_tmp5_, FILE_BROWSER_FILE_COLUMN_NAME, &b_name, -1);
		_tmp6_ = a_name;
		_tmp7_ = b_name;
		result = g_utf8_collate (_tmp6_, _tmp7_);
		_g_free0 (b_name);
		_g_free0 (a_name);
		return result;
	}
	_tmp9_ = a_is_dir;
	if (_tmp9_) {
		_tmp8_ = -1;
	} else {
		_tmp8_ = 1;
	}
	result = _tmp8_;
	return result;
}


static gchar*
file_browser_get_extension_icon_name (FileBrowser* self, 
                                      const gchar* file_extension)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file_extension != NULL, NULL);
	_tmp0_ = file_extension;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (".tex")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup (GTK_STOCK_EDIT);
				result = _tmp3_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (".pdf")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("latexila-pdf");
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (".dvi")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("latexila-dvi");
				result = _tmp5_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string (".ps")))) || (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string (".eps"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("latexila-ps");
				result = _tmp6_;
				return result;
			}
		}
	} else if (((((((_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string (".png")))) || (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string (".jpg"))))) || (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string (".jpeg"))))) || (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string (".gif"))))) || (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string (".bmp"))))) || (_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string (".tif"))))) || (_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string (".tiff"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("image-x-generic");
				result = _tmp7_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("text-x-generic");
				result = _tmp8_;
				return result;
			}
		}
	}
}


static void
file_browser_class_init (FileBrowserClass * klass)
{
	file_browser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FileBrowserPrivate));
	G_OBJECT_CLASS (klass)->finalize = file_browser_finalize;
}


static void
file_browser_instance_init (FileBrowser * self)
{
	self->priv = FILE_BROWSER_GET_PRIVATE (self);
	self->priv->_timeout_id = (guint) 0;
}


static void
file_browser_finalize (GObject * obj)
{
	FileBrowser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_BROWSER, FileBrowser);
	_g_object_unref0 (self->priv->_parent_dir_store);
	_g_object_unref0 (self->priv->_combo_box);
	_g_object_unref0 (self->priv->_list_store);
	_g_object_unref0 (self->priv->_list_view);
	_g_object_unref0 (self->priv->_current_directory);
	_g_object_unref0 (self->priv->_monitor);
	_g_object_unref0 (self->priv->_parent_button);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_latex_settings);
	G_OBJECT_CLASS (file_browser_parent_class)->finalize (obj);
}


GType
file_browser_get_type (void)
{
	static volatile gsize file_browser_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FileBrowserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_browser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileBrowser), 0, (GInstanceInitFunc) file_browser_instance_init, NULL };
		GType file_browser_type_id;
		file_browser_type_id = g_type_register_static (gtk_grid_get_type (), "FileBrowser", &g_define_type_info, 0);
		g_once_init_leave (&file_browser_type_id__volatile, file_browser_type_id);
	}
	return file_browser_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



