package org.gnu.libedataserver;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

public class ESourceGroup extends EDSObject
{
    public ESourceGroup(Handle handle)
    {
        super(handle);
    }

    public static ESourceGroup getESourceGroup(Handle handle) {
        if (handle == null)
            return null;

        ESourceGroup obj = (ESourceGroup) GObject.getGObjectFromHandle(handle);
        return obj == null ? new ESourceGroup(handle) : obj;
    }

    public void setName(String name)
    {
        e_source_group_set_name(getHandle(), name);
    }

    public void setBaseUri(String baseUri)
    {
        e_source_group_set_base_uri(getHandle(), baseUri);
    }

    public void setReadonly(boolean readonly)
    {
        e_source_group_set_readonly(getHandle(), readonly);
    }

    public String getUid()
    {
        return e_source_group_peek_uid(getHandle());
    }

    public String getName()
    {
        return e_source_group_peek_name(getHandle());
    }

    public String getBaseUri()
    {
        return e_source_group_peek_base_uri(getHandle());
    }

    public boolean getReadonly()
    {
        return e_source_group_get_readonly(getHandle());
    }

    public ESource[] getSources()
    {
        return convertHandlesToESources(e_source_group_peek_sources(getHandle()));
    }

    public ESource getSourceByUid(String uid)
    {
        return createESourceFromHandle(e_source_group_peek_source_by_uid(getHandle(), uid));
    }

    public ESource getSourceByName(String name)
    {
        return createESourceFromHandle(e_source_group_peek_source_by_name(getHandle(), name));
    }

    public boolean addSource(ESource source)
    {
        return e_source_group_add_source(getHandle(), source.getHandle(), -1);
    }

    public boolean removeSource(ESource source)
    {
        return e_source_group_remove_source(getHandle(), source.getHandle());
    }

    public boolean removeSourceByUid(String uid)
    {
        return e_source_group_remove_source_by_uid(getHandle(), uid);
    }

    public String getAsXml()
    {
        return e_source_group_to_xml(getHandle());
    }

    public static ESourceGroup createFromUri(String name, String baseUri)
    {
        return name == null || baseUri == null ? null : getESourceGroup(e_source_group_new(name, baseUri));
    }

    public static ESourceGroup createFromXml(String xml)
    {
        return xml == null ? null : getESourceGroup(e_source_group_new_from_xml(xml));
    }

    private static ESource createESourceFromHandle(Handle handle)
    {
        return handle == null ? null : ESource.getESource(handle);
    }

    private static ESource[] convertHandlesToESources(Handle[] handles)
    {
        ESource[] eSources = new ESource[handles.length];
        for (int i = 0; i < handles.length; i++)
            eSources[i] = ESource.getESource(handles[i]);
        return eSources;
    }


    native static private Handle e_source_group_new(String name, String baseUri);

    native static private Handle e_source_group_new_from_xml(String xml);

    native static private void e_source_group_set_name(Handle handle, String name);

    native static private void e_source_group_set_base_uri(Handle handle, String baseUri);

    native static private void e_source_group_set_readonly(Handle handle, boolean readonly);

    native static private String e_source_group_peek_uid(Handle handle);

    native static private String e_source_group_peek_name(Handle handle);

    native static private String e_source_group_peek_base_uri(Handle handle);

    native static private boolean e_source_group_get_readonly(Handle handle);

    native static private Handle[] e_source_group_peek_sources(Handle handle);

    native static private Handle e_source_group_peek_source_by_uid(Handle handle, String uid);

    native static private Handle e_source_group_peek_source_by_name(Handle handle, String sourceName);

    native static private boolean e_source_group_add_source(Handle handle, Handle sourceHandle, int position);

    native static private boolean e_source_group_remove_source(Handle handle, Handle sourceHandle);

    native static private boolean e_source_group_remove_source_by_uid(Handle handle, String uid);

    native static private String e_source_group_to_xml(Handle handle);
}
