package org.gnu.libedataserver;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

public class ESourceList extends EDSObject
{
    public ESourceList(Handle handle)
    {
        super(handle);
    }

    public static ESourceList getESourceList(Handle handle) {
        if (handle == null)
            return null;

        ESourceList obj = (ESourceList) GObject.getGObjectFromHandle(handle);
        return obj == null ? new ESourceList(handle) : obj;
    }

    public ESourceGroup[] getGroups()
    {
        Handle[] handles = e_source_list_peek_groups(getHandle());
        ESourceGroup[] result = new ESourceGroup[handles.length];
        for (int i = 0; i < result.length; i++)
            result[i] = ESourceGroup.getESourceGroup(handles[i]);
        return result;
    }

    public ESourceGroup getGroupByUid(String uid)
    {
        return ESourceGroup.getESourceGroup(e_source_list_peek_group_by_uid(getHandle(), uid));
    }

    public ESourceGroup getGroupByName(String name)
    {
        return ESourceGroup.getESourceGroup(e_source_list_peek_group_by_name(getHandle(), name));
    }

    public ESource getSourceByUid(String uid)
    {
        return ESource.getESource(e_source_list_peek_source_by_uid(getHandle(), uid));
    }

    public ESource getSourceAny()
    {
        return ESource.getESource(e_source_list_peek_source_any(getHandle()));
    }

    public boolean addGroup(ESourceGroup source)
    {
        return e_source_list_add_group(getHandle(), source.getHandle(), -1);
    }

    public boolean removeGroup(ESourceGroup source)
    {
        return e_source_list_remove_group(getHandle(), source.getHandle());
    }

    public boolean removeGroup(String uid)
    {
        return e_source_list_remove_group_by_uid(getHandle(), uid);
    }

    public boolean removeSource(String uid)
    {
        return e_source_list_remove_source_by_uid(getHandle(), uid);
    }

    public boolean sync()
    {
        return e_source_list_sync(getHandle());
    }

    public static ESourceList createFromPath(String path)
    {
        return path == null ? null : getESourceList(e_source_list_new_for_gconf_default(path));
    }

    public static ESourceList createNew()
    {
        return getESourceList(e_source_list_new());
    }

    native private static Handle e_source_list_new();

    native private static Handle e_source_list_new_for_gconf_default(String path);

    native private static Handle[] e_source_list_peek_groups(Handle handle);

    native private static Handle e_source_list_peek_group_by_uid(Handle handle, String uid);

    native private static Handle e_source_list_peek_group_by_name(Handle handle, String name);

    native private static Handle e_source_list_peek_source_by_uid(Handle handle, String uid);

    native private static Handle e_source_list_peek_source_any(Handle handle);

    native private static boolean e_source_list_add_group(Handle handle, Handle eSourceGroup, int position);

    native private static boolean e_source_list_remove_group(Handle handle, Handle eSourceGroup);

    native private static boolean e_source_list_remove_group_by_uid(Handle handle, String uid);

    native private static boolean e_source_list_remove_source_by_uid(Handle handle, String uid);

    native private static boolean e_source_list_sync(Handle handle);

}
