/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "jg_jnu.h"
#include "gtk_java.h"
#include <libebook/e-book.h>
#include "org_gnu_libebook_EBook.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBook_e_1book_1new(JNIEnv *env, jclass cls, jobject handle, jobject error) {
    GError* error_g = NULL;
    ESource *source_g = (ESource*)getPointerFromHandle(env, handle);
    EBook *result = e_book_new(source_g, &error_g);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    return getGObjectHandleAndRef(env, (GObject*)result);
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_new_from_uri
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBook_e_1book_1new_1from_1uri(JNIEnv *env, jclass cls, jstring uri, jobject error) {
    GError* error_g = NULL;
    char* uri_g = (char*)(*env)->GetStringUTFChars(env, uri, 0);
    EBook *result = e_book_new_from_uri(uri_g, &error_g);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    (*env)->ReleaseStringUTFChars(env, uri, uri_g);
    return getGObjectHandleAndRef(env, (GObject*)result);
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_remove
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libebook_EBook_e_1book_1remove(JNIEnv *env, jclass cls, jobject handle, jobject error) {
    GError* error_g = NULL;
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    jboolean result = e_book_remove(book_g, &error_g);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    return result;
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_get_supported_fields
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_libebook_EBook_e_1book_1get_1supported_1fields(JNIEnv *env, jclass cls, jobject handle, jobject error) {
    GError* error_g = NULL;
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    GList *fields;
    GList *item;
    jclass strClass = (*env)->FindClass(env, "java/lang/String");
    int len, i;
    gchar* value;
    jstring str;
    jobjectArray result;

    e_book_get_supported_fields(book_g, &fields, &error_g);
    if (error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    if (fields == NULL)
        return NULL;

    len = g_list_length(fields);
    result = (*env)->NewObjectArray(env, len, strClass, NULL);
    item = fields;
    for (i = 0; item != NULL; item = item->next, ++i) {
        value = (gchar*)item->data;
        str = (*env)->NewStringUTF(env, value);
        (*env)->SetObjectArrayElement(env, result, i, str);
    }

    releaseStringArrayInGList(env, result, fields);
    return result;
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_get_supported_auth_methods
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_libebook_EBook_e_1book_1get_1supported_1auth_1methods(JNIEnv *env, jclass cls, jobject handle, jobject error) {
    GError* error_g = NULL;
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    GList *authMethods;
    GList *item;
    jclass strClass = (*env)->FindClass(env, "java/lang/String");
    int len, i;
    gchar* value;
    jstring str;
    jobjectArray result;

    e_book_get_supported_auth_methods(book_g, &authMethods, &error_g);
    if (error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    if (authMethods == NULL)
        return NULL;

    len = g_list_length(authMethods);
    result = (*env)->NewObjectArray(env, len, strClass, NULL);
    item = authMethods;
    for (i = 0; item != NULL; item = item->next, ++i) {
        value = (gchar*)item->data;
        str = (*env)->NewStringUTF(env, value);
        (*env)->SetObjectArrayElement(env, result, i, str);
    }

    releaseStringArrayInGList(env, result, authMethods);
    return result;
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_authenticate_user
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libebook_EBook_e_1book_1authenticate_1user(JNIEnv *env, jclass cls, jobject handle, jstring user, jstring password, jstring auth_method, jobject error) {
    GError* error_g = NULL;
    char* user_g = (char*)(*env)->GetStringUTFChars(env, user, 0);
    char* password_g = (char*)(*env)->GetStringUTFChars(env, password, 0);
    char* auth_method_g = (char*)(*env)->GetStringUTFChars(env, auth_method, 0);
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    jboolean result = e_book_authenticate_user(book_g, user_g, password_g, auth_method_g, &error_g);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    (*env)->ReleaseStringUTFChars(env, user, user_g);
    (*env)->ReleaseStringUTFChars(env, password, password_g);
    (*env)->ReleaseStringUTFChars(env, auth_method, auth_method_g);
    return result;
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_get_contact
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBook_e_1book_1get_1contact(JNIEnv *env, jclass cls, jobject handle, jstring id, jobject error) {
    GError* error_g = NULL;
    char* id_g = (char*)(*env)->GetStringUTFChars(env, id, 0);
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    EContact *e_contact;
    e_book_get_contact(book_g, id_g, &e_contact, &error_g);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    (*env)->ReleaseStringUTFChars(env, id, id_g);
    return getGObjectHandle(env, (GObject *)e_contact);
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_remove_contact
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libebook_EBook_e_1book_1remove_1contact(JNIEnv *env, jclass cls, jobject handle, jstring id, jobject error) {
    GError* error_g = NULL;
    char* id_g = (char*)(*env)->GetStringUTFChars(env, id, 0);
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    jboolean result = e_book_remove_contact(book_g, id_g, &error_g);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    (*env)->ReleaseStringUTFChars(env, id, id_g);
    return result;
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_remove_contacts
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libebook_EBook_e_1book_1remove_1contacts(JNIEnv *env, jclass cls, jobject handle, jobjectArray ids, jobject error) {
    GError* error_g = NULL;
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    GList *list;
    int i, len;

    list = g_list_alloc();
    len = (*env)->GetArrayLength(env, ids);
    for (i = 0; i < len; i++) {
        jstring id = (jstring)(*env)->GetObjectArrayElement(env, ids, i);
        const char *id_g = (char*)(*env)->GetStringUTFChars(env, id, 0);
        list = g_list_append(i == 0 ? NULL : list, (char *)id_g);

//        TODO fix this leak....
//        (*env)->ReleaseStringUTFChars(env, id, id_g);
    }

    jboolean result = e_book_remove_contacts(book_g, list, &error_g);

    g_list_free(list);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    return result;
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_add_contact
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libebook_EBook_e_1book_1add_1contact(JNIEnv *env, jclass cls, jobject handle, jobject contact, jobject error) {
    GError* error_g = NULL;
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    EContact *contact_g = (EContact*)getPointerFromHandle(env, contact);
    jboolean result = e_book_add_contact(book_g, contact_g, &error_g);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    return result;
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_commit_contact
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libebook_EBook_e_1book_1commit_1contact(JNIEnv *env, jclass cls, jobject handle, jobject contact, jobject error) {
    GError* error_g = NULL;
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    EContact *contact_g = (EContact*)getPointerFromHandle(env, contact);
    jboolean result = e_book_commit_contact(book_g, contact_g, &error_g);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    return result;
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_get_book_view
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBook_e_1book_1get_1book_1view(JNIEnv *env, jclass cls, jobject handle, jobject query, jobjectArray requested_fields, int max_results, jobject error) {
    GError* error_g = NULL;
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    GList *list = g_list_alloc();
    int i = 0;
    int len = (*env)->GetArrayLength(env, requested_fields);
    EBookQuery *query_g = (EBookQuery*)getPointerFromHandle(env, query);
    EBookView *e_book_view;
    gboolean result;



    for (i = 0; i < len; i++) {
        jstring requested_field = (jstring)(*env)->GetObjectArrayElement(env, requested_fields, i);
        const char *requested_field_g = (char*)(*env)->GetStringUTFChars(env, requested_field, 0);
        list = g_list_append(i == 0 ? NULL : list, (char *)requested_field_g);

//        TODO fix this leak....
//        (*env)->ReleaseStringUTFChars(env, requested_field, requested_field_g);
    }

    result = e_book_get_book_view(book_g, query_g, list, max_results, &e_book_view, &error_g);
    g_list_free(list);

    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    if(!result)
    	return NULL;
    return getGObjectHandle(env, (GObject *)e_book_view);
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_get_contacts
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_libebook_EBook_e_1book_1get_1contacts(JNIEnv *env, jclass cls, jobject handle, jobject query, jobject error) {
    GError* error_g = NULL;
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    EBookQuery *query_g = (EBookQuery*)getPointerFromHandle(env, query);
    GList *contacts = NULL;

    e_book_get_contacts(book_g, query_g, &contacts, &error_g);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);

    return getGObjectHandlesFromGListAndRef(env, contacts);
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_get_uri
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libebook_EBook_e_1book_1get_1uri(JNIEnv *env, jclass cls, jobject handle) {
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    return (*env)->NewStringUTF(env, e_book_get_uri(book_g));
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_get_static_capabilities
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libebook_EBook_e_1book_1get_1static_1capabilities(JNIEnv *env, jclass cls, jobject handle, jobject error) {
    GError* error_g = NULL;
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    const char *result = e_book_get_static_capabilities(book_g, &error_g);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    return (*env)->NewStringUTF(env, result);
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_check_static_capability
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libebook_EBook_e_1book_1check_1static_1capability(JNIEnv *env, jclass cls, jobject handle, jstring capability) {
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    char* capability_g = (char*)(*env)->GetStringUTFChars(env, capability, 0);
    jboolean result = e_book_check_static_capability(book_g, capability_g);
    (*env)->ReleaseStringUTFChars(env, capability, capability_g);
    return result;
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_is_writable
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libebook_EBook_e_1book_1is_1writable(JNIEnv *env, jclass cls, jobject handle) {
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    return e_book_is_writable(book_g);
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_cancel
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libebook_EBook_e_1book_1cancel(JNIEnv *env, jclass cls, jobject handle, jobject error) {
    GError* error_g = NULL;
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    jboolean result = e_book_cancel(book_g, &error_g);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    return result;
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_get_self
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBook_e_1book_1get_1self(JNIEnv *env, jclass cls, jobject handle, jobject error) {
    GError* error_g = NULL;
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    EContact *contact = NULL;
    e_book_get_self(&contact, &book_g, &error_g);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    return getGObjectHandle(env, (GObject *)contact);
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_set_self
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libebook_EBook_e_1book_1set_1self(JNIEnv *env, jclass cls, jobject handle, jobject contact, jobject error) {
    GError* error_g = NULL;
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    EContact *contact_g = (EContact*)getPointerFromHandle(env, contact);
    jboolean result = e_book_set_self(book_g, contact_g, &error_g);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    return result;
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_get_addressbooks
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBook_e_1book_1get_1addressbooks(JNIEnv *env, jclass cls, jobject error) {
    GError* error_g = NULL;
    ESourceList *sources = NULL;
    ESourceList *sources_copy = NULL;

    jboolean result = e_book_get_addressbooks(&sources, &error_g);
    if (error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);

    if(!result)
        return NULL;

//    sources_copy = malloc(sizeof(ESourceList));
//    memcpy(sources_copy, sources, sizeof(ESourceList));

    return getGObjectHandleAndRef(env, (GObject *)sources);
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_open
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libebook_EBook_e_1book_1open(JNIEnv *env, jclass cls, jobject handle, jobject error) {
    GError* error_g = NULL;
    EBook *book_g = (EBook*)getPointerFromHandle(env, handle);
    jboolean result = e_book_open(book_g, FALSE, &error_g);

    //SC: don't ask - we'll just try it again for the craic
    if(error_g && !result) {
        g_error_free(error_g);
        error_g = NULL;
        result = e_book_open(book_g, TRUE, &error_g);
    }

    if (error_g)
        updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    return result;
}

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_new_default_addressbook
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBook_e_1book_1new_1default_1addressbook(JNIEnv *env, jclass cls, jobject error) {
    GError* error_g = NULL;

    EBook *e_book = e_book_new_default_addressbook(&error_g);
    if (NULL != error_g)
    	updateStructHandle(env, error, error_g, (JGFreeFunc) g_error_free);
    return getGObjectHandle(env, (GObject*)e_book);
}







/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_open_default_addressbook
 */
//JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBook_e_1book_1open_1default_1addressbook
//(JNIEnv *env, jclass cls)
//{
//    GError *error = 0;
//    EBook *book = e_book_new_default_addressbook(&error);
//    e_book_open(book, TRUE, &error);
//    return getHandleFromPointer(env, book);
//}
//

/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_open_from_source
 */
//JNIEXPORT jboolean JNICALL Java_org_gnu_libebook_EBook_e_1book_1open
//(JNIEnv *env, jclass cls, jobject obj)
//{
//    EBook *book = (EBook*)getPointerFromHandle(env, obj);
//    GError *error = 0;
//    return e_book_open(book, FALSE, &error);
//}



/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_get_static_capabilities
 */
//JNIEXPORT jstring JNICALL Java_org_gnu_libebook_EBook_e_1book_1get_1static_1capabilities
//(JNIEnv *env, jclass cls, jobject obj)
//{
//    EBook *book = (EBook*)getPointerFromHandle(env, obj);
//    return (*env)->NewStringUTF(env, e_book_get_static_capabilities(book, NULL));
//}
/*
 * Class:     org_gnu_libebook_EBook
 * Method:    e_book_get_addressbooks
 */
//JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBook_e_1book_1get_1addressbooks
//(JNIEnv *env, jclass cls)
//{
//    ESourceList *sources = NULL;
//
//    if(!e_book_get_addressbooks(&sources, NULL))
//        return NULL;
//
//    return getHandleFromPointer(env, sources);
//}


#ifdef __cplusplus
}

#endif
