// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDA_UIMM_RTEDITOR_H
#define _LIBGDA_UIMM_RTEDITOR_H


#include <glibmm.h>

/* libgda-uimm - a C++ wrapper for libgda-ui
 *
 * Copyright (c) 2011 libgda-uimm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/box.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdauiRtEditor GdauiRtEditor;
typedef struct _GdauiRtEditorClass GdauiRtEditorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace GdaUI
{ class RtEditor_Class; } // namespace GdaUI

} // namespace Gnome
namespace Gtk
{

class TextBuffer;

}

namespace Gnome
{

// Gnome::Gda class forward declarations.
namespace Gda
{

class DataModel;

}

namespace GdaUI
{

/** RtEditor - Rich text editor which uses a subset of the txt2tags markup.
 * The text entered in the editor can be formatted using bold, underline,
 * title, ... attributes and then extracted using a subset of the txt2tags
 * markup. Use this widget to edit textual fields where some markup is
 * desirable to organize the text. 
 */

class RtEditor :
  public Gtk::Box
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef RtEditor CppObjectType;
  typedef RtEditor_Class CppClassType;
  typedef GdauiRtEditor BaseObjectType;
  typedef GdauiRtEditorClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~RtEditor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class RtEditor_Class;
  static CppClassType rteditor_class_;

  // noncopyable
  RtEditor(const RtEditor&);
  RtEditor& operator=(const RtEditor&);

protected:
  explicit RtEditor(const Glib::ConstructParams& construct_params);
  explicit RtEditor(GdauiRtEditor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GdauiRtEditor*       gobj()       { return reinterpret_cast<GdauiRtEditor*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GdauiRtEditor* gobj() const { return reinterpret_cast<GdauiRtEditor*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_changed();


private:


public:
  
  /** Creates a new Gdaui::RtEditor widget
   * 
   * @newin{4,2}.2
   * @return The new widget.
   */

  RtEditor();

public:
  
  /** Get the contents of @a editor, using the markup syntax
   * 
   * @newin{4,2}.2
   * @return A new string, or <tt>0</tt> if there was an error.
   */
  Glib::ustring get_contents() const;
  
  /** Set @a editor's contents. If @a length is -1, @a markup must be nul-terminated
   * 
   * @newin{4,2}.2
   * @param markup The text to set in @a editor, using the markup syntax (must be valid UTF-8).
   * @param length Length of text in bytes.
   */
  void set_contents(const Glib::ustring& markup, int length =  -1);
  
  /** Set @a editor's editability
   * 
   * @newin{4,2}.2
   * @param editable Whether it's editable.
   */
  void set_editable(bool editable);

  
  /**
   * @par Prototype:
   * <tt>void on_my_%changed()</tt>
   */

  Glib::SignalProxy0< void > signal_changed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gtk::TextBuffer> > property_buffer() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_in_scrolled_window() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_in_scrolled_window() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_no_background() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_no_background() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_markup() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_markup() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace GdaUI

} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::GdaUI::RtEditor
   */
  Gnome::GdaUI::RtEditor* wrap(GdauiRtEditor* object, bool take_copy = false);
} //namespace Glib


#endif /* _LIBGDA_UIMM_RTEDITOR_H */

