    #include <libgda/libgda.h>
    #include <stdio.h>

    #define DEFAULT_BUFFER_SIZE 1024
    
    
    gboolean
    get_errors (GdaConnection *connection)
    {
      GList *list;
      GList *node;
      GdaError *error;
    
      list = (GList *) gda_connection_get_errors (connection);
    
      for (node = g_list_first (list); node != NULL; node = g_list_next (node))
        {
          error = (GdaError *) node->data;
          g_print ("Error no: %d\t", gda_error_get_number (error));
          g_print ("desc: %s\t", gda_error_get_description (error));
          g_print ("source: %s\t", gda_error_get_source (error));
          g_print ("sqlstate: %s\n", gda_error_get_sqlstate (error));
        }
    }
    
    
    
    void
    show_table (GdaDataModel * dm)
    {
      gint row_id;
      gint column_id;
      GdaValue *value;
      gchar *string;
    
      for (column_id = 0; column_id < gda_data_model_get_n_columns (dm);
           column_id++)
        g_print("%s\t",gda_data_model_get_column_title (dm, column_id));
      g_print("\n");
    
      for (row_id = 0; row_id < gda_data_model_get_n_rows (dm); row_id++)
        {
          for (column_id = 0; column_id < gda_data_model_get_n_columns (dm);
               column_id++)
            {
              value =
                (GdaValue *) gda_data_model_get_value_at (dm, column_id, row_id);
              string=gda_value_stringify (value);
              g_print ("%s\t", string);
              g_free(string);
            }
          g_print("\n");
        }
    }
    
    
    
    void
    show_table2 (GdaDataModel * dm)
    {
      gint row_id;
      gint column_id;
      GdaValue *value;
      GdaRow *row;
      gchar *string;
    
      for (column_id = 0; column_id < gda_data_model_get_n_columns (dm);
           column_id++)
        g_print("%s\t",gda_data_model_get_column_title (dm, column_id));
      g_print("\n");
    
      for (row_id = 0; row_id < gda_data_model_get_n_rows (dm); row_id++)
        {
          row = (GdaRow *) gda_data_model_get_row (dm, row_id);
          for (column_id = 0; column_id < gda_data_model_get_n_columns (dm);
               column_id++)
            {
              value = gda_row_get_value (row, column_id);
              string=gda_value_stringify (value);
              g_print ("%s\t", string);
              gda_value_free(value);
              g_free(string);
            }
          g_print ("\n");
        }
    }
    
    
    
    void process_accounts(GdaConnection *connection)
    {
      GdaTransaction *transaction_one, *transaction_two;
      GdaCommand *command;
    
      transaction_one=gda_transaction_new("accounts1");
      gda_connection_begin_transaction(connection,transaction_one);
    
      command=gda_command_new (
                               "UPDATE accounts SET balance=balance+50"
                               "WHERE account_code=456",
                               GDA_COMMAND_TYPE_SQL,
                               GDA_COMMAND_OPTION_STOP_ON_ERRORS);
      gda_command_set_transaction(command,transaction_one);
      gda_connection_execute_non_query(connection,command,NULL);
      gda_command_free(command);
    
      command=gda_command_new (
                               "UPDATE accounts SET balance=balance-50"
                               "WHERE account_code=12",
                               GDA_COMMAND_TYPE_SQL,
                               GDA_COMMAND_OPTION_STOP_ON_ERRORS);
      gda_command_set_transaction(command,transaction_one);
      gda_connection_execute_non_query(connection,command,NULL);
      gda_command_free(command);
    
      gda_connection_commit_transaction(connection,transaction_one);
      g_object_unref(transaction_one);
    
      transaction_two=gda_transaction_new("accounts2");
      gda_connection_begin_transaction(connection,transaction_two);
    
      command=gda_command_new (
                               "UPDATE accounts SET balance=balance+400"
                               "WHERE account_code=456",
                               GDA_COMMAND_TYPE_SQL,
                               GDA_COMMAND_OPTION_STOP_ON_ERRORS);
      gda_command_set_transaction(command,transaction_two);
      gda_connection_execute_non_query(connection,command,NULL);
      gda_command_free(command);
    
      command=gda_command_new (
                               "UPDATE accounts SET balance=balance-400"
                               "WHERE account_code=12",
                               GDA_COMMAND_TYPE_SQL,
                               GDA_COMMAND_OPTION_STOP_ON_ERRORS);
      gda_command_set_transaction(command,transaction_two);
      gda_connection_execute_non_query(connection,command,NULL);
      gda_command_free(command);
    
      gda_connection_rollback_transaction(connection,transaction_two);
      g_object_unref(transaction_two);
    
      execute_sql_command(connection,"SELECT * FROM accounts");
    }
    
    
    void process_accounts2(GdaConnection *connection)
    {/*
      GdaBatch *batch;
      GdaCommand *command;
    
      batch=gda_batch_new();
      gda_batch_add_command(batch,
                            "UPDATE accounts SET balance=balance+300"
                            "WHERE account_code=456"
                           );
      gda_batch_add_command(batch,
                            "UPDATE accounts SET balance=balance-300"
                            "WHERE account_code=12",
                           );
      gda_batch_set_connection(batch,connection);
      gda_batch_set_transaction_mode(batch,TRUE);
      if (gda_batch_start(batch))
        g_print("BATCH OK\n");
      else
        g_print("BATCH failed\n");
    
      execute_sql_command(connection,"SELECT * FROM accounts");
    */}
    
    
    gint
    execute_sql_command (GdaConnection *connection, const gchar * buffer)
    {
      GdaCommand *command;
      GList *list;
      GList *node;
      gboolean errors=FALSE;
    
      GdaDataModel *dm;
    
    
      command = gda_command_new (buffer, GDA_COMMAND_TYPE_SQL, GDA_COMMAND_OPTION_STOP_ON_ERRORS);
      list = gda_connection_execute_command (connection, command, NULL);
      if (list!=NULL)
        for (node=g_list_first(list); node != NULL; node=g_list_next(node))
          {
            dm=(GdaDataModel *) node->data;
            if (dm == NULL)
              {
                errors=TRUE;
              }
            else
              {
                show_table (dm);
                g_object_unref(dm);
              }
          }
      else
        {
          errors=TRUE;
        }
      gda_command_free (command);
    
      return (errors);
    }
    
    
    
    gint
    execute_sql_non_query (GdaConnection *connection, const gchar * buffer)
    {
      GdaCommand *command;
      gint number;
    
      command = gda_command_new (buffer, GDA_COMMAND_TYPE_SQL, GDA_COMMAND_OPTION_STOP_ON_ERRORS);
      number  = gda_connection_execute_non_query (connection, command, NULL);
    
      gda_command_free (command);
    
      return (number);
    }
    
    
    
    void
    proving_errors (GdaConnection *connection)
    {
    
      execute_sql_non_query (connection,
                             "DELETE FROM cliente"
                            );
      execute_sql_non_query (connection,
                             "INSERT INTO cliente(cd_cli, dni, nombr, direc, telef) "
                             "VALUES ('1', '1234', 'Xabier',"
                             "'Rua Unha calquera', '123')"
                             "; INSERT INTO cliente(cd_cli, dni, nombr, direc, telef) "
                             "VALUES ('2', '2345', 'Rodriguez',"
                             "'Rua Outra calquera', '234')"
                            );
      execute_sql_non_query (connection,
                             "INSERT INTO cliente(cd_cli, dni, nombr, direc, telef) "
                             "VALUES ('1', '1234', 'Xabier',"
                             "'Rua Unha calquera', '123')"
                             "; INSERT INTO cliente(cd_cli, dni, nombr, direc, telef) "
                             "VALUES ('2', '2345', 'Rodriguez',"
                             "'Rua Outra calquera', '234')"
                            );
      execute_sql_command (connection, "SELECT * FROM cliente");
    
    
      execute_sql_non_query (connection,
                             "DELETE FROM accounts;"
                             "INSERT INTO accounts"
                             "(client_code, account_code, balance)"
                             "VALUES (123, 456, 1000);"
                             "INSERT INTO accounts"
                             "(client_code, account_code, balance)"
                             "VALUES (789, 012, 5000);"
                            );
    
      execute_sql_command (connection, "SELECT * FROM accounts");
    
    }
    
    
    
    void
    list_datasources (void)
    {
      GList *ds_list;
      GList *node;
      GdaDataSourceInfo *info;
    
      ds_list = gda_config_get_data_source_list ();
    
      g_print ("\n");
      for (node = g_list_first (ds_list); node != NULL; node = g_list_next (node))
        {
          info = (GdaDataSourceInfo *) node->data;
    
          g_print
            ("NAME: %s PROVIDER: %s CNC: %s DESC: %s USER: %s PASSWORD: %s\n",
             info->name, info->provider, info->cnc_string, info->description,
             info->username, info->password);
    
        }
      g_print ("\n");
    
      gda_config_free_data_source_list (ds_list);
    
    }
    
    
    
    void
    list_providers (void)
    {
      GList *prov_list;
      GList *node;
      GdaProviderInfo *info;
    
      prov_list = gda_config_get_provider_list ();
    
      for (node = g_list_first (prov_list); node != NULL;
           node = g_list_next (node))
        {
          info = (GdaProviderInfo *) node->data;
    
          g_print ("ID: %s\n", info->id);
    
        }
    
      gda_config_free_provider_list (prov_list);
    
    }
    
    
    
    void
    do_stuff ()
    {
      GdaClient *client;
      GdaConnection *connection;
    
      list_providers ();
      list_datasources ();
    
      client = gda_client_new ();
    
      g_print ("CONNECTING\n");
      connection = gda_client_open_connection (client, "calvaris", NULL, NULL);
      g_print ("CONNECTED\n");
    
      proving_errors (connection);
    
      process_accounts(connection);
    
      process_accounts2(connection);
    
      gda_client_close_all_connections (client);
    
      gda_main_quit();
    }
    
    
    
    void
    save_ds ()
    {
      gda_config_save_data_source ("calvaris", "PostgreSQL", "DATABASE=calvaris",
                                   "cosa de calvaris", NULL, NULL);
    }
    
    
    
    void
    remove_ds ()
    {
      gda_config_remove_data_source("calvaris");
    }
    
    
    
    int
    main (int argc, char **argv)
    {
    
      g_print ("STARTING\n");
      gda_init ("TestGDA", "0.1", argc, argv);
    
      save_ds ();
      /*  remove_ds(); */
    
      gda_main_run ((GdaInitFunc) do_stuff, (gpointer) NULL);
      /*  do_stuff(); */
    
    }
