/* Record.c generated by valac 0.40.8.18-c87af, the Vala compiler
 * generated from Record.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdavala
 * Copyright (C) Daniel Espinosa Ortiz 2012 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <libgda/libgda.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


#define GDA_DATA_TYPE_DB_OBJECT (gda_data_db_object_get_type ())
#define GDA_DATA_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObject))
#define GDA_DATA_IS_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_OBJECT))
#define GDA_DATA_DB_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObjectIface))

typedef struct _GdaDataDbObject GdaDataDbObject;
typedef struct _GdaDataDbObjectIface GdaDataDbObjectIface;

#define GDA_DATA_TYPE_DB_RECORD (gda_data_db_record_get_type ())
#define GDA_DATA_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecord))
#define GDA_DATA_IS_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_RECORD))
#define GDA_DATA_DB_RECORD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecordIface))

typedef struct _GdaDataDbRecord GdaDataDbRecord;
typedef struct _GdaDataDbRecordIface GdaDataDbRecordIface;

#define GDA_DATA_TYPE_DB_FIELD (gda_data_db_field_get_type ())
#define GDA_DATA_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbField))
#define GDA_DATA_IS_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD))
#define GDA_DATA_DB_FIELD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbFieldIface))

typedef struct _GdaDataDbField GdaDataDbField;
typedef struct _GdaDataDbFieldIface GdaDataDbFieldIface;

#define GDA_DATA_DB_FIELD_TYPE_ATTRIBUTE (gda_data_db_field_attribute_get_type ())

#define GDA_DATA_TYPE_DB_NAMED_OBJECT (gda_data_db_named_object_get_type ())
#define GDA_DATA_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObject))
#define GDA_DATA_IS_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT))
#define GDA_DATA_DB_NAMED_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObjectIface))

typedef struct _GdaDataDbNamedObject GdaDataDbNamedObject;
typedef struct _GdaDataDbNamedObjectIface GdaDataDbNamedObjectIface;

#define GDA_DATA_TYPE_DB_TABLE (gda_data_db_table_get_type ())
#define GDA_DATA_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTable))
#define GDA_DATA_IS_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_TABLE))
#define GDA_DATA_DB_TABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTableIface))

typedef struct _GdaDataDbTable GdaDataDbTable;
typedef struct _GdaDataDbTableIface GdaDataDbTableIface;

#define GDA_DATA_TYPE_DB_FIELD_INFO (gda_data_db_field_info_get_type ())
#define GDA_DATA_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfo))
#define GDA_DATA_IS_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO))
#define GDA_DATA_DB_FIELD_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfoIface))

typedef struct _GdaDataDbFieldInfo GdaDataDbFieldInfo;
typedef struct _GdaDataDbFieldInfoIface GdaDataDbFieldInfoIface;

#define GDA_DATA_DB_FIELD_INFO_TYPE_ATTRIBUTE (gda_data_db_field_info_attribute_get_type ())

#define GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY (gda_data_db_field_info_foreign_key_get_type ())
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKey))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))

typedef struct _GdaDataDbFieldInfoForeignKey GdaDataDbFieldInfoForeignKey;
typedef struct _GdaDataDbFieldInfoForeignKeyClass GdaDataDbFieldInfoForeignKeyClass;

#define GDA_DATA_TYPE_DB_CATALOG (gda_data_db_catalog_get_type ())
#define GDA_DATA_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalog))
#define GDA_DATA_IS_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_CATALOG))
#define GDA_DATA_DB_CATALOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalogIface))

typedef struct _GdaDataDbCatalog GdaDataDbCatalog;
typedef struct _GdaDataDbCatalogIface GdaDataDbCatalogIface;

#define GDA_DATA_TYPE_DB_SCHEMA (gda_data_db_schema_get_type ())
#define GDA_DATA_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchema))
#define GDA_DATA_IS_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_SCHEMA))
#define GDA_DATA_DB_SCHEMA_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchemaIface))

typedef struct _GdaDataDbSchema GdaDataDbSchema;
typedef struct _GdaDataDbSchemaIface GdaDataDbSchemaIface;

#define GDA_DATA_DB_TABLE_TYPE_TABLE_TYPE (gda_data_db_table_table_type_get_type ())

#define GDA_DATA_TYPE_RECORD (gda_data_record_get_type ())
#define GDA_DATA_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_RECORD, GdaDataRecord))
#define GDA_DATA_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_RECORD, GdaDataRecordClass))
#define GDA_DATA_IS_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_RECORD))
#define GDA_DATA_IS_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_RECORD))
#define GDA_DATA_RECORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_RECORD, GdaDataRecordClass))

typedef struct _GdaDataRecord GdaDataRecord;
typedef struct _GdaDataRecordClass GdaDataRecordClass;
typedef struct _GdaDataRecordPrivate GdaDataRecordPrivate;
enum  {
	GDA_DATA_RECORD_0_PROPERTY,
	GDA_DATA_RECORD_TABLE_PROPERTY,
	GDA_DATA_RECORD_FIELDS_PROPERTY,
	GDA_DATA_RECORD_KEYS_PROPERTY,
	GDA_DATA_RECORD_CONNECTION_PROPERTY,
	GDA_DATA_RECORD_UPDATE_META_PROPERTY,
	GDA_DATA_RECORD_NUM_PROPERTIES
};
static GParamSpec* gda_data_record_properties[GDA_DATA_RECORD_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GDA_DATA_TYPE_FIELD (gda_data_field_get_type ())
#define GDA_DATA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_FIELD, GdaDataField))
#define GDA_DATA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_FIELD, GdaDataFieldClass))
#define GDA_DATA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_FIELD))
#define GDA_DATA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_FIELD))
#define GDA_DATA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_FIELD, GdaDataFieldClass))

typedef struct _GdaDataField GdaDataField;
typedef struct _GdaDataFieldClass GdaDataFieldClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GdaDataDbObjectIface {
	GTypeInterface parent_iface;
	void (*append) (GdaDataDbObject* self, GError** error);
	void (*update) (GdaDataDbObject* self, GError** error);
	void (*save) (GdaDataDbObject* self, GError** error);
	void (*drop) (GdaDataDbObject* self, gboolean cascade, GError** error);
	GdaConnection* (*get_connection) (GdaDataDbObject* self);
	void (*set_connection) (GdaDataDbObject* self, GdaConnection* value);
	gboolean (*get_update_meta) (GdaDataDbObject* self);
	void (*set_update_meta) (GdaDataDbObject* self, gboolean value);
};

typedef enum  {
	GDA_DATA_DB_FIELD_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL = 1 << 1,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL = 1 << 2,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT = 1 << 3,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT = 1 << 4,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED = 1 << 5,
	GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN = 1 << 6,
	GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID = 1 << 7,
	GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG = 1 << 8,
	GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF = 1 << 9,
	GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED = 1 << 10
} GdaDataDbFieldAttribute;

struct _GdaDataDbFieldIface {
	GTypeInterface parent_iface;
	gboolean (*equal) (GdaDataDbField* self, GdaDataDbField* field);
	gchar* (*to_string) (GdaDataDbField* self);
	GValue* (*get_value) (GdaDataDbField* self);
	void (*set_value) (GdaDataDbField* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbField* self);
	void (*set_name) (GdaDataDbField* self, const gchar* value);
	const gchar* (*get_column_name) (GdaDataDbField* self);
	GdaDataDbFieldAttribute (*get_attributes) (GdaDataDbField* self);
};

struct _GdaDataDbNamedObjectIface {
	GTypeInterface parent_iface;
	const gchar* (*get_name) (GdaDataDbNamedObject* self);
	void (*set_name) (GdaDataDbNamedObject* self, const gchar* value);
};

typedef enum  {
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY = 1 << 1,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE = 1 << 2,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY = 1 << 3,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK = 1 << 4,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT = 1 << 5,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL = 1 << 6,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT = 1 << 7
} GdaDataDbFieldInfoAttribute;

struct _GdaDataDbFieldInfoIface {
	GTypeInterface parent_iface;
	gboolean (*compatible) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
	gboolean (*equivalent) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
	gchar* (*to_string) (GdaDataDbFieldInfo* self);
	gint (*get_ordinal) (GdaDataDbFieldInfo* self);
	void (*set_ordinal) (GdaDataDbFieldInfo* self, gint value);
	GType (*get_value_type) (GdaDataDbFieldInfo* self);
	void (*set_value_type) (GdaDataDbFieldInfo* self, GType value);
	GdaDataDbFieldInfoAttribute (*get_attributes) (GdaDataDbFieldInfo* self);
	void (*set_attributes) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoAttribute value);
	GValue* (*get_default_value) (GdaDataDbFieldInfo* self);
	void (*set_default_value) (GdaDataDbFieldInfo* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbFieldInfo* self);
	void (*set_name) (GdaDataDbFieldInfo* self, const gchar* value);
	const gchar* (*get_desc) (GdaDataDbFieldInfo* self);
	void (*set_desc) (GdaDataDbFieldInfo* self, const gchar* value);
	gint (*get_precision) (GdaDataDbFieldInfo* self);
	void (*set_precision) (GdaDataDbFieldInfo* self, gint value);
	gint (*get_scale) (GdaDataDbFieldInfo* self);
	void (*set_scale) (GdaDataDbFieldInfo* self, gint value);
	GdaDataDbFieldInfoForeignKey* (*get_fkey) (GdaDataDbFieldInfo* self);
	void (*set_fkey) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoForeignKey* value);
};

struct _GdaDataDbSchemaIface {
	GTypeInterface parent_iface;
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbSchema* self);
	void (*set_catalog) (GdaDataDbSchema* self, GdaDataDbCatalog* value);
	GeeCollection* (*get_tables) (GdaDataDbSchema* self);
};

struct _GdaDataDbCatalogIface {
	GTypeInterface parent_iface;
	GeeCollection* (*get_shemas) (GdaDataDbCatalog* self);
	void (*set_shemas) (GdaDataDbCatalog* self, GeeCollection* value);
};

typedef enum  {
	GDA_DATA_DB_TABLE_TABLE_TYPE_NONE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_BASE_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_VIEW,
	GDA_DATA_DB_TABLE_TABLE_TYPE_LOCAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYSTEM_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_GLOBAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_ALIAS,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYNONYM
} GdaDataDbTableTableType;

struct _GdaDataDbTableIface {
	GTypeInterface parent_iface;
	void (*set_field) (GdaDataDbTable* self, GdaDataDbFieldInfo* field, GError** error);
	GdaDataDbFieldInfo* (*get_field) (GdaDataDbTable* self, const gchar* name, GError** error);
	gboolean (*compatible) (GdaDataDbTable* self, GdaDataDbTable* table);
	gboolean (*equivalent) (GdaDataDbTable* self, GdaDataDbTable* table);
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbTable* self);
	void (*set_catalog) (GdaDataDbTable* self, GdaDataDbCatalog* value);
	GdaDataDbSchema* (*get_schema) (GdaDataDbTable* self);
	void (*set_schema) (GdaDataDbTable* self, GdaDataDbSchema* value);
	GdaDataDbTableTableType (*get_table_type) (GdaDataDbTable* self);
	void (*set_table_type) (GdaDataDbTable* self, GdaDataDbTableTableType value);
	GeeCollection* (*get_records) (GdaDataDbTable* self);
	GeeCollection* (*get_depends) (GdaDataDbTable* self);
	GeeCollection* (*get_referenced) (GdaDataDbTable* self);
	GeeCollection* (*get_fields) (GdaDataDbTable* self);
	GeeCollection* (*get_primary_keys) (GdaDataDbTable* self);
};

struct _GdaDataDbRecordIface {
	GTypeInterface parent_iface;
	GValue* (*get_value) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_field) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_field_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_field) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_key) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_key_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_key) (GdaDataDbRecord* self, const gchar* name, GError** error);
	gchar* (*to_string) (GdaDataDbRecord* self);
	void (*copy) (GdaDataDbRecord* self, GdaDataDbRecord* record, GError** error);
	gboolean (*equal) (GdaDataDbRecord* self, GdaDataDbRecord* record, GError** error);
	GdaDataDbTable* (*get_table) (GdaDataDbRecord* self);
	void (*set_table) (GdaDataDbRecord* self, GdaDataDbTable* value);
	GeeCollection* (*get_fields) (GdaDataDbRecord* self);
	GeeCollection* (*get_keys) (GdaDataDbRecord* self);
};

struct _GdaDataRecord {
	GObject parent_instance;
	GdaDataRecordPrivate * priv;
	GeeHashMap* _fields;
	GeeHashMap* _keys;
};

struct _GdaDataRecordClass {
	GObjectClass parent_class;
};

struct _GdaDataRecordPrivate {
	gboolean _update_meta;
	GdaDataDbTable* _table;
	GdaConnection* _connection;
};

typedef enum  {
	GDA_DATA_DB_OBJECT_ERROR_APPEND,
	GDA_DATA_DB_OBJECT_ERROR_UPDATE,
	GDA_DATA_DB_OBJECT_ERROR_SAVE,
	GDA_DATA_DB_OBJECT_ERROR_DROP
} GdaDataDbObjectError;
#define GDA_DATA_DB_OBJECT_ERROR gda_data_db_object_error_quark ()

static gpointer gda_data_record_parent_class = NULL;
static GdaDataDbObjectIface * gda_data_record_gda_data_db_object_parent_iface = NULL;
static GeeComparableIface * gda_data_record_gee_comparable_parent_iface = NULL;
static GdaDataDbRecordIface * gda_data_record_gda_data_db_record_parent_iface = NULL;

GType gda_data_db_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_attribute_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_get_type (void) G_GNUC_CONST;
GType gda_data_db_named_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_attribute_get_type (void) G_GNUC_CONST;
gpointer gda_data_db_field_info_foreign_key_ref (gpointer instance);
void gda_data_db_field_info_foreign_key_unref (gpointer instance);
GParamSpec* gda_data_db_field_info_param_spec_foreign_key (const gchar* name,
                                                           const gchar* nick,
                                                           const gchar* blurb,
                                                           GType object_type,
                                                           GParamFlags flags);
void gda_data_db_field_info_value_set_foreign_key (GValue* value,
                                                   gpointer v_object);
void gda_data_db_field_info_value_take_foreign_key (GValue* value,
                                                    gpointer v_object);
gpointer gda_data_db_field_info_value_get_foreign_key (const GValue* value);
GType gda_data_db_field_info_foreign_key_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_get_type (void) G_GNUC_CONST;
GType gda_data_db_schema_get_type (void) G_GNUC_CONST;
GType gda_data_db_catalog_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_table_type_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_get_type (void) G_GNUC_CONST;
GType gda_data_db_record_get_type (void) G_GNUC_CONST;
GType gda_data_record_get_type (void) G_GNUC_CONST;
#define GDA_DATA_RECORD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GDA_DATA_TYPE_RECORD, GdaDataRecordPrivate))
static GValue* gda_data_record_real_get_value (GdaDataDbRecord* base,
                                        const gchar* field,
                                        GError** error);
GValue* gda_data_db_field_get_value (GdaDataDbField* self);
static void gda_data_record_real_set_field (GdaDataDbRecord* base,
                                     GdaDataDbField* field,
                                     GError** error);
const gchar* gda_data_db_field_get_name (GdaDataDbField* self);
void gda_data_db_field_set_value (GdaDataDbField* self,
                                  GValue* value);
GType gda_data_field_get_type (void) G_GNUC_CONST;
GdaDataField* gda_data_field_new (const gchar* col_name,
                                  GdaDataDbFieldAttribute attr);
GdaDataField* gda_data_field_construct (GType object_type,
                                        const gchar* col_name,
                                        GdaDataDbFieldAttribute attr);
static void gda_data_record_real_set_field_value (GdaDataDbRecord* base,
                                           const gchar* field,
                                           GValue* val,
                                           GError** error);
void gda_data_db_record_set_field (GdaDataDbRecord* self,
                                   GdaDataDbField* field,
                                   GError** error);
static GdaDataDbField* gda_data_record_real_get_field (GdaDataDbRecord* base,
                                                const gchar* name,
                                                GError** error);
static void gda_data_record_real_set_key (GdaDataDbRecord* base,
                                   GdaDataDbField* field,
                                   GError** error);
static void gda_data_record_real_set_key_value (GdaDataDbRecord* base,
                                         const gchar* key,
                                         GValue* val,
                                         GError** error);
void gda_data_db_record_set_key (GdaDataDbRecord* self,
                                 GdaDataDbField* field,
                                 GError** error);
static GdaDataDbField* gda_data_record_real_get_key (GdaDataDbRecord* base,
                                              const gchar* name,
                                              GError** error);
static void gda_data_record_real_save (GdaDataDbObject* base,
                                GError** error);
GeeCollection* gda_data_db_record_get_fields (GdaDataDbRecord* self);
GQuark gda_data_db_object_error_quark (void);
GeeCollection* gda_data_db_record_get_keys (GdaDataDbRecord* self);
GdaDataDbTable* gda_data_db_record_get_table (GdaDataDbRecord* self);
const gchar* gda_data_db_named_object_get_name (GdaDataDbNamedObject* self);
const gchar* gda_data_db_field_get_column_name (GdaDataDbField* self);
GdaConnection* gda_data_db_object_get_connection (GdaDataDbObject* self);
static void gda_data_record_real_update (GdaDataDbObject* base,
                                  GError** error);
gboolean gda_data_db_object_get_update_meta (GdaDataDbObject* self);
void gda_data_db_object_set_update_meta (GdaDataDbObject* self,
                                         gboolean value);
static void gda_data_record_real_append (GdaDataDbObject* base,
                                  GError** error);
static void gda_data_record_real_drop (GdaDataDbObject* base,
                                gboolean cascade,
                                GError** error);
static gchar* gda_data_record_real_to_string (GdaDataDbRecord* base);
static gint gda_data_record_real_compare_to (GeeComparable* base,
                                      GdaDataDbRecord* object);
GdaDataDbField* gda_data_db_record_get_field (GdaDataDbRecord* self,
                                              const gchar* name,
                                              GError** error);
GdaDataRecord* gda_data_record_new (void);
GdaDataRecord* gda_data_record_construct (GType object_type);
static void gda_data_record_finalize (GObject * obj);
static void _vala_gda_data_record_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
void gda_data_db_record_set_table (GdaDataDbRecord* self,
                                   GdaDataDbTable* value);
void gda_data_db_object_set_connection (GdaDataDbObject* self,
                                        GdaConnection* value);
static void _vala_gda_data_record_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);


/**
         * Returns a GLib.Value containing the value stored in the given field.
         */
static GValue*
gda_data_record_real_get_value (GdaDataDbRecord* base,
                                const gchar* field,
                                GError** error)
{
	GdaDataRecord * self;
	GValue* result = NULL;
	GdaDataDbField* f = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GValue* _tmp2_;
	GValue* _tmp3_;
	self = (GdaDataRecord*) base;
	g_return_val_if_fail (field != NULL, NULL);
	_tmp0_ = self->_fields;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, field);
	f = (GdaDataDbField*) _tmp1_;
	_tmp2_ = gda_data_db_field_get_value (f);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	_g_object_unref0 (f);
	return result;
}


/**
         * Set the value to a field with the given @name.
         */
static void
gda_data_record_real_set_field (GdaDataDbRecord* base,
                                GdaDataDbField* field,
                                GError** error)
{
	GdaDataRecord * self;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (GdaDataRecord*) base;
	g_return_if_fail (field != NULL);
	_tmp0_ = self->_fields;
	_tmp1_ = gda_data_db_field_get_name (field);
	_tmp2_ = _tmp1_;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_)) {
		GdaDataDbField* f = NULL;
		GeeHashMap* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gpointer _tmp6_;
		GdaDataDbField* _tmp7_;
		GValue* _tmp8_;
		GValue* _tmp9_;
		GeeHashMap* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GdaDataDbField* _tmp13_;
		_tmp3_ = self->_fields;
		_tmp4_ = gda_data_db_field_get_name (field);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp5_);
		f = (GdaDataDbField*) _tmp6_;
		_tmp7_ = f;
		_tmp8_ = gda_data_db_field_get_value (field);
		_tmp9_ = _tmp8_;
		gda_data_db_field_set_value (_tmp7_, _tmp9_);
		_tmp10_ = self->_fields;
		_tmp11_ = gda_data_db_field_get_name (field);
		_tmp12_ = _tmp11_;
		_tmp13_ = f;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp12_, _tmp13_);
		_g_object_unref0 (f);
	} else {
		GdaDataField* n = NULL;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		GdaDataField* _tmp16_;
		GdaDataField* _tmp17_;
		GValue* _tmp18_;
		GValue* _tmp19_;
		GeeHashMap* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		GdaDataField* _tmp23_;
		_tmp14_ = gda_data_db_field_get_name (field);
		_tmp15_ = _tmp14_;
		_tmp16_ = gda_data_field_new (_tmp15_, GDA_DATA_DB_FIELD_ATTRIBUTE_NONE);
		n = _tmp16_;
		_tmp17_ = n;
		_tmp18_ = gda_data_db_field_get_value (field);
		_tmp19_ = _tmp18_;
		gda_data_db_field_set_value ((GdaDataDbField*) _tmp17_, _tmp19_);
		_tmp20_ = self->_fields;
		_tmp21_ = gda_data_db_field_get_name (field);
		_tmp22_ = _tmp21_;
		_tmp23_ = n;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, _tmp22_, (GdaDataDbField*) _tmp23_);
		_g_object_unref0 (n);
	}
}


static void
gda_data_record_real_set_field_value (GdaDataDbRecord* base,
                                      const gchar* field,
                                      GValue* val,
                                      GError** error)
{
	GdaDataRecord * self;
	GdaDataField* n = NULL;
	GdaDataField* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecord*) base;
	g_return_if_fail (field != NULL);
	_tmp0_ = gda_data_field_new (field, GDA_DATA_DB_FIELD_ATTRIBUTE_NONE);
	n = _tmp0_;
	gda_data_db_field_set_value ((GdaDataDbField*) n, val);
	gda_data_db_record_set_field ((GdaDataDbRecord*) self, (GdaDataDbField*) n, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (n);
		return;
	}
	_g_object_unref0 (n);
}


static GdaDataDbField*
gda_data_record_real_get_field (GdaDataDbRecord* base,
                                const gchar* name,
                                GError** error)
{
	GdaDataRecord * self;
	GdaDataDbField* result = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	self = (GdaDataRecord*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->_fields;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, name);
	result = (GdaDataDbField*) _tmp1_;
	return result;
}


static void
gda_data_record_real_set_key (GdaDataDbRecord* base,
                              GdaDataDbField* field,
                              GError** error)
{
	GdaDataRecord * self;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (GdaDataRecord*) base;
	g_return_if_fail (field != NULL);
	_tmp0_ = self->_keys;
	_tmp1_ = gda_data_db_field_get_name (field);
	_tmp2_ = _tmp1_;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_)) {
		GdaDataDbField* f = NULL;
		GeeHashMap* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gpointer _tmp6_;
		GdaDataDbField* _tmp7_;
		GValue* _tmp8_;
		GValue* _tmp9_;
		GeeHashMap* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GdaDataDbField* _tmp13_;
		_tmp3_ = self->_keys;
		_tmp4_ = gda_data_db_field_get_name (field);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp5_);
		f = (GdaDataDbField*) _tmp6_;
		_tmp7_ = f;
		_tmp8_ = gda_data_db_field_get_value (field);
		_tmp9_ = _tmp8_;
		gda_data_db_field_set_value (_tmp7_, _tmp9_);
		_tmp10_ = self->_keys;
		_tmp11_ = gda_data_db_field_get_name (field);
		_tmp12_ = _tmp11_;
		_tmp13_ = f;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp12_, _tmp13_);
		_g_object_unref0 (f);
	} else {
		GdaDataField* n = NULL;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		GdaDataField* _tmp16_;
		GdaDataField* _tmp17_;
		GValue* _tmp18_;
		GValue* _tmp19_;
		GeeHashMap* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		GdaDataField* _tmp23_;
		_tmp14_ = gda_data_db_field_get_name (field);
		_tmp15_ = _tmp14_;
		_tmp16_ = gda_data_field_new (_tmp15_, GDA_DATA_DB_FIELD_ATTRIBUTE_NONE);
		n = _tmp16_;
		_tmp17_ = n;
		_tmp18_ = gda_data_db_field_get_value (field);
		_tmp19_ = _tmp18_;
		gda_data_db_field_set_value ((GdaDataDbField*) _tmp17_, _tmp19_);
		_tmp20_ = self->_keys;
		_tmp21_ = gda_data_db_field_get_name (field);
		_tmp22_ = _tmp21_;
		_tmp23_ = n;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, _tmp22_, (GdaDataDbField*) _tmp23_);
		_g_object_unref0 (n);
	}
}


static void
gda_data_record_real_set_key_value (GdaDataDbRecord* base,
                                    const gchar* key,
                                    GValue* val,
                                    GError** error)
{
	GdaDataRecord * self;
	GdaDataField* n = NULL;
	GdaDataField* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecord*) base;
	g_return_if_fail (key != NULL);
	_tmp0_ = gda_data_field_new (key, GDA_DATA_DB_FIELD_ATTRIBUTE_NONE);
	n = _tmp0_;
	gda_data_db_field_set_value ((GdaDataDbField*) n, val);
	gda_data_db_record_set_key ((GdaDataDbRecord*) self, (GdaDataDbField*) n, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (n);
		return;
	}
	_g_object_unref0 (n);
}


static GdaDataDbField*
gda_data_record_real_get_key (GdaDataDbRecord* base,
                              const gchar* name,
                              GError** error)
{
	GdaDataRecord * self;
	GdaDataDbField* result = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	self = (GdaDataRecord*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->_keys;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, name);
	result = (GdaDataDbField*) _tmp1_;
	return result;
}


/**
         * Saves any modficiation made to in memory representation of the data directly to
         * the database.
         */
static void
gda_data_record_real_save (GdaDataDbObject* base,
                           GError** error)
{
	GdaDataRecord * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_;
	GdaSqlBuilder* q = NULL;
	GdaSqlBuilder* _tmp14_;
	GdaSqlBuilder* _tmp15_;
	GdaDataDbTable* _tmp16_;
	GdaDataDbTable* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GdaSqlBuilderId cond = 0U;
	GdaSqlBuilder* _tmp59_;
	GdaSqlBuilderId _tmp60_;
	GdaStatement* _tmp61_ = NULL;
	GdaSqlBuilder* _tmp62_;
	GdaStatement* _tmp63_;
	gint i = 0;
	GdaConnection* _tmp64_;
	GdaConnection* _tmp65_;
	gint _tmp66_;
	gint _tmp67_;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecord*) base;
	_tmp0_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ <= 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_SAVE, "No fields has been set");
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp7_ = gda_data_db_record_get_keys ((GdaDataDbRecord*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_collection_get_size (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ <= 0;
	_g_object_unref0 (_tmp9_);
	if (_tmp12_) {
		GError* _tmp13_;
		_tmp13_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_SAVE, "No Keys has been set");
		_inner_error_ = _tmp13_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp14_ = gda_sql_builder_new (GDA_SQL_STATEMENT_UPDATE);
	q = _tmp14_;
	_tmp15_ = q;
	_tmp16_ = gda_data_db_record_get_table ((GdaDataDbRecord*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp17_);
	_tmp19_ = _tmp18_;
	gda_sql_builder_set_table (_tmp15_, _tmp19_);
	{
		GeeIterator* _f_it = NULL;
		GeeCollection* _tmp20_;
		GeeCollection* _tmp21_;
		GeeCollection* _tmp22_;
		GeeIterator* _tmp23_;
		GeeIterator* _tmp24_;
		_tmp20_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp23_ = gee_iterable_iterator ((GeeIterable*) _tmp22_);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (_tmp22_);
		_f_it = _tmp24_;
		while (TRUE) {
			GeeIterator* _tmp25_;
			GdaDataDbField* f = NULL;
			GeeIterator* _tmp26_;
			gpointer _tmp27_;
			GdaSqlBuilder* _tmp28_;
			GdaDataDbField* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			GdaDataDbField* _tmp32_;
			GValue* _tmp33_;
			GValue* _tmp34_;
			_tmp25_ = _f_it;
			if (!gee_iterator_next (_tmp25_)) {
				break;
			}
			_tmp26_ = _f_it;
			_tmp27_ = gee_iterator_get (_tmp26_);
			f = (GdaDataDbField*) _tmp27_;
			_tmp28_ = q;
			_tmp29_ = f;
			_tmp30_ = gda_data_db_field_get_column_name (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = f;
			_tmp33_ = gda_data_db_field_get_value (_tmp32_);
			_tmp34_ = _tmp33_;
			gda_sql_builder_add_field_value_as_gvalue (_tmp28_, _tmp31_, _tmp34_);
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	cond = (GdaSqlBuilderId) -1;
	{
		GeeIterator* _f_it = NULL;
		GeeCollection* _tmp35_;
		GeeCollection* _tmp36_;
		GeeCollection* _tmp37_;
		GeeIterator* _tmp38_;
		GeeIterator* _tmp39_;
		_tmp35_ = gda_data_db_record_get_keys ((GdaDataDbRecord*) self);
		_tmp36_ = _tmp35_;
		_tmp37_ = _tmp36_;
		_tmp38_ = gee_iterable_iterator ((GeeIterable*) _tmp37_);
		_tmp39_ = _tmp38_;
		_g_object_unref0 (_tmp37_);
		_f_it = _tmp39_;
		while (TRUE) {
			GeeIterator* _tmp40_;
			GdaDataDbField* f = NULL;
			GeeIterator* _tmp41_;
			gpointer _tmp42_;
			GdaSqlBuilderId f_id = 0U;
			GdaSqlBuilder* _tmp43_;
			GdaDataDbField* _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			GdaSqlBuilderId e_id = 0U;
			GdaSqlBuilder* _tmp47_;
			GdaDataDbField* _tmp48_;
			GValue* _tmp49_;
			GValue* _tmp50_;
			GdaSqlBuilderId c_id = 0U;
			GdaSqlBuilder* _tmp51_;
			GdaSqlBuilderId _tmp52_;
			GdaSqlBuilderId _tmp53_;
			GdaSqlBuilderId _tmp54_;
			_tmp40_ = _f_it;
			if (!gee_iterator_next (_tmp40_)) {
				break;
			}
			_tmp41_ = _f_it;
			_tmp42_ = gee_iterator_get (_tmp41_);
			f = (GdaDataDbField*) _tmp42_;
			_tmp43_ = q;
			_tmp44_ = f;
			_tmp45_ = gda_data_db_field_get_name (_tmp44_);
			_tmp46_ = _tmp45_;
			f_id = gda_sql_builder_add_id (_tmp43_, _tmp46_);
			_tmp47_ = q;
			_tmp48_ = f;
			_tmp49_ = gda_data_db_field_get_value (_tmp48_);
			_tmp50_ = _tmp49_;
			e_id = gda_sql_builder_add_expr_value (_tmp47_, NULL, _tmp50_);
			_tmp51_ = q;
			_tmp52_ = f_id;
			_tmp53_ = e_id;
			c_id = gda_sql_builder_add_cond (_tmp51_, GDA_SQL_OPERATOR_TYPE_EQ, _tmp52_, _tmp53_, (GdaSqlBuilderId) 0);
			_tmp54_ = cond;
			if (_tmp54_ == ((GdaSqlBuilderId) -1)) {
				GdaSqlBuilderId _tmp55_;
				_tmp55_ = c_id;
				cond = _tmp55_;
			} else {
				GdaSqlBuilder* _tmp56_;
				GdaSqlBuilderId _tmp57_;
				GdaSqlBuilderId _tmp58_;
				_tmp56_ = q;
				_tmp57_ = cond;
				_tmp58_ = c_id;
				cond = gda_sql_builder_add_cond (_tmp56_, GDA_SQL_OPERATOR_TYPE_AND, _tmp57_, _tmp58_, (GdaSqlBuilderId) 0);
			}
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	_tmp59_ = q;
	_tmp60_ = cond;
	gda_sql_builder_set_where (_tmp59_, _tmp60_);
	_tmp62_ = q;
	_tmp63_ = gda_sql_builder_get_statement (_tmp62_, &_inner_error_);
	_tmp61_ = _tmp63_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (q);
		return;
	}
	_tmp64_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp65_ = _tmp64_;
	_tmp66_ = gda_connection_statement_execute_non_select (_tmp65_, _tmp61_, NULL, NULL, &_inner_error_);
	i = _tmp66_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp61_);
		_g_object_unref0 (q);
		return;
	}
	_tmp67_ = i;
	if (_tmp67_ != 1) {
		GError* _tmp68_;
		_tmp68_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_SAVE, "Have been saved more or less rows than expected");
		_inner_error_ = _tmp68_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp61_);
		_g_object_unref0 (q);
		return;
	}
	_g_object_unref0 (_tmp61_);
	_g_object_unref0 (q);
}


/**
         * Updates values stored in database.
         */
static void
gda_data_record_real_update (GdaDataDbObject* base,
                             GError** error)
{
	GdaDataRecord * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	GdaSqlBuilder* q = NULL;
	GdaSqlBuilder* _tmp11_;
	GdaSqlBuilder* _tmp12_;
	GdaDataDbTable* _tmp13_;
	GdaDataDbTable* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GdaSqlBuilder* _tmp17_;
	GdaSqlBuilderId cond = 0U;
	GdaSqlBuilder* _tmp42_;
	GdaSqlBuilderId _tmp43_;
	GdaStatement* _tmp44_ = NULL;
	GdaSqlBuilder* _tmp45_;
	GdaStatement* _tmp46_;
	GdaDataModel* m = NULL;
	GdaConnection* _tmp47_;
	GdaConnection* _tmp48_;
	GdaDataModel* _tmp49_;
	GdaDataModel* _tmp50_;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecord*) base;
	_tmp0_ = gda_data_db_object_get_update_meta ((GdaDataDbObject*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GdaConnection* _tmp2_;
		GdaConnection* _tmp3_;
		_tmp2_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
		_tmp3_ = _tmp2_;
		gda_connection_update_meta_store (_tmp3_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, FALSE);
	}
	_tmp4_ = gda_data_db_record_get_keys ((GdaDataDbRecord*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_collection_get_size (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ <= 0;
	_g_object_unref0 (_tmp6_);
	if (_tmp9_) {
		GError* _tmp10_;
		_tmp10_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_UPDATE, "No Keys has been set");
		_inner_error_ = _tmp10_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp11_ = gda_sql_builder_new (GDA_SQL_STATEMENT_SELECT);
	q = _tmp11_;
	_tmp12_ = q;
	_tmp13_ = gda_data_db_record_get_table ((GdaDataDbRecord*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp14_);
	_tmp16_ = _tmp15_;
	gda_sql_builder_select_add_target (_tmp12_, _tmp16_, NULL);
	_tmp17_ = q;
	gda_sql_builder_select_add_field (_tmp17_, "*", NULL, NULL);
	cond = (GdaSqlBuilderId) -1;
	{
		GeeIterator* _f_it = NULL;
		GeeCollection* _tmp18_;
		GeeCollection* _tmp19_;
		GeeCollection* _tmp20_;
		GeeIterator* _tmp21_;
		GeeIterator* _tmp22_;
		_tmp18_ = gda_data_db_record_get_keys ((GdaDataDbRecord*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_;
		_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		_f_it = _tmp22_;
		while (TRUE) {
			GeeIterator* _tmp23_;
			GdaDataDbField* f = NULL;
			GeeIterator* _tmp24_;
			gpointer _tmp25_;
			GdaSqlBuilderId f_id = 0U;
			GdaSqlBuilder* _tmp26_;
			GdaDataDbField* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			GdaSqlBuilderId e_id = 0U;
			GdaSqlBuilder* _tmp30_;
			GdaDataDbField* _tmp31_;
			GValue* _tmp32_;
			GValue* _tmp33_;
			GdaSqlBuilderId c_id = 0U;
			GdaSqlBuilder* _tmp34_;
			GdaSqlBuilderId _tmp35_;
			GdaSqlBuilderId _tmp36_;
			GdaSqlBuilderId _tmp37_;
			_tmp23_ = _f_it;
			if (!gee_iterator_next (_tmp23_)) {
				break;
			}
			_tmp24_ = _f_it;
			_tmp25_ = gee_iterator_get (_tmp24_);
			f = (GdaDataDbField*) _tmp25_;
			_tmp26_ = q;
			_tmp27_ = f;
			_tmp28_ = gda_data_db_field_get_name (_tmp27_);
			_tmp29_ = _tmp28_;
			f_id = gda_sql_builder_add_id (_tmp26_, _tmp29_);
			_tmp30_ = q;
			_tmp31_ = f;
			_tmp32_ = gda_data_db_field_get_value (_tmp31_);
			_tmp33_ = _tmp32_;
			e_id = gda_sql_builder_add_expr_value (_tmp30_, NULL, _tmp33_);
			_tmp34_ = q;
			_tmp35_ = f_id;
			_tmp36_ = e_id;
			c_id = gda_sql_builder_add_cond (_tmp34_, GDA_SQL_OPERATOR_TYPE_EQ, _tmp35_, _tmp36_, (GdaSqlBuilderId) 0);
			_tmp37_ = cond;
			if (_tmp37_ == ((GdaSqlBuilderId) -1)) {
				GdaSqlBuilderId _tmp38_;
				_tmp38_ = c_id;
				cond = _tmp38_;
			} else {
				GdaSqlBuilder* _tmp39_;
				GdaSqlBuilderId _tmp40_;
				GdaSqlBuilderId _tmp41_;
				_tmp39_ = q;
				_tmp40_ = cond;
				_tmp41_ = c_id;
				cond = gda_sql_builder_add_cond (_tmp39_, GDA_SQL_OPERATOR_TYPE_AND, _tmp40_, _tmp41_, (GdaSqlBuilderId) 0);
			}
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	_tmp42_ = q;
	_tmp43_ = cond;
	gda_sql_builder_set_where (_tmp42_, _tmp43_);
	_tmp45_ = q;
	_tmp46_ = gda_sql_builder_get_statement (_tmp45_, &_inner_error_);
	_tmp44_ = _tmp46_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (q);
		return;
	}
	_tmp47_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp48_ = _tmp47_;
	_tmp49_ = gda_connection_statement_execute_select (_tmp48_, _tmp44_, NULL, &_inner_error_);
	m = _tmp49_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp44_);
		_g_object_unref0 (q);
		return;
	}
	_tmp50_ = m;
	if (gda_data_model_get_n_rows (_tmp50_) != 1) {
		GError* _tmp51_;
		_tmp51_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_UPDATE, "Returning number of rows are more than 1");
		_inner_error_ = _tmp51_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (m);
		_g_object_unref0 (_tmp44_);
		_g_object_unref0 (q);
		return;
	}
	{
		gint c = 0;
		c = 0;
		{
			gboolean _tmp52_ = FALSE;
			_tmp52_ = TRUE;
			while (TRUE) {
				gint _tmp54_;
				GdaDataModel* _tmp55_;
				GdaDataField* f = NULL;
				GdaDataModel* _tmp56_;
				gint _tmp57_;
				const gchar* _tmp58_;
				GdaDataModel* _tmp59_;
				gint _tmp60_;
				GdaDataField* _tmp61_;
				GValue* _tmp62_ = NULL;
				GdaDataModel* _tmp63_;
				gint _tmp64_;
				GdaDataField* _tmp65_;
				GdaDataField* _tmp66_;
				if (!_tmp52_) {
					gint _tmp53_;
					_tmp53_ = c;
					c = _tmp53_ + 1;
				}
				_tmp52_ = FALSE;
				_tmp54_ = c;
				_tmp55_ = m;
				if (!(_tmp54_ < gda_data_model_get_n_columns (_tmp55_))) {
					break;
				}
				_tmp56_ = m;
				_tmp57_ = c;
				_tmp58_ = gda_data_model_get_column_name (_tmp56_, _tmp57_);
				_tmp59_ = m;
				_tmp60_ = c;
				_tmp61_ = gda_data_field_new (_tmp58_, (GdaDataDbFieldAttribute) gda_data_model_get_attributes_at (_tmp59_, _tmp60_, 0));
				f = _tmp61_;
				_tmp63_ = m;
				_tmp64_ = c;
				_tmp62_ = gda_data_model_get_value_at (_tmp63_, _tmp64_, 0, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_object_unref0 (m);
					_g_object_unref0 (_tmp44_);
					_g_object_unref0 (q);
					return;
				}
				_tmp65_ = f;
				gda_data_db_field_set_value ((GdaDataDbField*) _tmp65_, _tmp62_);
				_tmp66_ = f;
				gda_data_db_record_set_field ((GdaDataDbRecord*) self, (GdaDataDbField*) _tmp66_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_object_unref0 (m);
					_g_object_unref0 (_tmp44_);
					_g_object_unref0 (q);
					return;
				}
				_g_object_unref0 (f);
			}
		}
	}
	_g_object_unref0 (m);
	_g_object_unref0 (_tmp44_);
	_g_object_unref0 (q);
}


/**
         * Append a new row to the defined table and returns its ID. If defaults is set to true,
         * default value for each field is set.
         */
static void
gda_data_record_real_append (GdaDataDbObject* base,
                             GError** error)
{
	GdaDataRecord * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	GdaSqlBuilder* sql = NULL;
	GdaSqlBuilder* _tmp7_;
	GdaSqlBuilder* _tmp8_;
	GdaDataDbTable* _tmp9_;
	GdaDataDbTable* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GdaStatement* _tmp29_ = NULL;
	GdaSqlBuilder* _tmp30_;
	GdaStatement* _tmp31_;
	gint i = 0;
	GdaConnection* _tmp32_;
	GdaConnection* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecord*) base;
	_tmp0_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ <= 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_APPEND, "No fields has been set");
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp7_ = gda_sql_builder_new (GDA_SQL_STATEMENT_INSERT);
	sql = _tmp7_;
	_tmp8_ = sql;
	_tmp9_ = gda_data_db_record_get_table ((GdaDataDbRecord*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp10_);
	_tmp12_ = _tmp11_;
	gda_sql_builder_set_table (_tmp8_, _tmp12_);
	{
		GeeIterator* _f_it = NULL;
		GeeHashMap* _tmp13_;
		GeeCollection* _tmp14_;
		GeeCollection* _tmp15_;
		GeeCollection* _tmp16_;
		GeeIterator* _tmp17_;
		GeeIterator* _tmp18_;
		_tmp13_ = self->_fields;
		_tmp14_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		_f_it = _tmp18_;
		while (TRUE) {
			GeeIterator* _tmp19_;
			GdaDataDbField* f = NULL;
			GeeIterator* _tmp20_;
			gpointer _tmp21_;
			GdaSqlBuilder* _tmp22_;
			GdaDataDbField* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			GdaDataDbField* _tmp26_;
			GValue* _tmp27_;
			GValue* _tmp28_;
			_tmp19_ = _f_it;
			if (!gee_iterator_next (_tmp19_)) {
				break;
			}
			_tmp20_ = _f_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			f = (GdaDataDbField*) _tmp21_;
			_tmp22_ = sql;
			_tmp23_ = f;
			_tmp24_ = gda_data_db_field_get_column_name (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = f;
			_tmp27_ = gda_data_db_field_get_value (_tmp26_);
			_tmp28_ = _tmp27_;
			gda_sql_builder_add_field_value_as_gvalue (_tmp22_, _tmp25_, _tmp28_);
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	_tmp30_ = sql;
	_tmp31_ = gda_sql_builder_get_statement (_tmp30_, &_inner_error_);
	_tmp29_ = _tmp31_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (sql);
		return;
	}
	_tmp32_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = gda_connection_statement_execute_non_select (_tmp33_, _tmp29_, NULL, NULL, &_inner_error_);
	i = _tmp34_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp29_);
		_g_object_unref0 (sql);
		return;
	}
	_tmp35_ = i;
	if (_tmp35_ != 1) {
		GError* _tmp36_;
		_tmp36_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_UPDATE, "Have been updated more or less rows than expected");
		_inner_error_ = _tmp36_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp29_);
		_g_object_unref0 (sql);
		return;
	}
	_g_object_unref0 (_tmp29_);
	_g_object_unref0 (sql);
}


static void
gda_data_record_real_drop (GdaDataDbObject* base,
                           gboolean cascade,
                           GError** error)
{
	GdaDataRecord * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	GdaSqlBuilder* sql = NULL;
	GdaSqlBuilder* _tmp7_;
	GdaSqlBuilder* _tmp8_;
	GdaDataDbTable* _tmp9_;
	GdaDataDbTable* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GdaSqlBuilderId cond = 0U;
	GdaSqlBuilder* _tmp37_;
	GdaSqlBuilderId _tmp38_;
	GdaStatement* _tmp39_ = NULL;
	GdaSqlBuilder* _tmp40_;
	GdaStatement* _tmp41_;
	gchar* _tmp42_ = NULL;
	GdaConnection* _tmp43_;
	GdaConnection* _tmp44_;
	gchar* _tmp45_;
	FILE* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	GdaStatement* _tmp51_ = NULL;
	GdaSqlBuilder* _tmp52_;
	GdaStatement* _tmp53_;
	gint i = 0;
	GdaConnection* _tmp54_;
	GdaConnection* _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecord*) base;
	_tmp0_ = gda_data_db_record_get_keys ((GdaDataDbRecord*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ <= 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_DROP, "No keys has been set");
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp7_ = gda_sql_builder_new (GDA_SQL_STATEMENT_DELETE);
	sql = _tmp7_;
	_tmp8_ = sql;
	_tmp9_ = gda_data_db_record_get_table ((GdaDataDbRecord*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp10_);
	_tmp12_ = _tmp11_;
	gda_sql_builder_set_table (_tmp8_, _tmp12_);
	cond = (GdaSqlBuilderId) -1;
	{
		GeeIterator* _f_it = NULL;
		GeeCollection* _tmp13_;
		GeeCollection* _tmp14_;
		GeeCollection* _tmp15_;
		GeeIterator* _tmp16_;
		GeeIterator* _tmp17_;
		_tmp13_ = gda_data_db_record_get_keys ((GdaDataDbRecord*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp15_);
		_f_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			GdaDataDbField* f = NULL;
			GeeIterator* _tmp19_;
			gpointer _tmp20_;
			GdaSqlBuilderId fid = 0U;
			GdaSqlBuilder* _tmp21_;
			GdaDataDbField* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			GdaSqlBuilderId vid = 0U;
			GdaSqlBuilder* _tmp25_;
			GdaDataDbField* _tmp26_;
			GValue* _tmp27_;
			GValue* _tmp28_;
			GdaSqlBuilderId c_id = 0U;
			GdaSqlBuilder* _tmp29_;
			GdaSqlBuilderId _tmp30_;
			GdaSqlBuilderId _tmp31_;
			GdaSqlBuilderId _tmp32_;
			_tmp18_ = _f_it;
			if (!gee_iterator_next (_tmp18_)) {
				break;
			}
			_tmp19_ = _f_it;
			_tmp20_ = gee_iterator_get (_tmp19_);
			f = (GdaDataDbField*) _tmp20_;
			_tmp21_ = sql;
			_tmp22_ = f;
			_tmp23_ = gda_data_db_field_get_column_name (_tmp22_);
			_tmp24_ = _tmp23_;
			fid = gda_sql_builder_add_id (_tmp21_, _tmp24_);
			_tmp25_ = sql;
			_tmp26_ = f;
			_tmp27_ = gda_data_db_field_get_value (_tmp26_);
			_tmp28_ = _tmp27_;
			vid = gda_sql_builder_add_expr_value (_tmp25_, NULL, _tmp28_);
			_tmp29_ = sql;
			_tmp30_ = fid;
			_tmp31_ = vid;
			c_id = gda_sql_builder_add_cond (_tmp29_, GDA_SQL_OPERATOR_TYPE_EQ, _tmp30_, _tmp31_, (GdaSqlBuilderId) 0);
			_tmp32_ = cond;
			if (_tmp32_ == ((GdaSqlBuilderId) -1)) {
				GdaSqlBuilderId _tmp33_;
				_tmp33_ = c_id;
				cond = _tmp33_;
			} else {
				GdaSqlBuilder* _tmp34_;
				GdaSqlBuilderId _tmp35_;
				GdaSqlBuilderId _tmp36_;
				_tmp34_ = sql;
				_tmp35_ = cond;
				_tmp36_ = c_id;
				cond = gda_sql_builder_add_cond (_tmp34_, GDA_SQL_OPERATOR_TYPE_AND, _tmp35_, _tmp36_, (GdaSqlBuilderId) 0);
			}
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	_tmp37_ = sql;
	_tmp38_ = cond;
	gda_sql_builder_set_where (_tmp37_, _tmp38_);
	_tmp40_ = sql;
	_tmp41_ = gda_sql_builder_get_statement (_tmp40_, &_inner_error_);
	_tmp39_ = _tmp41_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (sql);
		return;
	}
	_tmp43_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp44_ = _tmp43_;
	_tmp45_ = gda_statement_to_sql_extended (_tmp39_, _tmp44_, NULL, GDA_STATEMENT_SQL_PRETTY, NULL, &_inner_error_);
	_tmp42_ = _tmp45_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp39_);
		_g_object_unref0 (sql);
		return;
	}
	_tmp46_ = stdout;
	_tmp47_ = g_strconcat ("DEBUG: DELETE statement to execute: \n", _tmp42_, NULL);
	_tmp48_ = _tmp47_;
	_tmp49_ = g_strconcat (_tmp48_, "\n", NULL);
	_tmp50_ = _tmp49_;
	fprintf (_tmp46_, "%s", _tmp50_);
	_g_free0 (_tmp50_);
	_g_free0 (_tmp48_);
	_tmp52_ = sql;
	_tmp53_ = gda_sql_builder_get_statement (_tmp52_, &_inner_error_);
	_tmp51_ = _tmp53_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (_tmp42_);
		_g_object_unref0 (_tmp39_);
		_g_object_unref0 (sql);
		return;
	}
	_tmp54_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp55_ = _tmp54_;
	_tmp56_ = gda_connection_statement_execute_non_select (_tmp55_, _tmp51_, NULL, NULL, &_inner_error_);
	i = _tmp56_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp51_);
		_g_free0 (_tmp42_);
		_g_object_unref0 (_tmp39_);
		_g_object_unref0 (sql);
		return;
	}
	_tmp57_ = i;
	if (_tmp57_ != 1) {
		GError* _tmp58_;
		_tmp58_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_DROP, "Have been dropped more or less rows than expected");
		_inner_error_ = _tmp58_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp51_);
		_g_free0 (_tmp42_);
		_g_object_unref0 (_tmp39_);
		_g_object_unref0 (sql);
		return;
	}
	_g_object_unref0 (_tmp51_);
	_g_free0 (_tmp42_);
	_g_object_unref0 (_tmp39_);
	_g_object_unref0 (sql);
}


static gchar*
gda_data_record_real_to_string (GdaDataDbRecord* base)
{
	GdaDataRecord * self;
	gchar* result = NULL;
	gchar* r = NULL;
	gchar* _tmp0_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	self = (GdaDataRecord*) base;
	_tmp0_ = g_strdup ("");
	r = _tmp0_;
	{
		GeeIterator* _f_it = NULL;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp1_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_f_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GdaDataDbField* f = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			const gchar* _tmp9_;
			GdaDataDbField* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp6_ = _f_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _f_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			f = (GdaDataDbField*) _tmp8_;
			_tmp9_ = r;
			_tmp10_ = f;
			_tmp11_ = gda_data_db_field_get_name (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat ("|", _tmp12_, NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat (_tmp9_, _tmp14_, NULL);
			_g_free0 (r);
			r = _tmp15_;
			_g_free0 (_tmp14_);
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	_tmp16_ = r;
	_tmp17_ = g_strconcat (_tmp16_, "\n", NULL);
	_g_free0 (r);
	r = _tmp17_;
	{
		GeeIterator* _f_it = NULL;
		GeeCollection* _tmp18_;
		GeeCollection* _tmp19_;
		GeeCollection* _tmp20_;
		GeeIterator* _tmp21_;
		GeeIterator* _tmp22_;
		_tmp18_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_;
		_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		_f_it = _tmp22_;
		while (TRUE) {
			GeeIterator* _tmp23_;
			GdaDataDbField* f = NULL;
			GeeIterator* _tmp24_;
			gpointer _tmp25_;
			const gchar* _tmp26_;
			GdaDataDbField* _tmp27_;
			GValue* _tmp28_;
			GValue* _tmp29_;
			GValue _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp23_ = _f_it;
			if (!gee_iterator_next (_tmp23_)) {
				break;
			}
			_tmp24_ = _f_it;
			_tmp25_ = gee_iterator_get (_tmp24_);
			f = (GdaDataDbField*) _tmp25_;
			_tmp26_ = r;
			_tmp27_ = f;
			_tmp28_ = gda_data_db_field_get_value (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = *_tmp29_;
			_tmp31_ = gda_value_stringify (&_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat ("|", _tmp32_, NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strconcat (_tmp26_, _tmp34_, NULL);
			_g_free0 (r);
			r = _tmp35_;
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	result = r;
	return result;
}


/**
         * Compare two DbRecord keys. If record have more than one key allways return -1.
         *
         * @Returns: 0 if keys are equal or -1 if they are different.
         */
static gint
gda_data_record_real_compare_to (GeeComparable* base,
                                 GdaDataDbRecord* object)
{
	GdaDataRecord * self;
	gint result = 0;
	gint r = 0;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecord*) base;
	g_return_val_if_fail (object != NULL, 0);
	r = 0;
	{
		{
			GeeIterator* _f_it = NULL;
			GeeCollection* _tmp0_;
			GeeCollection* _tmp1_;
			GeeCollection* _tmp2_;
			GeeIterator* _tmp3_;
			GeeIterator* _tmp4_;
			_tmp0_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) self);
			_tmp1_ = _tmp0_;
			_tmp2_ = _tmp1_;
			_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
			_tmp4_ = _tmp3_;
			_g_object_unref0 (_tmp2_);
			_f_it = _tmp4_;
			while (TRUE) {
				GeeIterator* _tmp5_;
				GdaDataDbField* f = NULL;
				GeeIterator* _tmp6_;
				gpointer _tmp7_;
				GdaDataDbField* fl = NULL;
				GdaDataDbField* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				GdaDataDbField* _tmp11_;
				GdaDataDbField* _tmp12_;
				GValue* _tmp13_;
				GValue* _tmp14_;
				GdaDataDbField* _tmp15_;
				GValue* _tmp16_;
				GValue* _tmp17_;
				GValue _tmp18_;
				GValue _tmp19_;
				_tmp5_ = _f_it;
				if (!gee_iterator_next (_tmp5_)) {
					break;
				}
				_tmp6_ = _f_it;
				_tmp7_ = gee_iterator_get (_tmp6_);
				f = (GdaDataDbField*) _tmp7_;
				_tmp8_ = f;
				_tmp9_ = gda_data_db_field_get_name (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = gda_data_db_record_get_field (object, _tmp10_, &_inner_error_);
				fl = _tmp11_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (f);
					_g_object_unref0 (_f_it);
					goto __catch8_g_error;
				}
				_tmp12_ = f;
				_tmp13_ = gda_data_db_field_get_value (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = fl;
				_tmp16_ = gda_data_db_field_get_value (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = *_tmp14_;
				_tmp19_ = *_tmp17_;
				if (gda_value_compare (&_tmp18_, &_tmp19_) != 0) {
					result = -1;
					_g_object_unref0 (fl);
					_g_object_unref0 (f);
					_g_object_unref0 (_f_it);
					return result;
				}
				_g_object_unref0 (fl);
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_it);
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("Record.vala:280: %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp22_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp22_;
	}
	result = r;
	return result;
}


GdaDataRecord*
gda_data_record_construct (GType object_type)
{
	GdaDataRecord * self = NULL;
	self = (GdaDataRecord*) g_object_new (object_type, NULL);
	return self;
}


GdaDataRecord*
gda_data_record_new (void)
{
	return gda_data_record_construct (GDA_DATA_TYPE_RECORD);
}


static GdaDataDbTable*
gda_data_record_real_get_table (GdaDataDbRecord* base)
{
	GdaDataDbTable* result;
	GdaDataRecord* self;
	GdaDataDbTable* _tmp0_;
	self = (GdaDataRecord*) base;
	_tmp0_ = self->priv->_table;
	result = _tmp0_;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
gda_data_record_real_set_table (GdaDataDbRecord* base,
                                GdaDataDbTable* value)
{
	GdaDataRecord* self;
	self = (GdaDataRecord*) base;
	if (gda_data_record_real_get_table (base) != value) {
		GdaDataDbTable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_table);
		self->priv->_table = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gda_data_record_properties[GDA_DATA_RECORD_TABLE_PROPERTY]);
	}
}


static GeeCollection*
gda_data_record_real_get_fields (GdaDataDbRecord* base)
{
	GeeCollection* result;
	GdaDataRecord* self;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	self = (GdaDataRecord*) base;
	_tmp0_ = self->_fields;
	_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static GeeCollection*
gda_data_record_real_get_keys (GdaDataDbRecord* base)
{
	GeeCollection* result;
	GdaDataRecord* self;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	self = (GdaDataRecord*) base;
	_tmp0_ = self->_keys;
	_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static GdaConnection*
gda_data_record_real_get_connection (GdaDataDbObject* base)
{
	GdaConnection* result;
	GdaDataRecord* self;
	GdaConnection* _tmp0_;
	self = (GdaDataRecord*) base;
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}


static void
gda_data_record_real_set_connection (GdaDataDbObject* base,
                                     GdaConnection* value)
{
	GdaDataRecord* self;
	self = (GdaDataRecord*) base;
	if (gda_data_record_real_get_connection (base) != value) {
		GdaConnection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_connection);
		self->priv->_connection = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gda_data_record_properties[GDA_DATA_RECORD_CONNECTION_PROPERTY]);
	}
}


static gboolean
gda_data_record_real_get_update_meta (GdaDataDbObject* base)
{
	gboolean result;
	GdaDataRecord* self;
	gboolean _tmp0_;
	self = (GdaDataRecord*) base;
	_tmp0_ = self->priv->_update_meta;
	result = _tmp0_;
	return result;
}


static void
gda_data_record_real_set_update_meta (GdaDataDbObject* base,
                                      gboolean value)
{
	GdaDataRecord* self;
	self = (GdaDataRecord*) base;
	self->priv->_update_meta = value;
	g_object_notify_by_pspec ((GObject *) self, gda_data_record_properties[GDA_DATA_RECORD_UPDATE_META_PROPERTY]);
}


static void
gda_data_record_class_init (GdaDataRecordClass * klass)
{
	gda_data_record_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GdaDataRecordPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gda_data_record_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gda_data_record_set_property;
	G_OBJECT_CLASS (klass)->finalize = gda_data_record_finalize;
	/**
	         * Derived classes must implement this property to set the table used to get data from.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_TABLE_PROPERTY, gda_data_record_properties[GDA_DATA_RECORD_TABLE_PROPERTY] = g_param_spec_object ("table", "table", "table", GDA_DATA_TYPE_DB_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	         * Returns a Gee.Collection with the data stored by this object.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_FIELDS_PROPERTY, gda_data_record_properties[GDA_DATA_RECORD_FIELDS_PROPERTY] = g_param_spec_object ("fields", "fields", "fields", GEE_TYPE_COLLECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_KEYS_PROPERTY, gda_data_record_properties[GDA_DATA_RECORD_KEYS_PROPERTY] = g_param_spec_object ("keys", "keys", "keys", GEE_TYPE_COLLECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * Set the connection to be used to get/set data.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_CONNECTION_PROPERTY, gda_data_record_properties[GDA_DATA_RECORD_CONNECTION_PROPERTY] = g_param_spec_object ("connection", "connection", "connection", gda_connection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_UPDATE_META_PROPERTY, gda_data_record_properties[GDA_DATA_RECORD_UPDATE_META_PROPERTY] = g_param_spec_boolean ("update-meta", "update-meta", "update-meta", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
gda_data_record_gda_data_db_object_interface_init (GdaDataDbObjectIface * iface)
{
	gda_data_record_gda_data_db_object_parent_iface = g_type_interface_peek_parent (iface);
	iface->save = (void (*) (GdaDataDbObject *, GError**)) gda_data_record_real_save;
	iface->update = (void (*) (GdaDataDbObject *, GError**)) gda_data_record_real_update;
	iface->append = (void (*) (GdaDataDbObject *, GError**)) gda_data_record_real_append;
	iface->drop = (void (*) (GdaDataDbObject *, gboolean, GError**)) gda_data_record_real_drop;
	iface->get_connection = gda_data_record_real_get_connection;
	iface->set_connection = gda_data_record_real_set_connection;
	iface->get_update_meta = gda_data_record_real_get_update_meta;
	iface->set_update_meta = gda_data_record_real_set_update_meta;
}


static void
gda_data_record_gee_comparable_interface_init (GeeComparableIface * iface)
{
	gda_data_record_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare_to = (gint (*) (GeeComparable *, gconstpointer)) gda_data_record_real_compare_to;
}


static void
gda_data_record_gda_data_db_record_interface_init (GdaDataDbRecordIface * iface)
{
	gda_data_record_gda_data_db_record_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_value = (GValue* (*) (GdaDataDbRecord *, const gchar*, GError**)) gda_data_record_real_get_value;
	iface->set_field = (void (*) (GdaDataDbRecord *, GdaDataDbField*, GError**)) gda_data_record_real_set_field;
	iface->set_field_value = (void (*) (GdaDataDbRecord *, const gchar*, GValue*, GError**)) gda_data_record_real_set_field_value;
	iface->get_field = (GdaDataDbField* (*) (GdaDataDbRecord *, const gchar*, GError**)) gda_data_record_real_get_field;
	iface->set_key = (void (*) (GdaDataDbRecord *, GdaDataDbField*, GError**)) gda_data_record_real_set_key;
	iface->set_key_value = (void (*) (GdaDataDbRecord *, const gchar*, GValue*, GError**)) gda_data_record_real_set_key_value;
	iface->get_key = (GdaDataDbField* (*) (GdaDataDbRecord *, const gchar*, GError**)) gda_data_record_real_get_key;
	iface->to_string = (gchar* (*) (GdaDataDbRecord *)) gda_data_record_real_to_string;
	iface->get_table = gda_data_record_real_get_table;
	iface->set_table = gda_data_record_real_set_table;
	iface->get_fields = gda_data_record_real_get_fields;
	iface->get_keys = gda_data_record_real_get_keys;
}


static void
gda_data_record_instance_init (GdaDataRecord * self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = GDA_DATA_RECORD_GET_PRIVATE (self);
	self->priv->_update_meta = FALSE;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GDA_DATA_TYPE_DB_FIELD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->_fields = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GDA_DATA_TYPE_DB_FIELD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->_keys = _tmp1_;
}


static void
gda_data_record_finalize (GObject * obj)
{
	GdaDataRecord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GDA_DATA_TYPE_RECORD, GdaDataRecord);
	_g_object_unref0 (self->_fields);
	_g_object_unref0 (self->_keys);
	_g_object_unref0 (self->priv->_table);
	_g_object_unref0 (self->priv->_connection);
	G_OBJECT_CLASS (gda_data_record_parent_class)->finalize (obj);
}


GType
gda_data_record_get_type (void)
{
	static volatile gsize gda_data_record_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_record_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdaDataRecordClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gda_data_record_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdaDataRecord), 0, (GInstanceInitFunc) gda_data_record_instance_init, NULL };
		static const GInterfaceInfo gda_data_db_object_info = { (GInterfaceInitFunc) gda_data_record_gda_data_db_object_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) gda_data_record_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gda_data_db_record_info = { (GInterfaceInitFunc) gda_data_record_gda_data_db_record_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gda_data_record_type_id;
		gda_data_record_type_id = g_type_register_static (G_TYPE_OBJECT, "GdaDataRecord", &g_define_type_info, 0);
		g_type_add_interface_static (gda_data_record_type_id, GDA_DATA_TYPE_DB_OBJECT, &gda_data_db_object_info);
		g_type_add_interface_static (gda_data_record_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_type_add_interface_static (gda_data_record_type_id, GDA_DATA_TYPE_DB_RECORD, &gda_data_db_record_info);
		g_once_init_leave (&gda_data_record_type_id__volatile, gda_data_record_type_id);
	}
	return gda_data_record_type_id__volatile;
}


static void
_vala_gda_data_record_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GdaDataRecord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GDA_DATA_TYPE_RECORD, GdaDataRecord);
	switch (property_id) {
		case GDA_DATA_RECORD_TABLE_PROPERTY:
		g_value_set_object (value, gda_data_db_record_get_table ((GdaDataDbRecord*) self));
		break;
		case GDA_DATA_RECORD_FIELDS_PROPERTY:
		g_value_take_object (value, gda_data_db_record_get_fields ((GdaDataDbRecord*) self));
		break;
		case GDA_DATA_RECORD_KEYS_PROPERTY:
		g_value_take_object (value, gda_data_db_record_get_keys ((GdaDataDbRecord*) self));
		break;
		case GDA_DATA_RECORD_CONNECTION_PROPERTY:
		g_value_set_object (value, gda_data_db_object_get_connection ((GdaDataDbObject*) self));
		break;
		case GDA_DATA_RECORD_UPDATE_META_PROPERTY:
		g_value_set_boolean (value, gda_data_db_object_get_update_meta ((GdaDataDbObject*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_gda_data_record_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GdaDataRecord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GDA_DATA_TYPE_RECORD, GdaDataRecord);
	switch (property_id) {
		case GDA_DATA_RECORD_TABLE_PROPERTY:
		gda_data_db_record_set_table ((GdaDataDbRecord*) self, g_value_get_object (value));
		break;
		case GDA_DATA_RECORD_CONNECTION_PROPERTY:
		gda_data_db_object_set_connection ((GdaDataDbObject*) self, g_value_get_object (value));
		break;
		case GDA_DATA_RECORD_UPDATE_META_PROPERTY:
		gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



