/* CheckDataObject.c generated by valac 0.40.8.18-c87af, the Vala compiler
 * generated from CheckDataObject.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata Unit Tests
 * Copyright (C) Daniel Espinosa Ortiz 2011 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <libgda/data/libgdadata.h>
#include <stdlib.h>
#include <string.h>
#include <libgda/libgda.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gee.h>


#define CHECK_TYPE_RECORD (check_record_get_type ())
#define CHECK_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECK_TYPE_RECORD, CheckRecord))
#define CHECK_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECK_TYPE_RECORD, CheckRecordClass))
#define CHECK_IS_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECK_TYPE_RECORD))
#define CHECK_IS_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECK_TYPE_RECORD))
#define CHECK_RECORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECK_TYPE_RECORD, CheckRecordClass))

typedef struct _CheckRecord CheckRecord;
typedef struct _CheckRecordClass CheckRecordClass;
typedef struct _CheckRecordPrivate CheckRecordPrivate;
enum  {
	CHECK_RECORD_0_PROPERTY,
	CHECK_RECORD_NUM_PROPERTIES
};
static GParamSpec* check_record_properties[CHECK_RECORD_NUM_PROPERTIES];

#define CHECK_TYPE_TESTS (check_tests_get_type ())
#define CHECK_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECK_TYPE_TESTS, CheckTests))
#define CHECK_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECK_TYPE_TESTS, CheckTestsClass))
#define CHECK_IS_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECK_TYPE_TESTS))
#define CHECK_IS_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECK_TYPE_TESTS))
#define CHECK_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECK_TYPE_TESTS, CheckTestsClass))

typedef struct _CheckTests CheckTests;
typedef struct _CheckTestsClass CheckTestsClass;
typedef struct _CheckTestsPrivate CheckTestsPrivate;
enum  {
	CHECK_TESTS_0_PROPERTY,
	CHECK_TESTS_CONNECTION_PROPERTY,
	CHECK_TESTS_NUM_PROPERTIES
};
static GParamSpec* check_tests_properties[CHECK_TESTS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _CheckRecord {
	GdaDataRecord parent_instance;
	CheckRecordPrivate * priv;
};

struct _CheckRecordClass {
	GdaDataRecordClass parent_class;
};

struct _CheckTests {
	GObject parent_instance;
	CheckTestsPrivate * priv;
};

struct _CheckTestsClass {
	GObjectClass parent_class;
};

struct _CheckTestsPrivate {
	GdaConnection* _connection;
};


static gpointer check_record_parent_class = NULL;
extern gchar* check_record_t;
gchar* check_record_t = NULL;
static gpointer check_tests_parent_class = NULL;

GType check_record_get_type (void) G_GNUC_CONST;
CheckRecord* check_record_new (void);
CheckRecord* check_record_construct (GType object_type);
static void check_record_finalize (GObject * obj);
GType check_tests_get_type (void) G_GNUC_CONST;
#define CHECK_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHECK_TYPE_TESTS, CheckTestsPrivate))
static CheckTests* check_tests_new (void);
static CheckTests* check_tests_construct (GType object_type);
void check_tests_set_connection (CheckTests* self,
                                 GdaConnection* value);
GdaConnection* check_tests_get_connection (CheckTests* self);
gint check_tests_t1 (CheckTests* self,
                     GError** error);
static void _vala_GValue_free (GValue* self);
gint check_tests_t2 (CheckTests* self,
                     GError** error);
static GValue* _g_value_dup (GValue* self);
gint check_tests_main (gchar** args,
                       int args_length1);
static void check_tests_finalize (GObject * obj);
static void _vala_check_tests_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_check_tests_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);


CheckRecord*
check_record_construct (GType object_type)
{
	CheckRecord * self = NULL;
	self = (CheckRecord*) gda_data_record_construct (object_type);
	return self;
}


CheckRecord*
check_record_new (void)
{
	return check_record_construct (CHECK_TYPE_RECORD);
}


static void
check_record_class_init (CheckRecordClass * klass)
{
	gchar* _tmp0_;
	check_record_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = check_record_finalize;
	_tmp0_ = g_strdup ("user");
	check_record_t = _tmp0_;
}


static void
check_record_instance_init (CheckRecord * self)
{
}


static void
check_record_finalize (GObject * obj)
{
	CheckRecord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHECK_TYPE_RECORD, CheckRecord);
	G_OBJECT_CLASS (check_record_parent_class)->finalize (obj);
}


GType
check_record_get_type (void)
{
	static volatile gsize check_record_type_id__volatile = 0;
	if (g_once_init_enter (&check_record_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckRecordClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) check_record_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckRecord), 0, (GInstanceInitFunc) check_record_instance_init, NULL };
		GType check_record_type_id;
		check_record_type_id = g_type_register_static (GDA_DATA_TYPE_RECORD, "CheckRecord", &g_define_type_info, 0);
		g_once_init_leave (&check_record_type_id__volatile, check_record_type_id);
	}
	return check_record_type_id__volatile;
}


static CheckTests*
check_tests_construct (GType object_type)
{
	CheckTests * self = NULL;
	GError * _inner_error_ = NULL;
	self = (CheckTests*) g_object_new (object_type, NULL);
	{
		FILE* _tmp0_;
		GdaConnection* _tmp1_ = NULL;
		GdaConnection* _tmp2_;
		FILE* _tmp3_;
		GdaConnection* _tmp4_;
		GdaConnection* _tmp5_;
		GdaConnection* _tmp6_;
		FILE* _tmp7_;
		GdaConnection* _tmp8_;
		GdaConnection* _tmp9_;
		GdaConnection* _tmp10_;
		GdaConnection* _tmp11_;
		g_unlink ("dataobject.db");
		_tmp0_ = stdout;
		fprintf (_tmp0_, "Creating Database...\n");
		_tmp2_ = gda_connection_open_from_string ("SQLite", "DB_DIR=.;DB_NAME=dataobject", NULL, GDA_CONNECTION_OPTIONS_NONE, &_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		check_tests_set_connection (self, _tmp1_);
		_tmp3_ = stdout;
		fprintf (_tmp3_, "Creating table 'user'...\n");
		_tmp4_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp4_, "CREATE TABLE user (id integer PRIMARY KEY AUTOINCREMENT, name string, " \
"city string)", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp5_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp5_, "INSERT INTO user (id, name, city) VALUES (1, \"Daniel\", \"Mexico\")", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp6_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp6_, "INSERT INTO user (id, name, city) VALUES (2, \"Jhon\", \"USA\")", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp7_ = stdout;
		fprintf (_tmp7_, "Creating table 'company'...\n");
		_tmp8_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp8_, "CREATE TABLE company (id int PRIMARY KEY, name string, responsability " \
"string)", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp9_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp9_, "INSERT INTO company (id, name, responsability) VALUES (1, \"Telcsa\", " \
"\"Programing\")", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp10_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp10_, "INSERT INTO company (id, name, responsability) VALUES (2, \"Viasa\", \"" \
"Accessories\")", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp11_ = self->priv->_connection;
		gda_connection_update_meta_store (_tmp11_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stdout;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "Couln't create temporary database...\nERROR: %s\n", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static CheckTests*
check_tests_new (void)
{
	return check_tests_construct (CHECK_TYPE_TESTS);
}


static void
_vala_GValue_free (GValue* self)
{
	g_value_unset (self);
	g_free (self);
}


gint
check_tests_t1 (CheckTests* self,
                GError** error)
{
	gint result = 0;
	FILE* _tmp0_;
	gint fails = 0;
	FILE* _tmp1_;
	CheckRecord* r = NULL;
	CheckRecord* _tmp2_;
	FILE* _tmp3_;
	CheckRecord* _tmp4_;
	GdaConnection* _tmp5_;
	FILE* _tmp6_;
	GdaDataTable* t = NULL;
	GdaDataTable* _tmp7_;
	FILE* _tmp8_;
	GdaDataTable* _tmp9_;
	FILE* _tmp10_;
	GdaDataTable* _tmp11_;
	GdaConnection* _tmp12_;
	FILE* _tmp13_;
	CheckRecord* _tmp14_;
	GdaDataTable* _tmp15_;
	FILE* _tmp16_;
	GdaDataField* k = NULL;
	GdaDataField* _tmp17_;
	FILE* _tmp18_;
	FILE* _tmp85_;
	CheckRecord* _tmp86_;
	GdaDataDbTable* _tmp87_;
	GdaDataDbTable* _tmp88_;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	CheckRecord* _tmp95_;
	GdaDataDbTable* _tmp96_;
	GdaDataDbTable* _tmp97_;
	FILE* _tmp98_;
	CheckRecord* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	FILE* _tmp102_;
	GdaDataDbField* _tmp103_ = NULL;
	CheckRecord* _tmp104_;
	GdaDataDbField* _tmp105_;
	gint i = 0;
	GValue* _tmp107_;
	GValue* _tmp108_;
	gint _tmp109_;
	FILE* _tmp114_;
	GdaDataDbField* _tmp115_ = NULL;
	CheckRecord* _tmp116_;
	GdaDataDbField* _tmp117_;
	gchar* vdb = NULL;
	GValue* _tmp119_;
	GValue* _tmp120_;
	gchar* _tmp121_;
	const gchar* _tmp122_;
	FILE* _tmp132_;
	FILE* _tmp156_;
	FILE* _tmp189_;
	FILE* _tmp207_;
	GdaDataTable* t2 = NULL;
	GdaDataTable* _tmp208_;
	GdaDataTable* _tmp209_;
	GdaDataTable* _tmp210_;
	GdaConnection* _tmp211_;
	CheckRecord* _tmp212_;
	GdaDataTable* _tmp213_;
	FILE* _tmp214_;
	CheckRecord* _tmp215_;
	GdaDataDbTable* _tmp216_;
	GdaDataDbTable* _tmp217_;
	const gchar* _tmp218_;
	const gchar* _tmp219_;
	gchar* _tmp220_;
	gchar* _tmp221_;
	gchar* _tmp222_;
	gchar* _tmp223_;
	FILE* _tmp242_;
	FILE* _tmp264_;
	CheckRecord* nr = NULL;
	CheckRecord* _tmp265_;
	CheckRecord* _tmp266_;
	CheckRecord* _tmp267_;
	gboolean _tmp269_ = FALSE;
	CheckRecord* _tmp270_;
	CheckRecord* _tmp271_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> NEW TEST: GdaData.DbRecord API tests\n");
	fails = 0;
	_tmp1_ = stdout;
	fprintf (_tmp1_, "Creating new record\n");
	_tmp2_ = check_record_new ();
	r = _tmp2_;
	_tmp3_ = stdout;
	fprintf (_tmp3_, "Setting connection\n");
	_tmp4_ = r;
	_tmp5_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp4_, _tmp5_);
	_tmp6_ = stdout;
	fprintf (_tmp6_, "Setting up DbTable\n");
	_tmp7_ = gda_data_table_new ();
	t = _tmp7_;
	_tmp8_ = stdout;
	fprintf (_tmp8_, "Setting DbTable name\n");
	_tmp9_ = t;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp9_, "user");
	_tmp10_ = stdout;
	fprintf (_tmp10_, "Setting DbTable connection\n");
	_tmp11_ = t;
	_tmp12_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp11_, _tmp12_);
	_tmp13_ = stdout;
	fprintf (_tmp13_, ">>> Setting table to record\n");
	_tmp14_ = r;
	_tmp15_ = t;
	gda_data_db_record_set_table ((GdaDataDbRecord*) _tmp14_, (GdaDataDbTable*) _tmp15_);
	_tmp16_ = stdout;
	fprintf (_tmp16_, ">>> Setting up Key 'id'\n");
	_tmp17_ = gda_data_field_new ("id", GDA_DATA_DB_FIELD_ATTRIBUTE_NONE);
	k = _tmp17_;
	_tmp18_ = stdout;
	fprintf (_tmp18_, "Setting record ID to 1...");
	{
		GdaDataField* _tmp19_;
		GValue* _tmp20_ = NULL;
		CheckRecord* _tmp21_;
		GdaDataField* _tmp22_;
		CheckRecord* _tmp50_;
		FILE* _tmp78_;
		_tmp19_ = k;
		_tmp20_ = g_new0 (GValue, 1);
		g_value_init (_tmp20_, G_TYPE_INT);
		g_value_set_int (_tmp20_, 1);
		gda_data_db_field_set_value ((GdaDataDbField*) _tmp19_, _tmp20_);
		__vala_GValue_free0 (_tmp20_);
		_tmp21_ = r;
		_tmp22_ = k;
		gda_data_db_record_set_key ((GdaDataDbRecord*) _tmp21_, (GdaDataDbField*) _tmp22_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		{
			GeeIterator* _kv_it = NULL;
			CheckRecord* _tmp23_;
			GeeCollection* _tmp24_;
			GeeCollection* _tmp25_;
			GeeCollection* _tmp26_;
			GeeIterator* _tmp27_;
			GeeIterator* _tmp28_;
			_tmp23_ = r;
			_tmp24_ = gda_data_db_record_get_keys ((GdaDataDbRecord*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = _tmp25_;
			_tmp27_ = gee_iterable_iterator ((GeeIterable*) _tmp26_);
			_tmp28_ = _tmp27_;
			_g_object_unref0 (_tmp26_);
			_kv_it = _tmp28_;
			while (TRUE) {
				GeeIterator* _tmp29_;
				GdaDataDbField* kv = NULL;
				GeeIterator* _tmp30_;
				gpointer _tmp31_;
				FILE* _tmp32_;
				GdaDataDbField* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				GdaDataDbField* _tmp40_;
				GValue* _tmp41_;
				GValue* _tmp42_;
				GValue _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				_tmp29_ = _kv_it;
				if (!gee_iterator_next (_tmp29_)) {
					break;
				}
				_tmp30_ = _kv_it;
				_tmp31_ = gee_iterator_get (_tmp30_);
				kv = (GdaDataDbField*) _tmp31_;
				_tmp32_ = stdout;
				_tmp33_ = kv;
				_tmp34_ = gda_data_db_field_get_name (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strconcat ("KEY: ", _tmp35_, NULL);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_strconcat (_tmp37_, " VALUE: ", NULL);
				_tmp39_ = _tmp38_;
				_tmp40_ = kv;
				_tmp41_ = gda_data_db_field_get_value (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = *_tmp42_;
				_tmp44_ = gda_value_stringify (&_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = g_strconcat (_tmp39_, _tmp45_, NULL);
				_tmp47_ = _tmp46_;
				_tmp48_ = g_strconcat (_tmp47_, "\n", NULL);
				_tmp49_ = _tmp48_;
				fprintf (_tmp32_, "%s", _tmp49_);
				_g_free0 (_tmp49_);
				_g_free0 (_tmp47_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp39_);
				_g_free0 (_tmp37_);
				_g_object_unref0 (kv);
			}
			_g_object_unref0 (_kv_it);
		}
		_tmp50_ = r;
		gda_data_db_object_update ((GdaDataDbObject*) _tmp50_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		{
			GeeIterator* _kv_it = NULL;
			CheckRecord* _tmp51_;
			GeeCollection* _tmp52_;
			GeeCollection* _tmp53_;
			GeeCollection* _tmp54_;
			GeeIterator* _tmp55_;
			GeeIterator* _tmp56_;
			_tmp51_ = r;
			_tmp52_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = _tmp53_;
			_tmp55_ = gee_iterable_iterator ((GeeIterable*) _tmp54_);
			_tmp56_ = _tmp55_;
			_g_object_unref0 (_tmp54_);
			_kv_it = _tmp56_;
			while (TRUE) {
				GeeIterator* _tmp57_;
				GdaDataDbField* kv = NULL;
				GeeIterator* _tmp58_;
				gpointer _tmp59_;
				FILE* _tmp60_;
				GdaDataDbField* _tmp61_;
				const gchar* _tmp62_;
				const gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				GdaDataDbField* _tmp68_;
				GValue* _tmp69_;
				GValue* _tmp70_;
				GValue _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				_tmp57_ = _kv_it;
				if (!gee_iterator_next (_tmp57_)) {
					break;
				}
				_tmp58_ = _kv_it;
				_tmp59_ = gee_iterator_get (_tmp58_);
				kv = (GdaDataDbField*) _tmp59_;
				_tmp60_ = stdout;
				_tmp61_ = kv;
				_tmp62_ = gda_data_db_field_get_name (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = g_strconcat ("FIELD: ", _tmp63_, NULL);
				_tmp65_ = _tmp64_;
				_tmp66_ = g_strconcat (_tmp65_, " VALUE: ", NULL);
				_tmp67_ = _tmp66_;
				_tmp68_ = kv;
				_tmp69_ = gda_data_db_field_get_value (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = *_tmp70_;
				_tmp72_ = gda_value_stringify (&_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = g_strconcat (_tmp67_, _tmp73_, NULL);
				_tmp75_ = _tmp74_;
				_tmp76_ = g_strconcat (_tmp75_, "\n", NULL);
				_tmp77_ = _tmp76_;
				fprintf (_tmp60_, "%s", _tmp77_);
				_g_free0 (_tmp77_);
				_g_free0 (_tmp75_);
				_g_free0 (_tmp73_);
				_g_free0 (_tmp67_);
				_g_free0 (_tmp65_);
				_g_object_unref0 (kv);
			}
			_g_object_unref0 (_kv_it);
		}
		_tmp78_ = stdout;
		fprintf (_tmp78_, "PASS\n");
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		gint _tmp79_;
		FILE* _tmp80_;
		gint _tmp81_;
		GError* _tmp82_;
		const gchar* _tmp83_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp79_ = fails;
		fails = _tmp79_ + 1;
		_tmp80_ = stdout;
		_tmp81_ = fails;
		_tmp82_ = e;
		_tmp83_ = _tmp82_->message;
		fprintf (_tmp80_, "FAIL: %i\nCouln't set ID...ERROR: %s\n", _tmp81_, _tmp83_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp84_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return _tmp84_;
	}
	_tmp85_ = stdout;
	_tmp86_ = r;
	_tmp87_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp86_);
	_tmp88_ = _tmp87_;
	_tmp89_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp88_);
	_tmp90_ = _tmp89_;
	_tmp91_ = g_strconcat ("DbRecord points to, in table ", _tmp90_, NULL);
	_tmp92_ = _tmp91_;
	_tmp93_ = g_strconcat (_tmp92_, ":\n", NULL);
	_tmp94_ = _tmp93_;
	_tmp95_ = r;
	_tmp96_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp95_);
	_tmp97_ = _tmp96_;
	fprintf (_tmp85_, _tmp94_, _tmp97_);
	_g_free0 (_tmp94_);
	_g_free0 (_tmp92_);
	_tmp98_ = stdout;
	_tmp99_ = r;
	_tmp100_ = gda_data_db_record_to_string ((GdaDataDbRecord*) _tmp99_);
	_tmp101_ = _tmp100_;
	fprintf (_tmp98_, "%s\n", _tmp101_);
	_g_free0 (_tmp101_);
	_tmp102_ = stdout;
	fprintf (_tmp102_, "Getting ID value...");
	_tmp104_ = r;
	_tmp105_ = gda_data_db_record_get_key ((GdaDataDbRecord*) _tmp104_, "id", &_inner_error_);
	_tmp103_ = _tmp105_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp106_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return _tmp106_;
	}
	_tmp107_ = gda_data_db_field_get_value (_tmp103_);
	_tmp108_ = _tmp107_;
	i = g_value_get_int (_tmp108_);
	_tmp109_ = i;
	if (_tmp109_ != 1) {
		gint _tmp110_;
		FILE* _tmp111_;
		gint _tmp112_;
		_tmp110_ = fails;
		fails = _tmp110_ + 1;
		_tmp111_ = stdout;
		_tmp112_ = fails;
		fprintf (_tmp111_, "FAIL: %i\n", _tmp112_);
	} else {
		FILE* _tmp113_;
		_tmp113_ = stdout;
		fprintf (_tmp113_, "PASS\n");
	}
	_tmp114_ = stdout;
	fprintf (_tmp114_, "Getting value at 'name'...");
	_tmp116_ = r;
	_tmp117_ = gda_data_db_record_get_field ((GdaDataDbRecord*) _tmp116_, "name", &_inner_error_);
	_tmp115_ = _tmp117_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp118_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp103_);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return _tmp118_;
	}
	_tmp119_ = gda_data_db_field_get_value (_tmp115_);
	_tmp120_ = _tmp119_;
	_tmp121_ = g_strdup (g_value_get_string (_tmp120_));
	vdb = _tmp121_;
	_tmp122_ = vdb;
	if (_tmp122_ == NULL) {
		gint _tmp123_;
		FILE* _tmp124_;
		gint _tmp125_;
		_tmp123_ = fails;
		fails = _tmp123_ + 1;
		_tmp124_ = stdout;
		_tmp125_ = fails;
		fprintf (_tmp124_, "FAIL: %i\n", _tmp125_);
	} else {
		const gchar* _tmp126_;
		_tmp126_ = vdb;
		if (g_strcmp0 (_tmp126_, "Daniel") != 0) {
			gint _tmp127_;
			FILE* _tmp128_;
			gint _tmp129_;
			const gchar* _tmp130_;
			_tmp127_ = fails;
			fails = _tmp127_ + 1;
			_tmp128_ = stdout;
			_tmp129_ = fails;
			_tmp130_ = vdb;
			fprintf (_tmp128_, "FAIL: %i\n" \
"ERROR: Value not match. Expected 'Daniel' but value is %s:\n", _tmp129_, _tmp130_);
		} else {
			FILE* _tmp131_;
			_tmp131_ = stdout;
			fprintf (_tmp131_, "PASS\n");
		}
	}
	_tmp132_ = stdout;
	fprintf (_tmp132_, "Setting value at 'name'...");
	{
		GdaDataDbField* f = NULL;
		CheckRecord* _tmp133_;
		GdaDataDbField* _tmp134_;
		GdaDataDbField* _tmp135_;
		GValue* _tmp136_ = NULL;
		CheckRecord* _tmp137_;
		GdaDataDbField* _tmp138_;
		FILE* _tmp139_;
		CheckRecord* _tmp140_;
		GdaDataDbTable* _tmp141_;
		GdaDataDbTable* _tmp142_;
		const gchar* _tmp143_;
		const gchar* _tmp144_;
		FILE* _tmp145_;
		CheckRecord* _tmp146_;
		gchar* _tmp147_;
		gchar* _tmp148_;
		FILE* _tmp149_;
		_tmp133_ = r;
		_tmp134_ = gda_data_db_record_get_field ((GdaDataDbRecord*) _tmp133_, "name", &_inner_error_);
		f = _tmp134_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp135_ = f;
		_tmp136_ = g_new0 (GValue, 1);
		g_value_init (_tmp136_, G_TYPE_STRING);
		g_value_set_string (_tmp136_, "Daniel Espinosa");
		gda_data_db_field_set_value (_tmp135_, _tmp136_);
		__vala_GValue_free0 (_tmp136_);
		_tmp137_ = r;
		_tmp138_ = f;
		gda_data_db_record_set_field ((GdaDataDbRecord*) _tmp137_, _tmp138_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (f);
			goto __catch2_g_error;
		}
		_tmp139_ = stdout;
		_tmp140_ = r;
		_tmp141_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp140_);
		_tmp142_ = _tmp141_;
		_tmp143_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp142_);
		_tmp144_ = _tmp143_;
		fprintf (_tmp139_, "DataObject points to in memory modified value, in table '%s':\n", _tmp144_);
		_tmp145_ = stdout;
		_tmp146_ = r;
		_tmp147_ = gda_data_db_record_to_string ((GdaDataDbRecord*) _tmp146_);
		_tmp148_ = _tmp147_;
		fprintf (_tmp145_, "%s\n", _tmp148_);
		_g_free0 (_tmp148_);
		_tmp149_ = stdout;
		fprintf (_tmp149_, "PASS\n");
		_g_object_unref0 (f);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		gint _tmp150_;
		FILE* _tmp151_;
		gint _tmp152_;
		GError* _tmp153_;
		const gchar* _tmp154_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp150_ = fails;
		fails = _tmp150_ + 1;
		_tmp151_ = stdout;
		_tmp152_ = fails;
		_tmp153_ = e;
		_tmp154_ = _tmp153_->message;
		fprintf (_tmp151_, "FAIL: %i\nCouln't modify record...ERROR: %s\n", _tmp152_, _tmp154_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp155_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_free0 (vdb);
		_g_object_unref0 (_tmp115_);
		_g_object_unref0 (_tmp103_);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return _tmp155_;
	}
	_tmp156_ = stdout;
	fprintf (_tmp156_, "Saving changes...");
	{
		CheckRecord* _tmp157_;
		FILE* _tmp158_;
		CheckRecord* _tmp159_;
		GdaDataDbTable* _tmp160_;
		GdaDataDbTable* _tmp161_;
		const gchar* _tmp162_;
		const gchar* _tmp163_;
		FILE* _tmp164_;
		CheckRecord* _tmp165_;
		gchar* _tmp166_;
		gchar* _tmp167_;
		FILE* _tmp168_;
		_tmp157_ = r;
		gda_data_db_object_save ((GdaDataDbObject*) _tmp157_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp158_ = stdout;
		_tmp159_ = r;
		_tmp160_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp159_);
		_tmp161_ = _tmp160_;
		_tmp162_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp161_);
		_tmp163_ = _tmp162_;
		fprintf (_tmp158_, "DataObject points to modified value, in table '%s':\n", _tmp163_);
		_tmp164_ = stdout;
		_tmp165_ = r;
		_tmp166_ = gda_data_db_record_to_string ((GdaDataDbRecord*) _tmp165_);
		_tmp167_ = _tmp166_;
		fprintf (_tmp164_, "%s\n", _tmp167_);
		_g_free0 (_tmp167_);
		_tmp168_ = stdout;
		fprintf (_tmp168_, "PASS\n");
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		gint _tmp169_;
		FILE* _tmp170_;
		gint _tmp171_;
		GError* _tmp172_;
		const gchar* _tmp173_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp169_ = fails;
		fails = _tmp169_ + 1;
		_tmp170_ = stdout;
		_tmp171_ = fails;
		_tmp172_ = e;
		_tmp173_ = _tmp172_->message;
		fprintf (_tmp170_, "FAIL: %i\nCouln't SAVE...ERROR: %s\n", _tmp171_, _tmp173_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp174_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_free0 (vdb);
		_g_object_unref0 (_tmp115_);
		_g_object_unref0 (_tmp103_);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return _tmp174_;
	}
	{
		FILE* _tmp175_;
		GdaConnection* _tmp176_;
		FILE* _tmp177_;
		_tmp175_ = stdout;
		fprintf (_tmp175_, "Simulating external database update...");
		_tmp176_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp176_, "UPDATE user SET name = \"Jhon Strauss\", city =\"New Jersey\"", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp177_ = stdout;
		fprintf (_tmp177_, "PASS\n");
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		gint _tmp178_;
		FILE* _tmp179_;
		gint _tmp180_;
		CheckRecord* _tmp181_;
		GdaDataDbTable* _tmp182_;
		GdaDataDbTable* _tmp183_;
		const gchar* _tmp184_;
		const gchar* _tmp185_;
		GError* _tmp186_;
		const gchar* _tmp187_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp178_ = fails;
		fails = _tmp178_ + 1;
		_tmp179_ = stdout;
		_tmp180_ = fails;
		_tmp181_ = r;
		_tmp182_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp181_);
		_tmp183_ = _tmp182_;
		_tmp184_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = e;
		_tmp187_ = _tmp186_->message;
		fprintf (_tmp179_, "FAIL: %i\nCouln't manual update table '%s'...ERROR: %s\n", _tmp180_, _tmp185_, _tmp187_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp188_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_free0 (vdb);
		_g_object_unref0 (_tmp115_);
		_g_object_unref0 (_tmp103_);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return _tmp188_;
	}
	_tmp189_ = stdout;
	fprintf (_tmp189_, "Updating values from database...");
	{
		CheckRecord* _tmp190_;
		FILE* _tmp191_;
		CheckRecord* _tmp192_;
		GdaDataDbTable* _tmp193_;
		GdaDataDbTable* _tmp194_;
		const gchar* _tmp195_;
		const gchar* _tmp196_;
		FILE* _tmp197_;
		CheckRecord* _tmp198_;
		gchar* _tmp199_;
		gchar* _tmp200_;
		_tmp190_ = r;
		gda_data_db_object_update ((GdaDataDbObject*) _tmp190_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_tmp191_ = stdout;
		_tmp192_ = r;
		_tmp193_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp192_);
		_tmp194_ = _tmp193_;
		_tmp195_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp194_);
		_tmp196_ = _tmp195_;
		fprintf (_tmp191_, "DataObject points to actual stored values, in table '%s':\n", _tmp196_);
		_tmp197_ = stdout;
		_tmp198_ = r;
		_tmp199_ = gda_data_db_record_to_string ((GdaDataDbRecord*) _tmp198_);
		_tmp200_ = _tmp199_;
		fprintf (_tmp197_, "%s\n", _tmp200_);
		_g_free0 (_tmp200_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		gint _tmp201_;
		FILE* _tmp202_;
		gint _tmp203_;
		GError* _tmp204_;
		const gchar* _tmp205_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp201_ = fails;
		fails = _tmp201_ + 1;
		_tmp202_ = stdout;
		_tmp203_ = fails;
		_tmp204_ = e;
		_tmp205_ = _tmp204_->message;
		fprintf (_tmp202_, "FAIL: %i\nCouln't UPDATE...ERROR: %s\n", _tmp203_, _tmp205_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp206_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_free0 (vdb);
		_g_object_unref0 (_tmp115_);
		_g_object_unref0 (_tmp103_);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return _tmp206_;
	}
	_tmp207_ = stdout;
	fprintf (_tmp207_, "Setting a new Table... \n");
	_tmp208_ = gda_data_table_new ();
	t2 = _tmp208_;
	_tmp209_ = t2;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp209_, "company");
	_tmp210_ = t2;
	_tmp211_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp210_, _tmp211_);
	_tmp212_ = r;
	_tmp213_ = t2;
	gda_data_db_record_set_table ((GdaDataDbRecord*) _tmp212_, (GdaDataDbTable*) _tmp213_);
	_tmp214_ = stdout;
	_tmp215_ = r;
	_tmp216_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp215_);
	_tmp217_ = _tmp216_;
	_tmp218_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp217_);
	_tmp219_ = _tmp218_;
	_tmp220_ = g_strconcat ("Updating values from database using a new table '", _tmp219_, NULL);
	_tmp221_ = _tmp220_;
	_tmp222_ = g_strconcat (_tmp221_, "'...", NULL);
	_tmp223_ = _tmp222_;
	fprintf (_tmp214_, "%s", _tmp223_);
	_g_free0 (_tmp223_);
	_g_free0 (_tmp221_);
	{
		CheckRecord* _tmp224_;
		FILE* _tmp225_;
		CheckRecord* _tmp226_;
		GdaDataDbTable* _tmp227_;
		GdaDataDbTable* _tmp228_;
		const gchar* _tmp229_;
		const gchar* _tmp230_;
		FILE* _tmp231_;
		CheckRecord* _tmp232_;
		gchar* _tmp233_;
		gchar* _tmp234_;
		FILE* _tmp235_;
		_tmp224_ = r;
		gda_data_db_object_update ((GdaDataDbObject*) _tmp224_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp225_ = stdout;
		_tmp226_ = r;
		_tmp227_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp226_);
		_tmp228_ = _tmp227_;
		_tmp229_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp228_);
		_tmp230_ = _tmp229_;
		fprintf (_tmp225_, "DataObject points to actual stored values, in table '%s':\n", _tmp230_);
		_tmp231_ = stdout;
		_tmp232_ = r;
		_tmp233_ = gda_data_db_record_to_string ((GdaDataDbRecord*) _tmp232_);
		_tmp234_ = _tmp233_;
		fprintf (_tmp231_, "%s\n", _tmp234_);
		_g_free0 (_tmp234_);
		_tmp235_ = stdout;
		fprintf (_tmp235_, "PASS\n");
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		gint _tmp236_;
		FILE* _tmp237_;
		gint _tmp238_;
		GError* _tmp239_;
		const gchar* _tmp240_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp236_ = fails;
		fails = _tmp236_ + 1;
		_tmp237_ = stdout;
		_tmp238_ = fails;
		_tmp239_ = e;
		_tmp240_ = _tmp239_->message;
		fprintf (_tmp237_, "FAIL: %i\nCouln't UPDATE...ERROR: %s\n", _tmp238_, _tmp240_);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp241_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t2);
		_g_free0 (vdb);
		_g_object_unref0 (_tmp115_);
		_g_object_unref0 (_tmp103_);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return _tmp241_;
	}
	_tmp242_ = stdout;
	fprintf (_tmp242_, "Setting ID to 2...");
	{
		GdaDataField* _tmp243_;
		GValue* _tmp244_ = NULL;
		CheckRecord* _tmp245_;
		GdaDataField* _tmp246_;
		FILE* _tmp247_;
		CheckRecord* _tmp248_;
		GdaDataDbTable* _tmp249_;
		GdaDataDbTable* _tmp250_;
		const gchar* _tmp251_;
		const gchar* _tmp252_;
		FILE* _tmp253_;
		CheckRecord* _tmp254_;
		gchar* _tmp255_;
		gchar* _tmp256_;
		FILE* _tmp257_;
		_tmp243_ = k;
		_tmp244_ = g_new0 (GValue, 1);
		g_value_init (_tmp244_, G_TYPE_INT);
		g_value_set_int (_tmp244_, 2);
		gda_data_db_field_set_value ((GdaDataDbField*) _tmp243_, _tmp244_);
		__vala_GValue_free0 (_tmp244_);
		_tmp245_ = r;
		_tmp246_ = k;
		gda_data_db_record_set_key ((GdaDataDbRecord*) _tmp245_, (GdaDataDbField*) _tmp246_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		_tmp247_ = stdout;
		_tmp248_ = r;
		_tmp249_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp248_);
		_tmp250_ = _tmp249_;
		_tmp251_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp250_);
		_tmp252_ = _tmp251_;
		fprintf (_tmp247_, "DataObject points to actual stored values, in table '%s':\n", _tmp252_);
		_tmp253_ = stdout;
		_tmp254_ = r;
		_tmp255_ = gda_data_db_record_to_string ((GdaDataDbRecord*) _tmp254_);
		_tmp256_ = _tmp255_;
		fprintf (_tmp253_, "%s\n", _tmp256_);
		_g_free0 (_tmp256_);
		_tmp257_ = stdout;
		fprintf (_tmp257_, "PASS\n");
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		gint _tmp258_;
		FILE* _tmp259_;
		gint _tmp260_;
		GError* _tmp261_;
		const gchar* _tmp262_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp258_ = fails;
		fails = _tmp258_ + 1;
		_tmp259_ = stdout;
		_tmp260_ = fails;
		_tmp261_ = e;
		_tmp262_ = _tmp261_->message;
		fprintf (_tmp259_, "FAIL: %i\nCouln't set ID...ERROR: %s\n", _tmp260_, _tmp262_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp263_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t2);
		_g_free0 (vdb);
		_g_object_unref0 (_tmp115_);
		_g_object_unref0 (_tmp103_);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return _tmp263_;
	}
	_tmp264_ = stdout;
	fprintf (_tmp264_, "Coping Record ...");
	_tmp265_ = check_record_new ();
	nr = _tmp265_;
	_tmp266_ = nr;
	_tmp267_ = r;
	gda_data_db_record_copy ((GdaDataDbRecord*) _tmp266_, (GdaDataDbRecord*) _tmp267_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp268_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (nr);
		_g_object_unref0 (t2);
		_g_free0 (vdb);
		_g_object_unref0 (_tmp115_);
		_g_object_unref0 (_tmp103_);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return _tmp268_;
	}
	_tmp270_ = nr;
	_tmp271_ = r;
	_tmp269_ = gda_data_db_record_equal ((GdaDataDbRecord*) _tmp270_, (GdaDataDbRecord*) _tmp271_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp272_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (nr);
		_g_object_unref0 (t2);
		_g_free0 (vdb);
		_g_object_unref0 (_tmp115_);
		_g_object_unref0 (_tmp103_);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return _tmp272_;
	}
	if (!_tmp269_) {
		gint _tmp273_;
		FILE* _tmp274_;
		gint _tmp275_;
		FILE* _tmp276_;
		FILE* _tmp290_;
		_tmp273_ = fails;
		fails = _tmp273_ + 1;
		_tmp274_ = stdout;
		_tmp275_ = fails;
		fprintf (_tmp274_, "FAIL: %i\n No copy or equal works correctly\n", _tmp275_);
		_tmp276_ = stdout;
		fprintf (_tmp276_, "DUMP (from):\n");
		{
			GeeIterator* _f_it = NULL;
			CheckRecord* _tmp277_;
			GeeCollection* _tmp278_;
			GeeCollection* _tmp279_;
			GeeCollection* _tmp280_;
			GeeIterator* _tmp281_;
			GeeIterator* _tmp282_;
			_tmp277_ = r;
			_tmp278_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) _tmp277_);
			_tmp279_ = _tmp278_;
			_tmp280_ = _tmp279_;
			_tmp281_ = gee_iterable_iterator ((GeeIterable*) _tmp280_);
			_tmp282_ = _tmp281_;
			_g_object_unref0 (_tmp280_);
			_f_it = _tmp282_;
			while (TRUE) {
				GeeIterator* _tmp283_;
				GdaDataDbField* f = NULL;
				GeeIterator* _tmp284_;
				gpointer _tmp285_;
				FILE* _tmp286_;
				GdaDataDbField* _tmp287_;
				gchar* _tmp288_;
				gchar* _tmp289_;
				_tmp283_ = _f_it;
				if (!gee_iterator_next (_tmp283_)) {
					break;
				}
				_tmp284_ = _f_it;
				_tmp285_ = gee_iterator_get (_tmp284_);
				f = (GdaDataDbField*) _tmp285_;
				_tmp286_ = stdout;
				_tmp287_ = f;
				_tmp288_ = gda_data_db_field_to_string (_tmp287_);
				_tmp289_ = _tmp288_;
				fprintf (_tmp286_, "%s\n", _tmp289_);
				_g_free0 (_tmp289_);
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_it);
		}
		_tmp290_ = stdout;
		fprintf (_tmp290_, "DUMP (to):\n");
		{
			GeeIterator* _f2_it = NULL;
			CheckRecord* _tmp291_;
			GeeCollection* _tmp292_;
			GeeCollection* _tmp293_;
			GeeCollection* _tmp294_;
			GeeIterator* _tmp295_;
			GeeIterator* _tmp296_;
			_tmp291_ = nr;
			_tmp292_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) _tmp291_);
			_tmp293_ = _tmp292_;
			_tmp294_ = _tmp293_;
			_tmp295_ = gee_iterable_iterator ((GeeIterable*) _tmp294_);
			_tmp296_ = _tmp295_;
			_g_object_unref0 (_tmp294_);
			_f2_it = _tmp296_;
			while (TRUE) {
				GeeIterator* _tmp297_;
				GdaDataDbField* f2 = NULL;
				GeeIterator* _tmp298_;
				gpointer _tmp299_;
				FILE* _tmp300_;
				GdaDataDbField* _tmp301_;
				gchar* _tmp302_;
				gchar* _tmp303_;
				_tmp297_ = _f2_it;
				if (!gee_iterator_next (_tmp297_)) {
					break;
				}
				_tmp298_ = _f2_it;
				_tmp299_ = gee_iterator_get (_tmp298_);
				f2 = (GdaDataDbField*) _tmp299_;
				_tmp300_ = stdout;
				_tmp301_ = f2;
				_tmp302_ = gda_data_db_field_to_string (_tmp301_);
				_tmp303_ = _tmp302_;
				fprintf (_tmp300_, "%s\n", _tmp303_);
				_g_free0 (_tmp303_);
				_g_object_unref0 (f2);
			}
			_g_object_unref0 (_f2_it);
		}
	} else {
		FILE* _tmp304_;
		_tmp304_ = stdout;
		fprintf (_tmp304_, "PASS\n");
	}
	result = fails;
	_g_object_unref0 (nr);
	_g_object_unref0 (t2);
	_g_free0 (vdb);
	_g_object_unref0 (_tmp115_);
	_g_object_unref0 (_tmp103_);
	_g_object_unref0 (k);
	_g_object_unref0 (t);
	_g_object_unref0 (r);
	return result;
}


static GValue*
_g_value_dup (GValue* self)
{
	return g_boxed_copy (G_TYPE_VALUE, self);
}


gint
check_tests_t2 (CheckTests* self,
                GError** error)
{
	gint result = 0;
	FILE* _tmp0_;
	gint fails = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> NEW TEST: Gda.DbRecord - Adding/Deleting objects to DB...\n");
	fails = 0;
	{
		CheckRecord* n = NULL;
		CheckRecord* _tmp1_;
		CheckRecord* _tmp2_;
		GdaConnection* _tmp3_;
		GdaDataTable* t = NULL;
		GdaDataTable* _tmp4_;
		GdaDataTable* _tmp5_;
		GdaDataTable* _tmp6_;
		GdaConnection* _tmp7_;
		CheckRecord* _tmp8_;
		GdaDataTable* _tmp9_;
		GeeHashMap* f = NULL;
		GeeHashMap* _tmp10_;
		GeeHashMap* _tmp11_;
		GValue* _tmp12_ = NULL;
		GeeHashMap* _tmp13_;
		GValue* _tmp14_ = NULL;
		GeeHashMap* _tmp15_;
		GValue* _tmp16_ = NULL;
		FILE* _tmp32_;
		CheckRecord* _tmp33_;
		GdaDataDbTable* _tmp34_;
		GdaDataDbTable* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		FILE* _tmp38_;
		CheckRecord* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		CheckRecord* _tmp42_;
		GdaDataModel* m = NULL;
		CheckRecord* _tmp43_;
		GdaConnection* _tmp44_;
		GdaConnection* _tmp45_;
		GdaDataModel* _tmp46_;
		FILE* _tmp47_;
		GdaDataModel* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		GdaDataModel* _tmp55_;
		CheckRecord* r = NULL;
		CheckRecord* _tmp59_;
		CheckRecord* _tmp60_;
		GdaConnection* _tmp61_;
		CheckRecord* _tmp62_;
		GdaDataTable* _tmp63_;
		CheckRecord* _tmp64_;
		GValue* _tmp65_ = NULL;
		CheckRecord* _tmp66_;
		GdaDataModel* m2 = NULL;
		CheckRecord* _tmp67_;
		GdaConnection* _tmp68_;
		GdaConnection* _tmp69_;
		GdaDataModel* _tmp70_;
		FILE* _tmp71_;
		GdaDataModel* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		GdaDataModel* _tmp79_;
		_tmp1_ = check_record_new ();
		n = _tmp1_;
		_tmp2_ = n;
		_tmp3_ = self->priv->_connection;
		gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp2_, _tmp3_);
		_tmp4_ = gda_data_table_new ();
		t = _tmp4_;
		_tmp5_ = t;
		gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp5_, "user");
		_tmp6_ = t;
		_tmp7_ = self->priv->_connection;
		gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp6_, _tmp7_);
		_tmp8_ = n;
		_tmp9_ = t;
		gda_data_db_record_set_table ((GdaDataDbRecord*) _tmp8_, (GdaDataDbTable*) _tmp9_);
		_tmp10_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_VALUE, (GBoxedCopyFunc) _g_value_dup, (GDestroyNotify) _vala_GValue_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		f = _tmp10_;
		_tmp11_ = f;
		_tmp12_ = g_new0 (GValue, 1);
		g_value_init (_tmp12_, G_TYPE_INT);
		g_value_set_int (_tmp12_, 3);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, "id", _tmp12_);
		__vala_GValue_free0 (_tmp12_);
		_tmp13_ = f;
		_tmp14_ = g_new0 (GValue, 1);
		g_value_init (_tmp14_, G_TYPE_STRING);
		g_value_set_string (_tmp14_, "GdaDataNewName");
		gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, "name", _tmp14_);
		__vala_GValue_free0 (_tmp14_);
		_tmp15_ = f;
		_tmp16_ = g_new0 (GValue, 1);
		g_value_init (_tmp16_, G_TYPE_STRING);
		g_value_set_string (_tmp16_, "GdaDataNewCity");
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "city", _tmp16_);
		__vala_GValue_free0 (_tmp16_);
		{
			GeeIterator* _k_it = NULL;
			GeeHashMap* _tmp17_;
			GeeSet* _tmp18_;
			GeeSet* _tmp19_;
			GeeSet* _tmp20_;
			GeeIterator* _tmp21_;
			GeeIterator* _tmp22_;
			_tmp17_ = f;
			_tmp18_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = _tmp19_;
			_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
			_tmp22_ = _tmp21_;
			_g_object_unref0 (_tmp20_);
			_k_it = _tmp22_;
			while (TRUE) {
				GeeIterator* _tmp23_;
				gchar* k = NULL;
				GeeIterator* _tmp24_;
				gpointer _tmp25_;
				CheckRecord* _tmp26_;
				const gchar* _tmp27_;
				GeeHashMap* _tmp28_;
				const gchar* _tmp29_;
				gpointer _tmp30_;
				GValue* _tmp31_;
				_tmp23_ = _k_it;
				if (!gee_iterator_next (_tmp23_)) {
					break;
				}
				_tmp24_ = _k_it;
				_tmp25_ = gee_iterator_get (_tmp24_);
				k = (gchar*) _tmp25_;
				_tmp26_ = n;
				_tmp27_ = k;
				_tmp28_ = f;
				_tmp29_ = k;
				_tmp30_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp28_, _tmp29_);
				_tmp31_ = (GValue*) _tmp30_;
				gda_data_db_record_set_field_value ((GdaDataDbRecord*) _tmp26_, _tmp27_, _tmp31_, &_inner_error_);
				__vala_GValue_free0 (_tmp31_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (k);
					_g_object_unref0 (_k_it);
					_g_object_unref0 (f);
					_g_object_unref0 (t);
					_g_object_unref0 (n);
					goto __catch8_g_error;
				}
				_g_free0 (k);
			}
			_g_object_unref0 (_k_it);
		}
		_tmp32_ = stdout;
		_tmp33_ = n;
		_tmp34_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp35_);
		_tmp37_ = _tmp36_;
		fprintf (_tmp32_, "DbRecord in memory values, to added to table '%s':\n", _tmp37_);
		_tmp38_ = stdout;
		_tmp39_ = n;
		_tmp40_ = gda_data_db_record_to_string ((GdaDataDbRecord*) _tmp39_);
		_tmp41_ = _tmp40_;
		fprintf (_tmp38_, "%s\n", _tmp41_);
		_g_free0 (_tmp41_);
		_tmp42_ = n;
		gda_data_db_object_append ((GdaDataDbObject*) _tmp42_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (f);
			_g_object_unref0 (t);
			_g_object_unref0 (n);
			goto __catch8_g_error;
		}
		_tmp43_ = n;
		_tmp44_ = gda_data_db_object_get_connection ((GdaDataDbObject*) _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = gda_connection_execute_select_command (_tmp45_, "SELECT * FROM user", &_inner_error_);
		m = _tmp46_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (f);
			_g_object_unref0 (t);
			_g_object_unref0 (n);
			goto __catch8_g_error;
		}
		_tmp47_ = stdout;
		_tmp48_ = m;
		_tmp49_ = gda_data_model_dump_as_string (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strconcat ("All records:\n", _tmp50_, NULL);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strconcat (_tmp52_, "\n", NULL);
		_tmp54_ = _tmp53_;
		fprintf (_tmp47_, "%s", _tmp54_);
		_g_free0 (_tmp54_);
		_g_free0 (_tmp52_);
		_g_free0 (_tmp50_);
		_tmp55_ = m;
		if (gda_data_model_get_n_rows (_tmp55_) != 3) {
			gint _tmp56_;
			FILE* _tmp57_;
			_tmp56_ = fails;
			fails = _tmp56_ + 1;
			_tmp57_ = stdout;
			fprintf (_tmp57_, "FAIL\n");
		} else {
			FILE* _tmp58_;
			_tmp58_ = stdout;
			fprintf (_tmp58_, "PASS\n");
		}
		_tmp59_ = check_record_new ();
		r = _tmp59_;
		_tmp60_ = r;
		_tmp61_ = self->priv->_connection;
		gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp60_, _tmp61_);
		_tmp62_ = r;
		_tmp63_ = t;
		gda_data_db_record_set_table ((GdaDataDbRecord*) _tmp62_, (GdaDataDbTable*) _tmp63_);
		_tmp64_ = r;
		_tmp65_ = g_new0 (GValue, 1);
		g_value_init (_tmp65_, G_TYPE_INT);
		g_value_set_int (_tmp65_, 3);
		gda_data_db_record_set_key_value ((GdaDataDbRecord*) _tmp64_, "id", _tmp65_, &_inner_error_);
		__vala_GValue_free0 (_tmp65_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (r);
			_g_object_unref0 (m);
			_g_object_unref0 (f);
			_g_object_unref0 (t);
			_g_object_unref0 (n);
			goto __catch8_g_error;
		}
		_tmp66_ = r;
		gda_data_db_object_drop ((GdaDataDbObject*) _tmp66_, FALSE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (r);
			_g_object_unref0 (m);
			_g_object_unref0 (f);
			_g_object_unref0 (t);
			_g_object_unref0 (n);
			goto __catch8_g_error;
		}
		_tmp67_ = n;
		_tmp68_ = gda_data_db_object_get_connection ((GdaDataDbObject*) _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = gda_connection_execute_select_command (_tmp69_, "SELECT * FROM user", &_inner_error_);
		m2 = _tmp70_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (r);
			_g_object_unref0 (m);
			_g_object_unref0 (f);
			_g_object_unref0 (t);
			_g_object_unref0 (n);
			goto __catch8_g_error;
		}
		_tmp71_ = stdout;
		_tmp72_ = m2;
		_tmp73_ = gda_data_model_dump_as_string (_tmp72_);
		_tmp74_ = _tmp73_;
		_tmp75_ = g_strconcat ("All records:\n", _tmp74_, NULL);
		_tmp76_ = _tmp75_;
		_tmp77_ = g_strconcat (_tmp76_, "\n", NULL);
		_tmp78_ = _tmp77_;
		fprintf (_tmp71_, "%s", _tmp78_);
		_g_free0 (_tmp78_);
		_g_free0 (_tmp76_);
		_g_free0 (_tmp74_);
		_tmp79_ = m2;
		if (gda_data_model_get_n_rows (_tmp79_) != 2) {
			gint _tmp80_;
			FILE* _tmp81_;
			_tmp80_ = fails;
			fails = _tmp80_ + 1;
			_tmp81_ = stdout;
			fprintf (_tmp81_, "FAIL\n");
		} else {
			FILE* _tmp82_;
			_tmp82_ = stdout;
			fprintf (_tmp82_, "PASS\n");
		}
		_g_object_unref0 (m2);
		_g_object_unref0 (r);
		_g_object_unref0 (m);
		_g_object_unref0 (f);
		_g_object_unref0 (t);
		_g_object_unref0 (n);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		gint _tmp83_;
		FILE* _tmp84_;
		gint _tmp85_;
		GError* _tmp86_;
		const gchar* _tmp87_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp83_ = fails;
		fails = _tmp83_ + 1;
		_tmp84_ = stdout;
		_tmp85_ = fails;
		_tmp86_ = e;
		_tmp87_ = _tmp86_->message;
		fprintf (_tmp84_, "FAIL: %i\nCouln't set add new record...-ERROR: %s\n", _tmp85_, _tmp87_);
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp88_ = -1;
		g_propagate_error (error, _inner_error_);
		return _tmp88_;
	}
	result = fails;
	return result;
}


gint
check_tests_main (gchar** args,
                  int args_length1)
{
	gint result = 0;
	FILE* _tmp0_;
	gint failures = 0;
	CheckTests* app = NULL;
	CheckTests* _tmp1_;
	gint _tmp14_ = 0;
	gint _tmp15_;
	GError * _inner_error_ = NULL;
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Checking GdaData.DbRecord implementation...\n");
	failures = 0;
	_tmp1_ = check_tests_new ();
	app = _tmp1_;
	{
		gint _tmp2_ = 0;
		CheckTests* _tmp3_;
		gint _tmp4_;
		gint _tmp5_ = 0;
		CheckTests* _tmp6_;
		gint _tmp7_;
		_tmp3_ = app;
		_tmp2_ = check_tests_t1 (_tmp3_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
		_tmp4_ = failures;
		failures = _tmp4_ + _tmp2_;
		_tmp6_ = app;
		_tmp5_ = check_tests_t2 (_tmp6_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
		_tmp7_ = failures;
		failures = _tmp7_ + _tmp5_;
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		FILE* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = stdout;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		_tmp11_ = g_strconcat ("ERROR: ", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		fprintf (_tmp8_, "%s", _tmp12_);
		_g_free0 (_tmp12_);
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp13_ = -1;
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp13_;
	}
	_tmp15_ = failures;
	if (_tmp15_ != 0) {
		_tmp14_ = 1;
	} else {
		_tmp14_ = 0;
	}
	result = _tmp14_;
	_g_object_unref0 (app);
	return result;
}


int
main (int argc,
      char ** argv)
{
	return check_tests_main (argv, argc);
}


GdaConnection*
check_tests_get_connection (CheckTests* self)
{
	GdaConnection* result;
	GdaConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
check_tests_set_connection (CheckTests* self,
                            GdaConnection* value)
{
	g_return_if_fail (self != NULL);
	if (check_tests_get_connection (self) != value) {
		GdaConnection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_connection);
		self->priv->_connection = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, check_tests_properties[CHECK_TESTS_CONNECTION_PROPERTY]);
	}
}


static void
check_tests_class_init (CheckTestsClass * klass)
{
	check_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheckTestsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_check_tests_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_check_tests_set_property;
	G_OBJECT_CLASS (klass)->finalize = check_tests_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHECK_TESTS_CONNECTION_PROPERTY, check_tests_properties[CHECK_TESTS_CONNECTION_PROPERTY] = g_param_spec_object ("connection", "connection", "connection", gda_connection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
check_tests_instance_init (CheckTests * self)
{
	self->priv = CHECK_TESTS_GET_PRIVATE (self);
}


static void
check_tests_finalize (GObject * obj)
{
	CheckTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHECK_TYPE_TESTS, CheckTests);
	_g_object_unref0 (self->priv->_connection);
	G_OBJECT_CLASS (check_tests_parent_class)->finalize (obj);
}


GType
check_tests_get_type (void)
{
	static volatile gsize check_tests_type_id__volatile = 0;
	if (g_once_init_enter (&check_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) check_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckTests), 0, (GInstanceInitFunc) check_tests_instance_init, NULL };
		GType check_tests_type_id;
		check_tests_type_id = g_type_register_static (G_TYPE_OBJECT, "CheckTests", &g_define_type_info, 0);
		g_once_init_leave (&check_tests_type_id__volatile, check_tests_type_id);
	}
	return check_tests_type_id__volatile;
}


static void
_vala_check_tests_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	CheckTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CHECK_TYPE_TESTS, CheckTests);
	switch (property_id) {
		case CHECK_TESTS_CONNECTION_PROPERTY:
		g_value_set_object (value, check_tests_get_connection (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_check_tests_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	CheckTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CHECK_TYPE_TESTS, CheckTests);
	switch (property_id) {
		case CHECK_TESTS_CONNECTION_PROPERTY:
		check_tests_set_connection (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



