
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <libgdamm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "client.h"
#include "command.h"
#include "connection.h"
#include "datamodel.h"
#include "datasourceinfo.h"
#include "error.h"
#include "serverprovider.h"
#include "parameter.h"
#include "parameterlist.h"
#include "providerinfo.h"
#include "row.h"
#include "transaction.h"
#include "value.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType gda_client_get_type(void);
GType gda_connection_get_type(void);
GType gda_data_model_get_type(void);
GType gda_error_get_type(void);
GType gda_server_provider_get_type(void);
GType gda_transaction_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gnome { namespace Gda {  class Client_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Connection_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataModel_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Error_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class ServerProvider_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Transaction_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }

namespace Gnome { namespace Gda { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(gda_client_get_type(), &Gnome::Gda::Client_Class::wrap_new);
  Glib::wrap_register(gda_connection_get_type(), &Gnome::Gda::Connection_Class::wrap_new);
  Glib::wrap_register(gda_data_model_get_type(), &Gnome::Gda::DataModel_Class::wrap_new);
  Glib::wrap_register(gda_error_get_type(), &Gnome::Gda::Error_Class::wrap_new);
  Glib::wrap_register(gda_server_provider_get_type(), &Gnome::Gda::ServerProvider_Class::wrap_new);
  Glib::wrap_register(gda_transaction_get_type(), &Gnome::Gda::Transaction_Class::wrap_new);

  // Register the gtkmm gtypes:
  Gnome::Gda::Client::get_type();
  Gnome::Gda::Connection::get_type();
  Gnome::Gda::DataModel::get_type();
  Gnome::Gda::Error::get_type();
  Gnome::Gda::ServerProvider::get_type();
  Gnome::Gda::Transaction::get_type();

} // wrap_init()

} //Gda
} //Gnome


