// Generated by gtkmmproc -- DO NOT MODIFY!


#include <libgdamm/parameter.h>
#include <libgdamm/private/parameter_p.h>

/* $Id: parameter.ccg,v 1.8 2006/11/08 00:07:38 murrayc Exp $ */
// -*- C++ -*- //

/* parameter.cc
 * 
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/datamodel.h>
#include <libgda/gda-parameter.h>
#include <libgda/gda-parameter-util.h>
#include <libgda/gda-enum-types.h>

//Make life easier for the generated code:
typedef Gnome::Gda::Parameter::ListHandleEntityField ListHandleEntityField;

namespace Gnome
{

namespace Gda
{

/* TODO:
Parameter::Parameter(const Glib::ustring& name, const Value& value)
{
  gobject_ = gda_parameter_new_from_value(name.c_str(), value.gobj());
}
*/

Parameter::Parameter(const Glib::ustring& name, bool value)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Object(Glib::ConstructParams(parameter_class_.init(), "g_type",G_TYPE_BOOLEAN, static_cast<char*>(0)))
{
  //Reimplemented from gda_parameter_new_string():
  set_name(name);
  set_value(value ? "true" : "false");
}

Parameter::Parameter(const Glib::ustring& name, const Glib::ustring& value)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Object(Glib::ConstructParams(parameter_class_.init(), "g_type",G_TYPE_STRING, static_cast<char*>(0)))
{
  //Reimplemented from gda_parameter_new_boolean():
  set_name(name);
  set_value(value);
}

Parameter::Parameter(const Glib::ustring& name, const char* value)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Object(Glib::ConstructParams(parameter_class_.init(), "g_type",G_TYPE_STRING, static_cast<char*>(0)))
{
  set_name(name);
  set_value(Glib::ustring(value));
}

Value Parameter::get_value() const
{
  return Value(gda_parameter_get_value(const_cast<GdaParameter*>(gobj())));
}

Value Parameter::get_default_value() const
{
  return Value(gda_parameter_get_default_value(const_cast<GdaParameter*>(gobj())));
}

bool Parameter::has_restrict_values() const
{
  return gda_parameter_has_restrict_values(const_cast<GdaParameter*>(gobj()), 0, 0);
}

bool Parameter::has_restrict_values(Glib::RefPtr<DataModel>& model, int& col) const
{
  GdaDataModel* gda_model = 0;
  return gda_parameter_has_restrict_values(const_cast<GdaParameter*>(gobj()), &gda_model, &col);
  if(gda_model)
    model = Glib::wrap(gda_model, true); //No ref is provided, so we ref this.
}

Glib::ustring Parameter::get_value_str() const
{
  const gchar* value = gda_parameter_get_value_str(const_cast<GdaParameter*>(gobj()));
  if (value)
    return Glib::ustring(value);
  else
    return Glib::ustring();
}

void Parameter::set_entry_plugin(const Glib::ustring& entry)
{
  g_object_set(gobj(), "entry-plugin", entry.c_str(), NULL);
}

} //namespace Gda

} // namespace Gnome


namespace
{


static const Glib::SignalProxyInfo Parameter_signal_restrict_changed_info =
{
  "restrict-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


Gnome::Gda::ParameterError::ParameterError(Gnome::Gda::ParameterError::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (GDA_PARAMETER_ERROR, error_code, error_message)
{}

Gnome::Gda::ParameterError::ParameterError(GError* gobject)
:
  Glib::Error (gobject)
{}

Gnome::Gda::ParameterError::Code Gnome::Gda::ParameterError::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Gnome::Gda::ParameterError::throw_func(GError* gobject)
{
  throw Gnome::Gda::ParameterError(gobject);
}
#else
//When not using exceptions, we just pass the Exception object around without throwing it:
std::auto_ptr<Glib::Error> Gnome::Gda::ParameterError::throw_func(GError* gobject)
{
  return std::auto_ptr<Glib::Error>(new Gnome::Gda::ParameterError(gobject));
}
#endif //GLIBMM_EXCEPTIONS_ENABLED

// static
GType Glib::Value<Gnome::Gda::ParameterError::Code>::value_type()
{
  return gda_parameter_error_get_type();
}


namespace Glib
{

Glib::RefPtr<Gnome::Gda::Parameter> wrap(GdaParameter* object, bool take_copy)
{
  return Glib::RefPtr<Gnome::Gda::Parameter>( dynamic_cast<Gnome::Gda::Parameter*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gnome
{

namespace Gda
{


/* The *_Class implementation: */

const Glib::Class& Parameter_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Parameter_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gda_parameter_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Referer::add_interface(get_type());

  }

  return *this;
}

void Parameter_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->restrict_changed = &restrict_changed_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Parameter_Class::restrict_changed_callback(GdaParameter* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_restrict_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->restrict_changed)
    (*base->restrict_changed)(self);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Parameter_Class::wrap_new(GObject* object)
{
  return new Parameter((GdaParameter*)object);
}


/* The implementation: */

GdaParameter* Parameter::gobj_copy()
{
  reference();
  return gobj();
}

Parameter::Parameter(const Glib::ConstructParams& construct_params)
:
  Object(construct_params)
{

}

Parameter::Parameter(GdaParameter* castitem)
:
  Object((GdaObject*)(castitem))
{}

Parameter::~Parameter()
{}


Parameter::CppClassType Parameter::parameter_class_; // initialize static member

GType Parameter::get_type()
{
  return parameter_class_.init().get_type();
}

GType Parameter::get_base_type()
{
  return gda_parameter_get_type();
}


Parameter::Parameter()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Object(Glib::ConstructParams(parameter_class_.init()))
{
  

}

Glib::RefPtr<Parameter> Parameter::create()
{
  return Glib::RefPtr<Parameter>( new Parameter() );
}
Glib::RefPtr<Parameter> Parameter::create(const Glib::ustring& name, bool value)
{
  return Glib::RefPtr<Parameter>( new Parameter(name, value) );
}
Glib::RefPtr<Parameter> Parameter::create(const Glib::ustring& name, const Glib::ustring& value)
{
  return Glib::RefPtr<Parameter>( new Parameter(name, value) );
}
Glib::RefPtr<Parameter> Parameter::create(const Glib::ustring& name, const gchar* value)
{
  return Glib::RefPtr<Parameter>( new Parameter(name, value) );
}
Glib::RefPtr<Parameter> Parameter::copy() const
{
  return Glib::wrap(gda_parameter_new_copy(const_cast<GdaParameter*>(gobj())));
}

Glib::ustring Parameter::get_alphanum_name() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gda_parameter_get_alphanum_name(const_cast<GdaParameter*>(gobj())));
}

GType Parameter::get_g_type() const
{
  return gda_parameter_get_g_type(const_cast<GdaParameter*>(gobj()));
}

void Parameter::set_value(const Value& value)
{
gda_parameter_set_value(gobj(), (value).gobj()); 
}

bool Parameter::set_value(const Glib::ustring& value)
{
  return gda_parameter_set_value_str(gobj(), value.c_str());
}

void Parameter::declare_invalid()
{
gda_parameter_declare_invalid(gobj()); 
}

bool Parameter::is_valid() const
{
  return gda_parameter_is_valid(const_cast<GdaParameter*>(gobj()));
}

void Parameter::set_default_value(const Value& value)
{
gda_parameter_set_default_value(gobj(), (value).gobj()); 
}

bool Parameter::get_exists_default_value()
{
  return gda_parameter_get_exists_default_value(gobj());
}

void Parameter::set_exists_default_value(bool default_value_exists)
{
gda_parameter_set_exists_default_value(gobj(), static_cast<int>(default_value_exists)); 
}

void Parameter::set_not_null(bool not_null)
{
gda_parameter_set_not_null(gobj(), static_cast<int>(not_null)); 
}

bool Parameter::get_not_null() const
{
  return gda_parameter_get_not_null(const_cast<GdaParameter*>(gobj()));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Parameter::restrict_values(const Glib::RefPtr<DataModel>& model, int col)
#else
bool Parameter::restrict_values(const Glib::RefPtr<DataModel>& model, int col, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_parameter_restrict_values(gobj(), Glib::unwrap(model), col, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

void Parameter::bind_to_param(const Glib::RefPtr<Parameter>& bind_to)
{
gda_parameter_bind_to_param(gobj(), Glib::unwrap(bind_to)); 
}

Glib::RefPtr<Parameter> Parameter::get_bind_param()
{

  Glib::RefPtr<Parameter> retvalue = Glib::wrap(gda_parameter_get_bind_param(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Parameter> Parameter::get_bind_param() const
{
  return const_cast<Parameter*>(this)->get_bind_param();
}

Glib::SListHandle<Glib::RefPtr<EntityField> > Parameter::get_param_users()
{
  return Glib::SListHandle<Glib::RefPtr<EntityField> >(gda_parameter_get_param_users(gobj()), Glib::OWNERSHIP_NONE);
}

Glib::SListHandle<Glib::RefPtr<const EntityField> > Parameter::get_param_users() const
{
  return Glib::SListHandle<Glib::RefPtr<const EntityField> >(gda_parameter_get_param_users(const_cast<GdaParameter*>(gobj())), Glib::OWNERSHIP_NONE);
}

void Parameter::declare_param_user(const Glib::RefPtr<Object>& user)
{
gda_parameter_declare_param_user(gobj(), Glib::unwrap(user)); 
}


Glib::SignalProxy0< void > Parameter::signal_restrict_changed()
{
  return Glib::SignalProxy0< void >(this, &Parameter_signal_restrict_changed_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<GType> Parameter::property_g_type() const
{
  return Glib::PropertyProxy_ReadOnly<GType>(this, "g-type");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Parameter::property_entry_plugin() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "entry-plugin");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Parameter::property_entry_plugin() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "entry-plugin");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Parameter::property_use_default_value() 
{
  return Glib::PropertyProxy<bool>(this, "use-default-value");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Parameter::property_use_default_value() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "use-default-value");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Parameter::property_not_null() 
{
  return Glib::PropertyProxy<bool>(this, "not-null");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Parameter::property_not_null() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "not-null");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<Parameter> > Parameter::property_simple_bind() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Parameter> >(this, "simple-bind");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Parameter> > Parameter::property_simple_bind() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Parameter> >(this, "simple-bind");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<Parameter> > Parameter::property_full_bind() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Parameter> >(this, "full-bind");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Parameter> > Parameter::property_full_bind() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Parameter> >(this, "full-bind");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<DataModel> > Parameter::property_restrict_model() 
{
  return Glib::PropertyProxy< Glib::RefPtr<DataModel> >(this, "restrict-model");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DataModel> > Parameter::property_restrict_model() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DataModel> >(this, "restrict-model");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Parameter::property_restrict_column() 
{
  return Glib::PropertyProxy<int>(this, "restrict-column");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Parameter::property_restrict_column() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "restrict-column");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Gnome::Gda::Parameter::on_restrict_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->restrict_changed)
    (*base->restrict_changed)(gobj());
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gda

} // namespace Gnome


