// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_SQLPARSER_H
#define _LIBGDAMM_SQLPARSER_H


#include <glibmm.h>

// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* set.h
 *
 * Copyright 2006 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/batch.h>
#include <libgdamm/statement.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaSqlParser GdaSqlParser;
typedef struct _GdaSqlParserClass GdaSqlParserClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class SqlParser_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum SqlParserMode
{
  SQL_PARSER_MODE_PARSE,
  SQL_PARSER_MODE_DELIMIT
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::SqlParserMode> : public Glib::Value_Enum<Gnome::Gda::SqlParserMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** SQL parser
 *
 * The Gda::SqlParser is an object dedicated to creating Gda::Statement and 
 * Gda::Batch objects from SQL strings. The actual contents of the parsed 
 * statements is represented as Gda::SqlStatement structures (which can be 
 * obtained from any Gda::Statement through the "structure" property).
 *
 * Gda::SqlParser parsers can be created by calling Gda::ServerProvider::create_parser() 
 * for a provider adapted SQL parser, or using create() for a general purpose SQL parser.
 * 
 * The Gda::SqlParser can either work in "parse" mode where it will try to parse
 * the SQL string, or in "delimiter" mode where it will only attempt at delimiting 
 * SQL statements in a string which may contain several SQL statements (usually 
 * separated by a semi column). If operating in "parser" mode, and the parser 
 * can't correctly parse the string, then it will switch to the "delimiter" mode 
 * for the next statement in the string to parse (and create a STATEMENT_UNKNOWN statement).
 * 
 * The Gda::SqlParser object parses and analyses SQL statements and reports the 
 * following statement types:
 *
 * - SELECT (and COMPOUND select), INSERT, UPDATE and DELETE SQL statements should be completely parsed.
 *
 * - Transaction related statements (corresponding to the BEGIN, COMMIT, 
 *   ROLLBACK, SAVEPOINT, ROLLBACK SAVEPOINT and DELETE SAVEPOINT) are parsed and a 
 *   minimalist structure is created to extract some information (that structure is not enough per-se to re-create the complete SQL statement).
 *
 * Any other type of SQL statement (CREATE TABLE, ...) creates a GdaStatement of 
 * type STATEMENT_UNKNOWN, and it only able to locate place holders (variables)
 * and end of statement marks.
 *
 * NOTE: Any SQL of a type which should be parsed which but which creates a Gda::Statement
 * of type GDA_SQL_STATEMENT_UNKNOWN (check with Gda::Statement::get_statement_type()) 
 * should be reported as a bug.
 *
 * The Gda::SqlParser object recognizes place holders (variables), which can later
 * be queried and valued using Gda::Statement::get_parameters(). The folllowing syntax 
 * are recognized (other syntaxes might be recognized for specific database 
 * providers if the Gda::SqlParser is created using Gda::ServerProvider::create_parser() 
 * but for portability reasons it's better to avoid them):
 *
 * - ##NAME[::TYPE[::NULL]]: for a variable named NAME with the optional type TYPE 
 * (which can be a GType name or a custom database type name), and with the 
 * optional "::NULL" to instruct that the variable can be NULL.
 * - ## \/* name:NAME [type:TYPE] [nullok:[TRUE|FALSE]] [descr:DESCR] *\/ 
 * for a variable named NAME with the optional type TYPE (which can be a GType 
 * name or a custom database type name), with the optional "nullok" attribute 
 * and an optional description DESCR. Note that the NAME, TYPE and DESCR literals here 
 * must be quoted (simple or double quotes) if they include non alphanumeric 
 * characters, and that there must always be at least a space between the 
 * ## and the \/* ... *\/.
 *
 * @ingroup Connection
 */

class SqlParser : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SqlParser CppObjectType;
  typedef SqlParser_Class CppClassType;
  typedef GdaSqlParser BaseObjectType;
  typedef GdaSqlParserClass BaseClassType;

private:  friend class SqlParser_Class;
  static CppClassType sqlparser_class_;

private:
  // noncopyable
  SqlParser(const SqlParser&);
  SqlParser& operator=(const SqlParser&);

protected:
  explicit SqlParser(const Glib::ConstructParams& construct_params);
  explicit SqlParser(GdaSqlParser* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SqlParser();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaSqlParser*       gobj()       { return reinterpret_cast<GdaSqlParser*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaSqlParser* gobj() const { return reinterpret_cast<GdaSqlParser*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaSqlParser* gobj_copy();

private:

protected:
  SqlParser();
public:
  
  static Glib::RefPtr<SqlParser> create();

  
  /** Parses @a sql and creates a Gda::Statement statement from the first SQL statement contained in @a sql: if @a sql
   * contains more than one statement, then the remaining part of the string is not parsed at all, and @a remain (if
   * not <tt>0</tt>) will point at the first non parsed character.
   * @param sql The SQL string to parse.
   * @param remain Location to store a pointer to remaining part of @a sql in case @a sql has multiple statement, or <tt>0</tt>.
   * @return A new Gda::Statement object, or <tt>0</tt> if an error occurred.
   */

  Glib::RefPtr<Statement> parse_string(const Glib::ustring& sql, Glib::ustring& remain);
  
  /** Parse @a sql and creates a Gda::Batch object which contains all the Gda::Statement objects created while parsing (one object
   * per SQL statement). Empty statements (composed of spaces only) do not appear in the resulting object.
   * 
   *  @a sql is parsed and Gda::Statement objects are created as long as no error is found in @a sql. If an error is found 
   * at some point, then the parsing stops and @a remain may contain a non <tt>0</tt> pointer, @a error may be set, and <tt>0</tt>
   * is returned.
   * 
   * if @a sql is <tt>0</tt>, then the returned Gda::Batch object will contain no statement.
   * @param sql The SQL string to parse.
   * @param remain Location to store a pointer to remaining part of @a sql in case an error occurred while parsing @a sql, or <tt>0</tt>.
   * @return A new Gda::Batch object, or <tt>0</tt> if an error occurred.
   */

  Glib::RefPtr<Batch> parse_string_as_batch(const Glib::ustring& sql, Glib::ustring& remain);

  
  /** Parse @a filename's contents and creates a Gda::Batch object which contains all the
   * Gda::Statement objects created while parsing (one object per SQL statement).
   * 
   *  @a filename's contents are parsed and Gda::Statement objects are created as long as no error is found. If an error is found 
   * at some point, then the parsing stops, @a error may be set and <tt>0</tt> is returned
   * 
   * if @a sql is <tt>0</tt>, then the returned Gda::Batch object will contain no statement.
   * @param filename Name of the file to parse.
   * @return A new Gda::Batch object, or <tt>0</tt> if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<Batch> parse_file_as_batch(const std::string& filename);
#else
  Glib::RefPtr<Batch> parse_file_as_batch(const std::string& filename, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  //TODO:
#if 0  
  _WPAP_PROPERTY("column-error", int)
  _WPAP_PROPERTY("line-error", int)
  _WPAP_PROPERTY("mode", int)
  _WPAP_PROPERTY("tokenizer-flavour", int)
#endif


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::SqlParser
   */
  Glib::RefPtr<Gnome::Gda::SqlParser> wrap(GdaSqlParser* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_SQLPARSER_H */

