// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_STATEMENT_H
#define _LIBGDAMM_STATEMENT_H


#include <glibmm.h>

// -*- C++ -*- //

/* statement.h
 *
 * Copyright 2006 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/set.h>
#include <libgdamm/holder.h>
#include <libgdamm/sqlstatement.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaStatement GdaStatement;
typedef struct _GdaStatementClass GdaStatementClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Statement_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class Connection;

/** @addtogroup libgdammEnums libgdamm Enums and Flags */

/**
 * @ingroup libgdammEnums
 * @par Bitwise operators:
 * <tt>%StatementModelUsage operator|(StatementModelUsage, StatementModelUsage)</tt><br>
 * <tt>%StatementModelUsage operator&(StatementModelUsage, StatementModelUsage)</tt><br>
 * <tt>%StatementModelUsage operator^(StatementModelUsage, StatementModelUsage)</tt><br>
 * <tt>%StatementModelUsage operator~(StatementModelUsage)</tt><br>
 * <tt>%StatementModelUsage& operator|=(StatementModelUsage&, StatementModelUsage)</tt><br>
 * <tt>%StatementModelUsage& operator&=(StatementModelUsage&, StatementModelUsage)</tt><br>
 * <tt>%StatementModelUsage& operator^=(StatementModelUsage&, StatementModelUsage)</tt><br>
 */
enum StatementModelUsage
{
  STATEMENT_MODEL_RANDOM_ACCESS = 1 << 0,
  STATEMENT_MODEL_CURSOR_FORWARD = 1 << 1,
  STATEMENT_MODEL_CURSOR_BACKWARD = 1 << 2,
  STATEMENT_MODEL_CURSOR = 0x6,
  STATEMENT_MODEL_ALLOW_NOPARAM = 1 << 3
};

/** @ingroup libgdammEnums */
inline StatementModelUsage operator|(StatementModelUsage lhs, StatementModelUsage rhs)
  { return static_cast<StatementModelUsage>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline StatementModelUsage operator&(StatementModelUsage lhs, StatementModelUsage rhs)
  { return static_cast<StatementModelUsage>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline StatementModelUsage operator^(StatementModelUsage lhs, StatementModelUsage rhs)
  { return static_cast<StatementModelUsage>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline StatementModelUsage operator~(StatementModelUsage flags)
  { return static_cast<StatementModelUsage>(~static_cast<unsigned>(flags)); }

/** @ingroup libgdammEnums */
inline StatementModelUsage& operator|=(StatementModelUsage& lhs, StatementModelUsage rhs)
  { return (lhs = static_cast<StatementModelUsage>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline StatementModelUsage& operator&=(StatementModelUsage& lhs, StatementModelUsage rhs)
  { return (lhs = static_cast<StatementModelUsage>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline StatementModelUsage& operator^=(StatementModelUsage& lhs, StatementModelUsage rhs)
  { return (lhs = static_cast<StatementModelUsage>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::StatementModelUsage> : public Glib::Value_Flags<Gnome::Gda::StatementModelUsage>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 * @par Bitwise operators:
 * <tt>%StatementSqlFlag operator|(StatementSqlFlag, StatementSqlFlag)</tt><br>
 * <tt>%StatementSqlFlag operator&(StatementSqlFlag, StatementSqlFlag)</tt><br>
 * <tt>%StatementSqlFlag operator^(StatementSqlFlag, StatementSqlFlag)</tt><br>
 * <tt>%StatementSqlFlag operator~(StatementSqlFlag)</tt><br>
 * <tt>%StatementSqlFlag& operator|=(StatementSqlFlag&, StatementSqlFlag)</tt><br>
 * <tt>%StatementSqlFlag& operator&=(StatementSqlFlag&, StatementSqlFlag)</tt><br>
 * <tt>%StatementSqlFlag& operator^=(StatementSqlFlag&, StatementSqlFlag)</tt><br>
 */
enum StatementSqlFlag
{
  STATEMENT_SQL_PARAMS_AS_VALUES = 0x0,
  STATEMENT_SQL_PRETTY = 1 << 0,
  STATEMENT_SQL_PARAMS_LONG = 1 << 1,
  STATEMENT_SQL_PARAMS_SHORT = 1 << 2,
  STATEMENT_SQL_PARAMS_AS_COLON = 1 << 3,
  STATEMENT_SQL_PARAMS_AS_DOLLAR = 1 << 4,
  STATEMENT_SQL_PARAMS_AS_QMARK = 1 << 5,
  STATEMENT_SQL_PARAMS_AS_UQMARK = 1 << 6
};

/** @ingroup libgdammEnums */
inline StatementSqlFlag operator|(StatementSqlFlag lhs, StatementSqlFlag rhs)
  { return static_cast<StatementSqlFlag>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline StatementSqlFlag operator&(StatementSqlFlag lhs, StatementSqlFlag rhs)
  { return static_cast<StatementSqlFlag>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline StatementSqlFlag operator^(StatementSqlFlag lhs, StatementSqlFlag rhs)
  { return static_cast<StatementSqlFlag>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline StatementSqlFlag operator~(StatementSqlFlag flags)
  { return static_cast<StatementSqlFlag>(~static_cast<unsigned>(flags)); }

/** @ingroup libgdammEnums */
inline StatementSqlFlag& operator|=(StatementSqlFlag& lhs, StatementSqlFlag rhs)
  { return (lhs = static_cast<StatementSqlFlag>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline StatementSqlFlag& operator&=(StatementSqlFlag& lhs, StatementSqlFlag rhs)
  { return (lhs = static_cast<StatementSqlFlag>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline StatementSqlFlag& operator^=(StatementSqlFlag& lhs, StatementSqlFlag rhs)
  { return (lhs = static_cast<StatementSqlFlag>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::StatementSqlFlag> : public Glib::Value_Flags<Gnome::Gda::StatementSqlFlag>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


class StatementError : public Glib::Error
{
public:
  enum Code
  {
    STATEMENT_PARSE_ERROR,
    STATEMENT_SYNTAX_ERROR,
    STATEMENT_NO_CNC_ERROR,
    STATEMENT_CNC_CLOSED_ERROR,
    STATEMENT_EXEC_ERROR,
    STATEMENT_PARAM_TYPE_ERROR,
    STATEMENT_PARAM_ERROR
  };

  StatementError(Code error_code, const Glib::ustring& error_message);
  explicit StatementError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::StatementError::Code> : public Glib::Value_Enum<Gnome::Gda::StatementError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** Single SQL statement.
 *
 * The Gda::Statement represents a single SQL statement (multiple statements
 * can be grouped in a Batch object).
 *
 * A Gda::Statement can either be built "manually" by building a Gda::SqlStatement
 * structure, or from an SQL statement using a Gda::SqlParser object.
 * A GdaConnection can use a GdaStatement to:
 *
 *  - prepare it for a future execution, the preparation step involves converting the
 *     GdaStatement object into a structure used by the database's own API, see
 *     Gda::Connection::statement_prepare()
 *  - execute it using Gda::Connection::statement_execute_select() if it is known
 *     that the statement is a selection statement, Gda::Connection::statement_execute_non_select()
 *     if it is not a selection statement, or Gda::Connection::statement_execute()
 *     when the type of expected result is unknown.
 * Note that it is possible to use the same Gda::Statement object at the same time
 * with several Gda::Connection objects.
 *
 * @ingroup Connection
 */

class Statement : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Statement CppObjectType;
  typedef Statement_Class CppClassType;
  typedef GdaStatement BaseObjectType;
  typedef GdaStatementClass BaseClassType;

private:  friend class Statement_Class;
  static CppClassType statement_class_;

private:
  // noncopyable
  Statement(const Statement&);
  Statement& operator=(const Statement&);

protected:
  explicit Statement(const Glib::ConstructParams& construct_params);
  explicit Statement(GdaStatement* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Statement();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaStatement*       gobj()       { return reinterpret_cast<GdaStatement*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaStatement* gobj() const { return reinterpret_cast<GdaStatement*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaStatement* gobj_copy();

private:

protected:
  Statement();

public:
  
  static Glib::RefPtr<Statement> create();

  
  /** Copy constructor
   * @return A the new copy of @a orig.
   */
  Glib::RefPtr<Statement> copy() const;

  
  /** Creates a string representing the contents of @a stmt.
   * @return A string containing the serialized version of @a stmt.
   */
  Glib::ustring serialize() const;

  //TODO: Should this be const? Probably not, because the caller could change Set. murrayc.
  
  /** Get a new Gda::Set object which groups all the execution parameters
   * which @a stmt needs. This new object is returned though @a out_params.
   * 
   * Note that if @a stmt does not need any parameter, then @a out_params is set to <tt>0</tt>.
   * @param out_params A place to store a new Gda::Set object, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */

  bool get_parameters(Glib::RefPtr<Set>& out_params);
  

  //TODO: Documentation:
  Glib::ustring to_sql() const;

  //TODO: Documentation:
  Glib::ustring to_sql(const Glib::RefPtr<const Set>& params) const;
  

  typedef std::vector< const Glib::RefPtr<Holder> > HolderVector;

  //TODO: Add an overload without the params?
  
  /** Renders @a stmt as an SQL statement, with some control on how it is rendered.
   * 
   * If @a cnc is not <tt>0</tt>, then the rendered SQL will better be suited to be used by @a cnc (in particular
   * it may include some SQL tweaks and/or proprietary extensions specific to the database engine used by @a cnc):
   * in this case the result is similar to calling Gda::Connection::statement_to_sql().
   * @param cnc A Gda::Connection object, or <tt>0</tt>.
   * @param params Parameters contained in a single Gda::Set object.
   * @param flags A set of flags to control the rendering.
   * @param params_used A place to store the list of actual Gda::Holder objects in @params used to do the rendering, or <tt>0</tt>.
   * @return A new string if no error occurred.
   */

  Glib::ustring to_sql(const Glib::RefPtr<Connection>& cnc, const Glib::RefPtr<const Set>& params,
                                StatementSqlFlag flags, const HolderVector& params_used) const;

  
  /** Get the type of statement held by @a stmt. It returns GDA_SQL_STATEMENT_NONE if
   *  @a stmt does not hold any statement
   * @return The statement type.
   */
  SqlStatementType get_statement_type() const;
  
  /** Tells if @a stmt is composed only of spaces (that is it has no real SQL code), and is completely
   * useless as such.
   * @return <tt>true</tt> if executing @a stmt does nothing.
   */
  bool is_useless() const;
  
  /** Checks that @a stmt's structure is correct.
   * @return <tt>true</tt> if @a stmt's structure is correct.
   */
  bool check_structure() const;
  
  /** If @a cnc is not <tt>0</tt> then checks that every object (table, field, function) used in @a stmt 
   * actually exists in @a cnc's database
   * 
   * If @a cnc is <tt>0</tt>, then cleans anything related to @a cnc in @a stmt.
   * 
   * See gda_sql_statement_check_validity() for more information.
   * @param cnc A Gda::Connection object, or <tt>0</tt>.
   * @return <tt>true</tt> if every object actually exists in @a cnc's database.
   */
  bool check_validity(const Glib::RefPtr<Connection>& cnc) const;
  
  /** "Normalizes" some parts of @a stmt, see gda_sql_statement_normalize() for more
   * information.
   * @param cnc A Gda::Connection object.
   * @return <tt>true</tt> if no error occurred.
   */
  bool normalize(const Glib::RefPtr<Connection>& cnc);

  //TODO: gda_statement_to_sql_real() : See http://bugzilla.gnome.org/show_bug.cgi?id=574738

  //TODO: Use a real GType in libgda?
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<gpointer> property_structure() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<gpointer> property_structure() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  //The m4 conversion is here because it is only for signals:
 

  /**
   * @par Prototype:
   * <tt>void on_my_%checked(const Glib::RefPtr<Connection>& cnc, bool valid)</tt>
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<Connection>&,bool > signal_checked();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%reset()</tt>
   */

  Glib::SignalProxy0< void > signal_reset();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_checked(const Glib::RefPtr<Connection>& cnc, bool valid);
  virtual void on_reset();


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::Statement
   */
  Glib::RefPtr<Gnome::Gda::Statement> wrap(GdaStatement* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_STATEMENT_H */

