// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_COLUMN_H
#define _LIBGDAMM_COLUMN_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* $Id: column.hg,v 1.14 2006/11/30 06:58:55 murrayc Exp $ */
// -*- C++ -*- //

/* modelcolumnattributes.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/value.h>
#include <libgdamm/transactionstatus.h>
#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaColumn GdaColumn;
typedef struct _GdaColumnClass GdaColumnClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Column_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{


/* possible predefined attribute names for gda_holder_get_attribute() or gda_column_get_attribute() */
// Keep in sync with libgda
// TODO: How/When/Why are these used? Where are they documented? murrayc.
const std::string ATTRIBUTE_DESCRIPTION = "__gda_attr_descr"; /* G_TYPE_STRING */
const std::string ATTRIBUTE_NAME = "__gda_attr_name"; /* G_TYPE_STRING */
const std::string ATTRIBUTE_NUMERIC_PRECISION = "__gda_attr_numeric_precision"; /* G_TYPE_INT */
const std::string ATTRIBUTE_NUMERIC_SCALE = "__gda_attr_numeric_scale"; /* G_TYPE_INT */
const std::string ATTRIBUTE_AUTO_INCREMENT = "__gda_attr_autoinc"; /* G_TYPE_BOOLEAN */
const std::string ATTRIBUTE_IS_DEFAULT = "__gda_attr_is_default"; /* G_TYPE_BOOLEAN */

/** Management of DataModel column attributes.
 *
 * @ingroup DataHandlers
 */

class Column : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Column CppObjectType;
  typedef Column_Class CppClassType;
  typedef GdaColumn BaseObjectType;
  typedef GdaColumnClass BaseClassType;

private:  friend class Column_Class;
  static CppClassType column_class_;

private:
  // noncopyable
  Column(const Column&);
  Column& operator=(const Column&);

protected:
  explicit Column(const Glib::ConstructParams& construct_params);
  explicit Column(GdaColumn* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Column();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaColumn*       gobj()       { return reinterpret_cast<GdaColumn*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaColumn* gobj() const { return reinterpret_cast<GdaColumn*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaColumn* gobj_copy();

private:

protected:
  Column();

public:
  
  static Glib::RefPtr<Column> create();

  
  /** Creates a new Gda::Column object from an existing one.
   * @return A newly allocated Gda::Column with a copy of the data 	 
   * in @a column.
   */
  Glib::RefPtr<Column> copy() const;
  bool equal(const Glib::RefPtr<const Column>& src) const;

  
  /** 
   * @return The column's description, in any.
   */
  Glib::ustring get_description() const;
  
  /** Sets the column's description
   * @param title Title name.
   */
  void set_description(const Glib::ustring& title);
  
  void set_attribute(const Glib::ustring& attribute, const Value& value);
  
  /** Get the value associated to a named attribute.
   * 
   * Attributes can have any name, but Libgda proposes some default names, see this section.
   * @param attribute Attribute name as a string.
   * @return A read-only Value, or <tt>0</tt> if not attribute named @a attribute has been set for @a column.
   */
  Value get_attribute(const Glib::ustring& attribute) const;
    
  
  /** 
   * @return The name of @a column.
   */
  Glib::ustring get_name() const;
  
  /** Sets the name of @a column to @a name.
   * @param name The new name of @a column.
   */
  void set_name(const Glib::ustring& name);
  
  /** 
   * @return The database type of @a column.
   */
  Glib::ustring get_dbms_type() const;
  
  /** Defines @a column's database type
   * @param dbms_type A string.
   */
  void set_dbms_type(const Glib::ustring& dbms_type);

  
  /** 
   * @return The type of @a column.
   */
  GType get_g_type() const;
  
  /** Sets the type of @a column to @a type.
   * @param type The new type of @a column.
   */
  void set_g_type(GType type);
  
  /** Gets the 'allow null' flag of the given column.
   * @return Whether the given column allows null values or not (<tt>true</tt> or <tt>false</tt>).
   */
  bool get_allow_null() const;
  
  /** Sets the 'allow null' flag of the given column.
   * @param allow Whether the given column should allows null values or not.
   */
  void set_allow_null(bool allow =  true);
  
  /** 
   * @return Whether the given column is an auto incremented one (<tt>true</tt> or <tt>false</tt>).
   */
  bool get_auto_increment() const;
  
  /** Sets the auto increment flag for the given column.
   * @param is_auto Auto increment status.
   */
  void set_auto_increment(bool is_auto =  true);
  
  /** 
   * @return The position of the column refer to in the
   * containing data model.
   */
  gint get_position() const;
  
  /** Sets the position of the column refer to in the containing
   * data model.
   * @param position The wanted position of the column in the containing data model.
   */
  void set_position(gint position);

  
  /** 
   * @return  @a column's default value, as a Value object.
   */
  Value get_default_value() const;
  
  
  /** Sets @a column's default Value.
   * @param default_value Default Value for the column.
   */
  void set_default_value(const Value& default_value);

 
/**
   * @par Slot Prototype:
   * <tt>void on_my_%name_changed(const Glib::ustring& old_name)</tt>
   *
   */

  Glib::SignalProxy1< void,const Glib::ustring& > signal_name_changed();

  
/**
   * @par Slot Prototype:
   * <tt>void on_my_%g_type_changed(GType old_type, GType new_type)</tt>
   *
   */

  Glib::SignalProxy2< void,GType,GType > signal_g_type_changed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Column's Id (warning: the column's ID is not guaranteed to be unique in a GdaDataModel).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_id() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Column's Id (warning: the column's ID is not guaranteed to be unique in a GdaDataModel).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_name_changed().
  virtual void on_name_changed(const Glib::ustring& old_name);
  /// This is a default handler for the signal signal_g_type_changed().
  virtual void on_g_type_changed(GType old_type, GType new_type);


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::Column
   */
  Glib::RefPtr<Gnome::Gda::Column> wrap(GdaColumn* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_COLUMN_H */

