// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_DATAHANDLER_H
#define _LIBGDAMM_DATAHANDLER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- C++ -*- //

/* datahandler.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>
#include <libgdamm/value.h>
#include <libgda/gda-data-handler.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaDataHandler GdaDataHandler;
typedef struct _GdaDataHandlerClass GdaDataHandlerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class DataHandler_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** @defgroup DataHandlers Data Handlers
 */

/** Base class which provides data handling capabilities.
 *
 * Because data types vary a lot from one DBMS to another, the DataHandler interface helps with designing modules 
 * which can handle very specific pieces of data through plugins. Each object which imlements the DataHandler interface 
 * is expected to handle a subset of the possible libgda defined data types.
 * 
 * The DataHandler object can convert a Value to and from both SQL and 'STR'. The SQL representation of a value is the 
 * actual string which would be used in an SQL statement (for example a string's SQL representation is surrounded by 
 * quotes such as 'that\s a string''). The 'STR' representation is a human-readable representation of a value appropriate 
 * for the user's current locale. The 'STR' respresentation of a string is simply the original string without quotes but 
 * a numerical value or date, for instance, will be formatted according to the user's current locale.
 * 
 * Only one object which implements this interface is needed for any given data type, and it mainly contains some methods 
 * to manage values (as Value structures). The Gnome::Db::DataEntry interface is complementary to this one since it is 
 * implemented by widgets in which the user can enter or modify some data. 
 *
 * @ingroup DataHandlers
 */

class DataHandler : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataHandler CppObjectType;
  typedef DataHandler_Class CppClassType;
  typedef GdaDataHandler BaseObjectType;
  typedef GdaDataHandlerIface BaseClassType;

private:
  friend class DataHandler_Class;
  static CppClassType datahandler_class_;

  // noncopyable
  DataHandler(const DataHandler&);
  DataHandler& operator=(const DataHandler&);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  DataHandler();
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit DataHandler(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit DataHandler(GdaDataHandler* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataHandler();

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaDataHandler*       gobj()       { return reinterpret_cast<GdaDataHandler*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaDataHandler* gobj() const { return reinterpret_cast<GdaDataHandler*>(gobject_); }

private:

public:

  
  /** Creates a new string which is an SQL representation of the given value, the returned string
   * can be used directly in an SQL statement. For example if @a value is a G_TYPE_STRING, then
   * the returned string will be correctly quoted. Note however that it is a better practice
   * to use variables in statements instead of value literals, see
   * the GdaSqlParser for more information.
   * 
   * If the value is <tt>0</tt> or is of type GDA_TYPE_<tt>0</tt>, the returned string is "<tt>0</tt>".
   * @param value The value to be converted to a string.
   * @return The new string, or <tt>0</tt> if an error occurred.
   */
  Glib::ustring get_sql_from_value(const Value& value) const;
  
  /** Creates a new string which is a "user friendly" representation of the given value
   * (in the user's locale, specially for the dates). If the value is 
   * <tt>0</tt> or is of type GDA_TYPE_<tt>0</tt>, the returned string is a copy of "" (empty string).
   * @param value The value to be converted to a string.
   * @return The new string, or <tt>0</tt> if an error occurred.
   */
  Glib::ustring get_str_from_value(const Value& value) const;

  
  /** Creates a new GValue which represents the SQL value given as argument. This is
   * the opposite of the function get_sql_from_value(). The type argument
   * is used to determine the real data type requested for the returned value.
   * 
   * If the sql string is <tt>0</tt>, then the returned GValue is of type GDA_TYPE_<tt>0</tt>;
   * if the sql string does not correspond to a valid SQL string for the requested type, then
   * the "<tt>0</tt>" string is returned.
   * @param sql An SQL string.
   * @param type A GType.
   * @return The new GValue or <tt>0</tt> on error.
   */
  Value get_value_from_sql(const Glib::ustring& sql, GType type) const;
  
  /** Creates a new GValue which represents the STR value given as argument. This is
   * the opposite of the function get_str_from_value(). The type argument
   * is used to determine the real data type requested for the returned value.
   * 
   * If the str string is <tt>0</tt>, then the returned GValue is of type GDA_TYPE_<tt>0</tt>;
   * if the str string does not correspond to a valid STR string for the requested type, then
   * <tt>0</tt> is returned.
   * @param str A string.
   * @param type A GType.
   * @return The new GValue or <tt>0</tt> on error.
   */
  Value get_value_from_str(const Glib::ustring& sql, GType type) const;
  
  /** Creates a new GValue which holds a sane initial value to be used if no value is specifically
   * provided. For example for a simple string, this would return a new value containing the "" string.
   * @param type A GTYpe.
   * @return The new GValue, or <tt>0</tt> if no such value can be created.
   */
  Value get_sane_init_value(GType type) const;

  
  /** Checks wether the GdaDataHandler is able to handle the gda type given as argument.
   * @param type A Type.
   * @return <tt>true</tt> if the gda type can be handled.
   */
  bool accepts_g_type(GType type) const;
  
  /** Get a short description of the GdaDataHandler
   * @return The description.
   */
  Glib::ustring get_descr() const;

protected:

  //We don't wrap the vfuncs because they are only useful for implementation of libgda itself,
  //and they have a high code-size and per-object memory cost. murrayc


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::DataHandler
   */
  Glib::RefPtr<Gnome::Gda::DataHandler> wrap(GdaDataHandler* object, bool take_copy = false);

} // namespace Glib


#endif /* _LIBGDAMM_DATAHANDLER_H */

