// Generated by gtkmmproc -- DO NOT MODIFY!


#include <glibmm.h>

#include <libgdamm/holder.h>
#include <libgdamm/private/holder_p.h>


// -*- C++ -*- // this is for the .ccg, I realize gensig puts one in

/* holder.cc
 * 
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/holder.h>
#include <libgdamm/datamodel.h>
#include <libgda/gda-holder.h>
#include <libgda/gda-enum-types.h>

namespace Gnome
{

namespace Gda
{

Holder::Holder (GType g_type, const Glib::ustring& id)
 : // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(holder_class_.init(), "g-type",g_type,"id",id.c_str(), static_cast<char*>(0)))
{

}

static void on_set_attribute_destroy(gpointer data)
{
  g_free((char*)data);
}

void Holder::set_attribute(const Glib::ustring& attribute, const Value& value)
{
  //gda_holder_set_attribute() has stupid memory management.
  //See http://bugzilla.gnome.org/show_bug.cgi?id=564402
  gchar* dup = g_strdup(attribute.c_str());
  gda_holder_set_attribute(gobj(), dup, (value).gobj(), &on_set_attribute_destroy); 
}
  
} /* namespace Gda */

} /* namespace Gnome */


namespace
{


static const Glib::SignalProxyInfo Holder_signal_changed_info =
{
  "changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Holder_signal_source_changed_info =
{
  "source-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static GError* Holder_signal_validate_change_callback(GdaHolder* self, GValue* p0,void* data)
{
  using namespace Gnome::Gda;
  typedef sigc::slot< Glib::Error,const Value& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return ((*static_cast<SlotType*>(slot))(Value(p0)
)).gobj();
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef GError* RType;
  return RType();
}

static GError* Holder_signal_validate_change_notify_callback(GdaHolder* self, GValue* p0, void* data)
{
  using namespace Gnome::Gda;
  typedef sigc::slot< void,const Value& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Value(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef GError* RType;
  return RType();
}

static const Glib::SignalProxyInfo Holder_signal_validate_change_info =
{
  "validate-change",
  (GCallback) &Holder_signal_validate_change_callback,
  (GCallback) &Holder_signal_validate_change_notify_callback
};


static void Holder_signal_attribute_changed_callback(GdaHolder* self, const gchar* p0,GValue* p1,void* data)
{
  using namespace Gnome::Gda;
  typedef sigc::slot< void,const Glib::ustring&,const Value& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::convert_const_gchar_ptr_to_ustring(p0)
, Value(p1)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Holder_signal_attribute_changed_info =
{
  "attribute-changed",
  (GCallback) &Holder_signal_attribute_changed_callback,
  (GCallback) &Holder_signal_attribute_changed_callback
};


} // anonymous namespace


Gnome::Gda::HolderError::HolderError(Gnome::Gda::HolderError::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (GDA_HOLDER_ERROR, error_code, error_message)
{}

Gnome::Gda::HolderError::HolderError(GError* gobject)
:
  Glib::Error (gobject)
{}

Gnome::Gda::HolderError::Code Gnome::Gda::HolderError::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

void Gnome::Gda::HolderError::throw_func(GError* gobject)
{
  throw Gnome::Gda::HolderError(gobject);
}

// static
GType Glib::Value<Gnome::Gda::HolderError::Code>::value_type()
{
  return gda_holder_error_get_type();
}


namespace Glib
{

Glib::RefPtr<Gnome::Gda::Holder> wrap(GdaHolder* object, bool take_copy)
{
  return Glib::RefPtr<Gnome::Gda::Holder>( dynamic_cast<Gnome::Gda::Holder*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gnome
{

namespace Gda
{


/* The *_Class implementation: */

const Glib::Class& Holder_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Holder_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gda_holder_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Holder_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->changed = &changed_callback;
  klass->source_changed = &source_changed_callback;
}


void Holder_Class::changed_callback(GdaHolder* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->changed)
    (*base->changed)(self);
}
void Holder_Class::source_changed_callback(GdaHolder* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_source_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->source_changed)
    (*base->source_changed)(self);
}


Glib::ObjectBase* Holder_Class::wrap_new(GObject* object)
{
  return new Holder((GdaHolder*)object);
}


/* The implementation: */

GdaHolder* Holder::gobj_copy()
{
  reference();
  return gobj();
}

Holder::Holder(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Holder::Holder(GdaHolder* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Holder::~Holder()
{}


Holder::CppClassType Holder::holder_class_; // initialize static member

GType Holder::get_type()
{
  return holder_class_.init().get_type();
}


GType Holder::get_base_type()
{
  return gda_holder_get_type();
}


Glib::RefPtr<Holder> Holder::create(GType g_type, const Glib::ustring& id)
{
  return Glib::RefPtr<Holder>( new Holder(g_type, id) );
}

Glib::RefPtr<Holder> Holder::copy() const
{
  return Glib::wrap(gda_holder_copy(const_cast<GdaHolder*>(gobj())));
}

GType Holder::get_g_type() const
{
  return gda_holder_get_g_type(const_cast<GdaHolder*>(gobj()));
}

Glib::ustring Holder::get_id() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_holder_get_id(const_cast<GdaHolder*>(gobj())));
}

Value Holder::get_value() const
{
  return Value(gda_holder_get_value(const_cast<GdaHolder*>(gobj())));
}

Glib::ustring Holder::get_value_str(const Glib::RefPtr<DataHandler>& dh) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gda_holder_get_value_str(const_cast<GdaHolder*>(gobj()), Glib::unwrap(dh)));
}

bool Holder::set_value_as_value(const Value& value)
{
  GError* gerror = 0;
  bool retvalue = gda_holder_set_value(gobj(), (value).gobj(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool Holder::set_value_str(const Glib::RefPtr<DataHandler>& dh, const Glib::ustring& value)
{
  GError* gerror = 0;
  bool retvalue = gda_holder_set_value_str(gobj(), Glib::unwrap(dh), value.c_str(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool Holder::take_value(const Value& value)
{
  GError* gerror = 0;
  bool retvalue = gda_holder_take_value(gobj(), const_cast<GValue*>((value).gobj()), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Value Holder::take_static_value(const Value& value, bool& value_changed)
{
  GError* gerror = 0;
  Value retvalue = Value(gda_holder_take_static_value(gobj(), (value).gobj(), (gboolean*)(&(value_changed)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Value Holder::get_attribute(const Glib::ustring& attribute) const
{
  return Value(gda_holder_get_attribute(const_cast<GdaHolder*>(gobj()), attribute.c_str()));
}

Value Holder::get_default_value() const
{
  return Value(gda_holder_get_default_value(const_cast<GdaHolder*>(gobj())));
}

void Holder::set_default_value(const Value& value)
{
  gda_holder_set_default_value(gobj(), (value).gobj());
}

bool Holder::set_value_to_default()
{
  return gda_holder_set_value_to_default(gobj());
}

bool Holder::value_is_default() const
{
  return gda_holder_value_is_default(const_cast<GdaHolder*>(gobj()));
}

void Holder::force_invalid()
{
  gda_holder_force_invalid(gobj());
}

bool Holder::is_valid() const
{
  return gda_holder_is_valid(const_cast<GdaHolder*>(gobj()));
}

void Holder::set_not_null(bool not_null)
{
  gda_holder_set_not_null(gobj(), static_cast<int>(not_null));
}

bool Holder::get_not_null() const
{
  return gda_holder_get_not_null(const_cast<GdaHolder*>(gobj()));
}

Glib::RefPtr<DataModel> Holder::get_source_model(int& col)
{
  return Glib::wrap(gda_holder_get_source_model(gobj(), &(col)));
}

Glib::RefPtr<const DataModel> Holder::get_source_model(int& col) const
{
  return Glib::wrap(gda_holder_get_source_model(const_cast<GdaHolder*>(gobj()), &(col)));
}

bool Holder::set_source_model(const Glib::RefPtr<DataModel>& model, int col)
{
  GError* gerror = 0;
  bool retvalue = gda_holder_set_source_model(gobj(), Glib::unwrap(model), col, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

void Holder::set_bind(const Glib::RefPtr<Holder>& bind_to)
{
  GError* gerror = 0;
  gda_holder_set_bind(gobj(), Glib::unwrap(bind_to), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

Glib::RefPtr<Holder> Holder::get_bind()
{
  Glib::RefPtr<Holder> retvalue = Glib::wrap(gda_holder_get_bind(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Holder> Holder::get_bind() const
{
  return const_cast<Holder*>(this)->get_bind();
}


Glib::SignalProxy0< void > Holder::signal_changed()
{
  return Glib::SignalProxy0< void >(this, &Holder_signal_changed_info);
}


Glib::SignalProxy0< void > Holder::signal_source_changed()
{
  return Glib::SignalProxy0< void >(this, &Holder_signal_source_changed_info);
}


Glib::SignalProxy1< Glib::Error,const Value& > Holder::signal_validate_change()
{
  return Glib::SignalProxy1< Glib::Error,const Value& >(this, &Holder_signal_validate_change_info);
}


Glib::SignalProxy2< void,const Glib::ustring&,const Value& > Holder::signal_attribute_changed()
{
  return Glib::SignalProxy2< void,const Glib::ustring&,const Value& >(this, &Holder_signal_attribute_changed_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::ustring > Holder::property_description() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "description");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::ustring > Holder::property_description() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "description");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<Holder> > Holder::property_full_bind() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Holder> >(this, "full-bind");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Holder> > Holder::property_full_bind() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Holder> >(this, "full-bind");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< gulong > Holder::property_g_type() 
{
  return Glib::PropertyProxy< gulong >(this, "g-type");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< gulong > Holder::property_g_type() const
{
  return Glib::PropertyProxy_ReadOnly< gulong >(this, "g-type");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::ustring > Holder::property_id() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "id");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::ustring > Holder::property_id() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "id");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::ustring > Holder::property_name() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "name");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::ustring > Holder::property_name() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "name");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< bool > Holder::property_not_null() 
{
  return Glib::PropertyProxy< bool >(this, "not-null");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< bool > Holder::property_not_null() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "not-null");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<Holder> > Holder::property_simple_bind() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Holder> >(this, "simple-bind");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Holder> > Holder::property_simple_bind() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Holder> >(this, "simple-bind");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< int > Holder::property_source_column() 
{
  return Glib::PropertyProxy< int >(this, "source-column");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< int > Holder::property_source_column() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "source-column");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<DataModel> > Holder::property_source_model() 
{
  return Glib::PropertyProxy< Glib::RefPtr<DataModel> >(this, "source-model");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DataModel> > Holder::property_source_model() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DataModel> >(this, "source-model");
}
#endif //GLIBMM_PROPERTIES_ENABLED


void Gnome::Gda::Holder::on_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->changed)
    (*base->changed)(gobj());
}
void Gnome::Gda::Holder::on_source_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->source_changed)
    (*base->source_changed)(gobj());
}


} // namespace Gda

} // namespace Gnome


