// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_QUARKLIST_H
#define _LIBGDAMM_QUARKLIST_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- C++ -*- //

/* quarklist.h
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 

#include <glibmm/object.h>
#include <glibmm/error.h>
#include <libgda/gda-quark-list.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GdaQuarkList GdaQuarkList; }
#endif

namespace Gnome
{

namespace Gda
{

/** Manages lists of KEY=VALUE pairs.
 * This is used mainly by database providers' implementations to parse connection strings 
 * into lists of KEY=VALUE pairs.
 *
 * @ingroup DataHandlers
 */
class QuarkList
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef QuarkList CppObjectType;
  typedef GdaQuarkList BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  QuarkList();

  explicit QuarkList(GdaQuarkList* gobject, bool make_a_copy = true);

  QuarkList(const QuarkList& other);
  QuarkList& operator=(const QuarkList& other);

  ~QuarkList();

  void swap(QuarkList& other);

  ///Provides access to the underlying C instance.
  GdaQuarkList*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GdaQuarkList* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GdaQuarkList* gobj_copy() const;

protected:
  GdaQuarkList* gobject_;

private:

  
  public:
    
  
  /** Removes all strings in the given Gda::QuarkList.
   */
  void clear();
  
  /**  @a string must be a semi-colon separated list of "<key>=<value>" strings (for example
   * "DB_NAME=notes;USERNAME=alfred"). Each key and value must respect the RFC 1738 recommendations: the
   * <tt><>"#%{}|\\^~[]';/?:@=&</tt> and space characters are replaced by 
   * <tt>"%%ab"</tt> where
   * <tt>ab</tt> is the hexadecimal number corresponding to the character (for example the
   * "DB_NAME=notes;USERNAME=al%%20fred" string will specify a username as "al fred"). If this formalism
   * is not respected, then some unexpected results may occur.
   * 
   * Adds new key->value pairs from the given @a string. If @a cleanup is
   * set to <tt>true</tt>, the previous contents will be discarded before adding
   * the new pairs.
   * @param string A string.
   * @param cleanup Whether to cleanup the previous content or not.
   */
  void add_from_string(const Glib::ustring& name, bool cleanup);
  
  /** Searches for the value identified by @a name in the given Gda::QuarkList.
   * @param name The name of the value to search for.
   * @return The value associated with the given key if found, or <tt>0</tt>
   * if not found.
   */
  Glib::ustring find(const Glib::ustring& name) const;
  
  /** Removes an entry from the Gda::QuarkList, given its name.
   * @param name An entry name.
   */
  void remove(const Glib::ustring& name);
      
  typedef sigc::slot<void, Glib::ustring, Glib::ustring> ForeachSlot;
  
  /** Calls the given function for each of the key/value pairs in @a qlist. The function is passed the key and value 
   * of each pair, and the given user_data parameter. @a qlist may not be modified while iterating over it.
   * @param func The function to call for each key/value pair.
   * @param user_data User data to pass to the function.
   */

  void foreach(const ForeachSlot& func);
      

};

} // namespace Gda

} // namespace Gnome


namespace Gnome
{

namespace Gda
{

/** @relates Gnome::Gda::QuarkList
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(QuarkList& lhs, QuarkList& rhs)
  { lhs.swap(rhs); }

} // namespace Gda

} // namespace Gnome

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gnome::Gda::QuarkList
 */
Gnome::Gda::QuarkList wrap(GdaQuarkList* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gnome::Gda::QuarkList> : public Glib::Value_Boxed<Gnome::Gda::QuarkList>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _LIBGDAMM_QUARKLIST_H */

