// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_SQLSTATEMENT_H
#define _LIBGDAMM_SQLSTATEMENT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- C++ -*- //

/* Copyright 2010 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


//#include <libgdamm/connection.h>
#include <glibmm/value.h>
#include <libgda/sql-parser/gda-statement-struct.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GdaSqlStatement GdaSqlStatement; }
#endif

namespace Gnome
{

namespace Gda
{

/** @addtogroup libgdammEnums libgdamm Enums and Flags */

/** 
 * 
 * @ingroup libgdammEnums
 */
enum SqlStatementType
{
  SQL_STATEMENT_SELECT,
  SQL_STATEMENT_INSERT,
  SQL_STATEMENT_UPDATE,
  SQL_STATEMENT_DELETE,
  SQL_STATEMENT_COMPOUND,
  SQL_STATEMENT_BEGIN,
  SQL_STATEMENT_ROLLBACK,
  SQL_STATEMENT_COMMIT,
  SQL_STATEMENT_SAVEPOINT,
  SQL_STATEMENT_ROLLBACK_SAVEPOINT,
  SQL_STATEMENT_DELETE_SAVEPOINT,
  SQL_STATEMENT_UNKNOWN,
  SQL_STATEMENT_NONE
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::SqlStatementType> : public Glib::Value_Enum<Gnome::Gda::SqlStatementType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


class Connection;

/** Every SQL statement can be decomposed in the SqlStatement tree structure.
 * See the documentation for the underlying <a href="http://library.gnome.org/devel/libgda/unstable/libgda-4.0-GdaSqlStatement.html#libgda-4.0-GdaSqlStatement.description">GdaSqlStatement</a>.
 */
class SqlStatement
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef SqlStatement CppObjectType;
  typedef GdaSqlStatement BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  SqlStatement();

  explicit SqlStatement(GdaSqlStatement* gobject, bool make_a_copy = true);

  SqlStatement(const SqlStatement& other);
  SqlStatement& operator=(const SqlStatement& other);

  ~SqlStatement();

  void swap(SqlStatement& other);

  ///Provides access to the underlying C instance.
  GdaSqlStatement*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GdaSqlStatement* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GdaSqlStatement* gobj_copy() const;

protected:
  GdaSqlStatement* gobject_;

private:

  
public:

  explicit SqlStatement(SqlStatementType type = SQL_STATEMENT_SELECT);
  

  bool empty() const;

  
  /** Creates a string representation of @a stmt.
   * @return A new string.
   */
  Glib::ustring serialize() const;

  //_WRAP_METHOD(static Glib::ustring type_to_string(SqlStatementType type), gda_sql_statement_type_to_string)
  
  /** Converts a string to a Gda::SqlStatementType value, see also gda_sql_statement_type_to_string()
   * @param type A string representing a Gda::SqlStatementType type.
   * @return A Gda::SqlStatementType value.
   */
  static SqlStatementType string_to_type(const Glib::ustring& type);

  
  /** Checks for any error in @a stmt's structure to make sure the statement is valid
   * (for example a SELECT statement must at least return a column, a DELETE statement must specify which table
   * is targeted).
   * @return <tt>true</tt> if no error occurred.
   */
  bool check_structure() const;
  
  /** If @a cnc is not <tt>0</tt>, then checks that all the database objects referenced in the statement actually
   * exist in the connection's database (for example the table being updated in a UPDATE statement must exist in the
   * connection's database for the check to succeed). This method fills the @a stmt->validity_meta_struct attribute.
   * 
   * If @a cnc is <tt>0</tt>, then remove any information from a previous call to this method stored in @a stmt. In this case,
   * the @a stmt->validity_meta_struct attribute is cleared.
   * 
   * Also note that some parts of @a stmt may be modified: for example leading and trailing spaces in aliases or
   * objects names will be removed.
   * @param cnc A Gda::Connection object, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
  bool check_validity(const Glib::RefPtr<Connection>& cnc);
  
  /** Cleans any data set by a previous call to gda_sql_statement_check_validity().
   */
  void check_clean();
  
  /** "Normalizes" (in place) some parts of @a stmt, which means @a stmt may be modified.
   * At the moment any "*" field in a SELECT statement will be replaced by one
   * Gda::SqlSelectField structure for each field in the referenced table.
   * @param cnc A Gda::Connection object, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
  bool normalize(const Glib::RefPtr<Connection>& cnc);

  //_WRAP_METHOD(static GdaSqlStatementContentsInfo* get_contents_infos(SqlStatementType type), gda_sql_statement_get_contents_infos)


};

} // namespace Gda

} // namespace Gnome


namespace Gnome
{

namespace Gda
{

/** @relates Gnome::Gda::SqlStatement
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(SqlStatement& lhs, SqlStatement& rhs)
  { lhs.swap(rhs); }

} // namespace Gda

} // namespace Gnome

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gnome::Gda::SqlStatement
 */
Gnome::Gda::SqlStatement wrap(GdaSqlStatement* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gnome::Gda::SqlStatement> : public Glib::Value_Boxed<Gnome::Gda::SqlStatement>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _LIBGDAMM_SQLSTATEMENT_H */

