/* future.c generated by valac 0.20.1.51-7ff1, the Vala compiler
 * generated from future.vala, do not modify */

/* future.vala
 *
 * Copyright (C) 2013  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <string.h>


#define GEE_TYPE_FUTURE (gee_future_get_type ())
#define GEE_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_FUTURE, GeeFuture))
#define GEE_IS_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_FUTURE))
#define GEE_FUTURE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_FUTURE, GeeFutureIface))

typedef struct _GeeFuture GeeFuture;
typedef struct _GeeFutureIface GeeFutureIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _GeeFutureWaitAsyncData GeeFutureWaitAsyncData;

#define GEE_TYPE_MAP_FUTURE (gee_map_future_get_type ())
#define GEE_MAP_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP_FUTURE, GeeMapFuture))
#define GEE_MAP_FUTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_MAP_FUTURE, GeeMapFutureClass))
#define GEE_IS_MAP_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP_FUTURE))
#define GEE_IS_MAP_FUTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_MAP_FUTURE))
#define GEE_MAP_FUTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_MAP_FUTURE, GeeMapFutureClass))

typedef struct _GeeMapFuture GeeMapFuture;
typedef struct _GeeMapFutureClass GeeMapFutureClass;

#define GEE_TYPE_FLAT_MAP_FUTURE (gee_flat_map_future_get_type ())
#define GEE_FLAT_MAP_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_FLAT_MAP_FUTURE, GeeFlatMapFuture))
#define GEE_FLAT_MAP_FUTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_FLAT_MAP_FUTURE, GeeFlatMapFutureClass))
#define GEE_IS_FLAT_MAP_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_FLAT_MAP_FUTURE))
#define GEE_IS_FLAT_MAP_FUTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_FLAT_MAP_FUTURE))
#define GEE_FLAT_MAP_FUTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_FLAT_MAP_FUTURE, GeeFlatMapFutureClass))

typedef struct _GeeFlatMapFuture GeeFlatMapFuture;
typedef struct _GeeFlatMapFutureClass GeeFlatMapFutureClass;

#define GEE_FUTURE_TYPE_WHEN_DONE_ARRAY_ELEMENT (gee_future_when_done_array_element_get_type ())
typedef struct _GeeFutureWhenDoneArrayElement GeeFutureWhenDoneArrayElement;

typedef void (*GeeFutureWhenDoneFunc) (gconstpointer value, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef GeeFuture* (*GeeFutureFlatMapFunc) (gconstpointer value, void* user_data);
struct _GeeFutureIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeFuture* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeFuture* self);
	GDestroyNotify (*get_g_destroy_func) (GeeFuture* self);
	gconstpointer (*wait) (GeeFuture* self);
	gboolean (*wait_until) (GeeFuture* self, gint64 end_time, gconstpointer* value);
	void (*wait_async) (GeeFuture* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gconstpointer (*wait_finish) (GeeFuture* self, GAsyncResult* _res_);
	void (*when_done) (GeeFuture* self, GeeFutureWhenDoneFunc func, void* func_target);
	GeeFuture* (*map) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc func, void* func_target);
	GeeFuture* (*flatMap) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target);
	gconstpointer (*get_value) (GeeFuture* self);
	gboolean (*get_ready) (GeeFuture* self);
};

struct _Block5Data {
	int _ref_count_;
	GeeFuture * self;
	gconstpointer _result_;
	gboolean looped;
	GRecMutex mutex;
	gpointer _async_data_;
};

struct _GeeFutureWaitAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GeeFuture* self;
	gconstpointer result;
	Block5Data* _data5_;
};

struct _GeeFutureWhenDoneArrayElement {
	GeeFutureWhenDoneFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};



GType gee_future_get_type (void) G_GNUC_CONST;
gconstpointer gee_future_wait (GeeFuture* self);
gboolean gee_future_wait_until (GeeFuture* self, gint64 end_time, gconstpointer* value);
static void gee_future_real_wait_async_data_free (gpointer _data);
static void gee_future_real_wait_async (GeeFuture* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gee_future_wait_async (GeeFuture* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gconstpointer gee_future_wait_finish (GeeFuture* self, GAsyncResult* _res_);
static gboolean gee_future_real_wait_async_co (GeeFutureWaitAsyncData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
void gee_future_when_done (GeeFuture* self, GeeFutureWhenDoneFunc func, void* func_target);
static void __lambda38_ (Block5Data* _data5_, gconstpointer value);
static gboolean _gee_future_real_wait_async_co_gsource_func (gpointer self);
static void ___lambda38__gee_future_when_done_func (gconstpointer value, gpointer self);
GeeFuture* gee_future_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc func, void* func_target);
static GeeFuture* gee_future_real_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc func, void* func_target);
GeeMapFuture* gee_map_future_new (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeFuture* future_base, GeeMapFunc func, void* func_target);
GeeMapFuture* gee_map_future_construct (GType object_type, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeFuture* future_base, GeeMapFunc func, void* func_target);
GType gee_map_future_get_type (void) G_GNUC_CONST;
GeeFuture* gee_future_flatMap (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target);
static GeeFuture* gee_future_real_flatMap (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target);
GeeFlatMapFuture* gee_flat_map_future_new (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeFuture* base_future, GeeFutureFlatMapFunc func, void* func_target);
GeeFlatMapFuture* gee_flat_map_future_construct (GType object_type, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeFuture* base_future, GeeFutureFlatMapFunc func, void* func_target);
GType gee_flat_map_future_get_type (void) G_GNUC_CONST;
gconstpointer gee_future_get_value (GeeFuture* self);
gboolean gee_future_get_ready (GeeFuture* self);
GType gee_future_when_done_array_element_get_type (void) G_GNUC_CONST;
GeeFutureWhenDoneArrayElement* gee_future_when_done_array_element_dup (const GeeFutureWhenDoneArrayElement* self);
void gee_future_when_done_array_element_free (GeeFutureWhenDoneArrayElement* self);
void gee_future_when_done_array_element_copy (const GeeFutureWhenDoneArrayElement* self, GeeFutureWhenDoneArrayElement* dest);
void gee_future_when_done_array_element_destroy (GeeFutureWhenDoneArrayElement* self);
void gee_future_when_done_array_element_init (GeeFutureWhenDoneArrayElement *self, GeeFutureWhenDoneFunc func, void* func_target);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);


/**
 * Waits until the value is ready.
 *
 * @returns The {@link value} associated with future
 * @see ready
 * @see wait_until
 * @see wait_async
 */
gconstpointer gee_future_wait (GeeFuture* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_FUTURE_GET_INTERFACE (self)->wait (self);
}


/**
 * Waits until the value is ready or deadline have passed.
 *
 * @param end_time The time when the wait should finish
 * @param value The {@link value} associated with future if the wait was successful
 * @returns ``true`` if the value was ready within deadline or ``false`` otherwise
 * @see ready
 * @see wait
 * @see wait_async
 */
gboolean gee_future_wait_until (GeeFuture* self, gint64 end_time, gconstpointer* value) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_FUTURE_GET_INTERFACE (self)->wait_until (self, end_time, value);
}


static void gee_future_real_wait_async_data_free (gpointer _data) {
	GeeFutureWaitAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GeeFutureWaitAsyncData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gee_future_real_wait_async (GeeFuture* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GeeFutureWaitAsyncData* _data_;
	GeeFuture* _tmp0_ = NULL;
	_data_ = g_slice_new0 (GeeFutureWaitAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gee_future_real_wait_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gee_future_real_wait_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gee_future_real_wait_async_co (_data_);
}


static gconstpointer gee_future_real_wait_finish (GeeFuture* self, GAsyncResult* _res_) {
	gconstpointer result;
	GeeFutureWaitAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
 * Reschedules the callback until the {@link value} is available.
 *
 * @returns The {@link value} associated with future
 * @see ready
 * @see wait
 * @see wait_until
 */
static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GeeFuture * self;
		self = _data5_->self;
		_vala_clear_GRecMutex (&_data5_->mutex);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean _gee_future_real_wait_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = gee_future_real_wait_async_co (self);
	return result;
}


static void __lambda38_ (Block5Data* _data5_, gconstpointer value) {
	GeeFuture * self;
	gboolean looped_copy = FALSE;
	gboolean _tmp0_ = FALSE;
	gconstpointer _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	self = _data5_->self;
	g_rec_mutex_lock (&_data5_->mutex);
	_tmp0_ = _data5_->looped;
	looped_copy = _tmp0_;
	g_rec_mutex_unlock (&_data5_->mutex);
	_tmp1_ = value;
	_data5_->_result_ = _tmp1_;
	_tmp2_ = looped_copy;
	if (_tmp2_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _gee_future_real_wait_async_co_gsource_func, _data5_->_async_data_, NULL);
	} else {
		gee_future_real_wait_async_co (_data5_->_async_data_);
	}
}


static void ___lambda38__gee_future_when_done_func (gconstpointer value, gpointer self) {
	__lambda38_ (self, value);
	block5_data_unref (self);
}


static gboolean gee_future_real_wait_async_co (GeeFutureWaitAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_data_->_data5_->_async_data_ = _data_;
	_data_->_data5_->_result_ = NULL;
	_data_->_data5_->looped = TRUE;
	g_rec_mutex_init (&_data_->_data5_->mutex);
	g_rec_mutex_lock (&_data_->_data5_->mutex);
	gee_future_when_done (_data_->self, ___lambda38__gee_future_when_done_func, block5_data_ref (_data_->_data5_));
	_data_->_data5_->looped = FALSE;
	g_rec_mutex_unlock (&_data_->_data5_->mutex);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->result = _data_->_data5_->_result_;
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void gee_future_wait_async (GeeFuture* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GEE_FUTURE_GET_INTERFACE (self)->wait_async (self, _callback_, _user_data_);
}


gconstpointer gee_future_wait_finish (GeeFuture* self, GAsyncResult* _res_) {
	return GEE_FUTURE_GET_INTERFACE (self)->wait_finish (self, _res_);
}


/**
 * Registers a callback which is called once the future is {@link ready}.
 *
 * Note: As usually the callbacks are called from thread finishing the
 *   future it is recommended to not include lengthly computation.
 *   If one is needed please use {@link task}.
 */
void gee_future_when_done (GeeFuture* self, GeeFutureWhenDoneFunc func, void* func_target) {
	g_return_if_fail (self != NULL);
	GEE_FUTURE_GET_INTERFACE (self)->when_done (self, func, func_target);
}


/**
 * Maps a future value to another value by a function and returns the
 * another value in future.
 *
 * @param func Function applied to {@link value}
 * @returns Value returned by function
 *
 * @see flatMap
 *
 * Note: As time taken by function does not contribute to
 *   {@link wait_until} and the implementation is allowed to compute
 *   value eagerly by {@link when_done} it is recommended to use
 *   {@link task} and {@link flat_map} for longer computation.
 */
static GeeFuture* gee_future_real_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc func, void* func_target) {
	GeeFuture* result = NULL;
	GeeMapFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeMapFuture* _tmp1_ = NULL;
	_tmp0_ = func;
	_tmp0__target = func_target;
	_tmp1_ = gee_map_future_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, GEE_FUTURE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_FUTURE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_FUTURE_GET_INTERFACE (self)->get_g_destroy_func (self), self, _tmp0_, _tmp0__target);
	result = (GeeFuture*) _tmp1_;
	return result;
}


GeeFuture* gee_future_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc func, void* func_target) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_FUTURE_GET_INTERFACE (self)->map (self, a_type, a_dup_func, a_destroy_func, func, func_target);
}


/**
 * Maps a future value to another future value which is returned (call does not block).
 *
 * @param func Function applied to {@link value}
 * @param Value of a future returned by function
 *
 * @see map
 *
 * Note: As time taken by function does not contribute to
 *   {@link wait_until} and the implementation is allowed to compute
 *   value eagerly by {@link when_done} it is recommended to put the
 *   larger computation inside the returned future for example by
 *   {@link task}
 */
static GeeFuture* gee_future_real_flatMap (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target) {
	GeeFuture* result = NULL;
	GeeFutureFlatMapFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeFlatMapFuture* _tmp1_ = NULL;
	_tmp0_ = func;
	_tmp0__target = func_target;
	_tmp1_ = gee_flat_map_future_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, GEE_FUTURE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_FUTURE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_FUTURE_GET_INTERFACE (self)->get_g_destroy_func (self), self, _tmp0_, _tmp0__target);
	result = (GeeFuture*) _tmp1_;
	return result;
}


GeeFuture* gee_future_flatMap (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_FUTURE_GET_INTERFACE (self)->flatMap (self, a_type, a_dup_func, a_destroy_func, func, func_target);
}


gconstpointer gee_future_get_value (GeeFuture* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_FUTURE_GET_INTERFACE (self)->get_value (self);
}


static gconstpointer gee_future_real_get_value (GeeFuture* base) {
	gconstpointer result;
	GeeFuture* self;
	gconstpointer _tmp0_ = NULL;
	self = base;
	_tmp0_ = gee_future_wait (self);
	result = _tmp0_;
	return result;
}


gboolean gee_future_get_ready (GeeFuture* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_FUTURE_GET_INTERFACE (self)->get_ready (self);
}


void gee_future_when_done_array_element_init (GeeFutureWhenDoneArrayElement *self, GeeFutureWhenDoneFunc func, void* func_target) {
	GeeFutureWhenDoneFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	memset (self, 0, sizeof (GeeFutureWhenDoneArrayElement));
	_tmp0_ = func;
	_tmp0__target = func_target;
	((*self).func_target_destroy_notify == NULL) ? NULL : ((*self).func_target_destroy_notify ((*self).func_target), NULL);
	(*self).func = NULL;
	(*self).func_target = NULL;
	(*self).func_target_destroy_notify = NULL;
	(*self).func = _tmp0_;
	(*self).func_target = _tmp0__target;
	(*self).func_target_destroy_notify = NULL;
}


void gee_future_when_done_array_element_copy (const GeeFutureWhenDoneArrayElement* self, GeeFutureWhenDoneArrayElement* dest) {
	GeeFutureWhenDoneFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	_tmp0_ = (*self).func;
	_tmp0__target = (*self).func_target;
	((*dest).func_target_destroy_notify == NULL) ? NULL : ((*dest).func_target_destroy_notify ((*dest).func_target), NULL);
	(*dest).func = NULL;
	(*dest).func_target = NULL;
	(*dest).func_target_destroy_notify = NULL;
	(*dest).func = _tmp0_;
	(*dest).func_target = _tmp0__target;
	(*dest).func_target_destroy_notify = NULL;
}


void gee_future_when_done_array_element_destroy (GeeFutureWhenDoneArrayElement* self) {
	((*self).func_target_destroy_notify == NULL) ? NULL : ((*self).func_target_destroy_notify ((*self).func_target), NULL);
	(*self).func = NULL;
	(*self).func_target = NULL;
	(*self).func_target_destroy_notify = NULL;
}


GeeFutureWhenDoneArrayElement* gee_future_when_done_array_element_dup (const GeeFutureWhenDoneArrayElement* self) {
	GeeFutureWhenDoneArrayElement* dup;
	dup = g_new0 (GeeFutureWhenDoneArrayElement, 1);
	gee_future_when_done_array_element_copy (self, dup);
	return dup;
}


void gee_future_when_done_array_element_free (GeeFutureWhenDoneArrayElement* self) {
	gee_future_when_done_array_element_destroy (self);
	g_free (self);
}


GType gee_future_when_done_array_element_get_type (void) {
	static volatile gsize gee_future_when_done_array_element_type_id__volatile = 0;
	if (g_once_init_enter (&gee_future_when_done_array_element_type_id__volatile)) {
		GType gee_future_when_done_array_element_type_id;
		gee_future_when_done_array_element_type_id = g_boxed_type_register_static ("GeeFutureWhenDoneArrayElement", (GBoxedCopyFunc) gee_future_when_done_array_element_dup, (GBoxedFreeFunc) gee_future_when_done_array_element_free);
		g_once_init_leave (&gee_future_when_done_array_element_type_id__volatile, gee_future_when_done_array_element_type_id);
	}
	return gee_future_when_done_array_element_type_id__volatile;
}


static void gee_future_base_init (GeeFutureIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		 * Checks if value is ready. If it is calls to {@link wait} and
		 * {@link wait_until} will not block and value is returned immidiatly.
		 */
		g_object_interface_install_property (iface, g_param_spec_boolean ("ready", "ready", "ready", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		iface->wait_async = gee_future_real_wait_async;
		iface->wait_finish = gee_future_real_wait_finish;
		iface->map = gee_future_real_map;
		iface->flatMap = gee_future_real_flatMap;
		iface->get_value = gee_future_real_get_value;
	}
}


/**
 * Future is a value which might not yet be computed - for example it is calculated
 * in different thread or depends on I/O value.
 *
 * All methods can be called from many threads as part of interface.
 *
 * @see Promise
 * @see Lazy
 * @see task
 * @see async_task
 *
 * Note: Statement that call does not block does not mean that it is lock-free.
 *   Internally the implementation is allowed to take mutex but it should guarantee
 *   that it is not for a long time (including blocking on anything else, I/O calls
 *   or callbacks).
 */
GType gee_future_get_type (void) {
	static volatile gsize gee_future_type_id__volatile = 0;
	if (g_once_init_enter (&gee_future_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeFutureIface), (GBaseInitFunc) gee_future_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_future_type_id;
		gee_future_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeFuture", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_future_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_future_type_id__volatile, gee_future_type_id);
	}
	return gee_future_type_id__volatile;
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



