/* collection.c generated by valac 0.20.1.66-2886, the Vala compiler
 * generated from collection.vala, do not modify */

/* collection.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <string.h>


#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;

#define GEE_TYPE_ABSTRACT_SET (gee_abstract_set_get_type ())
#define GEE_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSet))
#define GEE_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))
#define GEE_IS_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_SET))
#define GEE_IS_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_SET))
#define GEE_ABSTRACT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))

typedef struct _GeeAbstractSet GeeAbstractSet;
typedef struct _GeeAbstractSetClass GeeAbstractSetClass;

#define GEE_TYPE_HASH_SET (gee_hash_set_get_type ())
#define GEE_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_HASH_SET, GeeHashSet))
#define GEE_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_HASH_SET, GeeHashSetClass))
#define GEE_IS_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_HASH_SET))
#define GEE_IS_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_HASH_SET))
#define GEE_HASH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_HASH_SET, GeeHashSetClass))

typedef struct _GeeHashSet GeeHashSet;
typedef struct _GeeHashSetClass GeeHashSetClass;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END,
	GEE_TRAVERSABLE_STREAM_WAIT
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
typedef GeeIterator* (*GeeFlatMapFunc) (gpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
	GeeIterator* (*flat_map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFlatMapFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator** (*tee) (GeeTraversable* self, guint forks, int* result_length1);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

typedef guint (*GeeHashDataFunc) (gconstpointer v, void* user_data);
typedef gboolean (*GeeEqualDataFunc) (gconstpointer a, gconstpointer b, void* user_data);
struct _GeeSetIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeSet* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeSet* self);
	GDestroyNotify (*get_g_destroy_func) (GeeSet* self);
	GeeSet* (*get_read_only_view) (GeeSet* self);
};



GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
gboolean gee_collection_contains (GeeCollection* self, gconstpointer item);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
gboolean gee_collection_remove (GeeCollection* self, gconstpointer item);
void gee_collection_clear (GeeCollection* self);
gboolean gee_collection_add_all (GeeCollection* self, GeeCollection* collection);
static gboolean gee_collection_real_add_all (GeeCollection* self, GeeCollection* collection);
gpointer gee_traversable_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static gboolean __lambda23_ (GeeCollection* self, gpointer item, gboolean changed);
static gpointer ___lambda23__gee_fold_func (gpointer g, gpointer a, gpointer self);
gboolean gee_collection_contains_all (GeeCollection* self, GeeCollection* collection);
static gboolean gee_collection_real_contains_all (GeeCollection* self, GeeCollection* collection);
gboolean gee_traversable_foreach (GeeTraversable* self, GeeForallFunc f, void* f_target);
static gboolean __lambda24_ (GeeCollection* self, gpointer item);
static gboolean ___lambda24__gee_forall_func (gpointer g, gpointer self);
gboolean gee_collection_remove_all (GeeCollection* self, GeeCollection* collection);
static gboolean gee_collection_real_remove_all (GeeCollection* self, GeeCollection* collection);
static gboolean __lambda25_ (GeeCollection* self, gpointer item, gboolean changed);
static gpointer ___lambda25__gee_fold_func (gpointer g, gpointer a, gpointer self);
gboolean gee_collection_retain_all (GeeCollection* self, GeeCollection* collection);
static gboolean gee_collection_real_retain_all (GeeCollection* self, GeeCollection* collection);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
void gee_iterator_remove (GeeIterator* self);
gpointer* gee_collection_to_array (GeeCollection* self, int* result_length1);
static gpointer* gee_collection_real_to_array (GeeCollection* self, int* result_length1);
static gboolean* gee_collection_to_bool_array (GeeCollection* coll, int* result_length1);
static gchar* gee_collection_to_char_array (GeeCollection* coll, int* result_length1);
static guchar* gee_collection_to_uchar_array (GeeCollection* coll, int* result_length1);
static gint* gee_collection_to_int_array (GeeCollection* coll, int* result_length1);
static guint* gee_collection_to_uint_array (GeeCollection* coll, int* result_length1);
static gint64* gee_collection_to_int64_array (GeeCollection* coll, int* result_length1);
static guint64* gee_collection_to_uint64_array (GeeCollection* coll, int* result_length1);
static glong* gee_collection_to_long_array (GeeCollection* coll, int* result_length1);
static gulong* gee_collection_to_ulong_array (GeeCollection* coll, int* result_length1);
static gfloat** gee_collection_to_float_array (GeeCollection* coll, int* result_length1);
static gdouble** gee_collection_to_double_array (GeeCollection* coll, int* result_length1);
gint gee_collection_get_size (GeeCollection* self);
gboolean gee_collection_add_all_array (GeeCollection* self, gpointer* array, int array_length1);
gboolean gee_collection_contains_all_array (GeeCollection* self, gpointer* array, int array_length1);
gboolean gee_collection_remove_all_array (GeeCollection* self, gpointer* array, int array_length1);
static gfloat* _float_dup (gfloat* self);
static gdouble* _double_dup (gdouble* self);
GeeCollection* gee_collection_empty (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeHashSet* gee_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeHashSet* gee_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_set_get_type (void) G_GNUC_CONST;
GType gee_hash_set_get_type (void) G_GNUC_CONST;
GType gee_set_get_type (void) G_GNUC_CONST;
GeeSet* gee_abstract_set_get_read_only_view (GeeAbstractSet* self);
gboolean gee_collection_get_is_empty (GeeCollection* self);
gboolean gee_collection_get_read_only (GeeCollection* self);
GeeCollection* gee_collection_get_read_only_view (GeeCollection* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Determines whether this collection contains the specified item.
 *
 * @param item the item to locate in the collection
 *
 * @return     ``true`` if item is found, ``false`` otherwise
 */
gboolean gee_collection_contains (GeeCollection* self, gconstpointer item) {
#line 51 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 51 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->contains (self, item);
#line 280 "collection.c"
}


/**
 * Adds an item to this collection. Must not be called on read-only
 * collections.
 *
 * @param item the item to add to the collection
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
gboolean gee_collection_add (GeeCollection* self, gconstpointer item) {
#line 61 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 61 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->add (self, item);
#line 297 "collection.c"
}


/**
 * Removes the first occurence of an item from this collection. Must not
 * be called on read-only collections.
 *
 * @param item the item to remove from the collection
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
gboolean gee_collection_remove (GeeCollection* self, gconstpointer item) {
#line 71 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 71 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->remove (self, item);
#line 314 "collection.c"
}


/**
 * Removes all items from this collection. Must not be called on
 * read-only collections.
 */
void gee_collection_clear (GeeCollection* self) {
#line 77 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	GEE_COLLECTION_GET_INTERFACE (self)->clear (self);
#line 327 "collection.c"
}


/**
 * Adds all items in the input collection to this collection.
 *
 * @param collection the collection which items will be added to this
 *                   collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean __lambda23_ (GeeCollection* self, gpointer item, gboolean changed) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gconstpointer _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = changed;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = item;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = gee_collection_add (self, _tmp1_);
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp0_ | _tmp2_;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	((item == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 356 "collection.c"
}


static gpointer ___lambda23__gee_fold_func (gpointer g, gpointer a, gpointer self) {
	gpointer result;
	result = __lambda23_ (self, g, a);
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 365 "collection.c"
}


static gboolean gee_collection_real_add_all (GeeCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	GeeCollection* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = collection;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_traversable_fold ((GeeTraversable*) _tmp0_, G_TYPE_BOOLEAN, NULL, NULL, ___lambda23__gee_fold_func, self, (gpointer) ((gintptr) FALSE));
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = (gboolean) ((gintptr) _tmp1_);
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 383 "collection.c"
}


gboolean gee_collection_add_all (GeeCollection* self, GeeCollection* collection) {
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->add_all (self, collection);
#line 392 "collection.c"
}


/**
 * Returns ``true`` it this collection contains all items as the input
 * collection.
 *
 * @param collection the collection which items will be compared with
 *                   this collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean __lambda24_ (GeeCollection* self, gpointer item) {
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = item;
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_contains (self, _tmp0_);
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp1_;
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	((item == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 419 "collection.c"
}


static gboolean ___lambda24__gee_forall_func (gpointer g, gpointer self) {
	gboolean result;
	result = __lambda24_ (self, g);
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 428 "collection.c"
}


static gboolean gee_collection_real_contains_all (GeeCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	GeeCollection* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 100 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = collection;
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_traversable_foreach ((GeeTraversable*) _tmp0_, ___lambda24__gee_forall_func, self);
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp1_;
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 446 "collection.c"
}


gboolean gee_collection_contains_all (GeeCollection* self, GeeCollection* collection) {
#line 100 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 100 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->contains_all (self, collection);
#line 455 "collection.c"
}


/**
 * Removes the subset of items in this collection corresponding to the
 * elments in the input collection. If there is several occurrences of
 * the same value in this collection they are decremented of the number
 * of occurrences in the input collection.
 *
 * @param collection the collection which items will be compared with
 *                   this collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean __lambda25_ (GeeCollection* self, gpointer item, gboolean changed) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gconstpointer _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = changed;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = item;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = gee_collection_remove (self, _tmp1_);
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp0_ | _tmp2_;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	((item == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 487 "collection.c"
}


static gpointer ___lambda25__gee_fold_func (gpointer g, gpointer a, gpointer self) {
	gpointer result;
	result = __lambda25_ (self, g, a);
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 496 "collection.c"
}


static gboolean gee_collection_real_remove_all (GeeCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	GeeCollection* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
#line 115 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = collection;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_traversable_fold ((GeeTraversable*) _tmp0_, G_TYPE_BOOLEAN, NULL, NULL, ___lambda25__gee_fold_func, self, (gpointer) ((gintptr) FALSE));
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = (gboolean) ((gintptr) _tmp1_);
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 514 "collection.c"
}


gboolean gee_collection_remove_all (GeeCollection* self, GeeCollection* collection) {
#line 115 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 115 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->remove_all (self, collection);
#line 523 "collection.c"
}


/**
 * Removes all items in this collection that are not contained in the input
 * collection. In other words all common items of both collections are
 * retained in this collection.
 *
 * @param collection the collection which items will be compared with
 *                   this collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean gee_collection_real_retain_all (GeeCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	gboolean changed = FALSE;
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	changed = FALSE;
#line 544 "collection.c"
	{
		GeeIterator* iter = NULL;
		GeeIterator* _tmp0_ = NULL;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) self);
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		iter = _tmp0_;
#line 552 "collection.c"
		{
			gboolean _tmp1_ = FALSE;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp1_ = TRUE;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			while (TRUE) {
#line 559 "collection.c"
				gboolean _tmp2_ = FALSE;
				GeeIterator* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				gpointer item = NULL;
				GeeIterator* _tmp5_ = NULL;
				gpointer _tmp6_ = NULL;
				GeeCollection* _tmp7_ = NULL;
				gconstpointer _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp2_ = _tmp1_;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				if (!_tmp2_) {
#line 573 "collection.c"
				}
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp1_ = FALSE;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp3_ = iter;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp4_ = gee_iterator_next (_tmp3_);
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				if (!_tmp4_) {
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					break;
#line 585 "collection.c"
				}
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp5_ = iter;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				item = _tmp6_;
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp7_ = collection;
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp8_ = item;
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp9_ = gee_collection_contains (_tmp7_, _tmp8_);
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				if (!_tmp9_) {
#line 601 "collection.c"
					GeeIterator* _tmp10_ = NULL;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					_tmp10_ = iter;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					gee_iterator_remove (_tmp10_);
#line 135 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					changed = TRUE;
#line 609 "collection.c"
				}
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				((item == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
#line 613 "collection.c"
			}
		}
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (iter);
#line 618 "collection.c"
	}
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = changed;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 624 "collection.c"
}


gboolean gee_collection_retain_all (GeeCollection* self, GeeCollection* collection) {
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->retain_all (self, collection);
#line 633 "collection.c"
}


/**
 * Returns an array containing all of items from this collection.
 *
 * @return an array containing all of items from this collection
 */
static gpointer* gee_collection_real_to_array (GeeCollection* self, int* result_length1) {
	gpointer* result = NULL;
	GType t = 0UL;
	GType _tmp0_ = 0UL;
#line 147 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	t = GEE_COLLECTION_GET_INTERFACE (self)->get_g_type (self);
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = t;
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (_tmp0_ == G_TYPE_BOOLEAN) {
#line 652 "collection.c"
		gint _tmp1_ = 0;
		gboolean* _tmp2_ = NULL;
		gpointer* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp2_ = gee_collection_to_bool_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp1_);
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp3_ = (gpointer*) _tmp2_;
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp3__length1 = _tmp1_;
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		if (result_length1) {
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			*result_length1 = _tmp3__length1;
#line 667 "collection.c"
		}
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		result = _tmp3_;
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		return result;
#line 673 "collection.c"
	} else {
		GType _tmp4_ = 0UL;
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = t;
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		if (_tmp4_ == G_TYPE_CHAR) {
#line 680 "collection.c"
			gint _tmp5_ = 0;
			gchar* _tmp6_ = NULL;
			gpointer* _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = gee_collection_to_char_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp5_);
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = (gpointer*) _tmp6_;
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7__length1 = _tmp5_;
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (result_length1) {
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				*result_length1 = _tmp7__length1;
#line 695 "collection.c"
			}
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			result = _tmp7_;
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			return result;
#line 701 "collection.c"
		} else {
			GType _tmp8_ = 0UL;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = t;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (_tmp8_ == G_TYPE_UCHAR) {
#line 708 "collection.c"
				gint _tmp9_ = 0;
				guchar* _tmp10_ = NULL;
				gpointer* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp10_ = gee_collection_to_uchar_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp9_);
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp11_ = (gpointer*) _tmp10_;
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp11__length1 = _tmp9_;
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				if (result_length1) {
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					*result_length1 = _tmp11__length1;
#line 723 "collection.c"
				}
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				result = _tmp11_;
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				return result;
#line 729 "collection.c"
			} else {
				GType _tmp12_ = 0UL;
#line 154 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp12_ = t;
#line 154 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				if (_tmp12_ == G_TYPE_INT) {
#line 736 "collection.c"
					gint _tmp13_ = 0;
					gint* _tmp14_ = NULL;
					gpointer* _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					_tmp14_ = gee_collection_to_int_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp13_);
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					_tmp15_ = (gpointer*) _tmp14_;
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					_tmp15__length1 = _tmp13_;
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					if (result_length1) {
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						*result_length1 = _tmp15__length1;
#line 751 "collection.c"
					}
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					result = _tmp15_;
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					return result;
#line 757 "collection.c"
				} else {
					GType _tmp16_ = 0UL;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					_tmp16_ = t;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					if (_tmp16_ == G_TYPE_UINT) {
#line 764 "collection.c"
						gint _tmp17_ = 0;
						guint* _tmp18_ = NULL;
						gpointer* _tmp19_ = NULL;
						gint _tmp19__length1 = 0;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						_tmp18_ = gee_collection_to_uint_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp17_);
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						_tmp19_ = (gpointer*) _tmp18_;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						_tmp19__length1 = _tmp17_;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						if (result_length1) {
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							*result_length1 = _tmp19__length1;
#line 779 "collection.c"
						}
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						result = _tmp19_;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						return result;
#line 785 "collection.c"
					} else {
						GType _tmp20_ = 0UL;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						_tmp20_ = t;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						if (_tmp20_ == G_TYPE_INT64) {
#line 792 "collection.c"
							gint _tmp21_ = 0;
							gint64* _tmp22_ = NULL;
							gpointer* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							_tmp22_ = gee_collection_to_int64_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp21_);
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							_tmp23_ = (gpointer*) _tmp22_;
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							_tmp23__length1 = _tmp21_;
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							if (result_length1) {
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								*result_length1 = _tmp23__length1;
#line 807 "collection.c"
							}
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							result = _tmp23_;
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							return result;
#line 813 "collection.c"
						} else {
							GType _tmp24_ = 0UL;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							_tmp24_ = t;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							if (_tmp24_ == G_TYPE_UINT64) {
#line 820 "collection.c"
								gint _tmp25_ = 0;
								guint64* _tmp26_ = NULL;
								gpointer* _tmp27_ = NULL;
								gint _tmp27__length1 = 0;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								_tmp26_ = gee_collection_to_uint64_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp25_);
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								_tmp27_ = (gpointer*) _tmp26_;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								_tmp27__length1 = _tmp25_;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								if (result_length1) {
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									*result_length1 = _tmp27__length1;
#line 835 "collection.c"
								}
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								result = _tmp27_;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								return result;
#line 841 "collection.c"
							} else {
								GType _tmp28_ = 0UL;
#line 162 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								_tmp28_ = t;
#line 162 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								if (_tmp28_ == G_TYPE_LONG) {
#line 848 "collection.c"
									gint _tmp29_ = 0;
									glong* _tmp30_ = NULL;
									gpointer* _tmp31_ = NULL;
									gint _tmp31__length1 = 0;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									_tmp30_ = gee_collection_to_long_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp29_);
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									_tmp31_ = (gpointer*) _tmp30_;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									_tmp31__length1 = _tmp29_;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									if (result_length1) {
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										*result_length1 = _tmp31__length1;
#line 863 "collection.c"
									}
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									result = _tmp31_;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									return result;
#line 869 "collection.c"
								} else {
									GType _tmp32_ = 0UL;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									_tmp32_ = t;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									if (_tmp32_ == G_TYPE_ULONG) {
#line 876 "collection.c"
										gint _tmp33_ = 0;
										gulong* _tmp34_ = NULL;
										gpointer* _tmp35_ = NULL;
										gint _tmp35__length1 = 0;
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										_tmp34_ = gee_collection_to_ulong_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp33_);
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										_tmp35_ = (gpointer*) _tmp34_;
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										_tmp35__length1 = _tmp33_;
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										if (result_length1) {
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											*result_length1 = _tmp35__length1;
#line 891 "collection.c"
										}
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										result = _tmp35_;
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										return result;
#line 897 "collection.c"
									} else {
										GType _tmp36_ = 0UL;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										_tmp36_ = t;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										if (_tmp36_ == G_TYPE_FLOAT) {
#line 904 "collection.c"
											gint _tmp37_ = 0;
											gfloat** _tmp38_ = NULL;
											gpointer* _tmp39_ = NULL;
											gint _tmp39__length1 = 0;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											_tmp38_ = gee_collection_to_float_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp37_);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											_tmp39_ = (gpointer*) _tmp38_;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											_tmp39__length1 = _tmp37_;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											if (result_length1) {
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												*result_length1 = _tmp39__length1;
#line 919 "collection.c"
											}
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											result = _tmp39_;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											return result;
#line 925 "collection.c"
										} else {
											GType _tmp40_ = 0UL;
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											_tmp40_ = t;
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											if (_tmp40_ == G_TYPE_DOUBLE) {
#line 932 "collection.c"
												gint _tmp41_ = 0;
												gdouble** _tmp42_ = NULL;
												gpointer* _tmp43_ = NULL;
												gint _tmp43__length1 = 0;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp42_ = gee_collection_to_double_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp41_);
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp43_ = (gpointer*) _tmp42_;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp43__length1 = _tmp41_;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												if (result_length1) {
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
													*result_length1 = _tmp43__length1;
#line 947 "collection.c"
												}
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												result = _tmp43_;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												return result;
#line 953 "collection.c"
											} else {
												gpointer* array = NULL;
												gint _tmp44_ = 0;
												gint _tmp45_ = 0;
												gpointer* _tmp46_ = NULL;
												gint array_length1 = 0;
												gint _array_size_ = 0;
												gint index = 0;
												gpointer* _tmp57_ = NULL;
												gint _tmp57__length1 = 0;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp44_ = gee_collection_get_size (self);
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp45_ = _tmp44_;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp46_ = g_new0 (gpointer, _tmp45_);
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												array = _tmp46_;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												array_length1 = _tmp45_;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_array_size_ = array_length1;
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												index = 0;
#line 978 "collection.c"
												{
													GeeIterator* _element_it = NULL;
													GeeIterator* _tmp47_ = NULL;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
													_tmp47_ = gee_iterable_iterator ((GeeIterable*) self);
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
													_element_it = _tmp47_;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
													while (TRUE) {
#line 988 "collection.c"
														GeeIterator* _tmp48_ = NULL;
														gboolean _tmp49_ = FALSE;
														gpointer element = NULL;
														GeeIterator* _tmp50_ = NULL;
														gpointer _tmp51_ = NULL;
														gpointer* _tmp52_ = NULL;
														gint _tmp52__length1 = 0;
														gint _tmp53_ = 0;
														gconstpointer _tmp54_ = NULL;
														gpointer _tmp55_ = NULL;
														gpointer _tmp56_ = NULL;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp48_ = _element_it;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp49_ = gee_iterator_next (_tmp48_);
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														if (!_tmp49_) {
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
															break;
#line 1008 "collection.c"
														}
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp50_ = _element_it;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp51_ = gee_iterator_get (_tmp50_);
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														element = _tmp51_;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp52_ = array;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp52__length1 = array_length1;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp53_ = index;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														index = _tmp53_ + 1;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp54_ = element;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp55_ = ((_tmp54_ != NULL) && (GEE_COLLECTION_GET_INTERFACE (self)->get_g_dup_func (self) != NULL)) ? GEE_COLLECTION_GET_INTERFACE (self)->get_g_dup_func (self) ((gpointer) _tmp54_) : ((gpointer) _tmp54_);
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														((_tmp52_[_tmp53_] == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (_tmp52_[_tmp53_] = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (_tmp52_[_tmp53_]), NULL));
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp52_[_tmp53_] = _tmp55_;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp56_ = _tmp52_[_tmp53_];
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														((element == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (element = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (element), NULL));
#line 1036 "collection.c"
													}
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
													_g_object_unref0 (_element_it);
#line 1040 "collection.c"
												}
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp57_ = array;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp57__length1 = array_length1;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												if (result_length1) {
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
													*result_length1 = _tmp57__length1;
#line 1050 "collection.c"
												}
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												result = _tmp57_;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												return result;
#line 1056 "collection.c"
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


gpointer* gee_collection_to_array (GeeCollection* self, int* result_length1) {
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->to_array (self, result_length1);
#line 1076 "collection.c"
}


/**
 * Adds all items in the input array to this collection.
 *
 * @param array the array which items will be added to this
 *              collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
gboolean gee_collection_add_all_array (GeeCollection* self, gpointer* array, int array_length1) {
	gboolean result = FALSE;
	gboolean changed = FALSE;
	gpointer* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	changed = FALSE;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = array;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0__length1 = array_length1;
#line 1099 "collection.c"
	{
		gpointer* item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		item_collection = _tmp0_;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		item_collection_length1 = _tmp0__length1;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		for (item_it = 0; item_it < _tmp0__length1; item_it = item_it + 1) {
#line 1111 "collection.c"
			gconstpointer item = NULL;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			item = item_collection[item_it];
#line 1115 "collection.c"
			{
				gboolean _tmp1_ = FALSE;
				gconstpointer _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp1_ = changed;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp2_ = item;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp3_ = gee_collection_add (self, _tmp2_);
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				changed = _tmp1_ | _tmp3_;
#line 1128 "collection.c"
			}
		}
	}
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = changed;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1136 "collection.c"
}


/**
 * Returns ``true`` it this collection contains all items as the input
 * array.
 *
 * @param array the array which items will be compared with
 *              this collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
gboolean gee_collection_contains_all_array (GeeCollection* self, gpointer* array, int array_length1) {
	gboolean result = FALSE;
	gpointer* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = array;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0__length1 = array_length1;
#line 1157 "collection.c"
	{
		gpointer* item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		item_collection = _tmp0_;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		item_collection_length1 = _tmp0__length1;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		for (item_it = 0; item_it < _tmp0__length1; item_it = item_it + 1) {
#line 1169 "collection.c"
			gconstpointer item = NULL;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			item = item_collection[item_it];
#line 1173 "collection.c"
			{
				gconstpointer _tmp1_ = NULL;
				gboolean _tmp2_ = FALSE;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp1_ = item;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp2_ = gee_collection_contains (self, _tmp1_);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				if (!_tmp2_) {
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					result = FALSE;
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					return result;
#line 1187 "collection.c"
				}
			}
		}
	}
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = TRUE;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1196 "collection.c"
}


/**
 * Removes the subset of items in this collection corresponding to the
 * elments in the input array. If there is several occurrences of
 * the same value in this collection they are decremented of the number
 * of occurrences in the input array.
 *
 * @param array the array which items will be compared with
 *              this collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
gboolean gee_collection_remove_all_array (GeeCollection* self, gpointer* array, int array_length1) {
	gboolean result = FALSE;
	gboolean changed = FALSE;
	gpointer* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	changed = FALSE;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = array;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0__length1 = array_length1;
#line 1222 "collection.c"
	{
		gpointer* item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		item_collection = _tmp0_;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		item_collection_length1 = _tmp0__length1;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		for (item_it = 0; item_it < _tmp0__length1; item_it = item_it + 1) {
#line 1234 "collection.c"
			gconstpointer item = NULL;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			item = item_collection[item_it];
#line 1238 "collection.c"
			{
				gboolean _tmp1_ = FALSE;
				gconstpointer _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp1_ = changed;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp2_ = item;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp3_ = gee_collection_remove (self, _tmp2_);
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				changed = _tmp1_ | _tmp3_;
#line 1251 "collection.c"
			}
		}
	}
#line 233 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = changed;
#line 233 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1259 "collection.c"
}


static gboolean* gee_collection_to_bool_array (GeeCollection* coll, int* result_length1) {
	gboolean* result = NULL;
	gboolean* array = NULL;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean* _tmp3_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint index = 0;
	gboolean* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (gboolean, _tmp2_);
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1293 "collection.c"
	{
		GeeIterator* _element_it = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1306 "collection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gboolean element = FALSE;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			gboolean* _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			gint _tmp11_ = 0;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1325 "collection.c"
			}
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = (gboolean) ((gintptr) _tmp9_);
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = array;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10__length1 = array_length1;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = index;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp11_ + 1;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = element;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_[_tmp11_] = _tmp12_;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 1347 "collection.c"
		}
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 1351 "collection.c"
	}
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14_ = array;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14__length1 = array_length1;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp14__length1;
#line 1361 "collection.c"
	}
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp14_;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1367 "collection.c"
}


static gchar* gee_collection_to_char_array (GeeCollection* coll, int* result_length1) {
	gchar* result = NULL;
	gchar* array = NULL;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint index = 0;
	gchar* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
#line 245 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (gchar, _tmp2_);
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 247 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1401 "collection.c"
	{
		GeeIterator* _element_it = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1414 "collection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gchar element = '\0';
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			gint _tmp11_ = 0;
			gchar _tmp12_ = '\0';
			gchar _tmp13_ = '\0';
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1433 "collection.c"
			}
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = (gchar) ((gintptr) _tmp9_);
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = array;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10__length1 = array_length1;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = index;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp11_ + 1;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = element;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_[_tmp11_] = _tmp12_;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 1455 "collection.c"
		}
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 1459 "collection.c"
	}
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14_ = array;
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14__length1 = array_length1;
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp14__length1;
#line 1469 "collection.c"
	}
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp14_;
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1475 "collection.c"
}


static guchar* gee_collection_to_uchar_array (GeeCollection* coll, int* result_length1) {
	guchar* result = NULL;
	guchar* array = NULL;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guchar* _tmp3_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint index = 0;
	guchar* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
#line 254 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (guchar, _tmp2_);
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1509 "collection.c"
	{
		GeeIterator* _element_it = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1522 "collection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			guchar element = '\0';
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			guchar* _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			gint _tmp11_ = 0;
			guchar _tmp12_ = '\0';
			guchar _tmp13_ = '\0';
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1541 "collection.c"
			}
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = (guchar) ((guintptr) _tmp9_);
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = array;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10__length1 = array_length1;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = index;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp11_ + 1;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = element;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_[_tmp11_] = _tmp12_;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 1563 "collection.c"
		}
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 1567 "collection.c"
	}
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14_ = array;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14__length1 = array_length1;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp14__length1;
#line 1577 "collection.c"
	}
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp14_;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1583 "collection.c"
}


static gint* gee_collection_to_int_array (GeeCollection* coll, int* result_length1) {
	gint* result = NULL;
	gint* array = NULL;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint index = 0;
	gint* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (gint, _tmp2_);
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1617 "collection.c"
	{
		GeeIterator* _element_it = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1630 "collection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gint element = 0;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			gint* _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1649 "collection.c"
			}
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = (gint) ((gintptr) _tmp9_);
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = array;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10__length1 = array_length1;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = index;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp11_ + 1;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = element;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_[_tmp11_] = _tmp12_;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 1671 "collection.c"
		}
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 1675 "collection.c"
	}
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14_ = array;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14__length1 = array_length1;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp14__length1;
#line 1685 "collection.c"
	}
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp14_;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1691 "collection.c"
}


static guint* gee_collection_to_uint_array (GeeCollection* coll, int* result_length1) {
	guint* result = NULL;
	guint* array = NULL;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint* _tmp3_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint index = 0;
	guint* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
#line 272 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (guint, _tmp2_);
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1725 "collection.c"
	{
		GeeIterator* _element_it = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1738 "collection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			guint element = 0U;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			guint* _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			gint _tmp11_ = 0;
			guint _tmp12_ = 0U;
			guint _tmp13_ = 0U;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1757 "collection.c"
			}
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = (guint) ((guintptr) _tmp9_);
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = array;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10__length1 = array_length1;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = index;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp11_ + 1;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = element;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_[_tmp11_] = _tmp12_;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 1779 "collection.c"
		}
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 1783 "collection.c"
	}
#line 278 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14_ = array;
#line 278 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14__length1 = array_length1;
#line 278 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 278 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp14__length1;
#line 1793 "collection.c"
	}
#line 278 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp14_;
#line 278 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1799 "collection.c"
}


static gint64* gee_collection_to_int64_array (GeeCollection* coll, int* result_length1) {
	gint64* result = NULL;
	gint64* array = NULL;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint64* _tmp3_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint index = 0;
	gint64* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (gint64, _tmp2_);
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 283 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1833 "collection.c"
	{
		GeeIterator* _element_it = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1846 "collection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gint64 element = 0LL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			gint64* _tmp10_ = NULL;
			gint64 _tmp11_ = 0LL;
			gint64* _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			gint _tmp13_ = 0;
			gint64 _tmp14_ = 0LL;
			gint64 _tmp15_ = 0LL;
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1867 "collection.c"
			}
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = (gint64*) _tmp9_;
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = *_tmp10_;
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_g_free0 (_tmp10_);
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = _tmp11_;
#line 285 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = array;
#line 285 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12__length1 = array_length1;
#line 285 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = index;
#line 285 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp13_ + 1;
#line 285 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp14_ = element;
#line 285 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_[_tmp13_] = _tmp14_;
#line 285 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp15_ = _tmp12_[_tmp13_];
#line 1895 "collection.c"
		}
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 1899 "collection.c"
	}
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp16_ = array;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp16__length1 = array_length1;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp16__length1;
#line 1909 "collection.c"
	}
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp16_;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1915 "collection.c"
}


static guint64* gee_collection_to_uint64_array (GeeCollection* coll, int* result_length1) {
	guint64* result = NULL;
	guint64* array = NULL;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint64* _tmp3_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint index = 0;
	guint64* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
#line 290 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 291 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 291 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 291 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 291 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (guint64, _tmp2_);
#line 291 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 291 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 291 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1949 "collection.c"
	{
		GeeIterator* _element_it = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1962 "collection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			guint64 element = 0ULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			guint64* _tmp10_ = NULL;
			guint64 _tmp11_ = 0ULL;
			guint64* _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			gint _tmp13_ = 0;
			guint64 _tmp14_ = 0ULL;
			guint64 _tmp15_ = 0ULL;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1983 "collection.c"
			}
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = (guint64*) _tmp9_;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = *_tmp10_;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_g_free0 (_tmp10_);
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = _tmp11_;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = array;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12__length1 = array_length1;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = index;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp13_ + 1;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp14_ = element;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_[_tmp13_] = _tmp14_;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp15_ = _tmp12_[_tmp13_];
#line 2011 "collection.c"
		}
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 2015 "collection.c"
	}
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp16_ = array;
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp16__length1 = array_length1;
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp16__length1;
#line 2025 "collection.c"
	}
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp16_;
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 2031 "collection.c"
}


static glong* gee_collection_to_long_array (GeeCollection* coll, int* result_length1) {
	glong* result = NULL;
	glong* array = NULL;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	glong* _tmp3_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint index = 0;
	glong* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
#line 299 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (glong, _tmp2_);
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 2065 "collection.c"
	{
		GeeIterator* _element_it = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 2078 "collection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			glong element = 0L;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			glong* _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			gint _tmp11_ = 0;
			glong _tmp12_ = 0L;
			glong _tmp13_ = 0L;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 2097 "collection.c"
			}
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = (glong) ((gintptr) _tmp9_);
#line 303 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = array;
#line 303 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10__length1 = array_length1;
#line 303 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = index;
#line 303 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp11_ + 1;
#line 303 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = element;
#line 303 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_[_tmp11_] = _tmp12_;
#line 303 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 2119 "collection.c"
		}
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 2123 "collection.c"
	}
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14_ = array;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14__length1 = array_length1;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp14__length1;
#line 2133 "collection.c"
	}
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp14_;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 2139 "collection.c"
}


static gulong* gee_collection_to_ulong_array (GeeCollection* coll, int* result_length1) {
	gulong* result = NULL;
	gulong* array = NULL;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gulong* _tmp3_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint index = 0;
	gulong* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
#line 308 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (gulong, _tmp2_);
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 310 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 2173 "collection.c"
	{
		GeeIterator* _element_it = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 2186 "collection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gulong element = 0UL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			gulong* _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			gint _tmp11_ = 0;
			gulong _tmp12_ = 0UL;
			gulong _tmp13_ = 0UL;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 2205 "collection.c"
			}
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = (gulong) ((guintptr) _tmp9_);
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = array;
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10__length1 = array_length1;
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = index;
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp11_ + 1;
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = element;
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_[_tmp11_] = _tmp12_;
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 2227 "collection.c"
		}
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 2231 "collection.c"
	}
#line 314 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14_ = array;
#line 314 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14__length1 = array_length1;
#line 314 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 314 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp14__length1;
#line 2241 "collection.c"
	}
#line 314 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp14_;
#line 314 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 2247 "collection.c"
}


static gfloat* _float_dup (gfloat* self) {
	gfloat* dup;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	dup = g_new0 (gfloat, 1);
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	memcpy (dup, self, sizeof (gfloat));
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return dup;
#line 2259 "collection.c"
}


static gpointer __float_dup0 (gpointer self) {
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return self ? _float_dup (self) : NULL;
#line 2266 "collection.c"
}


static gfloat** gee_collection_to_float_array (GeeCollection* coll, int* result_length1) {
	gfloat** result = NULL;
	gfloat** array = NULL;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gfloat** _tmp3_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint index = 0;
	gfloat** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
#line 317 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (gfloat*, _tmp2_);
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 319 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 2300 "collection.c"
	{
		GeeIterator* _element_it = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 2313 "collection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gfloat element = 0.0F;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			gfloat* _tmp10_ = NULL;
			gfloat _tmp11_ = 0.0F;
			gfloat** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			gint _tmp13_ = 0;
			gfloat _tmp14_ = 0.0F;
			gfloat* _tmp15_ = NULL;
			gfloat* _tmp16_ = NULL;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 2335 "collection.c"
			}
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = (gfloat*) _tmp9_;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = *_tmp10_;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_g_free0 (_tmp10_);
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = _tmp11_;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = array;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12__length1 = array_length1;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = index;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp13_ + 1;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp14_ = element;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp15_ = __float_dup0 (&_tmp14_);
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_g_free0 (_tmp12_[_tmp13_]);
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_[_tmp13_] = _tmp15_;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp16_ = _tmp12_[_tmp13_];
#line 2367 "collection.c"
		}
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 2371 "collection.c"
	}
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp17_ = array;
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp17__length1 = array_length1;
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp17__length1;
#line 2381 "collection.c"
	}
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp17_;
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 2387 "collection.c"
}


static gdouble* _double_dup (gdouble* self) {
	gdouble* dup;
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	dup = g_new0 (gdouble, 1);
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	memcpy (dup, self, sizeof (gdouble));
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return dup;
#line 2399 "collection.c"
}


static gpointer __double_dup0 (gpointer self) {
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return self ? _double_dup (self) : NULL;
#line 2406 "collection.c"
}


static gdouble** gee_collection_to_double_array (GeeCollection* coll, int* result_length1) {
	gdouble** result = NULL;
	gdouble** array = NULL;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gdouble** _tmp3_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint index = 0;
	gdouble** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
#line 326 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (gdouble*, _tmp2_);
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 328 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 2440 "collection.c"
	{
		GeeIterator* _element_it = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 2453 "collection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gdouble element = 0.0;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			gdouble* _tmp10_ = NULL;
			gdouble _tmp11_ = 0.0;
			gdouble** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			gint _tmp13_ = 0;
			gdouble _tmp14_ = 0.0;
			gdouble* _tmp15_ = NULL;
			gdouble* _tmp16_ = NULL;
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 2475 "collection.c"
			}
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = (gdouble*) _tmp9_;
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = *_tmp10_;
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_g_free0 (_tmp10_);
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = _tmp11_;
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = array;
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12__length1 = array_length1;
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = index;
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp13_ + 1;
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp14_ = element;
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp15_ = __double_dup0 (&_tmp14_);
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_g_free0 (_tmp12_[_tmp13_]);
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_[_tmp13_] = _tmp15_;
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp16_ = _tmp12_[_tmp13_];
#line 2507 "collection.c"
		}
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 2511 "collection.c"
	}
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp17_ = array;
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp17__length1 = array_length1;
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp17__length1;
#line 2521 "collection.c"
	}
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp17_;
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 2527 "collection.c"
}


/**
 * Returns an immutable empty collection.
 *
 * @return an immutable empty collection
 */
GeeCollection* gee_collection_empty (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GeeCollection* result = NULL;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	GeeCollection* _tmp4_ = NULL;
#line 346 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = gee_hash_set_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, NULL, NULL, NULL, NULL, NULL, NULL);
#line 346 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = _tmp0_;
#line 346 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp1_);
#line 346 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = _tmp2_;
#line 346 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp4_ = (GeeCollection*) _tmp3_;
#line 346 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_g_object_unref0 (_tmp1_);
#line 346 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp4_;
#line 346 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 2559 "collection.c"
}


gint gee_collection_get_size (GeeCollection* self) {
#line 31 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 31 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->get_size (self);
#line 2568 "collection.c"
}


gboolean gee_collection_get_is_empty (GeeCollection* self) {
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->get_is_empty (self);
#line 2577 "collection.c"
}


static gboolean gee_collection_real_get_is_empty (GeeCollection* base) {
	gboolean result;
	GeeCollection* self;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	self = base;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = gee_collection_get_size (self);
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = _tmp0_;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp1_ == 0;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 2596 "collection.c"
}


gboolean gee_collection_get_read_only (GeeCollection* self) {
#line 42 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 42 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->get_read_only (self);
#line 2605 "collection.c"
}


GeeCollection* gee_collection_get_read_only_view (GeeCollection* self) {
#line 338 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 338 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->get_read_only_view (self);
#line 2614 "collection.c"
}


static void gee_collection_base_init (GeeCollectionIface * iface) {
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	static gboolean initialized = FALSE;
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (!initialized) {
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		initialized = TRUE;
#line 2625 "collection.c"
		/**
		 * The number of items in this collection.
		 */
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		g_object_interface_install_property (iface, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2631 "collection.c"
		/**
		 * Specifies whether this collection can change - i.e. wheather {@link add},
		 * {@link remove} etc. are legal operations.
		 */
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		g_object_interface_install_property (iface, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2638 "collection.c"
		/**
		 * The read-only view of this collection.
		 */
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("read-only-view", "read-only-view", "read-only-view", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		iface->add_all = gee_collection_real_add_all;
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		iface->contains_all = gee_collection_real_contains_all;
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		iface->remove_all = gee_collection_real_remove_all;
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		iface->retain_all = gee_collection_real_retain_all;
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		iface->to_array = gee_collection_real_to_array;
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		iface->get_is_empty = gee_collection_real_get_is_empty;
#line 2656 "collection.c"
	}
}


/**
 * A generic collection of objects.
 */
GType gee_collection_get_type (void) {
	static volatile gsize gee_collection_type_id__volatile = 0;
	if (g_once_init_enter (&gee_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeCollectionIface), (GBaseInitFunc) gee_collection_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_collection_type_id;
		gee_collection_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeCollection", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_collection_type_id, GEE_TYPE_ITERABLE);
		g_once_init_leave (&gee_collection_type_id__volatile, gee_collection_type_id);
	}
	return gee_collection_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



