/* abstractmap.c generated by valac, the Vala compiler
 * generated from abstractmap.vala, do not modify */

/* abstractmap.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Tomaž Vajngerl <quikee@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_MAP (gee_map_get_type ())
#define GEE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP, GeeMap))
#define GEE_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP))
#define GEE_MAP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MAP, GeeMapIface))

typedef struct _GeeMap GeeMap;
typedef struct _GeeMapIface GeeMapIface;

#define GEE_TYPE_MAP_ITERATOR (gee_map_iterator_get_type ())
#define GEE_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP_ITERATOR, GeeMapIterator))
#define GEE_IS_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP_ITERATOR))
#define GEE_MAP_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MAP_ITERATOR, GeeMapIteratorIface))

typedef struct _GeeMapIterator GeeMapIterator;
typedef struct _GeeMapIteratorIface GeeMapIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_MAP_TYPE_ENTRY (gee_map_entry_get_type ())
#define GEE_MAP_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_MAP_TYPE_ENTRY, GeeMapEntry))
#define GEE_MAP_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_MAP_TYPE_ENTRY, GeeMapEntryClass))
#define GEE_MAP_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_MAP_TYPE_ENTRY))
#define GEE_MAP_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_MAP_TYPE_ENTRY))
#define GEE_MAP_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_MAP_TYPE_ENTRY, GeeMapEntryClass))

typedef struct _GeeMapEntry GeeMapEntry;
typedef struct _GeeMapEntryClass GeeMapEntryClass;

#define GEE_TYPE_ABSTRACT_MAP (gee_abstract_map_get_type ())
#define GEE_ABSTRACT_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap))
#define GEE_ABSTRACT_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_MAP, GeeAbstractMapClass))
#define GEE_IS_ABSTRACT_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_MAP))
#define GEE_IS_ABSTRACT_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_MAP))
#define GEE_ABSTRACT_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_MAP, GeeAbstractMapClass))

typedef struct _GeeAbstractMap GeeAbstractMap;
typedef struct _GeeAbstractMapClass GeeAbstractMapClass;
typedef struct _GeeAbstractMapPrivate GeeAbstractMapPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_TYPE_READ_ONLY_MAP (gee_read_only_map_get_type ())
#define GEE_READ_ONLY_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMap))
#define GEE_READ_ONLY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMapClass))
#define GEE_IS_READ_ONLY_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_MAP))
#define GEE_IS_READ_ONLY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_MAP))
#define GEE_READ_ONLY_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMapClass))

typedef struct _GeeReadOnlyMap GeeReadOnlyMap;
typedef struct _GeeReadOnlyMapClass GeeReadOnlyMapClass;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeMapIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeMapIterator* self);
	gboolean (*has_next) (GeeMapIterator* self);
	gboolean (*first) (GeeMapIterator* self);
	gpointer (*get_key) (GeeMapIterator* self);
	gpointer (*get_value) (GeeMapIterator* self);
	void (*set_value) (GeeMapIterator* self, gconstpointer value);
	void (*unset) (GeeMapIterator* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_read_only_view) (GeeSet* self);
};

struct _GeeMapIface {
	GTypeInterface parent_iface;
	gboolean (*has_key) (GeeMap* self, gconstpointer key);
	gboolean (*contains) (GeeMap* self, gconstpointer key);
	gboolean (*has) (GeeMap* self, gconstpointer key, gconstpointer value);
	gpointer (*get) (GeeMap* self, gconstpointer key);
	void (*set) (GeeMap* self, gconstpointer key, gconstpointer value);
	gboolean (*unset) (GeeMap* self, gconstpointer key, gpointer* value);
	gboolean (*remove) (GeeMap* self, gconstpointer key, gpointer* value);
	void (*clear) (GeeMap* self);
	GeeMapIterator* (*map_iterator) (GeeMap* self);
	void (*set_all) (GeeMap* self, GeeMap* map);
	gboolean (*unset_all) (GeeMap* self, GeeMap* map);
	gboolean (*remove_all) (GeeMap* self, GeeMap* map);
	gboolean (*has_all) (GeeMap* self, GeeMap* map);
	gboolean (*contains_all) (GeeMap* self, GeeMap* map);
	gint (*get_size) (GeeMap* self);
	gboolean (*get_is_empty) (GeeMap* self);
	GeeSet* (*get_keys) (GeeMap* self);
	GeeCollection* (*get_values) (GeeMap* self);
	GeeSet* (*get_entries) (GeeMap* self);
	GeeMap* (*get_read_only_view) (GeeMap* self);
	GType (*get_key_type) (GeeMap* self);
	GType (*get_value_type) (GeeMap* self);
};

struct _GeeAbstractMap {
	GObject parent_instance;
	GeeAbstractMapPrivate * priv;
};

struct _GeeAbstractMapClass {
	GObjectClass parent_class;
	gboolean (*has_key) (GeeAbstractMap* self, gconstpointer key);
	gboolean (*has) (GeeAbstractMap* self, gconstpointer key, gconstpointer value);
	gpointer (*get) (GeeAbstractMap* self, gconstpointer key);
	void (*set) (GeeAbstractMap* self, gconstpointer key, gconstpointer value);
	gboolean (*unset) (GeeAbstractMap* self, gconstpointer key, gpointer* value);
	GeeMapIterator* (*map_iterator) (GeeAbstractMap* self);
	void (*clear) (GeeAbstractMap* self);
	void (*set_all) (GeeAbstractMap* self, GeeMap* map);
	gboolean (*unset_all) (GeeAbstractMap* self, GeeMap* map);
	gboolean (*has_all) (GeeAbstractMap* self, GeeMap* map);
	gint (*get_size) (GeeAbstractMap* self);
	gboolean (*get_is_empty) (GeeAbstractMap* self);
	GeeSet* (*get_keys) (GeeAbstractMap* self);
	GeeCollection* (*get_values) (GeeAbstractMap* self);
	GeeSet* (*get_entries) (GeeAbstractMap* self);
	GeeMap* (*get_read_only_view) (GeeAbstractMap* self);
};

struct _GeeAbstractMapPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	GeeMap* _read_only_view;
};


static gpointer gee_abstract_map_parent_class = NULL;
static GeeIterableIface* gee_abstract_map_gee_iterable_parent_iface = NULL;
static GeeMapIface* gee_abstract_map_gee_map_parent_iface = NULL;

GType gee_iterator_get_type (void);
GType gee_iterable_get_type (void);
GType gee_map_iterator_get_type (void);
GType gee_collection_get_type (void);
GType gee_set_get_type (void);
GType gee_map_entry_get_type (void);
GType gee_map_get_type (void);
GType gee_abstract_map_get_type (void);
#define GEE_ABSTRACT_MAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ABSTRACT_MAP, GeeAbstractMapPrivate))
enum  {
	GEE_ABSTRACT_MAP_DUMMY_PROPERTY,
	GEE_ABSTRACT_MAP_SIZE,
	GEE_ABSTRACT_MAP_IS_EMPTY,
	GEE_ABSTRACT_MAP_KEYS,
	GEE_ABSTRACT_MAP_VALUES,
	GEE_ABSTRACT_MAP_ENTRIES,
	GEE_ABSTRACT_MAP_READ_ONLY_VIEW,
	GEE_ABSTRACT_MAP_KEY_TYPE,
	GEE_ABSTRACT_MAP_VALUE_TYPE,
	GEE_ABSTRACT_MAP_ELEMENT_TYPE,
	GEE_ABSTRACT_MAP_K_TYPE,
	GEE_ABSTRACT_MAP_K_DUP_FUNC,
	GEE_ABSTRACT_MAP_K_DESTROY_FUNC,
	GEE_ABSTRACT_MAP_V_TYPE,
	GEE_ABSTRACT_MAP_V_DUP_FUNC,
	GEE_ABSTRACT_MAP_V_DESTROY_FUNC
};
gboolean gee_abstract_map_has_key (GeeAbstractMap* self, gconstpointer key);
static gboolean gee_abstract_map_real_has_key (GeeAbstractMap* self, gconstpointer key);
static gboolean gee_abstract_map_real_contains (GeeMap* base, gconstpointer key);
gboolean gee_abstract_map_has (GeeAbstractMap* self, gconstpointer key, gconstpointer value);
static gboolean gee_abstract_map_real_has (GeeAbstractMap* self, gconstpointer key, gconstpointer value);
gpointer gee_abstract_map_get (GeeAbstractMap* self, gconstpointer key);
static gpointer gee_abstract_map_real_get (GeeAbstractMap* self, gconstpointer key);
void gee_abstract_map_set (GeeAbstractMap* self, gconstpointer key, gconstpointer value);
static void gee_abstract_map_real_set (GeeAbstractMap* self, gconstpointer key, gconstpointer value);
gboolean gee_abstract_map_unset (GeeAbstractMap* self, gconstpointer key, gpointer* value);
static gboolean gee_abstract_map_real_unset (GeeAbstractMap* self, gconstpointer key, gpointer* value);
GeeMapIterator* gee_abstract_map_map_iterator (GeeAbstractMap* self);
static GeeMapIterator* gee_abstract_map_real_map_iterator (GeeAbstractMap* self);
static gboolean gee_abstract_map_real_remove (GeeMap* base, gconstpointer key, gpointer* value);
void gee_abstract_map_clear (GeeAbstractMap* self);
static void gee_abstract_map_real_clear (GeeAbstractMap* self);
GeeSet* gee_map_get_entries (GeeMap* self);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
gconstpointer gee_map_entry_get_key (GeeMapEntry* self);
gconstpointer gee_map_entry_get_value (GeeMapEntry* self);
void gee_abstract_map_set_all (GeeAbstractMap* self, GeeMap* map);
static void gee_abstract_map_real_set_all (GeeAbstractMap* self, GeeMap* map);
GeeSet* gee_map_get_keys (GeeMap* self);
gboolean gee_map_remove (GeeMap* self, gconstpointer key, gpointer* value);
gboolean gee_abstract_map_unset_all (GeeAbstractMap* self, GeeMap* map);
static gboolean gee_abstract_map_real_unset_all (GeeAbstractMap* self, GeeMap* map);
static gboolean gee_abstract_map_real_remove_all (GeeMap* base, GeeMap* map);
gboolean gee_abstract_map_has_all (GeeAbstractMap* self, GeeMap* map);
static gboolean gee_abstract_map_real_has_all (GeeAbstractMap* self, GeeMap* map);
static gboolean gee_abstract_map_real_contains_all (GeeMap* base, GeeMap* map);
static GeeIterator* gee_abstract_map_real_iterator (GeeIterable* base);
GeeAbstractMap* gee_abstract_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func);
gint gee_abstract_map_get_size (GeeAbstractMap* self);
gint gee_map_get_size (GeeMap* self);
gboolean gee_abstract_map_get_is_empty (GeeAbstractMap* self);
GeeSet* gee_abstract_map_get_keys (GeeAbstractMap* self);
GeeCollection* gee_abstract_map_get_values (GeeAbstractMap* self);
GeeSet* gee_abstract_map_get_entries (GeeAbstractMap* self);
GeeReadOnlyMap* gee_read_only_map_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMap* map);
GeeReadOnlyMap* gee_read_only_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMap* map);
GType gee_read_only_map_get_type (void);
GeeMap* gee_abstract_map_get_read_only_view (GeeAbstractMap* self);
static void gee_abstract_map_finalize (GObject* obj);
GType gee_map_get_key_type (GeeMap* self);
GType gee_map_get_value_type (GeeMap* self);
GType gee_iterable_get_element_type (GeeIterable* self);
static void gee_abstract_map_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_abstract_map_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static gboolean gee_abstract_map_real_has_key (GeeAbstractMap* self, gconstpointer key) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_map_has_key'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean gee_abstract_map_has_key (GeeAbstractMap* self, gconstpointer key) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->has_key (self, key);
}


static gboolean gee_abstract_map_real_contains (GeeMap* base, gconstpointer key) {
	GeeAbstractMap * self;
	gboolean result = FALSE;
	self = (GeeAbstractMap*) base;
	result = gee_abstract_map_has_key (self, key);
	return result;
}


static gboolean gee_abstract_map_real_has (GeeAbstractMap* self, gconstpointer key, gconstpointer value) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_map_has'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean gee_abstract_map_has (GeeAbstractMap* self, gconstpointer key, gconstpointer value) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->has (self, key, value);
}


static gpointer gee_abstract_map_real_get (GeeAbstractMap* self, gconstpointer key) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_map_get'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gpointer gee_abstract_map_get (GeeAbstractMap* self, gconstpointer key) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->get (self, key);
}


static void gee_abstract_map_real_set (GeeAbstractMap* self, gconstpointer key, gconstpointer value) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_map_set'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void gee_abstract_map_set (GeeAbstractMap* self, gconstpointer key, gconstpointer value) {
	GEE_ABSTRACT_MAP_GET_CLASS (self)->set (self, key, value);
}


static gboolean gee_abstract_map_real_unset (GeeAbstractMap* self, gconstpointer key, gpointer* value) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_map_unset'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean gee_abstract_map_unset (GeeAbstractMap* self, gconstpointer key, gpointer* value) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->unset (self, key, value);
}


static GeeMapIterator* gee_abstract_map_real_map_iterator (GeeAbstractMap* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_map_map_iterator'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeMapIterator* gee_abstract_map_map_iterator (GeeAbstractMap* self) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->map_iterator (self);
}


static gboolean gee_abstract_map_real_remove (GeeMap* base, gconstpointer key, gpointer* value) {
	GeeAbstractMap * self;
	gboolean result = FALSE;
	gpointer removed_value;
	gpointer _tmp2_;
	gboolean _tmp1_;
	gpointer _tmp0_ = NULL;
	gboolean _result_;
	self = (GeeAbstractMap*) base;
	removed_value = NULL;
	_result_ = (_tmp1_ = gee_abstract_map_unset (self, key, &_tmp0_), removed_value = (_tmp2_ = _tmp0_, ((removed_value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (removed_value = (self->priv->v_destroy_func (removed_value), NULL)), _tmp2_), _tmp1_);
	if ((value) != NULL) {
		gpointer _tmp4_;
		gconstpointer _tmp3_;
		*value = (_tmp4_ = (_tmp3_ = removed_value, ((_tmp3_ == NULL) || (self->priv->v_dup_func == NULL)) ? ((gpointer) _tmp3_) : self->priv->v_dup_func ((gpointer) _tmp3_)), (((*value) == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (*value = (self->priv->v_destroy_func (*value), NULL)), _tmp4_);
	}
	result = _result_;
	((removed_value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (removed_value = (self->priv->v_destroy_func (removed_value), NULL));
	return result;
}


static void gee_abstract_map_real_clear (GeeAbstractMap* self) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_map_clear'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void gee_abstract_map_clear (GeeAbstractMap* self) {
	GEE_ABSTRACT_MAP_GET_CLASS (self)->clear (self);
}


static void gee_abstract_map_real_set_all (GeeAbstractMap* self, GeeMap* map) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (map != NULL);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _entry_it;
		_entry_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_entries (map))), _g_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			GeeMapEntry* entry;
			if (!gee_iterator_next (_entry_it)) {
				break;
			}
			entry = (GeeMapEntry*) gee_iterator_get (_entry_it);
			gee_abstract_map_set (self, gee_map_entry_get_key (entry), gee_map_entry_get_value (entry));
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
}


void gee_abstract_map_set_all (GeeAbstractMap* self, GeeMap* map) {
	GEE_ABSTRACT_MAP_GET_CLASS (self)->set_all (self, map);
}


static gboolean gee_abstract_map_real_unset_all (GeeAbstractMap* self, GeeMap* map) {
	gboolean result = FALSE;
	gboolean changed;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (map != NULL, FALSE);
	changed = FALSE;
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _key_it;
		_key_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys (map))), _g_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			gpointer key;
			if (!gee_iterator_next (_key_it)) {
				break;
			}
			key = gee_iterator_get (_key_it);
			changed = changed | gee_map_remove ((GeeMap*) self, key, NULL);
			((key == NULL) || (self->priv->k_destroy_func == NULL)) ? NULL : (key = (self->priv->k_destroy_func (key), NULL));
		}
		_g_object_unref0 (_key_it);
	}
	result = changed;
	return result;
}


gboolean gee_abstract_map_unset_all (GeeAbstractMap* self, GeeMap* map) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->unset_all (self, map);
}


static gboolean gee_abstract_map_real_remove_all (GeeMap* base, GeeMap* map) {
	GeeAbstractMap * self;
	gboolean result = FALSE;
	self = (GeeAbstractMap*) base;
	g_return_val_if_fail (map != NULL, FALSE);
	result = gee_abstract_map_unset_all (self, map);
	return result;
}


static gboolean gee_abstract_map_real_has_all (GeeAbstractMap* self, GeeMap* map) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (map != NULL, FALSE);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _entry_it;
		_entry_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_entries (map))), _g_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			GeeMapEntry* entry;
			if (!gee_iterator_next (_entry_it)) {
				break;
			}
			entry = (GeeMapEntry*) gee_iterator_get (_entry_it);
			if (!gee_abstract_map_has (self, gee_map_entry_get_key (entry), gee_map_entry_get_value (entry))) {
				result = FALSE;
				_g_object_unref0 (entry);
				_g_object_unref0 (_entry_it);
				return result;
			}
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	result = TRUE;
	return result;
}


gboolean gee_abstract_map_has_all (GeeAbstractMap* self, GeeMap* map) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->has_all (self, map);
}


static gboolean gee_abstract_map_real_contains_all (GeeMap* base, GeeMap* map) {
	GeeAbstractMap * self;
	gboolean result = FALSE;
	self = (GeeAbstractMap*) base;
	g_return_val_if_fail (map != NULL, FALSE);
	result = gee_abstract_map_has_all (self, map);
	return result;
}


static GeeIterator* gee_abstract_map_real_iterator (GeeIterable* base) {
	GeeAbstractMap * self;
	GeeIterator* result = NULL;
	GeeSet* _tmp0_;
	GeeIterator* _tmp1_;
	self = (GeeAbstractMap*) base;
	result = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_entries ((GeeMap*) self))), _g_object_unref0 (_tmp0_), _tmp1_);
	return result;
}


GeeAbstractMap* gee_abstract_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func) {
	GeeAbstractMap * self;
	self = (GeeAbstractMap*) g_object_new (object_type, NULL);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	return self;
}


gint gee_abstract_map_get_size (GeeAbstractMap* self) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->get_size (self);
}


gboolean gee_abstract_map_get_is_empty (GeeAbstractMap* self) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->get_is_empty (self);
}


static gboolean gee_abstract_map_real_get_is_empty (GeeAbstractMap* base) {
	gboolean result;
	GeeAbstractMap* self;
	self = base;
	result = gee_map_get_size ((GeeMap*) self) == 0;
	return result;
}


GeeSet* gee_abstract_map_get_keys (GeeAbstractMap* self) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->get_keys (self);
}


GeeCollection* gee_abstract_map_get_values (GeeAbstractMap* self) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->get_values (self);
}


GeeSet* gee_abstract_map_get_entries (GeeAbstractMap* self) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->get_entries (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GeeMap* gee_abstract_map_get_read_only_view (GeeAbstractMap* self) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->get_read_only_view (self);
}


static GeeMap* gee_abstract_map_real_get_read_only_view (GeeAbstractMap* base) {
	GeeMap* result;
	GeeAbstractMap* self;
	GeeMap* instance;
	self = base;
	instance = _g_object_ref0 (self->priv->_read_only_view);
	if (self->priv->_read_only_view == NULL) {
		GeeMap* _tmp0_;
		instance = (_tmp0_ = (GeeMap*) gee_read_only_map_new (self->priv->k_type, (GBoxedCopyFunc) self->priv->k_dup_func, self->priv->k_destroy_func, self->priv->v_type, (GBoxedCopyFunc) self->priv->v_dup_func, self->priv->v_destroy_func, (GeeMap*) self), _g_object_unref0 (instance), _tmp0_);
		self->priv->_read_only_view = instance;
		g_object_add_weak_pointer ((GObject*) instance, (void**) (&self->priv->_read_only_view));
	}
	result = instance;
	return result;
}


static GType gee_abstract_map_real_get_key_type (GeeMap* base) {
	GType result;
	GeeAbstractMap* self;
	self = (GeeAbstractMap*) base;
	result = self->priv->k_type;
	return result;
}


static GType gee_abstract_map_real_get_value_type (GeeMap* base) {
	GType result;
	GeeAbstractMap* self;
	self = (GeeAbstractMap*) base;
	result = self->priv->v_type;
	return result;
}


static GType gee_abstract_map_real_get_element_type (GeeIterable* base) {
	GType result;
	GeeAbstractMap* self;
	self = (GeeAbstractMap*) base;
	result = GEE_MAP_TYPE_ENTRY;
	return result;
}


static void gee_abstract_map_class_init (GeeAbstractMapClass * klass) {
	gee_abstract_map_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeAbstractMapPrivate));
	GEE_ABSTRACT_MAP_CLASS (klass)->has_key = gee_abstract_map_real_has_key;
	GEE_ABSTRACT_MAP_CLASS (klass)->has = gee_abstract_map_real_has;
	GEE_ABSTRACT_MAP_CLASS (klass)->get = gee_abstract_map_real_get;
	GEE_ABSTRACT_MAP_CLASS (klass)->set = gee_abstract_map_real_set;
	GEE_ABSTRACT_MAP_CLASS (klass)->unset = gee_abstract_map_real_unset;
	GEE_ABSTRACT_MAP_CLASS (klass)->map_iterator = gee_abstract_map_real_map_iterator;
	GEE_ABSTRACT_MAP_CLASS (klass)->clear = gee_abstract_map_real_clear;
	GEE_ABSTRACT_MAP_CLASS (klass)->set_all = gee_abstract_map_real_set_all;
	GEE_ABSTRACT_MAP_CLASS (klass)->unset_all = gee_abstract_map_real_unset_all;
	GEE_ABSTRACT_MAP_CLASS (klass)->has_all = gee_abstract_map_real_has_all;
	GEE_ABSTRACT_MAP_CLASS (klass)->get_is_empty = gee_abstract_map_real_get_is_empty;
	GEE_ABSTRACT_MAP_CLASS (klass)->get_read_only_view = gee_abstract_map_real_get_read_only_view;
	G_OBJECT_CLASS (klass)->get_property = gee_abstract_map_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_abstract_map_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_abstract_map_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_K_TYPE, g_param_spec_gtype ("k-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_K_DUP_FUNC, g_param_spec_pointer ("k-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_K_DESTROY_FUNC, g_param_spec_pointer ("k-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_V_TYPE, g_param_spec_gtype ("v-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_V_DUP_FUNC, g_param_spec_pointer ("v-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_V_DESTROY_FUNC, g_param_spec_pointer ("v-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_SIZE, "size");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_IS_EMPTY, "is-empty");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_KEYS, "keys");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_VALUES, "values");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_ENTRIES, "entries");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_READ_ONLY_VIEW, "read-only-view");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_KEY_TYPE, "key-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_VALUE_TYPE, "value-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_ELEMENT_TYPE, "element-type");
}


static void gee_abstract_map_gee_iterable_interface_init (GeeIterableIface * iface) {
	gee_abstract_map_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = gee_abstract_map_real_iterator;
	iface->get_element_type = gee_abstract_map_real_get_element_type;
}


static void gee_abstract_map_gee_map_interface_init (GeeMapIface * iface) {
	gee_abstract_map_gee_map_parent_iface = g_type_interface_peek_parent (iface);
	iface->has_key = (gboolean (*)(GeeMap* ,gconstpointer)) gee_abstract_map_has_key;
	iface->contains = gee_abstract_map_real_contains;
	iface->has = (gboolean (*)(GeeMap* ,gconstpointer ,gconstpointer)) gee_abstract_map_has;
	iface->get = (gpointer (*)(GeeMap* ,gconstpointer)) gee_abstract_map_get;
	iface->set = (void (*)(GeeMap* ,gconstpointer ,gconstpointer)) gee_abstract_map_set;
	iface->unset = (gboolean (*)(GeeMap* ,gconstpointer ,gpointer*)) gee_abstract_map_unset;
	iface->map_iterator = (GeeMapIterator* (*)(GeeMap*)) gee_abstract_map_map_iterator;
	iface->remove = gee_abstract_map_real_remove;
	iface->clear = (void (*)(GeeMap*)) gee_abstract_map_clear;
	iface->set_all = (void (*)(GeeMap* ,GeeMap*)) gee_abstract_map_set_all;
	iface->unset_all = (gboolean (*)(GeeMap* ,GeeMap*)) gee_abstract_map_unset_all;
	iface->remove_all = gee_abstract_map_real_remove_all;
	iface->has_all = (gboolean (*)(GeeMap* ,GeeMap*)) gee_abstract_map_has_all;
	iface->contains_all = gee_abstract_map_real_contains_all;
	iface->get_size = (gint (*) (GeeMap *)) gee_abstract_map_get_size;
	iface->get_is_empty = (gboolean (*) (GeeMap *)) gee_abstract_map_get_is_empty;
	iface->get_keys = (GeeSet* (*) (GeeMap *)) gee_abstract_map_get_keys;
	iface->get_values = (GeeCollection* (*) (GeeMap *)) gee_abstract_map_get_values;
	iface->get_entries = (GeeSet* (*) (GeeMap *)) gee_abstract_map_get_entries;
	iface->get_read_only_view = (GeeMap* (*) (GeeMap *)) gee_abstract_map_get_read_only_view;
	iface->get_key_type = gee_abstract_map_real_get_key_type;
	iface->get_value_type = gee_abstract_map_real_get_value_type;
}


static void gee_abstract_map_instance_init (GeeAbstractMap * self) {
	self->priv = GEE_ABSTRACT_MAP_GET_PRIVATE (self);
}


static void gee_abstract_map_finalize (GObject* obj) {
	GeeAbstractMap * self;
	self = GEE_ABSTRACT_MAP (obj);
	G_OBJECT_CLASS (gee_abstract_map_parent_class)->finalize (obj);
}


GType gee_abstract_map_get_type (void) {
	static volatile gsize gee_abstract_map_type_id__volatile = 0;
	if (g_once_init_enter (&gee_abstract_map_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeAbstractMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_abstract_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeAbstractMap), 0, (GInstanceInitFunc) gee_abstract_map_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) gee_abstract_map_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_map_info = { (GInterfaceInitFunc) gee_abstract_map_gee_map_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_abstract_map_type_id;
		gee_abstract_map_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeAbstractMap", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (gee_abstract_map_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (gee_abstract_map_type_id, GEE_TYPE_MAP, &gee_map_info);
		g_once_init_leave (&gee_abstract_map_type_id__volatile, gee_abstract_map_type_id);
	}
	return gee_abstract_map_type_id__volatile;
}


static void gee_abstract_map_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeAbstractMap * self;
	self = GEE_ABSTRACT_MAP (object);
	switch (property_id) {
		case GEE_ABSTRACT_MAP_IS_EMPTY:
		g_value_set_boolean (value, gee_abstract_map_get_is_empty (self));
		break;
		case GEE_ABSTRACT_MAP_READ_ONLY_VIEW:
		g_value_take_object (value, gee_abstract_map_get_read_only_view (self));
		break;
		case GEE_ABSTRACT_MAP_KEY_TYPE:
		g_value_set_gtype (value, gee_map_get_key_type ((GeeMap*) self));
		break;
		case GEE_ABSTRACT_MAP_VALUE_TYPE:
		g_value_set_gtype (value, gee_map_get_value_type ((GeeMap*) self));
		break;
		case GEE_ABSTRACT_MAP_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_iterable_get_element_type ((GeeIterable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_abstract_map_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeAbstractMap * self;
	self = GEE_ABSTRACT_MAP (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_ABSTRACT_MAP_K_TYPE:
		self->priv->k_type = g_value_get_gtype (value);
		break;
		case GEE_ABSTRACT_MAP_K_DUP_FUNC:
		self->priv->k_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_MAP_K_DESTROY_FUNC:
		self->priv->k_destroy_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_MAP_V_TYPE:
		self->priv->v_type = g_value_get_gtype (value);
		break;
		case GEE_ABSTRACT_MAP_V_DUP_FUNC:
		self->priv->v_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_MAP_V_DESTROY_FUNC:
		self->priv->v_destroy_func = g_value_get_pointer (value);
		break;
	}
}




