/* functions.c generated by valac 0.14.0.19-a786, the Vala compiler
 * generated from functions.vala, do not modify */

/* functions.vala
 *
 * Copyright (C) 2009  Didier Villevalois, Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_COMPARABLE (gee_comparable_get_type ())
#define GEE_COMPARABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COMPARABLE, GeeComparable))
#define GEE_IS_COMPARABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COMPARABLE))
#define GEE_COMPARABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COMPARABLE, GeeComparableIface))

typedef struct _GeeComparable GeeComparable;
typedef struct _GeeComparableIface GeeComparableIface;

struct _GeeComparableIface {
	GTypeInterface parent_iface;
	gint (*compare_to) (GeeComparable* self, gconstpointer object);
};



GEqualFunc gee_functions_get_equal_func_for (GType t);
GHashFunc gee_functions_get_hash_func_for (GType t);
GCompareFunc gee_functions_get_compare_func_for (GType t);
GType gee_comparable_get_type (void) G_GNUC_CONST;
gint gee_comparable_compare_to (GeeComparable* self, gconstpointer object);
gint gee_direct_compare (void* _val1, void* _val2);


/**
 * Get a equality testing function for a given type.
 *
 * @param t the type which to get an equality testing function for.
 *
 * @return the equality testing function corresponding to the given type.
 */
GEqualFunc gee_functions_get_equal_func_for (GType t) {
	GEqualFunc result = NULL;
	GType _tmp0_;
	_tmp0_ = t;
	if (_tmp0_ == G_TYPE_STRING) {
		GEqualFunc _tmp1_;
		_tmp1_ = g_str_equal;
		result = _tmp1_;
		return result;
	} else {
		GEqualFunc _tmp2_;
		_tmp2_ = g_direct_equal;
		result = _tmp2_;
		return result;
	}
}


/**
 * Get a hash function for a given type.
 *
 * @param t the type which to get the hash function for.
 *
 * @return the hash function corresponding to the given type.
 */
GHashFunc gee_functions_get_hash_func_for (GType t) {
	GHashFunc result = NULL;
	GType _tmp0_;
	_tmp0_ = t;
	if (_tmp0_ == G_TYPE_STRING) {
		GHashFunc _tmp1_;
		_tmp1_ = g_str_hash;
		result = _tmp1_;
		return result;
	} else {
		GHashFunc _tmp2_;
		_tmp2_ = g_direct_hash;
		result = _tmp2_;
		return result;
	}
}


/**
 * Get a comparator function for a given type.
 *
 * @param t the type which to get a comparator function for.
 *
 * @return the comparator function corresponding to the given type.
 */
GCompareFunc gee_functions_get_compare_func_for (GType t) {
	GCompareFunc result = NULL;
	GType _tmp0_;
	_tmp0_ = t;
	if (_tmp0_ == G_TYPE_STRING) {
		GCompareFunc _tmp1_;
		_tmp1_ = g_strcmp0;
		result = (GCompareFunc) _tmp1_;
		return result;
	} else {
		GType _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = t;
		_tmp3_ = g_type_is_a (_tmp2_, GEE_TYPE_COMPARABLE);
		if (_tmp3_) {
			result = (GCompareFunc) gee_comparable_compare_to;
			return result;
		} else {
			result = (GCompareFunc) gee_direct_compare;
			return result;
		}
	}
}


/**
 * Compares two arbitrary elements together.
 *
 * The comparison is done on pointers and not on values behind.
 *
 * @param _val1 the first value to compare.
 * @param _val2 the second value to compare.
 *
 * @return a negative value if _val1 is lesser than _val2, a positive value
 *         if _val1 is greater then _val2 and zero if both are equal.
 */
gint gee_direct_compare (void* _val1, void* _val2) {
	gint result = 0;
	void* _tmp0_;
	glong val1;
	void* _tmp1_;
	glong val2;
	glong _tmp2_;
	glong _tmp3_;
	_tmp0_ = _val1;
	val1 = (glong) _tmp0_;
	_tmp1_ = _val2;
	val2 = (glong) _tmp1_;
	_tmp2_ = val1;
	_tmp3_ = val2;
	if (_tmp2_ > _tmp3_) {
		result = 1;
		return result;
	} else {
		glong _tmp4_;
		glong _tmp5_;
		_tmp4_ = val1;
		_tmp5_ = val2;
		if (_tmp4_ == _tmp5_) {
			result = 0;
			return result;
		} else {
			result = -1;
			return result;
		}
	}
}



