/* mapiterator.c generated by valac 0.18.0.57-8d977, the Vala compiler
 * generated from mapiterator.vala, do not modify */

/* mapiterator.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_MAP_ITERATOR (gee_map_iterator_get_type ())
#define GEE_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP_ITERATOR, GeeMapIterator))
#define GEE_IS_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP_ITERATOR))
#define GEE_MAP_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MAP_ITERATOR, GeeMapIteratorIface))

typedef struct _GeeMapIterator GeeMapIterator;
typedef struct _GeeMapIteratorIface GeeMapIteratorIface;

struct _GeeMapIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeMapIterator* self);
	gboolean (*has_next) (GeeMapIterator* self);
	gboolean (*first) (GeeMapIterator* self);
	gpointer (*get_key) (GeeMapIterator* self);
	gpointer (*get_value) (GeeMapIterator* self);
	void (*set_value) (GeeMapIterator* self, gconstpointer value);
	void (*unset) (GeeMapIterator* self);
};



GType gee_map_iterator_get_type (void) G_GNUC_CONST;
gboolean gee_map_iterator_next (GeeMapIterator* self);
gboolean gee_map_iterator_has_next (GeeMapIterator* self);
gboolean gee_map_iterator_first (GeeMapIterator* self);
gpointer gee_map_iterator_get_key (GeeMapIterator* self);
gpointer gee_map_iterator_get_value (GeeMapIterator* self);
void gee_map_iterator_set_value (GeeMapIterator* self, gconstpointer value);
void gee_map_iterator_unset (GeeMapIterator* self);


/**
 * Advances to the next entry in the iteration.
 *
 * @return ``true`` if the iterator has a next entry
 */
gboolean gee_map_iterator_next (GeeMapIterator* self) {
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	return GEE_MAP_ITERATOR_GET_INTERFACE (self)->next (self);
#line 72 "mapiterator.c"
}


/**
 * Checks whether there is a next entry in the iteration.
 *
 * @return ``true`` if the iterator has a next entry
 */
gboolean gee_map_iterator_has_next (GeeMapIterator* self) {
#line 48 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 48 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	return GEE_MAP_ITERATOR_GET_INTERFACE (self)->has_next (self);
#line 86 "mapiterator.c"
}


/**
 * Rewinds to the first entry in the iteration.
 *
 * @return ``true`` if the iterator has a first entry
 */
gboolean gee_map_iterator_first (GeeMapIterator* self) {
#line 55 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 55 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	return GEE_MAP_ITERATOR_GET_INTERFACE (self)->first (self);
#line 100 "mapiterator.c"
}


/**
 * Returns the current key in the iteration.
 *
 * @return the current key in the iteration
 */
gpointer gee_map_iterator_get_key (GeeMapIterator* self) {
#line 62 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 62 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	return GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_key (self);
#line 114 "mapiterator.c"
}


/**
 * Returns the value associated with the current key in the iteration.
 *
 * @return the value for the current key
 */
gpointer gee_map_iterator_get_value (GeeMapIterator* self) {
#line 69 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 69 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	return GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_value (self);
#line 128 "mapiterator.c"
}


/**
 * Sets the value associated with the current key in the iteration.
 *
 * @param value the new value for the current key
 */
void gee_map_iterator_set_value (GeeMapIterator* self, gconstpointer value) {
#line 76 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	g_return_if_fail (self != NULL);
#line 76 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	GEE_MAP_ITERATOR_GET_INTERFACE (self)->set_value (self, value);
#line 142 "mapiterator.c"
}


/**
 * Unsets the current entry in the iteration. The cursor is set in an
 * in-between state. {@link get_key}, {@link get_value}, {@link set_value}
 * and {@link unset} will fail until the next move of the cursor (calling
 * {@link next} or {@link first}).
 */
void gee_map_iterator_unset (GeeMapIterator* self) {
#line 84 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	g_return_if_fail (self != NULL);
#line 84 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	GEE_MAP_ITERATOR_GET_INTERFACE (self)->unset (self);
#line 157 "mapiterator.c"
}


static void gee_map_iterator_base_init (GeeMapIteratorIface * iface) {
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	static gboolean initialized = FALSE;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
	if (!initialized) {
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/mapiterator.vala"
		initialized = TRUE;
#line 168 "mapiterator.c"
	}
}


/**
 * An iterator over a map.
 *
 * Gee's iterators are "on-track" iterators. They always point to an item
 * except before the first call to {@link next} or {@link first}, or, when an
 * item has been removed, until the next call to {@link next} or {@link first}.
 *
 * Please note that when the iterator is out of track, neither {@link get_key},
 * {@link get_value}, {@link set_value} nor {@link unset} are defined and all
 * will fail. After the next call to {@link next} or {@link first}, they will
 * be defined again.
 */
GType gee_map_iterator_get_type (void) {
	static volatile gsize gee_map_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_map_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeMapIteratorIface), (GBaseInitFunc) gee_map_iterator_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_map_iterator_type_id;
		gee_map_iterator_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeMapIterator", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_map_iterator_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_map_iterator_type_id__volatile, gee_map_iterator_type_id);
	}
	return gee_map_iterator_type_id__volatile;
}



