/* hazardpointer.c generated by valac 0.18.0.57-8d977, the Vala compiler
 * generated from hazardpointer.vala, do not modify */

/* hazardpointer.vala
 *
 * Copyright (C) 2011  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>

typedef struct _GeeHazardPointer GeeHazardPointer;
typedef struct _GeeHazardPointerNode GeeHazardPointerNode;

#define GEE_HAZARD_POINTER_TYPE_POLICY (gee_hazard_pointer_policy_get_type ())

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;

#define GEE_TYPE_ABSTRACT_BIDIR_LIST (gee_abstract_bidir_list_get_type ())
#define GEE_ABSTRACT_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList))
#define GEE_ABSTRACT_BIDIR_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirListClass))
#define GEE_IS_ABSTRACT_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST))
#define GEE_IS_ABSTRACT_BIDIR_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_BIDIR_LIST))
#define GEE_ABSTRACT_BIDIR_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirListClass))

typedef struct _GeeAbstractBidirList GeeAbstractBidirList;
typedef struct _GeeAbstractBidirListClass GeeAbstractBidirListClass;

#define GEE_TYPE_ARRAY_LIST (gee_array_list_get_type ())
#define GEE_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayList))
#define GEE_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))
#define GEE_IS_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_LIST))
#define GEE_IS_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_LIST))
#define GEE_ARRAY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))

typedef struct _GeeArrayList GeeArrayList;
typedef struct _GeeArrayListClass GeeArrayListClass;
typedef struct _GeeHazardPointerFreeNode GeeHazardPointerFreeNode;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_HAZARD_POINTER_TYPE_RELEASE_POLICY (gee_hazard_pointer_release_policy_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GEE_TYPE_LINKED_LIST (gee_linked_list_get_type ())
#define GEE_LINKED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LINKED_LIST, GeeLinkedList))
#define GEE_LINKED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LINKED_LIST, GeeLinkedListClass))
#define GEE_IS_LINKED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LINKED_LIST))
#define GEE_IS_LINKED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LINKED_LIST))
#define GEE_LINKED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LINKED_LIST, GeeLinkedListClass))

typedef struct _GeeLinkedList GeeLinkedList;
typedef struct _GeeLinkedListClass GeeLinkedListClass;
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
#define _gee_hazard_pointer_free0(var) ((var == NULL) ? NULL : (var = (gee_hazard_pointer_free (var), NULL)))
typedef struct _GeeHazardPointerContext GeeHazardPointerContext;

#define GEE_TYPE_ABSTRACT_SET (gee_abstract_set_get_type ())
#define GEE_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSet))
#define GEE_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))
#define GEE_IS_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_SET))
#define GEE_IS_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_SET))
#define GEE_ABSTRACT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))

typedef struct _GeeAbstractSet GeeAbstractSet;
typedef struct _GeeAbstractSetClass GeeAbstractSetClass;

#define GEE_TYPE_HASH_SET (gee_hash_set_get_type ())
#define GEE_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_HASH_SET, GeeHashSet))
#define GEE_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_HASH_SET, GeeHashSetClass))
#define GEE_IS_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_HASH_SET))
#define GEE_IS_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_HASH_SET))
#define GEE_HASH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_HASH_SET, GeeHashSetClass))

typedef struct _GeeHashSet GeeHashSet;
typedef struct _GeeHashSetClass GeeHashSetClass;
typedef struct _Block5Data Block5Data;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeHazardPointer {
	GeeHazardPointerNode* _node;
};

typedef enum  {
	GEE_HAZARD_POINTER_POLICY_DEFAULT,
	GEE_HAZARD_POINTER_POLICY_THREAD_EXIT,
	GEE_HAZARD_POINTER_POLICY_TRY_FREE,
	GEE_HAZARD_POINTER_POLICY_FREE,
	GEE_HAZARD_POINTER_POLICY_TRY_RELEASE,
	GEE_HAZARD_POINTER_POLICY_RELEASE
} GeeHazardPointerPolicy;

typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeQueue* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeQueue* self);
	GDestroyNotify (*get_g_destroy_func) (GeeQueue* self);
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

typedef enum  {
	GEE_HAZARD_POINTER_RELEASE_POLICY_HELPER_THREAD,
	GEE_HAZARD_POINTER_RELEASE_POLICY_MAIN_LOOP
} GeeHazardPointerReleasePolicy;

typedef gboolean (*GeeEqualDataFunc) (gconstpointer a, gconstpointer b, void* user_data);
typedef void (*GeeHazardPointerDestroyNotify) (void* ptr, void* user_data);
typedef guint (*GeeHashDataFunc) (gconstpointer v, void* user_data);
struct _GeeHazardPointerFreeNode {
	void* pointer;
	GeeHazardPointerDestroyNotify destroy_notify;
	gpointer destroy_notify_target;
	GDestroyNotify destroy_notify_target_destroy_notify;
};

struct _Block5Data {
	int _ref_count_;
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeeHazardPointerContext {
	GeeHazardPointerContext* _parent;
	GeeArrayList* _to_free;
	GeeHazardPointerPolicy* _policy;
};

struct _GeeHazardPointerNode {
	GeeHazardPointerNode* _next;
	gint _active;
	void* _hazard;
};


extern gint gee_hazard_pointer__default_policy;
extern gint gee_hazard_pointer__thread_exit_policy;
extern GStaticMutex gee_hazard_pointer__queue_mutex;
extern GeeQueue* gee_hazard_pointer__queue;
extern gint gee_hazard_pointer_release_policy;
extern GeeArrayList* gee_hazard_pointer__global_to_free;
extern GeeHazardPointerNode* gee_hazard_pointer__head;
GeeHazardPointerNode* gee_hazard_pointer__head = NULL;
gint gee_hazard_pointer__default_policy = (gint) GEE_HAZARD_POINTER_POLICY_TRY_FREE;
gint gee_hazard_pointer__thread_exit_policy = (gint) GEE_HAZARD_POINTER_POLICY_RELEASE;
gint gee_hazard_pointer_release_policy = 0;
GeeQueue* gee_hazard_pointer__queue = NULL;
GStaticMutex gee_hazard_pointer__queue_mutex = G_STATIC_MUTEX_INIT;
GeeArrayList* gee_hazard_pointer__global_to_free = NULL;
static guint gee_hazard_pointer_context_THRESHOLD;
extern GStaticPrivate gee_hazard_pointer_context__current_context;
GStaticPrivate gee_hazard_pointer_context__current_context = G_STATIC_PRIVATE_INIT;
extern GStaticPrivate gee_hazard_pointer_context__root_context;
GStaticPrivate gee_hazard_pointer_context__root_context = G_STATIC_PRIVATE_INIT;
static guint gee_hazard_pointer_context_THRESHOLD = (guint) 10;

void gee_hazard_pointer_free (GeeHazardPointer* self);
void gee_hazard_pointer_node_free (GeeHazardPointerNode* self);
static void gee_hazard_pointer_instance_init (GeeHazardPointer * self);
void gee_hazard_pointer_node_release (GeeHazardPointerNode* self);
GType gee_hazard_pointer_policy_get_type (void) G_GNUC_CONST;
gboolean gee_hazard_pointer_policy_is_concrete (GeeHazardPointerPolicy self);
gboolean gee_hazard_pointer_policy_is_blocking (GeeHazardPointerPolicy self);
gboolean gee_hazard_pointer_policy_is_safe (GeeHazardPointerPolicy self);
GeeHazardPointerPolicy gee_hazard_pointer_policy_to_concrete (GeeHazardPointerPolicy self);
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_list_get_type (void) G_GNUC_CONST;
GType gee_abstract_bidir_list_get_type (void) G_GNUC_CONST;
GType gee_array_list_get_type (void) G_GNUC_CONST;
void gee_hazard_pointer_free_node_free (GeeHazardPointerFreeNode* self);
GeeArrayList* gee_hazard_pointer_policy_perform (GeeHazardPointerPolicy self, GeeArrayList* to_free);
gboolean gee_hazard_pointer_try_free (GeeArrayList* to_free);
void gee_hazard_pointer_release_policy_ensure_start (void);
GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_queue_get_type (void) G_GNUC_CONST;
gboolean gee_queue_offer (GeeQueue* self, gconstpointer element);
GType gee_hazard_pointer_release_policy_get_type (void) G_GNUC_CONST;
static void gee_hazard_pointer_release_policy_start (GeeHazardPointerReleasePolicy _self_);
static gboolean ____lambda33_ (void);
static inline void gee_hazard_pointer_release_policy_attempt_free (void);
static gpointer _____lambda33__gthread_func (gpointer self);
static gboolean ___lambda35_ (void);
static gboolean ____lambda35__gsource_func (gpointer self);
GeeLinkedList* gee_linked_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeLinkedList* gee_linked_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GType gee_linked_list_get_type (void) G_GNUC_CONST;
GeeArrayList* gee_array_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeArrayList* gee_array_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
gint gee_queue_drain (GeeQueue* self, GeeCollection* recipient, gint amount);
gboolean gee_traversable_foreach (GeeTraversable* self, GeeForallFunc f, void* f_target);
static gboolean ___lambda34_ (GeeArrayList* x);
gboolean gee_array_list_add_all (GeeArrayList* self, GeeCollection* collection);
static gboolean ____lambda34__gee_forall_func (gpointer g, gpointer self);
GeeHazardPointer* gee_hazard_pointer_new (gconstpointer* ptr);
GeeHazardPointer* gee_hazard_pointer_new (gconstpointer* ptr);
GeeHazardPointerNode* gee_hazard_pointer_acquire (void);
void gee_hazard_pointer_node_set (GeeHazardPointerNode* self, void* ptr);
GeeHazardPointer* gee_hazard_pointer_new_from_node (GeeHazardPointerNode* node);
GeeHazardPointer* gee_hazard_pointer_new_from_node (GeeHazardPointerNode* node);
GeeHazardPointer* gee_hazard_pointer_get_hazard_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gsize mask, gsize* mask_out);
gpointer gee_hazard_pointer_get_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gsize mask, gsize* mask_out);
GeeHazardPointer* gee_hazard_pointer_exchange_hazard_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gpointer new_ptr, gsize mask, gsize new_mask, gsize* old_mask);
void gee_hazard_pointer_set_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gpointer new_ptr, gsize mask, gsize new_mask);
GeeHazardPointerDestroyNotify gee_hazard_pointer_get_destroy_notify (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, void** result_target, GDestroyNotify* result_target_destroy_notify);
void gee_hazard_pointer_release (GeeHazardPointer* self, GeeHazardPointerDestroyNotify notify, void* notify_target, GDestroyNotify notify_target_destroy_notify);
gpointer gee_hazard_pointer_exchange_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gpointer new_ptr, gsize mask, gsize new_mask, gsize* old_mask);
gconstpointer gee_hazard_pointer_get (GeeHazardPointer* self, gboolean other_thread);
gboolean gee_hazard_pointer_compare_and_exchange_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gconstpointer old_ptr, gpointer _new_ptr, gsize mask, gsize old_mask, gsize new_mask);
void gee_hazard_pointer_context_free (GeeHazardPointerContext* self);
GeeHazardPointerContext* gee_hazard_pointer_context_get_current_context (void);
void gee_hazard_pointer_context_release_ptr (GeeHazardPointerContext* self, void* ptr, GeeHazardPointerDestroyNotify notify, void* notify_target, GDestroyNotify notify_target_destroy_notify);
void* gee_hazard_pointer_node_get (GeeHazardPointerNode* self, gboolean safe);
void gee_hazard_pointer_set_default_policy (GeeHazardPointerPolicy policy);
void gee_hazard_pointer_set_thread_exit_policy (GeeHazardPointerPolicy policy);
gboolean gee_hazard_pointer_set_release_policy (GeeHazardPointerReleasePolicy policy);
GeeHazardPointerNode* gee_hazard_pointer_get_head (void);
GeeHazardPointerNode* gee_hazard_pointer_node_get_next (GeeHazardPointerNode* self);
gboolean gee_hazard_pointer_node_activate (GeeHazardPointerNode* self);
GeeHazardPointerNode* gee_hazard_pointer_node_new (void);
GeeHazardPointerNode* gee_hazard_pointer_node_new (void);
void gee_hazard_pointer_node_set_next (GeeHazardPointerNode* self, GeeHazardPointerNode* next);
GeeHashSet* gee_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeHashSet* gee_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GType gee_abstract_set_get_type (void) G_GNUC_CONST;
GType gee_hash_set_get_type (void) G_GNUC_CONST;
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gpointer gee_abstract_list_get (GeeAbstractList* self, gint index);
gboolean gee_collection_contains (GeeCollection* self, gconstpointer item);
gpointer gee_abstract_list_remove_at (GeeAbstractList* self, gint index);
void gee_abstract_list_set (GeeAbstractList* self, gint index, gconstpointer item);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda36_ (Block5Data* _data5_, void* ptr);
static void ___lambda36__gee_hazard_pointer_destroy_notify (void* ptr, gpointer self);
static void gee_hazard_pointer_context_instance_init (GeeHazardPointerContext * self);
GeeHazardPointerContext* gee_hazard_pointer_context_new (GeeHazardPointerPolicy* policy);
GeeHazardPointerContext* gee_hazard_pointer_context_new (GeeHazardPointerPolicy* policy);
static GeeHazardPointerPolicy* _gee_hazard_pointer_policy_dup (GeeHazardPointerPolicy* self);
void gee_hazard_pointer_context_try_free (GeeHazardPointerContext* self);
void gee_hazard_pointer_context_free_all (GeeHazardPointerContext* self);
void gee_hazard_pointer_context_try_release (GeeHazardPointerContext* self);
void gee_hazard_pointer_context_release (GeeHazardPointerContext* self);
GeeHazardPointerFreeNode* gee_hazard_pointer_free_node_new (void);
GeeHazardPointerFreeNode* gee_hazard_pointer_free_node_new (void);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static inline gboolean _gee_hazard_pointer_context_should_free (GeeHazardPointerContext* self);
static void gee_hazard_pointer_free_node_instance_init (GeeHazardPointerFreeNode * self);
static void gee_hazard_pointer_node_instance_init (GeeHazardPointerNode * self);
gboolean gee_hazard_pointer_node_is_active (GeeHazardPointerNode* self);


/**
 * Checks if the policy is concrete or if it depends on global variables.
 *
 * @return ``true`` if this policy does not depend on global variables
 */
gboolean gee_hazard_pointer_policy_is_concrete (GeeHazardPointerPolicy self) {
	gboolean result = FALSE;
#line 324 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	switch (self) {
#line 324 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_DEFAULT:
#line 324 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_THREAD_EXIT:
#line 436 "hazardpointer.c"
		{
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			result = FALSE;
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			return result;
#line 442 "hazardpointer.c"
		}
#line 324 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_TRY_FREE:
#line 324 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_FREE:
#line 324 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_TRY_RELEASE:
#line 324 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_RELEASE:
#line 452 "hazardpointer.c"
		{
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			result = TRUE;
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			return result;
#line 458 "hazardpointer.c"
		}
		default:
		{
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			g_assert_not_reached ();
#line 464 "hazardpointer.c"
		}
	}
}


/**
 * Checks if policy blocks or is lock-free.
 * Please note that it works on a concrete policy only.
 *
 * @return ``true`` if the policy may block the thread.
 */
gboolean gee_hazard_pointer_policy_is_blocking (GeeHazardPointerPolicy self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 344 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = gee_hazard_pointer_policy_is_concrete (self);
#line 344 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_val_if_fail (_tmp0_, FALSE);
#line 345 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	switch (self) {
#line 345 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_TRY_FREE:
#line 345 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_TRY_RELEASE:
#line 489 "hazardpointer.c"
		{
#line 348 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			result = FALSE;
#line 348 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			return result;
#line 495 "hazardpointer.c"
		}
#line 345 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_FREE:
#line 345 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_RELEASE:
#line 501 "hazardpointer.c"
		{
#line 351 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			result = TRUE;
#line 351 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			return result;
#line 507 "hazardpointer.c"
		}
		default:
		{
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			g_assert_not_reached ();
#line 513 "hazardpointer.c"
		}
	}
}


/**
 * Checks if policy guarantees freeing all elements.
 * Please note that it works on a concrete policy only.
 *
 * @return ``true`` if the policy guarantees freeing all elements.
 */
gboolean gee_hazard_pointer_policy_is_safe (GeeHazardPointerPolicy self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 363 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = gee_hazard_pointer_policy_is_concrete (self);
#line 363 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_val_if_fail (_tmp0_, FALSE);
#line 364 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	switch (self) {
#line 364 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_TRY_FREE:
#line 364 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_TRY_RELEASE:
#line 538 "hazardpointer.c"
		{
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			result = FALSE;
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			return result;
#line 544 "hazardpointer.c"
		}
#line 364 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_FREE:
#line 364 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_RELEASE:
#line 550 "hazardpointer.c"
		{
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			result = TRUE;
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			return result;
#line 556 "hazardpointer.c"
		}
		default:
		{
#line 372 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			g_assert_not_reached ();
#line 562 "hazardpointer.c"
		}
	}
}


/**
 * Finds concrete policy which corresponds to given policy.
 *
 * @return Policy that corresponds to given policy at given time in given thread.
 */
GeeHazardPointerPolicy gee_hazard_pointer_policy_to_concrete (GeeHazardPointerPolicy self) {
	GeeHazardPointerPolicy result = 0;
#line 382 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	switch (self) {
#line 382 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_TRY_FREE:
#line 382 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_FREE:
#line 382 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_TRY_RELEASE:
#line 382 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_RELEASE:
#line 585 "hazardpointer.c"
		{
			GeeHazardPointerPolicy _tmp0_;
			gboolean _tmp1_ = FALSE;
#line 387 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			result = self;
#line 387 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp0_ = result;
#line 387 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp1_ = gee_hazard_pointer_policy_is_concrete (_tmp0_);
#line 387 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			g_warn_if_fail (_tmp1_);
#line 387 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			return result;
#line 599 "hazardpointer.c"
		}
#line 382 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_DEFAULT:
#line 603 "hazardpointer.c"
		{
			gint _tmp2_ = 0;
			GeeHazardPointerPolicy _tmp3_;
			gboolean _tmp4_ = FALSE;
#line 389 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp2_ = g_atomic_int_get ((volatile gint *) (&gee_hazard_pointer__default_policy));
#line 389 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			result = (GeeHazardPointerPolicy) _tmp2_;
#line 389 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp3_ = result;
#line 389 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp4_ = gee_hazard_pointer_policy_is_concrete (_tmp3_);
#line 389 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			g_warn_if_fail (_tmp4_);
#line 389 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			return result;
#line 620 "hazardpointer.c"
		}
#line 382 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_THREAD_EXIT:
#line 624 "hazardpointer.c"
		{
			gint _tmp5_ = 0;
			GeeHazardPointerPolicy _tmp6_;
			gboolean _tmp7_ = FALSE;
#line 391 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp5_ = g_atomic_int_get ((volatile gint *) (&gee_hazard_pointer__thread_exit_policy));
#line 391 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			result = (GeeHazardPointerPolicy) _tmp5_;
#line 391 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp6_ = result;
#line 391 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp7_ = gee_hazard_pointer_policy_is_concrete (_tmp6_);
#line 391 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			g_warn_if_fail (_tmp7_);
#line 391 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			return result;
#line 641 "hazardpointer.c"
		}
		default:
		{
#line 393 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			g_assert_not_reached ();
#line 647 "hazardpointer.c"
		}
	}
}


/**
 * Runs the policy.
 * @param to_free List containing elements to free.
 * @return Non-empty list of not freed elements or ``null`` if all elements have been disposed.
 */
GeeArrayList* gee_hazard_pointer_policy_perform (GeeHazardPointerPolicy self, GeeArrayList* to_free) {
	GeeArrayList* result = NULL;
	GeeHazardPointerPolicy _tmp0_ = 0;
#line 403 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_val_if_fail (to_free != NULL, NULL);
#line 404 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = gee_hazard_pointer_policy_to_concrete (self);
#line 404 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	switch (_tmp0_) {
#line 404 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_TRY_FREE:
#line 669 "hazardpointer.c"
		{
			GeeArrayList* _tmp1_ = NULL;
			GeeArrayList* _tmp2_;
			gboolean _tmp3_ = FALSE;
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp2_ = to_free;
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp3_ = gee_hazard_pointer_try_free (_tmp2_);
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			if (_tmp3_) {
#line 680 "hazardpointer.c"
				GeeArrayList* _tmp4_;
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp4_ = to_free;
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				to_free = NULL;
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_g_object_unref0 (_tmp1_);
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp1_ = _tmp4_;
#line 690 "hazardpointer.c"
			} else {
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_g_object_unref0 (_tmp1_);
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp1_ = NULL;
#line 696 "hazardpointer.c"
			}
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			result = _tmp1_;
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_g_object_unref0 (to_free);
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			return result;
#line 704 "hazardpointer.c"
		}
#line 404 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_FREE:
#line 708 "hazardpointer.c"
		{
#line 408 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			while (TRUE) {
#line 712 "hazardpointer.c"
				GeeArrayList* _tmp5_;
				gboolean _tmp6_ = FALSE;
#line 408 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp5_ = to_free;
#line 408 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp6_ = gee_hazard_pointer_try_free (_tmp5_);
#line 408 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				if (!_tmp6_) {
#line 408 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					break;
#line 723 "hazardpointer.c"
				}
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				g_thread_yield ();
#line 727 "hazardpointer.c"
			}
#line 411 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			result = NULL;
#line 411 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_g_object_unref0 (to_free);
#line 411 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			return result;
#line 735 "hazardpointer.c"
		}
#line 404 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_TRY_RELEASE:
#line 739 "hazardpointer.c"
		{
			gboolean _tmp7_ = FALSE;
#line 413 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			gee_hazard_pointer_release_policy_ensure_start ();
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp7_ = g_static_mutex_trylock (&gee_hazard_pointer__queue_mutex);
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			if (_tmp7_) {
#line 748 "hazardpointer.c"
				GeeQueue* _tmp8_;
				GeeArrayList* _tmp9_;
				GeeArrayList* _tmp10_;
#line 415 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp8_ = gee_hazard_pointer__queue;
#line 415 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp9_ = to_free;
#line 415 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				to_free = NULL;
#line 415 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp10_ = _tmp9_;
#line 415 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				gee_queue_offer (_tmp8_, _tmp10_);
#line 415 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_g_object_unref0 (_tmp10_);
#line 416 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				g_static_mutex_unlock (&gee_hazard_pointer__queue_mutex);
#line 417 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				result = NULL;
#line 417 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_g_object_unref0 (to_free);
#line 417 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				return result;
#line 772 "hazardpointer.c"
			} else {
				GeeArrayList* _tmp11_;
#line 419 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp11_ = to_free;
#line 419 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				to_free = NULL;
#line 419 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				result = _tmp11_;
#line 419 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_g_object_unref0 (to_free);
#line 419 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				return result;
#line 785 "hazardpointer.c"
			}
		}
#line 404 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_POLICY_RELEASE:
#line 790 "hazardpointer.c"
		{
			GeeQueue* _tmp12_;
			GeeArrayList* _tmp13_;
			GeeArrayList* _tmp14_;
#line 422 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			gee_hazard_pointer_release_policy_ensure_start ();
#line 423 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			g_static_mutex_lock (&gee_hazard_pointer__queue_mutex);
#line 424 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp12_ = gee_hazard_pointer__queue;
#line 424 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp13_ = to_free;
#line 424 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			to_free = NULL;
#line 424 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp14_ = _tmp13_;
#line 424 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			gee_queue_offer (_tmp12_, _tmp14_);
#line 424 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_g_object_unref0 (_tmp14_);
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			g_static_mutex_unlock (&gee_hazard_pointer__queue_mutex);
#line 426 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			result = NULL;
#line 426 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_g_object_unref0 (to_free);
#line 426 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			return result;
#line 819 "hazardpointer.c"
		}
		default:
		{
#line 428 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			g_assert_not_reached ();
#line 825 "hazardpointer.c"
		}
	}
#line 403 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_g_object_unref0 (to_free);
#line 830 "hazardpointer.c"
}


/**
 * Policy determines what happens on exit from Context.
 */
GType gee_hazard_pointer_policy_get_type (void) {
	static volatile gsize gee_hazard_pointer_policy_type_id__volatile = 0;
	if (g_once_init_enter (&gee_hazard_pointer_policy_type_id__volatile)) {
		static const GEnumValue values[] = {{GEE_HAZARD_POINTER_POLICY_DEFAULT, "GEE_HAZARD_POINTER_POLICY_DEFAULT", "default"}, {GEE_HAZARD_POINTER_POLICY_THREAD_EXIT, "GEE_HAZARD_POINTER_POLICY_THREAD_EXIT", "thread-exit"}, {GEE_HAZARD_POINTER_POLICY_TRY_FREE, "GEE_HAZARD_POINTER_POLICY_TRY_FREE", "try-free"}, {GEE_HAZARD_POINTER_POLICY_FREE, "GEE_HAZARD_POINTER_POLICY_FREE", "free"}, {GEE_HAZARD_POINTER_POLICY_TRY_RELEASE, "GEE_HAZARD_POINTER_POLICY_TRY_RELEASE", "try-release"}, {GEE_HAZARD_POINTER_POLICY_RELEASE, "GEE_HAZARD_POINTER_POLICY_RELEASE", "release"}, {0, NULL, NULL}};
		GType gee_hazard_pointer_policy_type_id;
		gee_hazard_pointer_policy_type_id = g_enum_register_static ("GeeHazardPointerPolicy", values);
		g_once_init_leave (&gee_hazard_pointer_policy_type_id__volatile, gee_hazard_pointer_policy_type_id);
	}
	return gee_hazard_pointer_policy_type_id__volatile;
}


static gboolean ____lambda33_ (void) {
	gboolean result = FALSE;
	GThread* _tmp0_ = NULL;
#line 456 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = g_thread_self ();
#line 456 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_thread_set_priority (_tmp0_, G_THREAD_PRIORITY_LOW);
#line 457 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	while (TRUE) {
#line 458 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		g_thread_yield ();
#line 459 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		gee_hazard_pointer_release_policy_attempt_free ();
#line 862 "hazardpointer.c"
	}
#line 455 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 866 "hazardpointer.c"
}


static gpointer _____lambda33__gthread_func (gpointer self) {
	gpointer result;
	result = ____lambda33_ ();
#line 455 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 875 "hazardpointer.c"
}


static gboolean ___lambda35_ (void) {
	gboolean result = FALSE;
#line 468 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_hazard_pointer_release_policy_attempt_free ();
#line 469 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = TRUE;
#line 469 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 887 "hazardpointer.c"
}


static gboolean ____lambda35__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda35_ ();
#line 467 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 896 "hazardpointer.c"
}


static void gee_hazard_pointer_release_policy_start (GeeHazardPointerReleasePolicy _self_) {
	GeeHazardPointerReleasePolicy _tmp0_;
	GError * _inner_error_ = NULL;
#line 452 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = _self_;
#line 452 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	switch (_tmp0_) {
#line 452 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_RELEASE_POLICY_HELPER_THREAD:
#line 909 "hazardpointer.c"
		{
			{
#line 455 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				g_thread_create (_____lambda33__gthread_func, NULL, FALSE, &_inner_error_);
#line 455 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				if (_inner_error_ != NULL) {
#line 455 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					if (_inner_error_->domain == G_THREAD_ERROR) {
#line 918 "hazardpointer.c"
						goto __catch0_g_thread_error;
					}
#line 455 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 455 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					g_clear_error (&_inner_error_);
#line 455 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					return;
#line 927 "hazardpointer.c"
				}
			}
			goto __finally0;
			__catch0_g_thread_error:
			{
				GError* _error_ = NULL;
#line 454 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_error_ = _inner_error_;
#line 454 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_inner_error_ = NULL;
#line 463 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				g_assert_not_reached ();
#line 454 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_g_error_free0 (_error_);
#line 942 "hazardpointer.c"
			}
			__finally0:
#line 454 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			if (_inner_error_ != NULL) {
#line 454 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 454 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				g_clear_error (&_inner_error_);
#line 454 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				return;
#line 953 "hazardpointer.c"
			}
#line 465 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			break;
#line 957 "hazardpointer.c"
		}
#line 452 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		case GEE_HAZARD_POINTER_RELEASE_POLICY_MAIN_LOOP:
#line 961 "hazardpointer.c"
		{
#line 467 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			g_idle_add_full (G_PRIORITY_LOW, ____lambda35__gsource_func, NULL, NULL);
#line 471 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			break;
#line 967 "hazardpointer.c"
		}
		default:
		{
#line 473 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			g_assert_not_reached ();
#line 973 "hazardpointer.c"
		}
	}
}


/**
 * Ensures that helper methods are started.
 */
inline void gee_hazard_pointer_release_policy_ensure_start (void) {
	gint _tmp0_ = 0;
	gint policy;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 481 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = g_atomic_int_get ((volatile gint *) (&gee_hazard_pointer_release_policy));
#line 481 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	policy = _tmp0_;
#line 482 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = policy;
#line 482 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if ((_tmp1_ & (1 << ((sizeof (gint) * 8) - 1))) != 0) {
#line 483 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		return;
#line 997 "hazardpointer.c"
	}
#line 484 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = g_static_mutex_trylock (&gee_hazard_pointer__queue_mutex);
#line 484 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp2_) {
#line 1003 "hazardpointer.c"
		gint _tmp3_ = 0;
		gint _tmp4_;
#line 485 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp3_ = g_atomic_int_get ((volatile gint *) (&gee_hazard_pointer_release_policy));
#line 485 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		policy = _tmp3_;
#line 486 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp4_ = policy;
#line 486 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		if ((_tmp4_ & (1 << ((sizeof (gint) * 8) - 1))) == 0) {
#line 1014 "hazardpointer.c"
			GeeLinkedList* _tmp5_;
			gint _tmp6_ = 0;
			gint _tmp7_;
#line 487 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp5_ = gee_linked_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 487 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_g_object_unref0 (gee_hazard_pointer__queue);
#line 487 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			gee_hazard_pointer__queue = (GeeQueue*) _tmp5_;
#line 489 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp6_ = g_atomic_int_exchange_and_add ((volatile gint *) (&gee_hazard_pointer_release_policy), (gint) (1 << ((sizeof (gint) * 8) - 1)));
#line 489 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			policy = _tmp6_;
#line 490 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp7_ = policy;
#line 490 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			gee_hazard_pointer_release_policy_start ((GeeHazardPointerReleasePolicy) _tmp7_);
#line 1032 "hazardpointer.c"
		}
#line 492 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		g_static_mutex_unlock (&gee_hazard_pointer__queue_mutex);
#line 1036 "hazardpointer.c"
	}
}


static gboolean ___lambda34_ (GeeArrayList* x) {
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 501 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_val_if_fail (x != NULL, FALSE);
#line 501 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = gee_hazard_pointer__global_to_free;
#line 501 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = x;
#line 501 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_array_list_add_all (_tmp0_, (GeeCollection*) _tmp1_);
#line 501 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = TRUE;
#line 501 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_g_object_unref0 (x);
#line 501 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 1059 "hazardpointer.c"
}


static gboolean ____lambda34__gee_forall_func (gpointer g, gpointer self) {
	gboolean result;
	result = ___lambda34_ (g);
#line 501 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 1068 "hazardpointer.c"
}


static inline void gee_hazard_pointer_release_policy_attempt_free (void) {
	gboolean _tmp0_ = FALSE;
	GeeArrayList* _tmp5_;
#line 497 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = g_static_mutex_trylock (&gee_hazard_pointer__queue_mutex);
#line 497 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp0_) {
#line 1079 "hazardpointer.c"
		GeeArrayList* _tmp1_;
		GeeCollection* temp;
		GeeQueue* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
#line 498 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp1_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 498 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		temp = (GeeCollection*) _tmp1_;
#line 499 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp2_ = gee_hazard_pointer__queue;
#line 499 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp3_ = temp;
#line 499 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		gee_queue_drain (_tmp2_, _tmp3_, -1);
#line 500 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		g_static_mutex_unlock (&gee_hazard_pointer__queue_mutex);
#line 501 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp4_ = temp;
#line 501 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		gee_traversable_foreach ((GeeTraversable*) _tmp4_, ____lambda34__gee_forall_func, NULL);
#line 497 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_g_object_unref0 (temp);
#line 1103 "hazardpointer.c"
	}
#line 503 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp5_ = gee_hazard_pointer__global_to_free;
#line 503 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_hazard_pointer_try_free (_tmp5_);
#line 1109 "hazardpointer.c"
}


/**
 * Release policy determines what happens with object freed by Policy.TRY_RELEASE
 * and Policy.RELEASE.
 */
GType gee_hazard_pointer_release_policy_get_type (void) {
	static volatile gsize gee_hazard_pointer_release_policy_type_id__volatile = 0;
	if (g_once_init_enter (&gee_hazard_pointer_release_policy_type_id__volatile)) {
		static const GEnumValue values[] = {{GEE_HAZARD_POINTER_RELEASE_POLICY_HELPER_THREAD, "GEE_HAZARD_POINTER_RELEASE_POLICY_HELPER_THREAD", "helper-thread"}, {GEE_HAZARD_POINTER_RELEASE_POLICY_MAIN_LOOP, "GEE_HAZARD_POINTER_RELEASE_POLICY_MAIN_LOOP", "main-loop"}, {0, NULL, NULL}};
		GType gee_hazard_pointer_release_policy_type_id;
		gee_hazard_pointer_release_policy_type_id = g_enum_register_static ("GeeHazardPointerReleasePolicy", values);
		g_once_init_leave (&gee_hazard_pointer_release_policy_type_id__volatile, gee_hazard_pointer_release_policy_type_id);
	}
	return gee_hazard_pointer_release_policy_type_id__volatile;
}


/**
 * Creates a hazard pointer for a pointer.
 *
 * @param ptr Protected pointer
 */
GeeHazardPointer* gee_hazard_pointer_new (gconstpointer* ptr) {
	GeeHazardPointer* self;
	GeeHazardPointerNode* _tmp0_ = NULL;
	GeeHazardPointerNode* _tmp1_;
	gconstpointer* _tmp2_;
#line 57 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	self = g_slice_new0 (GeeHazardPointer);
#line 57 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_hazard_pointer_instance_init (self);
#line 58 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = gee_hazard_pointer_acquire ();
#line 58 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	self->_node = _tmp0_;
#line 59 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = self->_node;
#line 59 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = ptr;
#line 59 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_hazard_pointer_node_set (_tmp1_, (void*) _tmp2_);
#line 57 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return self;
#line 1155 "hazardpointer.c"
}


/**
 * Create a hazard pointer from Node.
 */
GeeHazardPointer* gee_hazard_pointer_new_from_node (GeeHazardPointerNode* node) {
	GeeHazardPointer* self;
	GeeHazardPointerNode* _tmp0_;
#line 65 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_val_if_fail (node != NULL, NULL);
#line 65 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	self = g_slice_new0 (GeeHazardPointer);
#line 65 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_hazard_pointer_instance_init (self);
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = node;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	self->_node = _tmp0_;
#line 65 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return self;
#line 1177 "hazardpointer.c"
}


/**
 * Gets hazard pointer from atomic pointer safely.
 *
 * @param aptr Atomic pointer.
 * @param mask Mask of bits.
 * @param mask_out Result of mask.
 * @return Hazard pointer containing the element.
 */
GeeHazardPointer* gee_hazard_pointer_get_hazard_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gsize mask, gsize* mask_out) {
	gsize _vala_mask_out = 0UL;
	GeeHazardPointer* result = NULL;
	GeeHazardPointerNode* _tmp0_ = NULL;
	GeeHazardPointerNode* node;
	void* rptr;
	void* ptr;
	void* _tmp14_;
#line 78 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = gee_hazard_pointer_acquire ();
#line 78 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	node = _tmp0_;
#line 79 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	rptr = NULL;
#line 80 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	ptr = NULL;
#line 81 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_vala_mask_out = (gsize) 0;
#line 1207 "hazardpointer.c"
	{
		gboolean _tmp1_;
#line 82 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp1_ = TRUE;
#line 82 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		while (TRUE) {
#line 1214 "hazardpointer.c"
			gboolean _tmp2_;
			gconstpointer** _tmp6_;
			void* _tmp7_ = NULL;
			void* _tmp8_;
			gsize _tmp9_;
			void* _tmp10_;
			gsize _tmp11_;
			GeeHazardPointerNode* _tmp12_;
			void* _tmp13_;
#line 82 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp2_ = _tmp1_;
#line 82 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			if (!_tmp2_) {
#line 1228 "hazardpointer.c"
				void* _tmp3_;
				gconstpointer** _tmp4_;
				void* _tmp5_ = NULL;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp3_ = rptr;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp4_ = aptr;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp5_ = g_atomic_pointer_get ((volatile gpointer *) ((void**) _tmp4_));
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				if (!(_tmp3_ != _tmp5_)) {
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					break;
#line 1242 "hazardpointer.c"
				}
			}
#line 82 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp1_ = FALSE;
#line 83 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp6_ = aptr;
#line 83 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp7_ = g_atomic_pointer_get ((volatile gpointer *) ((void**) _tmp6_));
#line 83 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			rptr = _tmp7_;
#line 84 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp8_ = rptr;
#line 84 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp9_ = mask;
#line 84 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			ptr = (void*) (((gsize) _tmp8_) & (~_tmp9_));
#line 85 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp10_ = rptr;
#line 85 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp11_ = mask;
#line 85 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_vala_mask_out = ((gsize) _tmp10_) & _tmp11_;
#line 86 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp12_ = node;
#line 86 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp13_ = ptr;
#line 86 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			gee_hazard_pointer_node_set (_tmp12_, _tmp13_);
#line 1271 "hazardpointer.c"
		}
	}
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp14_ = ptr;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp14_ != NULL) {
#line 1278 "hazardpointer.c"
		GeeHazardPointerNode* _tmp15_;
		GeeHazardPointer* _tmp16_;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp15_ = node;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp16_ = gee_hazard_pointer_new_from_node (_tmp15_);
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		result = _tmp16_;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		if (mask_out) {
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			*mask_out = _vala_mask_out;
#line 1291 "hazardpointer.c"
		}
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		return result;
#line 1295 "hazardpointer.c"
	} else {
		GeeHazardPointerNode* _tmp17_;
#line 91 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp17_ = node;
#line 91 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		gee_hazard_pointer_node_release (_tmp17_);
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		result = NULL;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		if (mask_out) {
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			*mask_out = _vala_mask_out;
#line 1308 "hazardpointer.c"
		}
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		return result;
#line 1312 "hazardpointer.c"
	}
#line 77 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (mask_out) {
#line 77 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		*mask_out = _vala_mask_out;
#line 1318 "hazardpointer.c"
	}
}


/**
 * Copy an object from atomic pointer.
 *
 * @param aptr Atomic pointer.
 * @param mask Mask of flags.
 * @param mask_out Result of mask.
 * @return A copy of object from atomic pointer.
 */
gpointer gee_hazard_pointer_get_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gsize mask, gsize* mask_out) {
	gsize _vala_mask_out = 0UL;
	gpointer result = NULL;
	GeeHazardPointerNode* _tmp0_ = NULL;
	GeeHazardPointerNode* node;
	void* rptr;
	void* ptr;
	void* _tmp14_;
	gpointer _tmp15_;
	gpointer res;
	GeeHazardPointerNode* _tmp16_;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = gee_hazard_pointer_acquire ();
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	node = _tmp0_;
#line 106 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	rptr = NULL;
#line 107 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	ptr = NULL;
#line 108 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_vala_mask_out = (gsize) 0;
#line 1352 "hazardpointer.c"
	{
		gboolean _tmp1_;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp1_ = TRUE;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		while (TRUE) {
#line 1359 "hazardpointer.c"
			gboolean _tmp2_;
			gconstpointer** _tmp6_;
			void* _tmp7_ = NULL;
			void* _tmp8_;
			gsize _tmp9_;
			void* _tmp10_;
			gsize _tmp11_;
			GeeHazardPointerNode* _tmp12_;
			void* _tmp13_;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp2_ = _tmp1_;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			if (!_tmp2_) {
#line 1373 "hazardpointer.c"
				void* _tmp3_;
				gconstpointer** _tmp4_;
				void* _tmp5_ = NULL;
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp3_ = rptr;
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp4_ = aptr;
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp5_ = g_atomic_pointer_get ((volatile gpointer *) ((void**) _tmp4_));
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				if (!(_tmp3_ != _tmp5_)) {
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					break;
#line 1387 "hazardpointer.c"
				}
			}
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp1_ = FALSE;
#line 110 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp6_ = aptr;
#line 110 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp7_ = g_atomic_pointer_get ((volatile gpointer *) ((void**) _tmp6_));
#line 110 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			rptr = _tmp7_;
#line 111 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp8_ = rptr;
#line 111 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp9_ = mask;
#line 111 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			ptr = (void*) (((gsize) _tmp8_) & (~_tmp9_));
#line 112 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp10_ = rptr;
#line 112 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp11_ = mask;
#line 112 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_vala_mask_out = ((gsize) _tmp10_) & _tmp11_;
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp12_ = node;
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp13_ = ptr;
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			gee_hazard_pointer_node_set (_tmp12_, _tmp13_);
#line 1416 "hazardpointer.c"
		}
	}
#line 115 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp14_ = ptr;
#line 115 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp15_ = ((((gconstpointer*) _tmp14_) != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) ((gconstpointer*) _tmp14_)) : ((gpointer) ((gconstpointer*) _tmp14_));
#line 115 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	res = _tmp15_;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp16_ = node;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_hazard_pointer_node_release (_tmp16_);
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = res;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (mask_out) {
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		*mask_out = _vala_mask_out;
#line 1435 "hazardpointer.c"
	}
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 1439 "hazardpointer.c"
}


/**
 * Exchange objects safly.
 *
 * @param aptr Atomic pointer.
 * @param new_ptr New value
 * @param mask Mask of flags.
 * @param new_mask New mask.
 * @param old_mask Previous mask mask.
 * @return Hazard pointer containing old value.
 */
GeeHazardPointer* gee_hazard_pointer_exchange_hazard_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gpointer new_ptr, gsize mask, gsize new_mask, gsize* old_mask) {
	gsize _vala_old_mask = 0UL;
	GeeHazardPointer* result = NULL;
	GeeHazardPointerNode* new_node;
	gconstpointer _tmp0_;
	gpointer _tmp4_;
	gsize _tmp5_;
	gsize _tmp6_;
	void* new_rptr;
	GeeHazardPointerNode* _tmp7_ = NULL;
	GeeHazardPointerNode* node;
	void* rptr;
	void* ptr;
	GeeHazardPointerNode* _tmp22_;
	void* _tmp24_;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	new_node = NULL;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = new_ptr;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp0_ != NULL) {
#line 1474 "hazardpointer.c"
		GeeHazardPointerNode* _tmp1_ = NULL;
		GeeHazardPointerNode* _tmp2_;
		gconstpointer _tmp3_;
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp1_ = gee_hazard_pointer_acquire ();
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		new_node = _tmp1_;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp2_ = new_node;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp3_ = new_ptr;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		gee_hazard_pointer_node_set (_tmp2_, _tmp3_);
#line 1488 "hazardpointer.c"
	}
#line 136 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_vala_old_mask = (gsize) 0;
#line 137 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp4_ = new_ptr;
#line 137 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	new_ptr = NULL;
#line 137 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp5_ = mask;
#line 137 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp6_ = new_mask;
#line 137 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	new_rptr = (void*) (((gsize) _tmp4_) | (_tmp5_ & _tmp6_));
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp7_ = gee_hazard_pointer_acquire ();
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	node = _tmp7_;
#line 139 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	rptr = NULL;
#line 140 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	ptr = NULL;
#line 1510 "hazardpointer.c"
	{
		gboolean _tmp8_;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp8_ = TRUE;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		while (TRUE) {
#line 1517 "hazardpointer.c"
			gboolean _tmp9_;
			gconstpointer** _tmp14_;
			void* _tmp15_ = NULL;
			void* _tmp16_;
			gsize _tmp17_;
			void* _tmp18_;
			gsize _tmp19_;
			GeeHazardPointerNode* _tmp20_;
			void* _tmp21_;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp9_ = _tmp8_;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			if (!_tmp9_) {
#line 1531 "hazardpointer.c"
				gconstpointer** _tmp10_;
				void* _tmp11_;
				void* _tmp12_;
				gboolean _tmp13_ = FALSE;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp10_ = aptr;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp11_ = rptr;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp12_ = new_rptr;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp13_ = g_atomic_pointer_compare_and_exchange ((volatile gpointer *) ((void**) _tmp10_), _tmp11_, _tmp12_);
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				if (!(!_tmp13_)) {
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					break;
#line 1548 "hazardpointer.c"
				}
			}
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp8_ = FALSE;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp14_ = aptr;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp15_ = g_atomic_pointer_get ((volatile gpointer *) ((void**) _tmp14_));
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			rptr = _tmp15_;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp16_ = rptr;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp17_ = mask;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			ptr = (void*) (((gsize) _tmp16_) & (~_tmp17_));
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp18_ = rptr;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp19_ = mask;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_vala_old_mask = ((gsize) _tmp18_) & _tmp19_;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp20_ = node;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp21_ = ptr;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			gee_hazard_pointer_node_set (_tmp20_, _tmp21_);
#line 1577 "hazardpointer.c"
		}
	}
#line 147 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp22_ = new_node;
#line 147 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp22_ != NULL) {
#line 1584 "hazardpointer.c"
		GeeHazardPointerNode* _tmp23_;
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp23_ = new_node;
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		gee_hazard_pointer_node_release (_tmp23_);
#line 1590 "hazardpointer.c"
	}
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp24_ = ptr;
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp24_ != NULL) {
#line 1596 "hazardpointer.c"
		GeeHazardPointerNode* _tmp25_;
		GeeHazardPointer* _tmp26_;
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp25_ = node;
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp26_ = gee_hazard_pointer_new_from_node (_tmp25_);
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		result = _tmp26_;
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_g_destroy_func0 (new_ptr);
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		if (old_mask) {
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			*old_mask = _vala_old_mask;
#line 1611 "hazardpointer.c"
		}
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		return result;
#line 1615 "hazardpointer.c"
	} else {
		GeeHazardPointerNode* _tmp27_;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp27_ = node;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		gee_hazard_pointer_node_release (_tmp27_);
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		result = NULL;
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_g_destroy_func0 (new_ptr);
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		if (old_mask) {
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			*old_mask = _vala_old_mask;
#line 1630 "hazardpointer.c"
		}
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		return result;
#line 1634 "hazardpointer.c"
	}
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_g_destroy_func0 (new_ptr);
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (old_mask) {
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		*old_mask = _vala_old_mask;
#line 1642 "hazardpointer.c"
	}
}


/**
 * Sets object safely
 *
 * @param aptr Atomic pointer.
 * @param new_ptr New value
 * @param mask Mask of flags.
 * @param new_mask New mask.
 */
void gee_hazard_pointer_set_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gpointer new_ptr, gsize mask, gsize new_mask) {
	gconstpointer** _tmp0_;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	gsize _tmp3_;
	gsize _tmp4_;
	GeeHazardPointer* _tmp5_ = NULL;
	GeeHazardPointer* ptr;
	GeeHazardPointer* _tmp6_;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = aptr;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = new_ptr;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = ((_tmp1_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp1_) : ((gpointer) _tmp1_);
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_ = mask;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp4_ = new_mask;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp5_ = gee_hazard_pointer_exchange_hazard_pointer (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, _tmp0_, _tmp2_, _tmp3_, _tmp4_, NULL);
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	ptr = _tmp5_;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp6_ = ptr;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp6_ != NULL) {
#line 1682 "hazardpointer.c"
		void* _tmp7_ = NULL;
		GDestroyNotify _tmp8_ = NULL;
		GeeHazardPointerDestroyNotify _tmp9_ = NULL;
		GeeHazardPointerDestroyNotify notify;
		void* notify_target;
		GDestroyNotify notify_target_destroy_notify;
		GeeHazardPointer* _tmp10_;
		GeeHazardPointerDestroyNotify _tmp11_;
		void* _tmp11__target;
		GDestroyNotify _tmp11__target_destroy_notify;
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp9_ = gee_hazard_pointer_get_destroy_notify (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, &_tmp7_, &_tmp8_);
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		notify = _tmp9_;
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		notify_target = _tmp7_;
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		notify_target_destroy_notify = _tmp8_;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp10_ = ptr;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp11_ = notify;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp11__target = notify_target;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp11__target_destroy_notify = notify_target_destroy_notify;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		notify_target_destroy_notify = NULL;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		gee_hazard_pointer_release (_tmp10_, _tmp11_, _tmp11__target, _tmp11__target_destroy_notify);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		(notify_target_destroy_notify == NULL) ? NULL : (notify_target_destroy_notify (notify_target), NULL);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		notify = NULL;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		notify_target = NULL;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		notify_target_destroy_notify = NULL;
#line 1721 "hazardpointer.c"
	}
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_gee_hazard_pointer_free0 (ptr);
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_g_destroy_func0 (new_ptr);
#line 1727 "hazardpointer.c"
}


/**
 * Exchange objects safly.
 *
 * @param aptr Atomic pointer.
 * @param new_ptr New value
 * @param mask Mask of flags.
 * @param new_mask New mask.
 * @param old_mask Previous mask mask.
 * @return Value that was previously stored.
 */
gpointer gee_hazard_pointer_exchange_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gpointer new_ptr, gsize mask, gsize new_mask, gsize* old_mask) {
	gsize _vala_old_mask = 0UL;
	gpointer result = NULL;
	gconstpointer** _tmp0_;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	gsize _tmp3_;
	gsize _tmp4_;
	gsize _tmp5_ = 0UL;
	GeeHazardPointer* _tmp6_ = NULL;
	GeeHazardPointer* ptr;
	gconstpointer _tmp7_ = NULL;
	GeeHazardPointer* _tmp8_;
	gconstpointer _tmp11_;
	gpointer _tmp12_;
	gpointer rptr;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = aptr;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = new_ptr;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = ((_tmp1_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp1_) : ((gpointer) _tmp1_);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_ = mask;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp4_ = new_mask;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp6_ = gee_hazard_pointer_exchange_hazard_pointer (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, _tmp0_, _tmp2_, _tmp3_, _tmp4_, &_tmp5_);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_vala_old_mask = _tmp5_;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	ptr = _tmp6_;
#line 185 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp8_ = ptr;
#line 185 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp8_ != NULL) {
#line 1777 "hazardpointer.c"
		GeeHazardPointer* _tmp9_;
		gconstpointer _tmp10_ = NULL;
#line 185 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp9_ = ptr;
#line 185 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp10_ = gee_hazard_pointer_get (_tmp9_, FALSE);
#line 185 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp7_ = _tmp10_;
#line 1786 "hazardpointer.c"
	} else {
#line 185 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp7_ = NULL;
#line 1790 "hazardpointer.c"
	}
#line 185 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp11_ = _tmp7_;
#line 185 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp12_ = ((_tmp11_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp11_) : ((gpointer) _tmp11_);
#line 185 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	rptr = _tmp12_;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = rptr;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_gee_hazard_pointer_free0 (ptr);
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_g_destroy_func0 (new_ptr);
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (old_mask) {
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		*old_mask = _vala_old_mask;
#line 1808 "hazardpointer.c"
	}
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 1812 "hazardpointer.c"
}


/**
 * Compares and exchanges objects.
 *
 * @param aptr Atomic pointer.
 * @param old_ptr Old pointer.
 * @param _new_ptr New value.
 * @param old_mask Old mask.
 * @param new_mask New mask.
 * @return Value that was previously stored.
 */
gboolean gee_hazard_pointer_compare_and_exchange_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gconstpointer old_ptr, gpointer _new_ptr, gsize mask, gsize old_mask, gsize new_mask) {
	gboolean result = FALSE;
	gpointer _tmp0_;
	gconstpointer* new_ptr;
	gconstpointer* _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	void* new_rptr;
	gconstpointer _tmp4_;
	gsize _tmp5_;
	gsize _tmp6_;
	void* old_rptr;
	gconstpointer** _tmp7_;
	void* _tmp8_;
	void* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean success;
	gboolean _tmp11_;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = _new_ptr;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_new_ptr = NULL;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	new_ptr = _tmp0_;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = new_ptr;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = mask;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_ = new_mask;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	new_rptr = (void*) (((gsize) _tmp1_) | (_tmp2_ & _tmp3_));
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp4_ = old_ptr;
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp5_ = mask;
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp6_ = old_mask;
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	old_rptr = (void*) (((gsize) _tmp4_) | (_tmp5_ & _tmp6_));
#line 203 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp7_ = aptr;
#line 203 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp8_ = old_rptr;
#line 203 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp9_ = new_rptr;
#line 203 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp10_ = g_atomic_pointer_compare_and_exchange ((volatile gpointer *) ((void**) _tmp7_), _tmp8_, _tmp9_);
#line 203 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	success = _tmp10_;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp11_ = success;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp11_) {
#line 1880 "hazardpointer.c"
		void* _tmp12_ = NULL;
		GDestroyNotify _tmp13_ = NULL;
		GeeHazardPointerDestroyNotify _tmp14_ = NULL;
		GeeHazardPointerDestroyNotify notify;
		void* notify_target;
		GDestroyNotify notify_target_destroy_notify;
		gconstpointer _tmp15_;
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp14_ = gee_hazard_pointer_get_destroy_notify (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, &_tmp12_, &_tmp13_);
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		notify = _tmp14_;
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		notify_target = _tmp12_;
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		notify_target_destroy_notify = _tmp13_;
#line 206 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp15_ = old_ptr;
#line 206 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		if (_tmp15_ != NULL) {
#line 1900 "hazardpointer.c"
			GeeHazardPointerContext* _tmp16_ = NULL;
			gconstpointer _tmp17_;
			GeeHazardPointerDestroyNotify _tmp18_;
			void* _tmp18__target;
			GDestroyNotify _tmp18__target_destroy_notify;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp16_ = gee_hazard_pointer_context_get_current_context ();
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp17_ = old_ptr;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp18_ = notify;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp18__target = notify_target;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp18__target_destroy_notify = notify_target_destroy_notify;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			notify_target_destroy_notify = NULL;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			gee_hazard_pointer_context_release_ptr (_tmp16_, _tmp17_, _tmp18_, _tmp18__target, _tmp18__target_destroy_notify);
#line 1920 "hazardpointer.c"
		}
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		(notify_target_destroy_notify == NULL) ? NULL : (notify_target_destroy_notify (notify_target), NULL);
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		notify = NULL;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		notify_target = NULL;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		notify_target_destroy_notify = NULL;
#line 1930 "hazardpointer.c"
	} else {
		gconstpointer* _tmp19_;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp19_ = new_ptr;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		if (_tmp19_ != NULL) {
#line 1937 "hazardpointer.c"
			gconstpointer* _tmp20_;
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp20_ = new_ptr;
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			new_ptr = NULL;
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_g_destroy_func0 (_new_ptr);
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_new_ptr = _tmp20_;
#line 1947 "hazardpointer.c"
		}
	}
#line 212 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = success;
#line 212 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_g_destroy_func0 (_new_ptr);
#line 212 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 1956 "hazardpointer.c"
}


/**
 * Gets the pointer hold by hazard pointer.
 *
 * @param other_thread Have to be set to ``true`` if accessed from thread that did not create this thread.
 * @return The value hold by pointer.
 */
inline gconstpointer gee_hazard_pointer_get (GeeHazardPointer* self, gboolean other_thread) {
	gconstpointer result = NULL;
	GeeHazardPointerNode* _tmp0_;
	gboolean _tmp1_;
	void* _tmp2_ = NULL;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = self->_node;
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = other_thread;
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = gee_hazard_pointer_node_get (_tmp0_, _tmp1_);
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = _tmp2_;
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 1983 "hazardpointer.c"
}


/**
 * Free the pointer.
 *
 * @param notify method freeing object
 */
void gee_hazard_pointer_release (GeeHazardPointer* self, GeeHazardPointerDestroyNotify notify, void* notify_target, GDestroyNotify notify_target_destroy_notify) {
	GeeHazardPointerNode* _tmp0_;
	void* _tmp1_ = NULL;
	gconstpointer item;
	GeeHazardPointerNode* _tmp2_;
	gconstpointer _tmp3_;
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_if_fail (self != NULL);
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = self->_node;
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = gee_hazard_pointer_node_get (_tmp0_, FALSE);
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	item = _tmp1_;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = self->_node;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_hazard_pointer_node_set (_tmp2_, NULL);
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_ = item;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp3_ != NULL) {
#line 2014 "hazardpointer.c"
		GeeHazardPointerContext* _tmp4_ = NULL;
		gconstpointer _tmp5_;
		GeeHazardPointerDestroyNotify _tmp6_;
		void* _tmp6__target;
		GDestroyNotify _tmp6__target_destroy_notify;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp4_ = gee_hazard_pointer_context_get_current_context ();
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp5_ = item;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp6_ = notify;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp6__target = notify_target;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp6__target_destroy_notify = notify_target_destroy_notify;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		notify_target_destroy_notify = NULL;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		gee_hazard_pointer_context_release_ptr (_tmp4_, _tmp5_, _tmp6_, _tmp6__target, _tmp6__target_destroy_notify);
#line 2034 "hazardpointer.c"
	}
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	(notify_target_destroy_notify == NULL) ? NULL : (notify_target_destroy_notify (notify_target), NULL);
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	notify = NULL;
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	notify_target = NULL;
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	notify_target_destroy_notify = NULL;
#line 2044 "hazardpointer.c"
}


/**
 * Sets default policy (i.e. default policy for user-created contexts).
 * The policy must be concrete and should not be blocking.
 *
 * @param policy New default policy.
 */
void gee_hazard_pointer_set_default_policy (GeeHazardPointerPolicy policy) {
	GeeHazardPointerPolicy _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeHazardPointerPolicy _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeHazardPointerPolicy _tmp4_;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = policy;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = gee_hazard_pointer_policy_is_concrete (_tmp0_);
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_if_fail (_tmp1_);
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = policy;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_ = gee_hazard_pointer_policy_is_blocking (_tmp2_);
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp3_) {
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		g_warning ("hazardpointer.vala:250: Setting blocking defautl Gee.HazardPointer.Pol" \
"icy (there may be a deadlock).\n");
#line 2074 "hazardpointer.c"
	}
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp4_ = policy;
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_atomic_int_set ((volatile gint *) (&gee_hazard_pointer__default_policy), (gint) _tmp4_);
#line 2080 "hazardpointer.c"
}


/**
 * Sets thread exit policy (i.e. default policy for the top-most Context).
 * The policy must be concrete and should not be unsafe.
 *
 * @param policy New thread policy.
 */
void gee_hazard_pointer_set_thread_exit_policy (GeeHazardPointerPolicy policy) {
	GeeHazardPointerPolicy _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeHazardPointerPolicy _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeHazardPointerPolicy _tmp4_;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = policy;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = gee_hazard_pointer_policy_is_concrete (_tmp0_);
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_if_fail (_tmp1_);
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = policy;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_ = gee_hazard_pointer_policy_is_safe (_tmp2_);
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (!_tmp3_) {
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		g_warning ("hazardpointer.vala:262: Setting unsafe globale thread-exit Gee.HazardP" \
"ointer.Policy (there may be a memory leak).\n");
#line 2110 "hazardpointer.c"
	}
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp4_ = policy;
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_atomic_int_set ((volatile gint *) (&gee_hazard_pointer__thread_exit_policy), (gint) _tmp4_);
#line 2116 "hazardpointer.c"
}


/**
 * Sets release (i.e. how exactly the released objects arefreed).
 *
 * The method can be only set before any objects is released and is not thread-safe.
 *
 * @param policy New release policy.
 */
gboolean gee_hazard_pointer_set_release_policy (GeeHazardPointerReleasePolicy policy) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint old_policy;
	gint _tmp1_;
	gint _tmp2_;
	GeeHazardPointerReleasePolicy _tmp3_;
	gboolean _tmp4_ = FALSE;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = g_atomic_int_get ((volatile gint *) (&gee_hazard_pointer_release_policy));
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	old_policy = _tmp0_;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = old_policy;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if ((_tmp1_ & ((sizeof (gint) * 8) - 1)) != 0) {
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		g_critical ("hazardpointer.vala:276: Attempt to change the policy of running helper" \
". Failing.");
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		result = FALSE;
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		return result;
#line 2149 "hazardpointer.c"
	}
#line 279 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = old_policy;
#line 279 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_ = policy;
#line 279 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp4_ = g_atomic_int_compare_and_exchange ((volatile gint *) (&gee_hazard_pointer_release_policy), _tmp2_, (gint) _tmp3_);
#line 279 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (!_tmp4_) {
#line 280 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		g_critical ("hazardpointer.vala:280: Concurrent access to release policy detected. " \
"Failing.");
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		result = FALSE;
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		return result;
#line 2165 "hazardpointer.c"
	}
#line 283 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = TRUE;
#line 283 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 2171 "hazardpointer.c"
}


/**
 * Gets a new hazard pointer node.
 *
 * @return new hazard pointer node.
 */
inline GeeHazardPointerNode* gee_hazard_pointer_acquire (void) {
	GeeHazardPointerNode* result = NULL;
	GeeHazardPointerNode* _tmp9_;
	GeeHazardPointerNode* node;
	GeeHazardPointerNode* old_head;
	GeeHazardPointerNode* _tmp18_;
	{
		GeeHazardPointerNode* _tmp0_ = NULL;
		GeeHazardPointerNode* curr;
#line 643 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp0_ = gee_hazard_pointer_get_head ();
#line 643 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		curr = _tmp0_;
#line 2193 "hazardpointer.c"
		{
			gboolean _tmp1_;
#line 643 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp1_ = TRUE;
#line 643 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			while (TRUE) {
#line 2200 "hazardpointer.c"
				gboolean _tmp2_;
				GeeHazardPointerNode* _tmp5_;
				GeeHazardPointerNode* _tmp6_;
				gboolean _tmp7_ = FALSE;
#line 643 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp2_ = _tmp1_;
#line 643 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				if (!_tmp2_) {
#line 2209 "hazardpointer.c"
					GeeHazardPointerNode* _tmp3_;
					GeeHazardPointerNode* _tmp4_ = NULL;
#line 643 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp3_ = curr;
#line 643 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp4_ = gee_hazard_pointer_node_get_next (_tmp3_);
#line 643 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					curr = _tmp4_;
#line 2218 "hazardpointer.c"
				}
#line 643 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp1_ = FALSE;
#line 643 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp5_ = curr;
#line 643 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				if (!(_tmp5_ != NULL)) {
#line 643 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					break;
#line 2228 "hazardpointer.c"
				}
#line 644 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp6_ = curr;
#line 644 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp7_ = gee_hazard_pointer_node_activate (_tmp6_);
#line 644 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				if (_tmp7_) {
#line 2236 "hazardpointer.c"
					GeeHazardPointerNode* _tmp8_;
#line 645 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp8_ = curr;
#line 645 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					result = _tmp8_;
#line 645 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					return result;
#line 2244 "hazardpointer.c"
				}
			}
		}
	}
#line 646 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp9_ = gee_hazard_pointer_node_new ();
#line 646 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	node = _tmp9_;
#line 647 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	old_head = NULL;
#line 2255 "hazardpointer.c"
	{
		gboolean _tmp10_;
#line 648 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp10_ = TRUE;
#line 648 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		while (TRUE) {
#line 2262 "hazardpointer.c"
			gboolean _tmp11_;
			GeeHazardPointerNode* _tmp15_;
			void* _tmp16_ = NULL;
			GeeHazardPointerNode* _tmp17_;
#line 648 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp11_ = _tmp10_;
#line 648 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			if (!_tmp11_) {
#line 2271 "hazardpointer.c"
				GeeHazardPointerNode* _tmp12_;
				GeeHazardPointerNode* _tmp13_;
				gboolean _tmp14_ = FALSE;
#line 650 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp12_ = old_head;
#line 650 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp13_ = node;
#line 650 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp14_ = g_atomic_pointer_compare_and_exchange ((volatile gpointer *) (&gee_hazard_pointer__head), _tmp12_, _tmp13_);
#line 650 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				if (!(!_tmp14_)) {
#line 650 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					break;
#line 2285 "hazardpointer.c"
				}
			}
#line 648 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp10_ = FALSE;
#line 649 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp15_ = node;
#line 649 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp16_ = g_atomic_pointer_get ((volatile gpointer *) (&gee_hazard_pointer__head));
#line 649 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			old_head = (GeeHazardPointerNode*) _tmp16_;
#line 649 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp17_ = old_head;
#line 649 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			gee_hazard_pointer_node_set_next (_tmp15_, _tmp17_);
#line 2300 "hazardpointer.c"
		}
	}
#line 651 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp18_ = node;
#line 651 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = _tmp18_;
#line 651 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 2309 "hazardpointer.c"
}


/**
 * Tries to free from list.
 *
 * @return ``true`` if list is empty.
 */
gboolean gee_hazard_pointer_try_free (GeeArrayList* to_free) {
	gboolean result = FALSE;
	GeeHashSet* _tmp0_;
	GeeCollection* used;
	GeeArrayList* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
#line 659 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_val_if_fail (to_free != NULL, FALSE);
#line 660 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 660 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	used = (GeeCollection*) _tmp0_;
#line 2331 "hazardpointer.c"
	{
		GeeHazardPointerNode* _tmp1_ = NULL;
		GeeHazardPointerNode* current;
#line 661 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp1_ = gee_hazard_pointer_get_head ();
#line 661 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		current = _tmp1_;
#line 2339 "hazardpointer.c"
		{
			gboolean _tmp2_;
#line 661 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp2_ = TRUE;
#line 661 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			while (TRUE) {
#line 2346 "hazardpointer.c"
				gboolean _tmp3_;
				GeeHazardPointerNode* _tmp6_;
				GeeCollection* _tmp7_;
				GeeHazardPointerNode* _tmp8_;
				void* _tmp9_ = NULL;
#line 661 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp3_ = _tmp2_;
#line 661 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				if (!_tmp3_) {
#line 2356 "hazardpointer.c"
					GeeHazardPointerNode* _tmp4_;
					GeeHazardPointerNode* _tmp5_ = NULL;
#line 661 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp4_ = current;
#line 661 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp5_ = gee_hazard_pointer_node_get_next (_tmp4_);
#line 661 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					current = _tmp5_;
#line 2365 "hazardpointer.c"
				}
#line 661 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp2_ = FALSE;
#line 661 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp6_ = current;
#line 661 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				if (!(_tmp6_ != NULL)) {
#line 661 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					break;
#line 2375 "hazardpointer.c"
				}
#line 662 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp7_ = used;
#line 662 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp8_ = current;
#line 662 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp9_ = gee_hazard_pointer_node_get (_tmp8_, TRUE);
#line 662 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				gee_collection_add (_tmp7_, _tmp9_);
#line 2385 "hazardpointer.c"
			}
		}
	}
	{
		gint i;
#line 664 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		i = 0;
#line 2393 "hazardpointer.c"
		{
			gboolean _tmp10_;
#line 664 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp10_ = TRUE;
#line 664 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			while (TRUE) {
#line 2400 "hazardpointer.c"
				gboolean _tmp11_;
				gint _tmp12_;
				GeeArrayList* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				GeeArrayList* _tmp16_;
				gint _tmp17_;
				gpointer _tmp18_ = NULL;
				GeeHazardPointerFreeNode* current;
				GeeCollection* _tmp19_;
				GeeHazardPointerFreeNode* _tmp20_;
				void* _tmp21_;
				gboolean _tmp22_ = FALSE;
#line 664 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp11_ = _tmp10_;
#line 664 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				if (!_tmp11_) {
#line 2418 "hazardpointer.c"
				}
#line 664 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp10_ = FALSE;
#line 664 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp12_ = i;
#line 664 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp13_ = to_free;
#line 664 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
#line 664 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp15_ = _tmp14_;
#line 664 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				if (!(_tmp12_ < _tmp15_)) {
#line 664 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					break;
#line 2434 "hazardpointer.c"
				}
#line 665 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp16_ = to_free;
#line 665 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp17_ = i;
#line 665 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 665 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				current = _tmp18_;
#line 666 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp19_ = used;
#line 666 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp20_ = current;
#line 666 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp21_ = _tmp20_->pointer;
#line 666 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				_tmp22_ = gee_collection_contains (_tmp19_, _tmp21_);
#line 666 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
				if (_tmp22_) {
#line 2454 "hazardpointer.c"
					gint _tmp23_;
#line 670 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp23_ = i;
#line 670 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					i = _tmp23_ + 1;
#line 2460 "hazardpointer.c"
				} else {
					GeeArrayList* _tmp24_;
					GeeArrayList* _tmp25_;
					gint _tmp26_;
					gint _tmp27_;
					gpointer _tmp28_ = NULL;
					GeeHazardPointerFreeNode* cur;
					gint _tmp29_;
					GeeArrayList* _tmp30_;
					gint _tmp31_;
					gint _tmp32_;
					GeeHazardPointerFreeNode* _tmp40_;
					GeeHazardPointerDestroyNotify _tmp41_;
					void* _tmp41__target;
					GeeHazardPointerFreeNode* _tmp42_;
					void* _tmp43_;
					GeeHazardPointerFreeNode* _tmp44_;
#line 675 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp24_ = to_free;
#line 675 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp25_ = to_free;
#line 675 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
#line 675 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp27_ = _tmp26_;
#line 675 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp28_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp24_, _tmp27_ - 1);
#line 675 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					cur = _tmp28_;
#line 676 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp29_ = i;
#line 676 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp30_ = to_free;
#line 676 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp31_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp30_);
#line 676 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp32_ = _tmp31_;
#line 676 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					if (_tmp29_ != _tmp32_) {
#line 2500 "hazardpointer.c"
						GeeArrayList* _tmp33_;
						gint _tmp34_;
						gpointer _tmp35_ = NULL;
						GeeHazardPointerFreeNode* temp;
						GeeArrayList* _tmp36_;
						gint _tmp37_;
						GeeHazardPointerFreeNode* _tmp38_;
						GeeHazardPointerFreeNode* _tmp39_;
#line 677 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
						_tmp33_ = to_free;
#line 677 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
						_tmp34_ = i;
#line 677 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
						_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _tmp34_);
#line 677 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
						temp = _tmp35_;
#line 678 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
						_tmp36_ = to_free;
#line 678 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
						_tmp37_ = i;
#line 678 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
						_tmp38_ = cur;
#line 678 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
						gee_abstract_list_set ((GeeAbstractList*) _tmp36_, _tmp37_, _tmp38_);
#line 679 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
						_tmp39_ = temp;
#line 679 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
						cur = _tmp39_;
#line 2529 "hazardpointer.c"
					}
#line 681 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp40_ = cur;
#line 681 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp41_ = _tmp40_->destroy_notify;
#line 681 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp41__target = _tmp40_->destroy_notify_target;
#line 681 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp42_ = cur;
#line 681 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp43_ = _tmp42_->pointer;
#line 681 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp41_ (_tmp43_, _tmp41__target);
#line 682 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					_tmp44_ = cur;
#line 682 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
					gee_hazard_pointer_free_node_free (_tmp44_);
#line 2547 "hazardpointer.c"
				}
			}
		}
	}
#line 685 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp45_ = to_free;
#line 685 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp46_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp45_);
#line 685 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp47_ = _tmp46_;
#line 685 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = _tmp47_ > 0;
#line 685 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_g_object_unref0 (used);
#line 685 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 2564 "hazardpointer.c"
}


/**
 * Gets head of hazard pointers.
 * @return Hazard pointer head.
 */
GeeHazardPointerNode* gee_hazard_pointer_get_head (void) {
	GeeHazardPointerNode* result = NULL;
	void* _tmp0_ = NULL;
#line 693 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = g_atomic_pointer_get ((volatile gpointer *) (&gee_hazard_pointer__head));
#line 693 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = (GeeHazardPointerNode*) _tmp0_;
#line 693 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 2581 "hazardpointer.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 710 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 710 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return _data5_;
#line 2590 "hazardpointer.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 710 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 2599 "hazardpointer.c"
		GType g_type;
		GBoxedCopyFunc g_dup_func;
		GDestroyNotify g_destroy_func;
#line 710 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		g_type = _data5_->g_type;
#line 710 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		g_dup_func = _data5_->g_dup_func;
#line 710 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		g_destroy_func = _data5_->g_destroy_func;
#line 710 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		g_slice_free (Block5Data, _data5_);
#line 2611 "hazardpointer.c"
	}
}


static void __lambda36_ (Block5Data* _data5_, void* ptr) {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	void* _tmp0_;
	gconstpointer* gptr;
	gconstpointer* _tmp1_;
	gpointer obj;
#line 711 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_type = _data5_->g_type;
#line 711 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_dup_func = _data5_->g_dup_func;
#line 711 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_destroy_func = _data5_->g_destroy_func;
#line 712 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = ptr;
#line 712 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gptr = _tmp0_;
#line 713 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = gptr;
#line 713 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gptr = NULL;
#line 713 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	obj = _tmp1_;
#line 714 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_g_destroy_func0 (obj);
#line 714 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	obj = NULL;
#line 711 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_g_destroy_func0 (obj);
#line 2646 "hazardpointer.c"
}


static void ___lambda36__gee_hazard_pointer_destroy_notify (void* ptr, gpointer self) {
#line 711 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	__lambda36_ (self, ptr);
#line 2653 "hazardpointer.c"
}


GeeHazardPointerDestroyNotify gee_hazard_pointer_get_destroy_notify (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, void** result_target, GDestroyNotify* result_target_destroy_notify) {
	GeeHazardPointerDestroyNotify result = NULL;
	Block5Data* _data5_;
	GeeHazardPointerDestroyNotify _tmp0_;
	void* _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
#line 710 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 710 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_data5_->_ref_count_ = 1;
#line 710 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_data5_->g_type = g_type;
#line 710 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_data5_->g_dup_func = g_dup_func;
#line 710 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_data5_->g_destroy_func = g_destroy_func;
#line 711 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = ___lambda36__gee_hazard_pointer_destroy_notify;
#line 711 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0__target = block5_data_ref (_data5_);
#line 711 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0__target_destroy_notify = block5_data_unref;
#line 711 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	*result_target = _tmp0__target;
#line 711 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	*result_target_destroy_notify = _tmp0__target_destroy_notify;
#line 711 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = _tmp0_;
#line 711 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	block5_data_unref (_data5_);
#line 711 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_data5_ = NULL;
#line 711 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 2691 "hazardpointer.c"
}


static GeeHazardPointerPolicy* _gee_hazard_pointer_policy_dup (GeeHazardPointerPolicy* self) {
	GeeHazardPointerPolicy* dup;
#line 532 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	dup = g_new0 (GeeHazardPointerPolicy, 1);
#line 532 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	memcpy (dup, self, sizeof (GeeHazardPointerPolicy));
#line 532 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return dup;
#line 2703 "hazardpointer.c"
}


static gpointer __gee_hazard_pointer_policy_dup0 (gpointer self) {
#line 532 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return self ? _gee_hazard_pointer_policy_dup (self) : NULL;
#line 2710 "hazardpointer.c"
}


GeeHazardPointerContext* gee_hazard_pointer_context_new (GeeHazardPointerPolicy* policy) {
	GeeHazardPointerContext* self;
	GeeArrayList* _tmp0_;
	void* _tmp1_ = NULL;
	GeeHazardPointerPolicy* _tmp2_;
#line 526 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	self = g_slice_new0 (GeeHazardPointerContext);
#line 526 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_hazard_pointer_context_instance_init (self);
#line 527 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
#line 527 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_g_object_unref0 (self->_to_free);
#line 527 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	self->_to_free = _tmp0_;
#line 528 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = g_static_private_get (&gee_hazard_pointer_context__current_context);
#line 528 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	self->_parent = _tmp1_;
#line 529 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_static_private_set (&gee_hazard_pointer_context__current_context, self, NULL);
#line 530 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = policy;
#line 530 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp2_ == NULL) {
#line 2739 "hazardpointer.c"
		GeeHazardPointerContext* _tmp3_;
#line 531 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp3_ = self->_parent;
#line 531 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		if (_tmp3_ == NULL) {
#line 2745 "hazardpointer.c"
			gint _tmp4_ = 0;
			GeeHazardPointerPolicy _tmp5_;
			GeeHazardPointerPolicy* _tmp6_;
#line 532 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp4_ = g_atomic_int_get ((volatile gint *) (&gee_hazard_pointer__thread_exit_policy));
#line 532 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp5_ = (GeeHazardPointerPolicy) _tmp4_;
#line 532 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp6_ = __gee_hazard_pointer_policy_dup0 (&_tmp5_);
#line 532 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_g_free0 (self->_policy);
#line 532 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			self->_policy = _tmp6_;
#line 2759 "hazardpointer.c"
		} else {
			gint _tmp7_ = 0;
			GeeHazardPointerPolicy _tmp8_;
			GeeHazardPointerPolicy* _tmp9_;
#line 534 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp7_ = g_atomic_int_get ((volatile gint *) (&gee_hazard_pointer__default_policy));
#line 534 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp8_ = (GeeHazardPointerPolicy) _tmp7_;
#line 534 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp9_ = __gee_hazard_pointer_policy_dup0 (&_tmp8_);
#line 534 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_g_free0 (self->_policy);
#line 534 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			self->_policy = _tmp9_;
#line 2774 "hazardpointer.c"
		}
	} else {
		GeeHazardPointerPolicy* _tmp10_;
		GeeHazardPointerPolicy _tmp11_ = 0;
		GeeHazardPointerPolicy* _tmp12_;
#line 537 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp10_ = policy;
#line 537 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp11_ = gee_hazard_pointer_policy_to_concrete (*_tmp10_);
#line 537 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp12_ = __gee_hazard_pointer_policy_dup0 (&_tmp11_);
#line 537 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_g_free0 (self->_policy);
#line 537 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		self->_policy = _tmp12_;
#line 2790 "hazardpointer.c"
	}
#line 526 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return self;
#line 2794 "hazardpointer.c"
}


/**
 * Tries to free all freed pointer in current context.
 */
void gee_hazard_pointer_context_try_free (GeeHazardPointerContext* self) {
	GeeArrayList* _tmp0_;
#line 573 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_if_fail (self != NULL);
#line 574 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = self->_to_free;
#line 574 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_hazard_pointer_try_free (_tmp0_);
#line 2809 "hazardpointer.c"
}


/**
 * Ensure that whole context is freed. Plase note that it might block.
 */
void gee_hazard_pointer_context_free_all (GeeHazardPointerContext* self) {
#line 580 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_if_fail (self != NULL);
#line 581 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	while (TRUE) {
#line 2821 "hazardpointer.c"
		GeeArrayList* _tmp0_;
		gboolean _tmp1_ = FALSE;
#line 581 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp0_ = self->_to_free;
#line 581 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp1_ = gee_hazard_pointer_try_free (_tmp0_);
#line 581 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		if (!_tmp1_) {
#line 581 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			break;
#line 2832 "hazardpointer.c"
		}
#line 582 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		g_thread_yield ();
#line 2836 "hazardpointer.c"
	}
}


/**
 * Tries to push the current context to releaser.
 */
void gee_hazard_pointer_context_try_release (GeeHazardPointerContext* self) {
	gboolean _tmp0_ = FALSE;
#line 588 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_if_fail (self != NULL);
#line 589 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = g_static_mutex_trylock (&gee_hazard_pointer__queue_mutex);
#line 589 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp0_) {
#line 2852 "hazardpointer.c"
		GeeQueue* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
#line 590 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp1_ = gee_hazard_pointer__queue;
#line 590 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp2_ = self->_to_free;
#line 590 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		self->_to_free = NULL;
#line 590 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp3_ = _tmp2_;
#line 590 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		gee_queue_offer (_tmp1_, _tmp3_);
#line 590 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_g_object_unref0 (_tmp3_);
#line 591 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp4_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
#line 591 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_g_object_unref0 (self->_to_free);
#line 591 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		self->_to_free = _tmp4_;
#line 592 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		g_static_mutex_unlock (&gee_hazard_pointer__queue_mutex);
#line 2877 "hazardpointer.c"
	}
}


/**
 * Pushes the current context to releaser. Plase note that it might block.
 */
void gee_hazard_pointer_context_release (GeeHazardPointerContext* self) {
	GeeQueue* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
#line 599 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_if_fail (self != NULL);
#line 600 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_static_mutex_lock (&gee_hazard_pointer__queue_mutex);
#line 601 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = gee_hazard_pointer__queue;
#line 601 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = self->_to_free;
#line 601 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	self->_to_free = NULL;
#line 601 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = _tmp1_;
#line 601 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_queue_offer (_tmp0_, _tmp2_);
#line 601 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_g_object_unref0 (_tmp2_);
#line 602 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
#line 602 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_g_object_unref0 (self->_to_free);
#line 602 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	self->_to_free = _tmp3_;
#line 603 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_static_mutex_unlock (&gee_hazard_pointer__queue_mutex);
#line 2914 "hazardpointer.c"
}


/**
 * Add pointer to freed array.
 */
inline void gee_hazard_pointer_context_release_ptr (GeeHazardPointerContext* self, void* ptr, GeeHazardPointerDestroyNotify notify, void* notify_target, GDestroyNotify notify_target_destroy_notify) {
	GeeHazardPointerFreeNode* _tmp0_;
	GeeHazardPointerFreeNode* node;
	GeeHazardPointerFreeNode* _tmp1_;
	void* _tmp2_;
	GeeHazardPointerFreeNode* _tmp3_;
	GeeHazardPointerDestroyNotify _tmp4_;
	void* _tmp4__target;
	GDestroyNotify _tmp4__target_destroy_notify;
	GeeArrayList* _tmp5_;
	GeeHazardPointerFreeNode* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	guint _tmp10_;
#line 609 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_if_fail (self != NULL);
#line 610 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = gee_hazard_pointer_free_node_new ();
#line 610 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	node = _tmp0_;
#line 611 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = node;
#line 611 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = ptr;
#line 611 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_->pointer = _tmp2_;
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_ = node;
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp4_ = notify;
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp4__target = notify_target;
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp4__target_destroy_notify = notify_target_destroy_notify;
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	notify_target_destroy_notify = NULL;
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	(_tmp3_->destroy_notify_target_destroy_notify == NULL) ? NULL : (_tmp3_->destroy_notify_target_destroy_notify (_tmp3_->destroy_notify_target), NULL);
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_->destroy_notify = NULL;
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_->destroy_notify_target = NULL;
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_->destroy_notify_target_destroy_notify = NULL;
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_->destroy_notify = _tmp4_;
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_->destroy_notify_target = _tmp4__target;
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_->destroy_notify_target_destroy_notify = _tmp4__target_destroy_notify;
#line 613 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp5_ = self->_to_free;
#line 613 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp6_ = node;
#line 613 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp6_);
#line 614 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp7_ = self->_to_free;
#line 614 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp7_);
#line 614 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp9_ = _tmp8_;
#line 614 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp10_ = gee_hazard_pointer_context_THRESHOLD;
#line 614 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (((guint) _tmp9_) >= _tmp10_) {
#line 2988 "hazardpointer.c"
		GeeArrayList* _tmp11_;
#line 615 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp11_ = self->_to_free;
#line 615 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		gee_hazard_pointer_try_free (_tmp11_);
#line 2994 "hazardpointer.c"
	}
#line 609 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	(notify_target_destroy_notify == NULL) ? NULL : (notify_target_destroy_notify (notify_target), NULL);
#line 609 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	notify = NULL;
#line 609 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	notify_target = NULL;
#line 609 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	notify_target_destroy_notify = NULL;
#line 3004 "hazardpointer.c"
}


/**
 * Gets current context.
 */
inline GeeHazardPointerContext* gee_hazard_pointer_context_get_current_context (void) {
	GeeHazardPointerContext* result = NULL;
	void* _tmp0_ = NULL;
#line 622 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = g_static_private_get (&gee_hazard_pointer_context__current_context);
#line 622 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = _tmp0_;
#line 622 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 3020 "hazardpointer.c"
}


static inline gboolean _gee_hazard_pointer_context_should_free (GeeHazardPointerContext* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GeeHazardPointerContext* _tmp2_;
	gboolean _tmp6_;
	gboolean _tmp11_;
#line 625 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = self->_parent;
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp2_ == NULL) {
#line 3037 "hazardpointer.c"
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp3_ = self->_to_free;
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp5_ = _tmp4_;
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp1_ = _tmp5_ > 0;
#line 3049 "hazardpointer.c"
	} else {
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp1_ = FALSE;
#line 3053 "hazardpointer.c"
	}
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp6_ = _tmp1_;
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp6_) {
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp0_ = TRUE;
#line 3061 "hazardpointer.c"
	} else {
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		guint _tmp10_;
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp7_ = self->_to_free;
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp7_);
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp9_ = _tmp8_;
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp10_ = gee_hazard_pointer_context_THRESHOLD;
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp0_ = ((guint) _tmp9_) >= _tmp10_;
#line 3077 "hazardpointer.c"
	}
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp11_ = _tmp0_;
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = _tmp11_;
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 3085 "hazardpointer.c"
}


static void gee_hazard_pointer_context_instance_init (GeeHazardPointerContext * self) {
}


void gee_hazard_pointer_context_free (GeeHazardPointerContext* self) {
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint size;
	gboolean clean_parent;
	gint _tmp3_;
	GeeHazardPointerContext* _tmp18_;
	gboolean _tmp19_;
#line 548 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = self->_to_free;
#line 548 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
#line 548 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp2_ = _tmp1_;
#line 548 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	size = _tmp2_;
#line 549 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	clean_parent = FALSE;
#line 550 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp3_ = size;
#line 550 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp3_ > 0) {
#line 3116 "hazardpointer.c"
		GeeArrayList* remaining = NULL;
		gboolean _tmp4_ = FALSE;
		GeeHazardPointerContext* _tmp5_;
		gboolean _tmp8_;
		GeeArrayList* _tmp13_;
#line 552 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp5_ = self->_parent;
#line 552 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		if (_tmp5_ == NULL) {
#line 552 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp4_ = TRUE;
#line 3128 "hazardpointer.c"
		} else {
			gint _tmp6_;
			guint _tmp7_;
#line 552 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp6_ = size;
#line 552 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp7_ = gee_hazard_pointer_context_THRESHOLD;
#line 552 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp4_ = ((guint) _tmp6_) >= _tmp7_;
#line 3138 "hazardpointer.c"
		}
#line 552 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp8_ = _tmp4_;
#line 552 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		if (_tmp8_) {
#line 3144 "hazardpointer.c"
			GeeHazardPointerPolicy* _tmp9_;
			GeeArrayList* _tmp10_;
			GeeArrayList* _tmp11_ = NULL;
#line 553 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp9_ = self->_policy;
#line 553 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp10_ = self->_to_free;
#line 553 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			self->_to_free = NULL;
#line 553 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp11_ = gee_hazard_pointer_policy_perform (*_tmp9_, _tmp10_);
#line 553 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_g_object_unref0 (remaining);
#line 553 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			remaining = _tmp11_;
#line 3160 "hazardpointer.c"
		} else {
			GeeArrayList* _tmp12_;
#line 555 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp12_ = self->_to_free;
#line 555 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			self->_to_free = NULL;
#line 555 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_g_object_unref0 (remaining);
#line 555 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			remaining = _tmp12_;
#line 3171 "hazardpointer.c"
		}
#line 556 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp13_ = remaining;
#line 556 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		if (_tmp13_ != NULL) {
#line 3177 "hazardpointer.c"
			GeeHazardPointerContext* _tmp14_;
			GeeHazardPointerContext* _tmp15_;
			GeeArrayList* _tmp16_;
			GeeArrayList* _tmp17_;
#line 557 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp14_ = self->_parent;
#line 557 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_vala_assert (_tmp14_ != NULL, "_parent != null");
#line 558 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp15_ = self->_parent;
#line 558 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp16_ = _tmp15_->_to_free;
#line 558 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			_tmp17_ = remaining;
#line 558 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			gee_array_list_add_all (_tmp16_, (GeeCollection*) _tmp17_);
#line 559 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
			clean_parent = TRUE;
#line 3196 "hazardpointer.c"
		}
#line 550 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_g_object_unref0 (remaining);
#line 3200 "hazardpointer.c"
	}
#line 565 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp18_ = self->_parent;
#line 565 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_static_private_set (&gee_hazard_pointer_context__current_context, _tmp18_, NULL);
#line 566 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp19_ = clean_parent;
#line 566 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp19_) {
#line 3210 "hazardpointer.c"
		GeeHazardPointerContext* _tmp20_;
		GeeArrayList* _tmp21_;
#line 567 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp20_ = self->_parent;
#line 567 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp21_ = _tmp20_->_to_free;
#line 567 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		gee_hazard_pointer_try_free (_tmp21_);
#line 3219 "hazardpointer.c"
	}
#line 630 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_g_object_unref0 (self->_to_free);
#line 631 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_g_free0 (self->_policy);
#line 525 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_slice_free (GeeHazardPointerContext, self);
#line 3227 "hazardpointer.c"
}


GeeHazardPointerFreeNode* gee_hazard_pointer_free_node_new (void) {
	GeeHazardPointerFreeNode* self;
#line 719 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	self = g_slice_new0 (GeeHazardPointerFreeNode);
#line 719 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_hazard_pointer_free_node_instance_init (self);
#line 719 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return self;
#line 3239 "hazardpointer.c"
}


static void gee_hazard_pointer_free_node_instance_init (GeeHazardPointerFreeNode * self) {
}


void gee_hazard_pointer_free_node_free (GeeHazardPointerFreeNode* self) {
#line 721 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	(self->destroy_notify_target_destroy_notify == NULL) ? NULL : (self->destroy_notify_target_destroy_notify (self->destroy_notify_target), NULL);
#line 721 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	self->destroy_notify = NULL;
#line 721 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	self->destroy_notify_target = NULL;
#line 721 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	self->destroy_notify_target_destroy_notify = NULL;
#line 719 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_slice_free (GeeHazardPointerFreeNode, self);
#line 3258 "hazardpointer.c"
}


GeeHazardPointerNode* gee_hazard_pointer_node_new (void) {
	GeeHazardPointerNode* self;
#line 729 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	self = g_slice_new0 (GeeHazardPointerNode);
#line 729 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_hazard_pointer_node_instance_init (self);
#line 730 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_atomic_pointer_set ((volatile gpointer *) (&self->_hazard), NULL);
#line 731 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_atomic_int_set ((volatile gint *) (&self->_active), 1);
#line 729 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return self;
#line 3274 "hazardpointer.c"
}


void gee_hazard_pointer_node_release (GeeHazardPointerNode* self) {
#line 738 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_if_fail (self != NULL);
#line 739 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_atomic_pointer_set ((volatile gpointer *) (&self->_hazard), NULL);
#line 740 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_atomic_int_set ((volatile gint *) (&self->_active), 0);
#line 3285 "hazardpointer.c"
}


inline gboolean gee_hazard_pointer_node_is_active (GeeHazardPointerNode* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
#line 743 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 744 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = g_atomic_int_get ((volatile gint *) (&self->_active));
#line 744 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = _tmp0_ != 0;
#line 744 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 3300 "hazardpointer.c"
}


inline gboolean gee_hazard_pointer_node_activate (GeeHazardPointerNode* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 747 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 748 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = g_atomic_int_compare_and_exchange ((volatile gint *) (&self->_active), 0, 1);
#line 748 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = _tmp0_;
#line 748 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 3315 "hazardpointer.c"
}


inline void gee_hazard_pointer_node_set (GeeHazardPointerNode* self, void* ptr) {
	void* _tmp0_;
#line 751 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_if_fail (self != NULL);
#line 752 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = ptr;
#line 752 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_atomic_pointer_set ((volatile gpointer *) (&self->_hazard), _tmp0_);
#line 3327 "hazardpointer.c"
}


inline void* gee_hazard_pointer_node_get (GeeHazardPointerNode* self, gboolean safe) {
	void* result = NULL;
	gboolean _tmp0_;
#line 755 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 756 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = safe;
#line 756 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	if (_tmp0_) {
#line 3340 "hazardpointer.c"
		void* _tmp1_ = NULL;
#line 757 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp1_ = g_atomic_pointer_get ((volatile gpointer *) (&self->_hazard));
#line 757 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		result = (void*) _tmp1_;
#line 757 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		return result;
#line 3348 "hazardpointer.c"
	} else {
		void* _tmp2_;
#line 759 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		_tmp2_ = self->_hazard;
#line 759 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		result = (void*) _tmp2_;
#line 759 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
		return result;
#line 3357 "hazardpointer.c"
	}
}


inline GeeHazardPointerNode* gee_hazard_pointer_node_get_next (GeeHazardPointerNode* self) {
	GeeHazardPointerNode* result = NULL;
	void* _tmp0_ = NULL;
#line 763 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 764 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = g_atomic_pointer_get ((volatile gpointer *) (&self->_next));
#line 764 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	result = (GeeHazardPointerNode*) _tmp0_;
#line 764 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	return result;
#line 3373 "hazardpointer.c"
}


inline void gee_hazard_pointer_node_set_next (GeeHazardPointerNode* self, GeeHazardPointerNode* next) {
	GeeHazardPointerNode* _tmp0_;
#line 767 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_return_if_fail (self != NULL);
#line 768 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = next;
#line 768 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_atomic_pointer_set ((volatile gpointer *) (&self->_next), _tmp0_);
#line 3385 "hazardpointer.c"
}


static void gee_hazard_pointer_node_instance_init (GeeHazardPointerNode * self) {
}


void gee_hazard_pointer_node_free (GeeHazardPointerNode* self) {
	GeeHazardPointerNode* _tmp0_;
#line 735 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = self->_next;
#line 735 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_hazard_pointer_node_free (_tmp0_);
#line 728 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_slice_free (GeeHazardPointerNode, self);
#line 3401 "hazardpointer.c"
}


static void gee_hazard_pointer_instance_init (GeeHazardPointer * self) {
}


void gee_hazard_pointer_free (GeeHazardPointer* self) {
	GeeHazardPointerNode* _tmp0_;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	_tmp0_ = self->_node;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	gee_hazard_pointer_node_release (_tmp0_);
#line 51 "/home/mpiechotka/Projects/contributions/libgee/gee/hazardpointer.vala"
	g_slice_free (GeeHazardPointer, self);
#line 3417 "hazardpointer.c"
}



