
#include <libgnomecanvasmm/widget.h>
#include <libgnomecanvasmm/private/widget_p.h>

/* $Id: widget.ccg,v 1.1 2002/02/24 20:41:19 murrayc Exp $ */

/* widget.cc
 *
 * Copyright (C) 1998 EMC Capital Management Inc.
 * Developed by Havoc Pennington <hp@pobox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdarg.h>
#include <gtkmm/widget.h>

namespace Gnome
{

namespace Canvas
{

Widget::Widget(Group& parentx, double x, double y,
                           Gtk::Widget& w)
  : Item(GNOME_CANVAS_ITEM(g_object_new(get_type(),0)))
{
  item_construct(parentx);
  set("x", x, "y", y, "widget",w.gobj(), 0);
}

Widget::Widget(Group& parentx)
  : Item(GNOME_CANVAS_ITEM(g_object_new(get_type(),0)))
{
  item_construct(parentx);
}

} /* namespace Canvas */
} /* namespace Gnome */


namespace
{
} // anonymous namespace


namespace Glib
{

Gnome::Canvas::Widget* wrap(GnomeCanvasWidget* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::Canvas::Widget *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace Canvas
{


/* The *_Class implementation: */

GType Widget_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        GType gtype_base = gnome_canvas_widget_get_type();
        Glib::ustring gtypename = "gtkmm__" + Glib::ustring( g_type_name(gtype_base) ); //This prefix is also used by libglademm to calculate gtkmm gtypes from gtk+ gtypes.
        gtype_ = g_type_register_static(gtype_base, gtypename.c_str(), &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Widget_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Widget_Class::wrap_new(GObject* o)
{
  return manage(new Widget((GnomeCanvasWidget*)(o)));
}


/* The implementation: */

Widget::Widget(GnomeCanvasWidget* castitem)
: Item((GnomeCanvasItem*)(castitem))
{}

Widget::~Widget()
{
  destroy_();
}

Widget::CppClassType Widget::widget_class_; //Initialize static member.

GType Widget::get_type()
{
  return widget_class_.get_type();
}

GType Widget::get_base_type()
{
  return gnome_canvas_widget_get_type();
}


Glib::PropertyProxy<Gtk::Widget> Widget::property_widget()
{
  return Glib::PropertyProxy<Gtk::Widget>(this, "widget");
}

Glib::PropertyProxy<double> Widget::property_x()
{
  return Glib::PropertyProxy<double>(this, "x");
}

Glib::PropertyProxy<double> Widget::property_y()
{
  return Glib::PropertyProxy<double>(this, "y");
}

Glib::PropertyProxy<double> Widget::property_width()
{
  return Glib::PropertyProxy<double>(this, "width");
}

Glib::PropertyProxy<double> Widget::property_height()
{
  return Glib::PropertyProxy<double>(this, "height");
}

Glib::PropertyProxy<Gtk::AnchorType> Widget::property_anchor()
{
  return Glib::PropertyProxy<Gtk::AnchorType>(this, "anchor");
}

Glib::PropertyProxy<bool> Widget::property_size_pixels()
{
  return Glib::PropertyProxy<bool>(this, "size_pixels");
}


} // namespace Canvas

} // namespace Gnome

