/* gnome-db-basic-form.h
 *
 * Copyright (C) 2002 - 2006 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_BASIC_FORM__
#define __GNOME_DB_BASIC_FORM__

#include <gtk/gtk.h>
#include <libgda/libgda.h>
#include <glade/glade.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_BASIC_FORM          (gnome_db_basic_form_get_type())
#define GNOME_DB_BASIC_FORM(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_basic_form_get_type(), GnomeDbBasicForm)
#define GNOME_DB_BASIC_FORM_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_basic_form_get_type (), GnomeDbBasicFormClass)
#define IS_GNOME_DB_BASIC_FORM(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_basic_form_get_type ())

typedef struct {
	GladeXML *xml_object; /* one of xml_object or */
	gchar    *xml_file;   /* xml_file is required */

	gchar    *root_element; /* required */
	gchar    *form_prefix;  /* required */
} GnomeDbFormLayoutSpec;

typedef struct _GnomeDbBasicForm      GnomeDbBasicForm;
typedef struct _GnomeDbBasicFormClass GnomeDbBasicFormClass;
typedef struct _GnomeDbBasicFormPriv  GnomeDbBasicFormPriv;

/* struct for the object's data */
struct _GnomeDbBasicForm
{
	GtkVBox               object;

	GnomeDbBasicFormPriv *priv;
};

/* struct for the object's class */
struct _GnomeDbBasicFormClass
{
	GtkVBoxClass          parent_class;

	/* signals */
        void       (*param_changed)         (GnomeDbBasicForm *form, GdaParameter *param, gboolean is_user_modif);
};

/* 
 * Generic widget's methods 
*/
GType             gnome_db_basic_form_get_type                 (void);
GtkWidget        *gnome_db_basic_form_new                      (GdaParameterList *data_set);
GtkWidget        *gnome_db_basic_form_new_custom               (GdaParameterList *data_set, const gchar *glade_file, 
								const gchar *root_element, const gchar *form_prefix);
GtkWidget        *gnome_db_basic_form_new_in_dialog            (GdaParameterList *data_set, GtkWindow *parent,
								const gchar *title, const gchar *header);
GdaParameterList *gnome_db_basic_form_get_data_set             (GnomeDbBasicForm *form);
gboolean          gnome_db_basic_form_is_valid                 (GnomeDbBasicForm *form);
gboolean          gnome_db_basic_form_has_been_changed         (GnomeDbBasicForm *form);
void              gnome_db_basic_form_reset                    (GnomeDbBasicForm *form);
void              gnome_db_basic_form_set_current_as_orig      (GnomeDbBasicForm *form);

void              gnome_db_basic_form_show_entries_actions     (GnomeDbBasicForm *form, gboolean show_actions);
void              gnome_db_basic_form_entry_show               (GnomeDbBasicForm *form, 
								GdaParameter *param, gboolean show);
void              gnome_db_basic_form_entry_set_sensitive      (GnomeDbBasicForm *form, GdaParameter *param, 
								gboolean sensitive);
void              gnome_db_basic_form_set_entries_auto_default (GnomeDbBasicForm *form, gboolean auto_default);
void              gnome_db_basic_form_set_entries_default      (GnomeDbBasicForm *form);

G_END_DECLS

#endif



