/* gnome-db-decl.h
 *
 * Copyright (C) 2003 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_DECL_H_
#define __GNOME_DB_DECL_H_

#include <glib/gi18n-lib.h>

/* Define how the SQL functions and aggregates are
 * tested for their arguments.
 * DO_TEST: only test the number of arguments (if 0) and apply STRICT test or not
 */
#define GNOME_DB_FUNCTIONS_TEST_PARAMS_DO_TEST 0

typedef struct _GnomeDbDict GnomeDbDict;
typedef struct _GnomeDbDictClass GnomeDbDictClass;
typedef struct _GnomeDbDictPrivate GnomeDbDictPrivate;
extern  GnomeDbDict *default_dict;
#define ASSERT_DICT(x) ((x) ? (x) : default_dict)

/*
 * Server part
 */
typedef struct _GnomeDbServer GnomeDbServer;
typedef struct _GnomeDbServerClass GnomeDbServerClass;
typedef struct _GnomeDbServerPrivate GnomeDbServerPrivate;
typedef struct _GnomeDbServerInfo GnomeDbServerInfo;

typedef struct _GnomeDbServerDataType GnomeDbServerDataType;
typedef struct _GnomeDbServerDataTypeClass GnomeDbServerDataTypeClass;
typedef struct _GnomeDbServerDataTypePrivate GnomeDbServerDataTypePrivate;

typedef struct _GnomeDbServerFunction GnomeDbServerFunction;
typedef struct _GnomeDbServerFunctionClass GnomeDbServerFunctionClass;
typedef struct _GnomeDbServerFunctionPrivate GnomeDbServerFunctionPrivate;

typedef struct _GnomeDbServerAggregate GnomeDbServerAggregate;
typedef struct _GnomeDbServerAggregateClass GnomeDbServerAggregateClass;
typedef struct _GnomeDbServerAggregatePrivate GnomeDbServerAggregatePrivate;

typedef struct _GnomeDbResultSet GnomeDbResultSet;
typedef struct _GnomeDbResultSetClass GnomeDbResultSetClass;
typedef struct _GnomeDbResultSetPrivate GnomeDbResultSetPrivate;

typedef struct _GnomeDbUser GnomeDbUser;
typedef struct _GnomeDbUserClass GnomeDbUserClass;
typedef struct _GnomeDbUserPrivate GnomeDbUserPrivate;

/*
 * Database part
 */
typedef struct _GnomeDbDatabase GnomeDbDatabase;
typedef struct _GnomeDbDatabaseClass GnomeDbDatabaseClass;
typedef struct _GnomeDbDatabasePrivate GnomeDbDatabasePrivate;

typedef struct _GnomeDbTable GnomeDbTable;
typedef struct _GnomeDbTableClass GnomeDbTableClass;
typedef struct _GnomeDbTablePrivate GnomeDbTablePrivate;

typedef struct _GnomeDbTableField GnomeDbTableField;
typedef struct _GnomeDbTableFieldClass GnomeDbTableFieldClass;
typedef struct _GnomeDbTableFieldPrivate GnomeDbTableFieldPrivate;

typedef struct _GnomeDbSequence GnomeDbSequence;
typedef struct _GnomeDbSequenceClass GnomeDbSequenceClass;
typedef struct _GnomeDbSequencePrivate GnomeDbSequencePrivate;

typedef struct _GnomeDbConstraint GnomeDbConstraint;
typedef struct _GnomeDbConstraintClass GnomeDbConstraintClass;
typedef struct _GnomeDbConstraintPrivate GnomeDbConstraintPrivate;


/*
 * Query part
*/
typedef struct _GnomeDbQuery GnomeDbQuery;
typedef struct _GnomeDbQueryClass GnomeDbQueryClass;
typedef struct _GnomeDbQueryPrivate GnomeDbQueryPrivate;

typedef struct _GnomeDbTarget GnomeDbTarget;
typedef struct _GnomeDbTargetClass GnomeDbTargetClass;
typedef struct _GnomeDbTargetPrivate GnomeDbTargetPrivate;

typedef struct _GnomeDbQfield GnomeDbQfield;
typedef struct _GnomeDbQfieldClass GnomeDbQfieldClass;
typedef struct _GnomeDbQfieldPrivate GnomeDbQfieldPrivate;

typedef struct _GnomeDbJoin GnomeDbJoin;
typedef struct _GnomeDbJoinClass GnomeDbJoinClass;
typedef struct _GnomeDbJoinPrivate GnomeDbJoinPrivate;

typedef struct _GnomeDbDataSet GnomeDbDataSet;
typedef struct _GnomeDbDataSetClass GnomeDbDataSetClass;
typedef struct _GnomeDbDataSetNode GnomeDbDataSetNode;
typedef struct _GnomeDbDataSetPrivate GnomeDbDataSetPrivate;

typedef struct _GnomeDbParameter GnomeDbParameter;
typedef struct _GnomeDbParameterClass GnomeDbParameterClass;
typedef struct _GnomeDbParameterPrivate GnomeDbParameterPrivate;

typedef struct _GnomeDbCondition GnomeDbCondition;
typedef struct _GnomeDbConditionClass GnomeDbConditionClass;
typedef struct _GnomeDbConditionPrivate GnomeDbConditionPrivate;

typedef struct _GnomeDbQfAll GnomeDbQfAll;
typedef struct _GnomeDbQfAllClass GnomeDbQfAllClass;
typedef struct _GnomeDbQfAllPrivate GnomeDbQfAllPrivate;

typedef struct _GnomeDbQfField GnomeDbQfField;
typedef struct _GnomeDbQfFieldClass GnomeDbQfFieldClass;
typedef struct _GnomeDbQfFieldPrivate GnomeDbQfFieldPrivate;

typedef struct _GnomeDbQfValue GnomeDbQfValue;
typedef struct _GnomeDbQfValueClass GnomeDbQfValueClass;
typedef struct _GnomeDbQfValuePrivate GnomeDbQfValuePrivate;

typedef struct _GnomeDbQfFunc GnomeDbQfFunc;
typedef struct _GnomeDbQfFuncClass GnomeDbQfFuncClass;
typedef struct _GnomeDbQfFuncPrivate GnomeDbQfFuncPrivate;

typedef struct _GnomeDbQfAgg GnomeDbQfAgg;
typedef struct _GnomeDbQfAggClass GnomeDbQfAggClass;
typedef struct _GnomeDbQfAggPrivate GnomeDbQfAggPrivate;

/*
 * Data model handling
 */
typedef struct _GnomeDbModelWrapper        GnomeDbModelWrapper;
typedef struct _GnomeDbModelWrapperClass   GnomeDbModelWrapperClass;
typedef struct _GnomeDbModelWrapperPrivate GnomeDbModelWrapperPrivate;

typedef struct _GnomeDbWrapperField        GnomeDbWrapperField;
typedef struct _GnomeDbWrapperFieldClass   GnomeDbWrapperFieldClass;
typedef struct _GnomeDbWrapperFieldPrivate GnomeDbWrapperFieldPrivate;

typedef struct _GnomeDbDataProxy           GnomeDbDataProxy;
typedef struct _GnomeDbDataProxyClass      GnomeDbDataProxyClass;
typedef struct _GnomeDbDataProxyPrivate    GnomeDbDataProxyPrivate;

/* 
 * Interfaces 
 */
typedef struct _GnomeDbXmlStorage       GnomeDbXmlStorage;
typedef struct _GnomeDbXmlStorageIface  GnomeDbXmlStorageIface;

typedef struct _GnomeDbDataHandler      GnomeDbDataHandler;
typedef struct _GnomeDbDataHandlerIface GnomeDbDataHandlerIface;

typedef struct _GnomeDbDataEntry        GnomeDbDataEntry;
typedef struct _GnomeDbDataEntryIface   GnomeDbDataEntryIface;

typedef struct _GnomeDbRenderer         GnomeDbRenderer;
typedef struct _GnomeDbRendererIface    GnomeDbRendererIface;

typedef struct _GnomeDbReferer          GnomeDbReferer;
typedef struct _GnomeDbRefererIface     GnomeDbRefererIface;

typedef struct _GnomeDbEntity           GnomeDbEntity;
typedef struct _GnomeDbEntityIface      GnomeDbEntityIface;

typedef struct _GnomeDbDataModel        GnomeDbDataModel;
typedef struct _GnomeDbDataModelIface   GnomeDbDataModelIface;

typedef struct _GnomeDbField            GnomeDbField;
typedef struct _GnomeDbFieldIface       GnomeDbFieldIface;

typedef struct _GnomeDbDataWidget       GnomeDbDataWidget;
typedef struct _GnomeDbDataWidgetIface  GnomeDbDataWidgetIface;


/*
 * Graphing part
 */
typedef struct _GnomeDbGraph GnomeDbGraph;
typedef struct _GnomeDbGraphClass GnomeDbGraphClass;
typedef struct _GnomeDbGraphPrivate GnomeDbGraphPrivate;

typedef struct _GnomeDbGraphQuery GnomeDbGraphQuery;
typedef struct _GnomeDbGraphQueryClass GnomeDbGraphQueryClass;
typedef struct _GnomeDbGraphQueryPrivate GnomeDbGraphQueryPrivate;

typedef struct _GnomeDbGraphItem GnomeDbGraphItem;
typedef struct _GnomeDbGraphItemClass GnomeDbGraphItemClass;
typedef struct _GnomeDbGraphItemPrivate GnomeDbGraphItemPrivate;

typedef struct _GnomeDbCanvas        GnomeDbCanvas;
typedef struct _GnomeDbCanvasClass   GnomeDbCanvasClass;
typedef struct _GnomeDbCanvasPrivate GnomeDbCanvasPrivate;

typedef struct _GnomeDbCanvasItem        GnomeDbCanvasItem;
typedef struct _GnomeDbCanvasItemClass   GnomeDbCanvasItemClass;
typedef struct _GnomeDbCanvasItemPrivate GnomeDbCanvasItemPrivate;

typedef struct _GnomeDbCanvasEntity        GnomeDbCanvasEntity;
typedef struct _GnomeDbCanvasEntityClass   GnomeDbCanvasEntityClass;
typedef struct _GnomeDbCanvasEntityPrivate GnomeDbCanvasEntityPrivate;

typedef struct _GnomeDbCanvasField        GnomeDbCanvasField;
typedef struct _GnomeDbCanvasFieldClass   GnomeDbCanvasFieldClass;
typedef struct _GnomeDbCanvasFieldPrivate GnomeDbCanvasFieldPrivate;

/*
 * Layouts part
 */
typedef struct _GnomeDbCustomLayout GnomeDbCustomLayout;
typedef struct _GnomeDbCustomLayoutClass GnomeDbCustomLayoutClass;
typedef struct _GnomeDbCustomLayoutPrivate GnomeDbCustomLayoutPrivate;

/* 
 * Colors
 */
#define GNOME_DB_COLOR_NORMAL_NULL "#00cd66"
#define GNOME_DB_COLOR_PRELIGHT_NULL "#00ef77"

#define GNOME_DB_COLOR_NORMAL_DEFAULT "#6495ed"
#define GNOME_DB_COLOR_PRELIGHT_DEFAULT "#75a6fe"

#define GNOME_DB_COLOR_NORMAL_MODIF "#cacaee"
#define GNOME_DB_COLOR_PRELIGHT_MODIF "#cfcffe"

#define GNOME_DB_COLOR_NORMAL_INVALID "#ff6a6a"
#define GNOME_DB_COLOR_PRELIGHT_INVALID "#ff7b7b"


/*
 * Variou macros
 */
#ifdef debug
#define D_COL_NOR "\033[0m"
#define D_COL_H0 "\033[;34;7m"
#define D_COL_H1 "\033[;36;7m"
#define D_COL_H2 "\033[;36;4m"
#define D_COL_OK "\033[;32m"
#define D_COL_ERR "\033[;31;1m"
#define AAA(X) (g_print (D_COL_H1 "DEBUG MARK %d\n" D_COL_NOR, X))
#define DEBUG_HEADER (g_print (D_COL_H0 "====================== %s %s():%d ======================\n" D_COL_NOR, __FILE__, __FUNCTION__, __LINE__))
#define DEBUG_HEADER_STR(str) (g_print (D_COL_H0 "====================== %s %s %s():%d ======================\n" D_COL_NOR, (str), __FILE__, __FUNCTION__, __LINE__))
#endif

#ifdef debug
#define TO_IMPLEMENT g_print (D_COL_ERR "Implementation missing:" D_COL_NOR " %s() in %s line %d\n", __FUNCTION__, __FILE__,__LINE__)
#else
#define TO_IMPLEMENT g_print ("Implementation missing: %s() in %s line %d\n", __FUNCTION__, __FILE__,__LINE__)
#endif

#endif
