/* gnome-db-qf-func.h
 *
 * Copyright (C) 2003 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_QF_FUNC_H_
#define __GNOME_DB_QF_FUNC_H_

#include "gnome-db-base.h"
#include "gnome-db-decl.h"
#include "gnome-db-server-function.h"
#include "gnome-db-qfield.h"

G_BEGIN_DECLS

#define GNOME_DB_TYPE_QF_FUNC          (gnome_db_qf_func_get_type())
#define GNOME_DB_QF_FUNC(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_qf_func_get_type(), GnomeDbQfFunc)
#define GNOME_DB_QF_FUNC_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_qf_func_get_type (), GnomeDbQfFuncClass)
#define IS_GNOME_DB_QF_FUNC(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_qf_func_get_type ())


/* error reporting */
extern GQuark gnome_db_qf_func_error_quark (void);
#define GNOME_DB_QF_FUNC_ERROR gnome_db_qf_func_error_quark ()

enum
{
	GNOME_DB_QF_FUNC_XML_LOAD_ERROR,
	GNOME_DB_QF_FUNC_RENDER_ERROR
};


/* struct for the object's data */
struct _GnomeDbQfFunc
{
	GnomeDbQfield               object;
	GnomeDbQfFuncPrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbQfFuncClass
{
	GnomeDbQfieldClass                  class;

	/* signals */
	void   (*templ_signal)        (GnomeDbQfFunc *obj);
};

GType                  gnome_db_qf_func_get_type          (void);
GObject               *gnome_db_qf_func_new_with_func     (GnomeDbQuery *query, GnomeDbServerFunction *func);
GObject               *gnome_db_qf_func_new_with_xml_id   (GnomeDbQuery *query, const gchar *func_xml_id);

GnomeDbServerFunction *gnome_db_qf_func_get_ref_func      (GnomeDbQfFunc *func);
gboolean               gnome_db_qf_func_set_args          (GnomeDbQfFunc *func, GSList *args);
GSList                *gnome_db_qf_func_get_args          (GnomeDbQfFunc *func);

G_END_DECLS

#endif
