/* gnome-db-data-model.h
 *
 * Copyright (C) 2004 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_DATA_MODEL_H_
#define __GNOME_DB_DATA_MODEL_H_

#include <glib-object.h>
#include "gnome-db-decl.h"
#include <libgda/libgda.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_DATA_MODEL          (gnome_db_data_model_get_type())
#define GNOME_DB_DATA_MODEL(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_DB_TYPE_DATA_MODEL, GnomeDbDataModel)
#define IS_GNOME_DB_DATA_MODEL(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, GNOME_DB_TYPE_DATA_MODEL)
#define GNOME_DB_DATA_MODEL_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GNOME_DB_TYPE_DATA_MODEL, GnomeDbDataModelIface))

typedef enum {
	GNOME_DB_DATA_MODEL_CAN_BE_REFRESHED   = 1 << 0,
	GNOME_DB_DATA_MODEL_NEEDS_INIT_REFRESH = 1 << 1
} GnomeDbDataModelAttributes;

/* struct for the interface */
struct _GnomeDbDataModelIface
{
	GTypeInterface     g_iface;

	/* virtual table */
	GObject          *(* copy)             (GnomeDbDataModel *iface, GHashTable *replacements);
	gboolean          (* refresh)          (GnomeDbDataModel *iface, GError **error);
	GnomeDbDataSet   *(* get_params)       (GnomeDbDataModel *iface);
	GnomeDbDataSet   *(* get_new_data_set) (GnomeDbDataModel *iface);
	gboolean          (* sync_data_set)    (GnomeDbDataModel *iface, GnomeDbDataSet *data_set, gint row);
	GnomeDbParameter *(* get_param_at_col) (GnomeDbDataModel *iface, GnomeDbDataSet *data_set, gint col);
	gint              (* get_col_at_param) (GnomeDbDataModel *iface, GnomeDbDataSet *data_set, GnomeDbParameter *param);
	GSList           *(* get_key_columns)  (GnomeDbDataModel *iface, GnomeDbDataSet *data_set);
	guint             (* get_status)       (GnomeDbDataModel *iface);

	/* signals */
	void            (*data_refreshed)  (GnomeDbDataModel *iface);
};

GType             gnome_db_data_model_get_type            (void) G_GNUC_CONST;

GObject          *gnome_db_data_model_copy                (GnomeDbDataModel *iface, GHashTable *replacements);
guint             gnome_db_data_model_get_status          (GnomeDbDataModel *iface);
gboolean          gnome_db_data_model_refresh             (GnomeDbDataModel *iface, GError **error);

/* GnomeDbDataSet for the parameters which control the data in @iface (there may be no param here) */
GnomeDbDataSet   *gnome_db_data_model_get_params          (GnomeDbDataModel *iface);

/* GnomeDbDataSet for the parameters which represent the data in @iface (there must be at least 1 param here)*/
GnomeDbDataSet   *gnome_db_data_model_get_new_data_set    (GnomeDbDataModel *iface);
gboolean          gnome_db_data_model_sync_data_set       (GnomeDbDataModel *iface, 
							   GnomeDbDataSet *data_set, gint row);
GnomeDbParameter *gnome_db_data_model_get_param_at_column (GnomeDbDataModel *iface, 
							   GnomeDbDataSet *data_set, gint column);
gint              gnome_db_data_model_get_column_at_param (GnomeDbDataModel *iface, 
							   GnomeDbDataSet *data_set, GnomeDbParameter *param);
GSList           *gnome_db_data_model_get_key_columns     (GnomeDbDataModel *iface, GnomeDbDataSet *data_set);

gint              gnome_db_data_model_get_row_from_values (GnomeDbDataModel *model, GSList *values, gint *cols_index);

G_END_DECLS

#endif
