/* Graph
 *
 * The GnomeDbCanvasDbRelation graph widget can be used to display
 * a database structure
 */

#include <libgnomedb/libgnomedb.h>

extern GdaDict *demo_dict;
static GtkWidget *window = NULL;

GtkWidget *
do_graph (GtkWidget *do_widget)
{  
	if (!window) {
                GdaQuery *query;
		GtkWidget *vbox;
		GtkWidget *label;
		GtkWidget *graphwidget;
		GdaGraph *graph;
		
		window = gtk_dialog_new_with_buttons ("Graph",
						      GTK_WINDOW (do_widget),
						      0,
						      GTK_STOCK_CLOSE,
						      GTK_RESPONSE_NONE,
						      NULL);
		
		g_signal_connect (window, "response",
				  G_CALLBACK (gtk_widget_destroy), NULL);
		g_signal_connect (window, "destroy",
				  G_CALLBACK (gtk_widget_destroyed), &window);
		
		vbox = gtk_vbox_new (FALSE, 5);
		gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox), vbox, TRUE, TRUE, 0);
		gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
		
		label = gtk_label_new ("The following GnomeDbCanvasDbRelation widget displays\n"
				       "the complete database structure: the graph has been defined\n"
				       "(its items and their positions) in the dictionary.");
		gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);
		
		/* Create the demo widget */
		graph = (GdaGraph*) gda_dict_get_object_by_name (demo_dict, GDA_TYPE_GRAPH, "Global");
		graphwidget = gnome_db_canvas_db_relations_new (demo_dict, graph);
		gtk_widget_set_size_request (graphwidget, 320, 320);
		
		gtk_box_pack_start (GTK_BOX (vbox), graphwidget, TRUE, TRUE, 0);
	}

	if (!GTK_WIDGET_VISIBLE (window))
		gtk_widget_show_all (window);
	else
		gtk_widget_destroy (window);

	return window;
}


