
#include <gtkmm.h>
#include <libgdamm.h>
#include <libgnomedbmm.h>

#ifndef _GNOMEDBMM_DEMO_H_
#define _GNOMEDBMM_DEMO_H_

class DemoBrowser: public Gtk::Window
{
private:
  typedef sigc::slot<Gtk::Window*> DemoCreateSlot;

  template<typename DemoType>
  Gtk::Window* create_demo()
  {
    return new DemoType(m_dict);
  }

  void add_demo(const DemoCreateSlot& slot, const Glib::ustring& category,
                const Glib::ustring& title, const Glib::ustring& description,
		const std::string& file);

public:
  DemoBrowser(const Glib::RefPtr<Gnome::Gda::Dict>& dict);
  ~DemoBrowser();

  // Note that this supports only hierarchies on one single level
  template<typename DemoType>
  void add_demo(const Glib::ustring& category, const Glib::ustring& title,
                const Glib::ustring& description)
  {
    DemoCreateSlot create_slot(sigc::mem_fun(*this, &DemoBrowser::create_demo<DemoType>));
    add_demo(create_slot, category, title, description, DemoType::FILE);
  }

protected:
  class DemoColumns: public Gtk::TreeModelColumnRecord
  {
  public:
    DemoColumns();

    Gtk::TreeModelColumn<Glib::ustring> title;
    Gtk::TreeModelColumn<Glib::ustring> description;
    Gtk::TreeModelColumn<std::string> file;
    Gtk::TreeModelColumn<Gtk::Window*> demo;
    Gtk::TreeModelColumn<Glib::ustring> category;
    Gtk::TreeModelColumn<DemoCreateSlot> create_slot;
  };

  void on_row_activated(const Gtk::TreePath& path, Gtk::TreeViewColumn* column);
  void on_row_changed();

  typedef std::vector<Gtk::Window*> DemoVector;
  DemoVector m_demos;

  DemoColumns m_demo_columns;
  Glib::RefPtr<Gtk::TreeStore> m_demo_tree;
  Gtk::TreeView m_demo_view;

  Gtk::TextView m_desc;
  Gtk::TextView m_source;

  Glib::RefPtr<Gnome::Gda::Dict> m_dict;
};

#endif // _GNOMEDBMM_DEMO_H_
