/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#include "examplewindow.h" 

#include <libgdamm.h>
#include <iostream>

ExampleWindow::ExampleWindow(const Glib::RefPtr<Gnome::Gda::Dict>& dict) :
  m_label("The following Gnome::Db::Grid widget displays data from the 'products' table.\n\n"
          "As modification queries are provided, the data is read-write\n(except for the 'price' "
          "field as these queries voluntarily omit that field).")
{    
  m_box.set_border_width(6);
  m_box.pack_start(m_label, Gtk::PACK_SHRINK);
    
  Glib::RefPtr<Gnome::Gda::Query> query = Gnome::Gda::Query::create(dict);
  query->set_sql_text("SELECT ref, category, name, price, wh_stored FROM products");
  
  /* Create the demo widget */
  m_model = Gnome::Gda::DataModelQuery::create(query);

  try
  {
    m_model->set_modification_query(
                   "UPDATE products set "
                   "ref=##/*name:'+0' type:gchararray*/, "
                   "category=##/*name:'+1' type:gint*/,"
                   "name=##/*name:'+2' type:gchararray*/, "
                   "wh_stored=##/*name:'+4' type:gint*/ "
                   "WHERE ref=##/*name:'-0' type:gchararray*/");

    m_model->set_modification_query(
                   "DELETE FROM products WHERE ref=##/*name:'-0' type:gchararray*/");

    m_model->set_modification_query(
                   "INSERT INTO products (ref, category, name, price, wh_stored) "
                   "VALUES (##/*name:'+0' type:gchararray*/, "
                   "##/*name:'+1' type:gint*/, "
                   "##/*name:'+2' type:gchararray*/, "
                   "1.0, "
                   "##/*name:'+4' type:gint*/)");
  }
  catch(const Glib::Error& err)
  {
    std::cerr << "Exception caught: " << err.what() << std::endl;
    exit(1);
  }

  m_grid.reset(new Gnome::Db::Grid(m_model));
  m_box.pack_start(*m_grid);
  add(m_box);
  set_default_size(0, 400);
  show_all();
}
