/* generate_defs_gnomedb.h
 *
 * Copyright (C) 2001 The Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "glibmm_generate_extra_defs/generate_extra_defs.h"
#include <libgnomedb/libgnomedb.h>
#include <libgnomedb-graph/libgnomedb-graph.h>
#include <libgnomedb-extra/libgnomedb-extra.h>

int main (int argc, char *argv[])
{
    gnome_db_init("generate_extra_defs", "0.1", argc, argv);

    std::cout << get_defs(GNOME_DB_TYPE_PROVIDER_SELECTOR)
              << get_defs(GNOME_DB_TYPE_DATA_SOURCE_SELECTOR)
	      << get_defs(GNOME_DB_TYPE_LOGIN)
	      << get_defs(GNOME_DB_TYPE_LOGIN_DIALOG)
	      << get_defs(GNOME_DB_TYPE_DSN_SPEC)

	      << get_defs(GNOME_DB_TYPE_DSN_EDITOR)

#ifdef GNOME_DB_TYPE_DSN_ASSISTANT /* Not available if libgnomedb was built with GTK+ <2.10 */
	      << get_defs(GNOME_DB_TYPE_DSN_ASSISTANT)
#endif

	      << get_defs(GNOME_DB_TYPE_CONNECTION_PROPERTIES)
	      << get_defs(GNOME_DB_TYPE_SERVER_OPERATION)
	      << get_defs(GNOME_DB_TYPE_TRANSACTION_STATUS)
	      << get_defs(GNOME_DB_TYPE_COMBO)
	      << get_defs(GNOME_DB_TYPE_BASIC_FORM)
	      << get_defs(GNOME_DB_TYPE_RAW_FORM)
	      << get_defs(GNOME_DB_TYPE_FORM)
	      << get_defs(GNOME_DB_TYPE_RAW_GRID)
	      << get_defs(GNOME_DB_TYPE_GRID)
	      << get_defs(GNOME_DB_TYPE_FIND_DIALOG)
	      << get_defs(GNOME_DB_TYPE_DATA_WIDGET)
	      << get_defs(GNOME_DB_TYPE_DATA_WIDGET_INFO)
	      << get_defs(GNOME_DB_TYPE_DATA_STORE)
	      << get_defs(GNOME_DB_TYPE_SELECTOR)
	      << get_defs(GNOME_DB_TYPE_DBMS_UPDATE_VIEWER)
	      << get_defs(GNOME_DB_TYPE_SQL_CONSOLE)
	      << get_defs(GNOME_DB_TYPE_EDITOR)
	      << get_defs(GNOME_DB_TYPE_REPORT_EDITOR)
	      << get_defs(GNOME_DB_TYPE_GRAY_BAR)
	      << get_defs(GNOME_DB_TYPE_ERROR_DIALOG)
	      << get_defs(GNOME_DB_TYPE_ERROR)
	      << get_defs(GNOME_DB_TYPE_DATA_ENTRY)
	      << get_defs(GNOME_DB_TYPE_ENTRY_STRING)
	      << get_defs(GNOME_DB_TYPE_ENTRY_BOOLEAN)
	      << get_defs(GNOME_DB_TYPE_ENTRY_TIME)
	      << get_defs(GNOME_DB_TYPE_ENTRY_DATE)
	      << get_defs(GNOME_DB_TYPE_ENTRY_TIMESTAMP)
	      << get_defs(GNOME_DB_TYPE_ENTRY_NONE)
	      << get_defs(GNOME_DB_TYPE_ENTRY_COMBO)
//	      << get_defs(GNOME_DB_TYPE_ENTRY_CIDR)
//	      << get_defs(GNOME_DB_TYPE_ENTRY_PASSMD5)
//	      << get_defs(GNOME_DB_TYPE_ENTRY_TEXT)
//	      << get_defs(GNOME_DB_TYPE_ENTRY_FILESEL)
	      << get_defs(GNOME_DB_TYPE_DATA_CELL_RENDERER_INFO)
	      << get_defs(GNOME_DB_TYPE_DATA_CELL_RENDERER_TEXTUAL)
	      << get_defs(GNOME_DB_TYPE_DATA_CELL_RENDERER_BOOLEAN)
	      << get_defs(GNOME_DB_TYPE_DATA_CELL_RENDERER_COMBO)
              << get_defs(GNOME_DB_TYPE_ENTRY_SHELL)
	      << get_defs(GNOME_DB_TYPE_ENTRY_WRAPPER)
	      << get_defs(GNOME_DB_TYPE_ENTRY_COMMON_TIME)

              //gnomedb-graph stuff:
	      << get_defs(GNOME_DB_TYPE_CANVAS)
	      << get_defs(GNOME_DB_TYPE_CANVAS_DB_RELATIONS)
	      << get_defs(GNOME_DB_TYPE_CANVAS_QUERY_STRUCT)
	      << get_defs(GNOME_DB_TYPE_CANVAS_ITEM)
	      << get_defs(GNOME_DB_TYPE_CANVAS_ENTITY)
	      << get_defs(GNOME_DB_TYPE_CANVAS_JOIN)
	      << get_defs(GNOME_DB_TYPE_CANVAS_FIELD)
	      << get_defs(GNOME_DB_TYPE_CANVAS_TIP)
	      << get_defs(GNOME_DB_TYPE_CANVAS_CURSOR)
	      << get_defs(GNOME_DB_TYPE_CANVAS_TEXT)
//	      << get_defs(GNOME_DB_TYPE_CANVAS_FK_CONSTRAINT)

	      ;

    return 0;
}
