
#include "demo.h"

DemoBrowser::DemoColumns::DemoColumns()
{
  add(title);
  add(description);
  add(file);
  add(demo);
  add(category);
  add(create_slot);
}

DemoBrowser::DemoBrowser(const Glib::RefPtr<Gnome::Gda::Dict>& dict):
  Gtk::Window(),
  m_demo_tree(Gtk::TreeStore::create(m_demo_columns)),
  m_demo_view(m_demo_tree),
  m_dict(dict)
{
  m_demo_view.append_column("Demo", m_demo_columns.title);

  Gtk::ScrolledWindow* tree_scroll = Gtk::manage(new Gtk::ScrolledWindow);
  tree_scroll->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
  tree_scroll->add(m_demo_view);

  Gtk::ScrolledWindow* desc_scroll = Gtk::manage(new Gtk::ScrolledWindow);
  desc_scroll->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
  desc_scroll->add(m_desc);

  Gtk::ScrolledWindow* source_scroll = Gtk::manage(new Gtk::ScrolledWindow);
  source_scroll->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
  source_scroll->add(m_source);

  m_desc.set_editable(false);
  m_source.modify_font(Pango::FontDescription("monospace"));
  m_source.set_editable(false);

  Gtk::Notebook* notebook = Gtk::manage(new Gtk::Notebook);
  notebook->append_page(*desc_scroll, "Description");
  notebook->append_page(*source_scroll, "Source code");

  Gtk::HPaned* paned = Gtk::manage(new Gtk::HPaned);
  paned->pack1(*tree_scroll, true, false);
  paned->pack2(*notebook, true, false);

  add(*paned);
  show_all_children();

  Glib::RefPtr<Gtk::TreeSelection> selection = m_demo_view.get_selection();
  selection->signal_changed().connect(sigc::mem_fun(*this, &DemoBrowser::on_row_changed));
  m_demo_view.signal_row_activated().connect(sigc::mem_fun(*this, &DemoBrowser::on_row_activated));

  set_title("gnomedbmm demo");
  set_default_size(640, 480);
}

DemoBrowser::~DemoBrowser()
{
  for(DemoVector::iterator iter = m_demos.begin(); iter != m_demos.end(); ++ iter)
    delete *iter;
}

void DemoBrowser::add_demo(const DemoCreateSlot& slot,
                           const Glib::ustring& category,
                           const Glib::ustring& title,
			   const Glib::ustring& description,
			   const std::string& file)
{
  Gtk::TreeIter parent;

  // Find parent for the new node
  if(!category.empty())
  {
    Gtk::TreeNodeChildren children = m_demo_tree->children();
    Gtk::TreeIter parent_iter;

    for(parent_iter = children.begin(); parent_iter != children.end(); ++ parent_iter)
    {
      if((*parent_iter)[m_demo_columns.category] == category)
      {
        parent = parent_iter->children();
	break;
      }
    }

    if(parent_iter == children.end())
    {
      Gtk::TreeIter category_iter = m_demo_tree->append();
      (*category_iter)[m_demo_columns.title] = category;
      (*category_iter)[m_demo_columns.category] = category;
      parent = category_iter;
    }
  }
  else
  {
    parent = m_demo_tree->children();
  }

  Gtk::TreeIter iter = m_demo_tree->append(parent->children());

  // TODO: Title and Description could also be arguments to add_demo
  (*iter)[m_demo_columns.title] = title;
  (*iter)[m_demo_columns.description] = description;
  (*iter)[m_demo_columns.file] = file;
  (*iter)[m_demo_columns.demo] = NULL;
  (*iter)[m_demo_columns.create_slot] = slot;
}

void DemoBrowser::on_row_activated(const Gtk::TreePath& path, Gtk::TreeViewColumn* column)
{
  Gtk::TreeIter iter = m_demo_tree->get_iter(path);
  if(!iter)
    return;

  Gtk::Window* demo = (*iter)[m_demo_columns.demo];

  if(demo == NULL)
  {
    DemoCreateSlot slot = (*iter)[m_demo_columns.create_slot];
    demo = slot();
    (*iter)[m_demo_columns.demo] = demo;
    m_demos.push_back(demo);
  }

  if(demo)
    demo->present();
}

void DemoBrowser::on_row_changed()
{
  Gtk::TreeIter iter = m_demo_view.get_selection()->get_selected();

  Glib::ustring category = (*iter)[m_demo_columns.category];
  if(category.empty())
  {
    std::string file = (*iter)[m_demo_columns.file];
    Glib::ustring content = Glib::file_get_contents(file);

    m_desc.get_buffer()->set_text((*iter)[m_demo_columns.description]);
    m_source.get_buffer()->set_text(content);
  }
}
