// -*- c++ -*-

/* init.cc
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomedbmm/init.h>
#include <libgdamm/init.h>
#include <glibmm/init.h>
#include <libgnomedbmmconfig.h> //For LIBGNOMEDBMM_VERSION
#include <libgnomedbmm/wrap_init.h>
#include <libgnomedb/libgnomedb.h>


namespace Gnome
{

namespace Db
{

void init(const Glib::ustring& app_id, const Glib::ustring& version, int nargs, gchar *args[])
{
  Glib::init(); //Sets up the g type system and the Glib::wrap() table.
  Gda::init(app_id, version, nargs, args); // Init gdamm because we depend on it.

  wrap_init(); //Tells the Glib::wrap() table about the libgnomedbmm classes.
  gnome_db_init(app_id.c_str(), version.c_str(), nargs, args);
}


} //namespace Db
} //namespace Gnome
