
#include <libgnomemm/program.h>
#include <libgnomemm/private/program_p.h>

/* $Id: program.ccg,v 1.4 2002/01/19 04:26:32 daniel Exp $ */
// -*- C++ -*- // this is for the .ccg, I realize gensig puts one in

/* program.cc
 * 
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Gnome
{

Glib::ustring Program::locate_file(GnomeFileDomain domain, const Glib::ustring& file_name, bool only_if_exists /* = true */)
{
  gchar* pchResult = gnome_program_locate_file(gobj(), domain, file_name.c_str(), (gboolean)only_if_exists, 0);
  return Glib::convert_return_gchar_ptr_to_ustring(pchResult);
}

Glib::SListHandle<Glib::ustring> Program::locate_file_multiple(
    GnomeFileDomain domain, const Glib::ustring& file_name, bool only_if_exists /* = true */)
{
  GSList* pGSList = 0;
  gchar* pchResult = gnome_program_locate_file(gobj(), domain, file_name.c_str(), (gboolean)only_if_exists, &pGSList);

  if(pchResult)
    pGSList = g_slist_prepend(pGSList, pchResult);

  return Glib::SListHandle<Glib::ustring>(pGSList, Glib::OWNERSHIP_DEEP);
}
//Glib::ustring locate_file(GnomeFileDomain domain, const Glib::ustring& file_name, bool only_if_exists = true, GSList** ret_locations);


} /* namespace Gnome */


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gnome::Program> wrap(GnomeProgram* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gnome::Program>( dynamic_cast<Gnome::Program*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gnome
{


/* The *_Class implementation: */

GType Program_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        GType gtype_base = gnome_program_get_type();
        Glib::ustring gtypename = "gtkmm__" + Glib::ustring( g_type_name(gtype_base) ); //This prefix is also used by libglademm to calculate gtkmm gtypes from gtk+ gtypes.
        gtype_ = g_type_register_static(gtype_base, gtypename.c_str(), &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Program_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Program_Class::wrap_new(GObject* o)
{
  return new Program((GnomeProgram*)(o));
}


/* The implementation: */

GnomeProgram* Program::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<Program> Program::wrap_specific_type(GnomeProgram* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<Program> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    Program* pCppObject = dynamic_cast<Program*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<Program>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<Program>( new Program(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

Program::Program(GnomeProgram* castitem)
: Glib::Object((GObject*)(castitem))
{}

Program::~Program()
{
}

Program::CppClassType Program::program_class_; //Initialize static member.

GType Program::get_type()
{
  return program_class_.get_type();
}

GType Program::get_base_type()
{
  return gnome_program_get_type();
}

Glib::RefPtr<Program> Program::get()
{
  return Glib::wrap(gnome_program_get());
}

Glib::ustring Program::get_human_readable_name() const
{
  return gnome_program_get_human_readable_name(const_cast<GnomeProgram*>(gobj()));
}

Glib::ustring Program::get_app_id() const
{
  return gnome_program_get_app_id(const_cast<GnomeProgram*>(gobj()));
}

Glib::ustring Program::get_app_version() const
{
  return gnome_program_get_app_version(const_cast<GnomeProgram*>(gobj()));
}


} // namespace Gnome

