/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 *  gnome-print-pdf-t1.c: Tyep1 Font embeding for gnome-print-pdf
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useoful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Authors:
 *    Chema Celorio <chema@celorio.com>
 *
 *  Copyright 2000-2001 Ximian, Inc. and authors
 *
 *  References:
 *    [1] Portable Document Format Referece Manual, Version 1.3 (March 11, 1999)
 */

#include "config.h"

#include <string.h>
#include <libgnomeprint/gnome-print.h>
#include <libgnomeprint/gnome-font-private.h>
#include <libgnomeprint/gnome-print-pdf-private.h>

gint
gnome_print_pdf_tt_embed (GnomePrintPdf *pdf,
			  GnomePrintPdfFont *font,
			  gint object_number)
{
	GnomeFontFace *face;
	GPFontEntryTT *tt;
	gchar *file_name = NULL;
	gchar *body = NULL;
	gint body_size, body_max;
	FILE *f;


	gint ob_num = gnome_print_pdf_object_new (pdf);
	gint len = 0;
	
	face = font->face;
	tt = (GPFontEntryTT *) face->entry;
	g_assert (face->entry->type == GP_FONT_ENTRY_TRUETYPE);
	file_name = tt->ttf.name;

	if (!file_name) {
		g_warning ("Could not find file_name to open");
		return GNOME_PRINT_ERROR_UNKNOWN;
	}

	f = fopen (file_name, "r");
	if (f == NULL) {
		g_warning ("Couldn't open font file %s\n", file_name);
		return GNOME_PRINT_ERROR_UNKNOWN;
	}
	
	body_size = 0;
	body_max = 32768;
	body = g_new (guchar, body_max);
	while (1) {
		gint bytes_read;
		bytes_read = fread (body + body_size, 1, body_max - body_size, f);
		if (bytes_read == 0)
			break;
		body_size += bytes_read;
		body = g_realloc (body, body_max <<= 1);
	}

	if (0 != fclose (f)) {
		g_warning ("Could not close %s", file_name);
		g_free (body);
		return GNOME_PRINT_ERROR_UNKNOWN;
	}


	/* Write the object */
	gnome_print_pdf_object_start (pdf, object_number, FALSE);
	gnome_print_pdf_fprintf    (pdf,
				    "/Length %d 0 R" EOL
				    "/Length1 %d" EOL
				    ">>" EOL
				    "stream" EOL,
				    ob_num,
				    body_size);
	len += gnome_print_pdf_print_sized (pdf, body, body_size);
	len += gnome_print_pdf_fprintf (pdf, EOL);
	gnome_print_pdf_fprintf (pdf,
				 "endstream" EOL
				 "endobj" EOL);
	gnome_print_pdf_object_end  (pdf, object_number, TRUE);

	/* */
	gnome_print_pdf_object_start (pdf, ob_num, TRUE);
	gnome_print_pdf_fprintf (pdf,
				 "%d 0 obj" EOL
				 "%d" EOL
				 "endobj" EOL,
				 ob_num, len);
	gnome_print_pdf_object_end (pdf, ob_num, TRUE);	
	

	g_free (body);
	
	return GNOME_PRINT_OK;
}

