/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

#ifndef __GPA_NODE_PRIVATE_H__
#define __GPA_NODE_PRIVATE_H__

/*
 *  gpa-node.h:
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Authors :
 *    Lauris Kaplinski <lauris@ximian.com>
 *    Jose M. Celorio <chema@ximian.com>
 *
 *  Copyright (C) 2000-2001 Ximian, Inc. and Jose M. Celorio
 *
 */

#include <glib.h>

G_BEGIN_DECLS

#include <glib-object.h>
#include "gpa-utils.h"

#define GPA_NODE_MODIFIED_FLAG ( 1 << 5 )

#define GPA_NODE_FLAGS(n)         (GPA_NODE(n)->flags)
#define GPA_NODE_SET_FLAGS(n,f)   (GPA_NODE(n)->flags |= f)
#define GPA_NODE_UNSET_FLAGS(n,f) (GPA_NODE(n)->flags &= (~f))

#define GPA_NODE_ID(n)           (gpa_quark_to_string (GPA_NODE (n)->qid))
#define GPA_NODE_ID_COMPARE(n,s) ((s) && (gpa_quark_try_string (s) == GPA_NODE (n)->qid))
#define GPA_NODE_ID_EXISTS(n)    (GPA_NODE (n)->qid != 0)
#define GPA_NODE_PARENT(n)       (GPA_NODE (n)->parent)

struct _GPANode {
	GObject object;
	guint32 flags;
	guint32 qid;
	GPANode *parent;
	GPANode *next;
};

struct _GPANodeClass {
	GObjectClass object_class;

	guchar * (* get_value)  (GPANode *node);
	gboolean (* set_value)  (GPANode *node, const guchar *value);

	GPANode * (* get_child) (GPANode *node, GPANode *previous_child);
	GPANode * (* lookup)    (GPANode *node, const guchar *path);

	GPANode * (* duplicate) (GPANode *node);
	gboolean  (* verify)    (GPANode *node);
	
	/* Signal that node or its children have been modified */
	void     (* modified)   (GPANode *node, guint flags);
};

GType gpa_node_get_type (void);

GPANode * gpa_node_new (GType type, const guchar *id);
GPANode * gpa_node_duplicate (GPANode *node);
gboolean  gpa_node_verify    (GPANode *node);
GPANode * gpa_node_lookup    (GPANode *node, const guchar *path);

/* Request that "modified" signal will be run from idle loop */
void gpa_node_request_modified (GPANode *node, guint flags);
void gpa_node_emit_modified    (GPANode *node, guint flags);

/* fixme: */
#if 0
GSList *gpa_list_nodes (void);
#endif

G_END_DECLS

#endif /* __GPA_NODE_PRIVATE_H__ */

