#define __GNOME_PRINTER_DIALOG_C__

/*
 *  Copyright (C) 1999-2001 Ximian Inc. and authors
 *
 *  Authors:
 *    Raph Levien (raph@acm.org)
 *    Miguel de Icaza (miguel@kernel.org)
 *    Lauris Kaplinski <lauris@ximian.com>
 *    Chema Celorio (chema@celorio.com)
 *
 *  Printer selection widget and dialog
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtksignal.h>
#include <gtk/gtkcheckbutton.h>
#include <gtk/gtkframe.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkmenuitem.h>
#include <gtk/gtkoptionmenu.h>
#include <gtk/gtktable.h>
#include <gtk/gtkbox.h>
#include <gtk/gtkdialog.h>
#include <gtk/gtkstock.h>
#include "gnome-print-i18n.h"
#include "gpaui/printer-selector.h"
#include "gpaui/settings-selector.h"
#include "gpaui/transport-selector.h"
#include "gnome-printer-dialog.h"

#define GPS_PAD 4

struct _GnomePrinterSelection {
	GPAWidget gpawidget;
	GtkAccelGroup *accel_group;
	GtkWidget *printers; /* GPAPrinterSelector */
	GtkWidget *settings; /* GPASettingsSelector */
	GtkWidget *transport; /* GPATransportSelector */
	GtkWidget *state, *type, *location, *comment;
};

struct _GnomePrinterSelectionClass {
	GPAWidgetClass gpa_widget_class;
};

static void gnome_printer_selection_class_init (GnomePrinterSelectionClass *klass);
static void gnome_printer_selection_init (GtkObject *object);

static void gnome_printer_selection_destroy (GtkObject *object);

static GtkWidget *gpw_create_label (GtkTable *table, gint l, gint r, gint t, gint b, const gchar *text);

static void gpw_configure_clicked (GtkWidget *widget, GPAWidget *gpaw);

static GPAWidgetClass *gpw_parent_class;

GtkType
gnome_printer_selection_get_type (void)
{
	static GtkType type = 0;
	if (!type) {
		GtkTypeInfo info = {
			"GnomePrinterSelection",
			sizeof (GnomePrinterSelection),
			sizeof (GnomePrinterSelectionClass),
			(GtkClassInitFunc) gnome_printer_selection_class_init,
			(GtkObjectInitFunc) gnome_printer_selection_init,
			NULL, NULL, NULL
		};
		type = gtk_type_unique (GPA_TYPE_WIDGET, &info);
	}
	return type;
}

static void
gnome_printer_selection_class_init (GnomePrinterSelectionClass *klass)
{
	GtkObjectClass *object_class;
	
	object_class = (GtkObjectClass*) klass;
	
	gpw_parent_class = gtk_type_class (GPA_TYPE_WIDGET);
	
	object_class->destroy  = gnome_printer_selection_destroy;
}

static void
gnome_printer_selection_init (GtkObject *object)
{
	GnomePrinterSelection *gpw;
	GtkWidget *f, *t, *b;

	gpw = GNOME_PRINTER_SELECTION (object);

	gpw->accel_group = gtk_accel_group_new ();

	f = gtk_frame_new (_("Printer"));
	gtk_widget_show (f);
	gtk_container_add (GTK_CONTAINER (gpw), f);

	t = gtk_table_new (3, 6, FALSE);
	gtk_widget_show (t);
	gtk_container_add (GTK_CONTAINER (f), t);

	gpw_create_label (GTK_TABLE (t), 0, 1, 0, 1, _("Printer:"));
	gpw_create_label (GTK_TABLE (t), 0, 1, 1, 2, _("Settings:"));
	gpw_create_label (GTK_TABLE (t), 0, 1, 2, 3, _("Location:"));
	gpw_create_label (GTK_TABLE (t), 0, 1, 3, 4, _("State:"));
	gpw_create_label (GTK_TABLE (t), 0, 1, 4, 5, _("Type:"));
	gpw_create_label (GTK_TABLE (t), 0, 1, 5, 6, _("Comment:"));

	gpw->type = gpw_create_label (GTK_TABLE (t), 1, 2, 3, 4, "");
	gpw->location = gpw_create_label (GTK_TABLE (t), 1, 2, 4, 5, "");
	gpw->comment = gpw_create_label (GTK_TABLE (t), 1, 2, 5, 6, "");

	b = gtk_button_new_with_label (_("Configure"));
	gtk_widget_show (b);
	gtk_signal_connect (GTK_OBJECT (b), "clicked", GTK_SIGNAL_FUNC (gpw_configure_clicked), gpw);
	gtk_table_attach (GTK_TABLE (t), b, 2, 3, 1, 2,
			  GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,
			  GPS_PAD, GPS_PAD);

	gpw->printers = gpa_widget_new (GPA_TYPE_PRINTER_SELECTOR, NULL);
	gtk_widget_show (gpw->printers);
	gtk_table_attach (GTK_TABLE (t), gpw->printers, 1, 2, 0, 1,
			  GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,
			  GPS_PAD, GPS_PAD);

	gpw->settings = gpa_widget_new (GPA_TYPE_SETTINGS_SELECTOR, NULL);
	gtk_widget_show (gpw->settings);
	gtk_table_attach (GTK_TABLE (t), gpw->settings, 1, 2, 1, 2,
			  GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,
			  GPS_PAD, GPS_PAD);

	gpw->transport = gpa_widget_new (GPA_TYPE_TRANSPORT_SELECTOR, NULL);
	gtk_widget_show (gpw->transport);
	gtk_table_attach (GTK_TABLE (t), gpw->transport, 1, 2, 2, 3,
			  GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,
			  GPS_PAD, GPS_PAD);
}

static void
gnome_printer_selection_destroy (GtkObject *object)
{
	GnomePrinterSelection *gpw;
	
	gpw = GNOME_PRINTER_SELECTION (object);

	if (gpw->accel_group) {
		gtk_accel_group_unref (gpw->accel_group);
		gpw->accel_group = NULL;
	}

	if (((GtkObjectClass *) gpw_parent_class)->destroy)
		(* ((GtkObjectClass *) gpw_parent_class)->destroy) (object);
}

GtkWidget *
gnome_printer_selection_new_default (void)
{
	GtkWidget *gpw;
	GnomePrintConfig *config;

	config = gnome_print_config_default ();
	gpw = gnome_printer_selection_new (config);
	gnome_print_config_unref (config);

	return gpw;
}

GtkWidget *
gnome_printer_selection_new (GnomePrintConfig *config)
{
	GnomePrinterSelection *gpw;

	g_return_val_if_fail (config != NULL, NULL);

	gpw = gtk_type_new (GNOME_TYPE_PRINTER_SELECTION);
	gpa_widget_construct (GPA_WIDGET (gpw), config);

	gpa_widget_construct (GPA_WIDGET (gpw->printers), config);
	gpa_widget_construct (GPA_WIDGET (gpw->settings), config);
	gpa_widget_construct (GPA_WIDGET (gpw->transport), config);

	return GTK_WIDGET (gpw);
}

#if 0
void
gnome_printer_selection_bind_editable_enters (GnomePrinterSelection * gpw, GnomeDialog * dialog)
{
}

void
gnome_printer_selection_bind_accel_group (GnomePrinterSelection * gpw, GtkWindow * window)
{
}
#endif

GnomePrintConfig *
gnome_printer_selection_get_config (GnomePrinterSelection *widget)
{
	GPAWidget *gpaw;

	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (GNOME_IS_PRINTER_SELECTION (widget), NULL);

	gpaw = GPA_WIDGET (widget);

	if (gpaw->config) gnome_print_config_ref (gpaw->config);

	return gpaw->config;
}

static GtkWidget *
gpw_create_label (GtkTable *table, gint l, gint r, gint t, gint b, const gchar *text)
{
	GtkWidget *w;

	w = gtk_label_new (text);
	gtk_widget_show (w);
	gtk_misc_set_alignment (GTK_MISC (w), 1.0, 0.5);
	gtk_table_attach (table, w, l, r, t, b, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, GPS_PAD, GPS_PAD);

	return w;
}

static void
gpw_configure_clicked (GtkWidget *widget, GPAWidget *gpaw)
{
}

struct _GnomePrinterDialog {
	GtkDialog dialog;
	GnomePrinterSelection *gnome_printer_selection;
};

struct _GnomePrinterDialogClass {
	GtkDialogClass parent_class;
};

static GtkDialogClass *dialog_parent_class = NULL;

static void
gnome_printer_dialog_destroy (GtkObject *object)
{
	GnomePrinterDialog *printer_dialog;
	
	g_return_if_fail (object != NULL);
	g_return_if_fail (GNOME_IS_PRINTER_DIALOG (object));
	
	printer_dialog = GNOME_PRINTER_DIALOG (object);
	
	(* GTK_OBJECT_CLASS (dialog_parent_class)->destroy) (object);
}

static void
gnome_printer_dialog_class_init (GnomePrinterDialogClass *class)
{
	GtkObjectClass *object_class;
	
	object_class = (GtkObjectClass*) class;
	
	dialog_parent_class = gtk_type_class (GTK_TYPE_DIALOG);
	
	object_class->destroy = gnome_printer_dialog_destroy;
}

GtkType
gnome_printer_dialog_get_type (void)
{
	static GtkType printer_dialog_type = 0;
	
	if (!printer_dialog_type)
	{
		GtkTypeInfo printer_dialog_info =
		{
			"GnomePrinterDialog",
			sizeof (GnomePrinterDialog),
			sizeof (GnomePrinterDialogClass),
			(GtkClassInitFunc) gnome_printer_dialog_class_init,
			(GtkObjectInitFunc) NULL,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};
		
		printer_dialog_type = gtk_type_unique (GTK_TYPE_DIALOG, &printer_dialog_info);
	}
	
	return printer_dialog_type;
}

GtkWidget *
gnome_printer_dialog_new_default (void)
{
	GtkWidget *gpw;
	GnomePrintConfig *config;

	config = gnome_print_config_default ();
	gpw = gnome_printer_dialog_new (config);
	gnome_print_config_unref (config);

	return gpw;
}

/**
 * gnome_printer_dialog_new:
 *
 * Creates a dialog box for selecting a printer.
 * This returns a GnomePrinterDialog object, the programmer
 * is resposible for querying the gnome_printer_dialog
 * to fetch the selected GnomePrinter object
 *
 * Returns: the GnomeDialog, ready to be ran.
 */
GtkWidget *
gnome_printer_dialog_new (GnomePrintConfig *config)
{
	GtkWidget *printer_dialog;
	GnomePrinterDialog *pd;
	GnomePrinterSelection *gpw;
	
	pd = gtk_type_new (gnome_printer_dialog_get_type ());
	printer_dialog = GTK_WIDGET (pd);
	
	gtk_window_set_title (GTK_WINDOW (printer_dialog), _("Select Printer"));
	
	gtk_dialog_add_button (GTK_DIALOG (printer_dialog), GTK_STOCK_OK, GTK_RESPONSE_OK);
	
	gtk_dialog_add_button (GTK_DIALOG(printer_dialog), GTK_STOCK_CANCEL, GTK_RESPONSE_OK);
	
	gtk_dialog_set_default_response (GTK_DIALOG (printer_dialog), GTK_RESPONSE_OK);
	
	pd->gnome_printer_selection = GNOME_PRINTER_SELECTION (gnome_printer_selection_new (config));
	if (pd->gnome_printer_selection == NULL) return NULL;
	gtk_widget_show (GTK_WIDGET (pd->gnome_printer_selection));

	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (printer_dialog)->vbox),
			    GTK_WIDGET (pd->gnome_printer_selection), TRUE, TRUE, 0);
	gpw = pd->gnome_printer_selection;

#ifdef	ENABLE_LIBGPA
#else	
#if 0
	gnome_dialog_editable_enters (GNOME_DIALOG(pd),
				      GTK_EDITABLE(gpw->entry_command));
	gnome_dialog_editable_enters (GNOME_DIALOG(pd),
				      GTK_EDITABLE(gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (gpw->entry_filename))));
#endif
#endif
#if 0	
	gtk_widget_grab_focus (gpw->profile_selector);
#endif
	gtk_window_add_accel_group (GTK_WINDOW (pd), gpw->accel_group);
	
	return printer_dialog;
}

#if 0
/**
 * gnome_printer_dialog_new_modal:
 *
 * Runs a dialog that allows the user to select a target
 * printer and returns a GnomePrinter object.  It returns NULL
 * on failure or user cancel.
 *
 * This function runs the dialog and returns the user selection.
 *
 * Returns: A GnomePrinter object that represents the printer
 * selected by the user or NULL if the user cancels the operation.
 */
GnomePrinter *
gnome_printer_dialog_new_modal (void)
{
	GtkWidget *printer_dialog;
	GnomePrinterDialog *pd;
	GnomePrinter *printer;
	int button;

	printer_dialog = gnome_printer_dialog_new();
	pd = GNOME_PRINTER_DIALOG (printer_dialog);
	
	gtk_window_set_modal (GTK_WINDOW (printer_dialog), TRUE);
	button = gnome_dialog_run (GNOME_DIALOG (printer_dialog));
	
	if (button < 0)
		return NULL;
	
	printer = NULL;
	if (button == 0)
		printer = gnome_printer_dialog_get_printer (pd);
	
	gtk_widget_destroy (printer_dialog);

	return printer;
}
#endif

/**
 * gnome_printer_dialog_get_printer:
 * @dialog: a GnomePrinterDialog
 *
 * Returns: the GnomePrinter associated with the @dialog GnomePrinterDialog
 */
GnomePrintConfig *
gnome_printer_dialog_get_config (GnomePrinterDialog *dialog)
{
	g_return_val_if_fail (dialog != NULL, NULL);
	g_return_val_if_fail (GNOME_IS_PRINTER_DIALOG (dialog), NULL);

	return gnome_printer_selection_get_config (GNOME_PRINTER_SELECTION (dialog->gnome_printer_selection));
}
