
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <libgnomeprintuimm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "./enums.h"
#include "./fontdialog.h"
#include "./configdialog.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType gnome_print_config_dialog_get_type(void);
GType gnome_font_dialog_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gnome { namespace Print { namespace UI {  class ConfigDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } } }
namespace Gnome { namespace Print { namespace UI {  class FontDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } } }

namespace Gnome { namespace Print { namespace UI { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(gnome_print_config_dialog_get_type(), &Gnome::Print::UI::ConfigDialog_Class::wrap_new);
  Glib::wrap_register(gnome_font_dialog_get_type(), &Gnome::Print::UI::FontDialog_Class::wrap_new);

  // Register the gtkmm gtypes:
  Gnome::Print::UI::ConfigDialog::get_type();
  Gnome::Print::UI::FontDialog::get_type();

} // wrap_init()

} //UI
} //Print
} //Gnome


