//$Id: examplewindow.h,v 1.1 2004/08/30 19:51:38 murrayc Exp $ -*- c++ -*-

/* gtkmm example Copyright (C) 2002 gtkmm development team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef LIBGNOMEPRINTUIMM_EXAMPLEWINDOW_H
#define LIBGNOMEPRINTUIMM_EXAMPLEWINDOW_H

#include <gtkmm/window.h>
#include <gtkmm/button.h>
#include <libgnomeprintuimm.h>
#include <libgnomeprint/gnome-print.h> //For constants.
#include <libgnomeprintui/gnome-print-dialog.h>

class ExampleWindow : public Gtk::Window
{
public:
  ExampleWindow();
  virtual ~ExampleWindow();

protected:
  void init_print();
  //Signal handlers:
  virtual void on_button_preview();
  virtual void on_button_print_dialog();

  //Child widgets:
  Gtk::Button m_button_preview;
  Gtk::Button m_button_print_dialog;

  //Print classes:
  Glib::RefPtr<Gnome::Print::Config> refConfig;
  Glib::RefPtr<Gnome::Print::Job> refJob;
};

#endif //LIBGNOMEPRINTUIMM_EXAMPLEWINDOW_H
