// -*- c++ -*-
/* $Id: init.cc 622 2004-03-29 17:59:17Z murrayc $ */

/* init.cc
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libnotify/notify.h>
#include <glibmm.h>

namespace Notify
{

Glib::ustring get_app_name()
{
	return notify_get_app_name();		
}
	
Glib::ListHandle<Glib::ustring> get_server_caps()
{
	return Glib::ListHandle<Glib::ustring>(notify_get_server_caps(), Glib::OWNERSHIP_SHALLOW);
}

bool get_server_info (Glib::ustring& ret_name,
											Glib::ustring& ret_vendor,
											Glib::ustring& ret_version,
											Glib::ustring& ret_spec_version)
{
	gchar* name;
	gchar* vendor;
	gchar* version;
	gchar* spec_version;
	
	if (!notify_get_server_info (&name, &vendor, &version, &spec_version))
		return false;
	
	ret_name = name;
	ret_vendor = vendor;
	ret_version = version;
	ret_spec_version = spec_version;
	
	g_free (name);
	g_free (vendor);
	g_free (version);
	g_free (spec_version);
	
	return true;
}


} //namespace Notify
