#include <gtk/gtk.h>
#include <girepository.h>
#include <libpeas/peas-engine.h>
#include <libpeasui/peas-ui-plugin-manager.h>

#include "peas-demo-window.h"

static PeasEngine *engine;
static GtkWidget *main_window;
static int n_windows;

static void
activate_plugin (GtkButton   *button,
                 const gchar *plugin_name)
{
  PeasPluginInfo *info;

  g_debug ("%s %s", G_STRFUNC, plugin_name);
  info = peas_engine_get_plugin_info (engine, plugin_name);
  g_return_if_fail (info != NULL);
  peas_engine_load_plugin (engine, info);
}

static void
create_plugin_manager (GtkButton *button,
                       gpointer   user_data)
{
  GtkWidget *window;
  GtkWidget *manager;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width (GTK_CONTAINER (window), 6);
  gtk_window_set_title (GTK_WINDOW (window), "Peas Plugin Manager");

  manager = peas_ui_plugin_manager_new (engine);
  gtk_container_add (GTK_CONTAINER (window), manager);

  gtk_widget_show_all (window);
}

static void
create_new_window (void)
{
  GtkWidget *window;

  window = demo_window_new (engine);
  gtk_widget_show_all (window);
}

static GtkWidget *
create_main_window (void)
{
  GtkWidget *window;
  GtkWidget *box;
  GtkWidget *button;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  g_signal_connect (window, "destroy", G_CALLBACK (gtk_main_quit), NULL);
  gtk_container_set_border_width (GTK_CONTAINER (window), 6);
  gtk_window_set_title (GTK_WINDOW (window), "Peas Demo");

  box = gtk_hbox_new (TRUE, 6);
  gtk_container_add (GTK_CONTAINER (window), box);

  button = gtk_button_new_with_label ("New window");
  g_signal_connect (button, "clicked", G_CALLBACK (create_new_window), NULL);
  gtk_box_pack_start (GTK_BOX (box), button, TRUE, TRUE, 0);

  button = gtk_button_new_with_label ("Hello World");
  g_signal_connect (button, "clicked", G_CALLBACK (activate_plugin), "helloworld");
  gtk_box_pack_start (GTK_BOX (box), button, TRUE, TRUE, 0);

  button = gtk_button_new_with_label ("Python Hello");
  g_signal_connect (button, "clicked", G_CALLBACK (activate_plugin), "pythonhello");
  gtk_box_pack_start (GTK_BOX (box), button, TRUE, TRUE, 0);

  button = gtk_button_new_with_label ("Seed Hello");
  g_signal_connect (button, "clicked", G_CALLBACK (activate_plugin), "seedhello");
  gtk_box_pack_start (GTK_BOX (box), button, TRUE, TRUE, 0);

  button = gtk_button_new_from_stock (GTK_STOCK_PREFERENCES);
  g_signal_connect (button, "clicked", G_CALLBACK (create_plugin_manager), NULL);
  gtk_box_pack_start (GTK_BOX (box), button, TRUE, TRUE, 0);

  button = gtk_button_new_from_stock (GTK_STOCK_QUIT);
  g_signal_connect (button, "clicked", G_CALLBACK (gtk_main_quit), NULL);
  gtk_box_pack_start (GTK_BOX (box), button, TRUE, TRUE, 0);

  return window;
}

int
main (int argc, char **argv)
{
  gchar const * const search_paths[] = {
    /* Uninstalled plugins */
    "./plugins/",
    "./plugins/",
    /* User-installed plugins */
    g_build_filename (g_get_user_config_dir (), "peas-demo/plugins", NULL),
    g_build_filename (g_get_user_config_dir (), "peas-demo/plugins", NULL),
    /* System-wide plugins */
    PEAS_PREFIX "/lib/peas-demo/plugins/",
    PEAS_PREFIX "/share/peas-demo/plugins/",
    NULL
  };

  gtk_init (&argc, &argv);

  g_irepository_prepend_search_path (PEAS_PREFIX "/lib/girepository-1.0");
  g_irepository_require (g_irepository_get_default (), "PeasUI", "1.0", 0, NULL);

  engine = peas_engine_new ("PeasDemo",
                            PEAS_PREFIX "/lib/peas-demo/",
                            (const gchar **) search_paths);

  n_windows = 0;
  main_window = create_main_window ();
  gtk_widget_show_all (main_window);

  gtk_main ();

  g_object_unref (engine);

  return 0;
}
