/*
 * globals.c: definition and handling of the set of global variables
 *            of the library
 *
 * The bottom of this file is automatically generated by build_glob.py
 * based on the description file global.data
 *
 * See Copyright for the status of this software.
 *
 * Gary Pennington <Gary.Pennington@uk.sun.com>
 * daniel@veillard.com
 */

#define IN_LIBXML
#include "libxml.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <string.h>

#include <libxml/globals.h>
#include <libxml/xmlmemory.h>

/* #define DEBUG_GLOBALS */

/*
 * Helpful Macro
 */
#ifdef LIBXML_THREAD_ENABLED
#define IS_MAIN_THREAD (xmlIsMainThread())
#else
#define IS_MAIN_THREAD 1
#endif

/************************************************************************
 * 									*
 *	All the user accessible global variables of the library		*
 * 									*
 ************************************************************************/

/*
 * Memory allocation routines
 */
#if defined(DEBUG_MEMORY_LOCATION) || defined(DEBUG_MEMORY)
extern void xmlMemFree(void *ptr);
extern void * xmlMemMalloc(size_t size);
extern void * xmlMemRealloc(void *ptr,size_t size);
extern char * xmlMemoryStrdup(const char *str);

xmlFreeFunc xmlFree = (xmlFreeFunc) xmlMemFree;
xmlMallocFunc xmlMalloc = (xmlMallocFunc) xmlMemMalloc;
xmlReallocFunc xmlRealloc = (xmlReallocFunc) xmlMemRealloc;
xmlStrdupFunc xmlMemStrdup = (xmlStrdupFunc) xmlMemoryStrdup;
#else
/**
 * xmlFree:
 * @mem: an already allocated block of memory
 *
 * The variable holding the libxml free() implementation
 */
xmlFreeFunc xmlFree = (xmlFreeFunc) free;
/**
 * xmlMalloc:
 * @size:  the size requested in bytes
 *
 * The variable holding the libxml malloc() implementation
 *
 * Returns a pointer to the newly allocated block or NULL in case of error
 */
xmlMallocFunc xmlMalloc = (xmlMallocFunc) malloc;
/**
 * xmlRealloc:
 * @mem: an already allocated block of memory
 * @size:  the new size requested in bytes
 *
 * The variable holding the libxml realloc() implementation
 *
 * Returns a pointer to the newly reallocated block or NULL in case of error
 */
xmlReallocFunc xmlRealloc = (xmlReallocFunc) realloc;
/**
 * xmlMemStrdup:
 * @str: a zero terminated string
 *
 * The variable holding the libxml strdup() implementation
 *
 * Returns the copy of the string or NULL in case of error
 */
xmlStrdupFunc xmlMemStrdup = (xmlStrdupFunc) xmlStrdup;
#endif

#include <libxml/threads.h>
#include <libxml/globals.h>
#include <libxml/SAX.h>

#undef	docbDefaultSAXHandler
#undef	htmlDefaultSAXHandler
#undef	oldXMLWDcompatibility
#undef	xmlBufferAllocScheme
#undef	xmlDefaultBufferSize
#undef	xmlDefaultSAXHandler
#undef	xmlDefaultSAXLocator
#undef	xmlDoValidityCheckingDefaultValue
#undef	xmlGenericError
#undef	xmlGenericErrorContext
#undef	xmlGetWarningsDefaultValue
#undef	xmlIndentTreeOutput
#undef  xmlTreeIndentString
#undef	xmlKeepBlanksDefaultValue
#undef	xmlLineNumbersDefaultValue
#undef	xmlLoadExtDtdDefaultValue
#undef	xmlParserDebugEntities
#undef	xmlParserVersion
#undef	xmlPedanticParserDefaultValue
#undef	xmlSaveNoEmptyTags
#undef	xmlSubstituteEntitiesDefaultValue

#undef	xmlFree
#undef	xmlMalloc
#undef	xmlMemStrdup
#undef	xmlRealloc

/**
 * xmlParserVersion:
 *
 * Constant string describing the internal version of the library
 */
const char *xmlParserVersion = LIBXML_VERSION_STRING;

/**
 * xmlBufferAllocScheme:
 *
 * Global setting, default allocation policy for buffers, default is
 * XML_BUFFER_ALLOC_EXACT
 */
xmlBufferAllocationScheme xmlBufferAllocScheme = XML_BUFFER_ALLOC_EXACT;
/**
 * xmlDefaultBufferSize:
 *
 * Global setting, default buffer size. Default value is BASE_BUFFER_SIZE
 */
int xmlDefaultBufferSize = BASE_BUFFER_SIZE;

/*
 * Parser defaults
 */

/**
 * oldXMLWDcompatibility:
 *
 * Global setting, DEPRECATED.
 */
int oldXMLWDcompatibility = 0; /* DEPRECATED */
/**
 * xmlParserDebugEntities:
 *
 * Global setting, asking the parser to print out debugging informations.
 * while handling entities.
 * Disabled by default
 */
int xmlParserDebugEntities = 0;
/**
 * xmlDoValidityCheckingDefaultValue:
 *
 * Global setting, indicate that the parser should work in validating mode.
 * Disabled by default.
 */
int xmlDoValidityCheckingDefaultValue = 0;
/**
 * xmlGetWarningsDefaultValue:
 *
 * Global setting, indicate that the parser should provide warnings.
 * Activated by default.
 */
int xmlGetWarningsDefaultValue = 1;
/**
 * xmlLoadExtDtdDefaultValue:
 *
 * Global setting, indicate that the parser should load DTD while not
 * validating.
 * Disabled by default.
 */
int xmlLoadExtDtdDefaultValue = 0;
/**
 * xmlPedanticParserDefaultValue:
 *
 * Global setting, indicate that the parser be pedantic
 * Disabled by default.
 */
int xmlPedanticParserDefaultValue = 0;
/**
 * xmlLineNumbersDefaultValue:
 *
 * Global setting, indicate that the parser should store the line number
 * in the content field of elements in the DOM tree. 
 * Disabled by default since this may not be safe for old classes of
 * applicaton.
 */
int xmlLineNumbersDefaultValue = 0;
/**
 * xmlKeepBlanksDefaultValue:
 *
 * Global setting, indicate that the parser should keep all blanks
 * nodes found in the content
 * Activated by default, this is actually needed to have the parser
 * conformant to the XML Recommendation, however the option is kept
 * for some applications since this was libxml1 default behaviour.
 */
int xmlKeepBlanksDefaultValue = 1;
/**
 * xmlSubstituteEntitiesDefaultValue:
 *
 * Global setting, indicate that the parser should not generate entity
 * references but replace them with the actual content of the entity
 * Disabled by default, this should be activated when using XPath since
 * the XPath data model requires entities replacement and the XPath
 * engine does not handle entities references transparently.
 */
int xmlSubstituteEntitiesDefaultValue = 0;

xmlRegisterNodeFunc xmlRegisterNodeDefaultValue = NULL;
xmlDeregisterNodeFunc xmlDeregisterNodeDefaultValue = NULL;

/*
 * Error handling
 */

/* xmlGenericErrorFunc xmlGenericError = xmlGenericErrorDefaultFunc; */
/* Must initialize xmlGenericError in xmlInitParser */
void xmlGenericErrorDefaultFunc	(void *ctx ATTRIBUTE_UNUSED,
				 const char *msg,
				 ...);
/**
 * xmlGenericError:
 *
 * Global setting: function used for generic error callbacks
 */
xmlGenericErrorFunc xmlGenericError = xmlGenericErrorDefaultFunc;
/**
 * xmlGenericErrorContext:
 *
 * Global setting passed to generic error callbacks
 */
void *xmlGenericErrorContext = NULL;

/*
 * output defaults
 */
/**
 * xmlIndentTreeOutput:
 *
 * Global setting, asking the serializer to indent the output tree by default
 * Enabled by default
 */
int xmlIndentTreeOutput = 1;

/**
 * xmlTreeIndentString:
 *
 * The string used to do one-level indent. By default is equal to "  " (two spaces)
 */
const char *xmlTreeIndentString = "  ";

/**
 * xmlSaveNoEmptyTags:
 *
 * Global setting, asking the serializer to not output empty tags
 * as <empty/> but <empty></empty>. those two forms are undistinguishable
 * once parsed.
 * Disabled by default
 */
int xmlSaveNoEmptyTags = 0;

/**
 * xmlDefaultSAXHandler:
 *
 * Default handler for XML, builds the DOM tree
 */
xmlSAXHandler xmlDefaultSAXHandler = {
    internalSubset,
    isStandalone,
    hasInternalSubset,
    hasExternalSubset,
    resolveEntity,
    getEntity,
    entityDecl,
    notationDecl,
    attributeDecl,
    elementDecl,
    unparsedEntityDecl,
    setDocumentLocator,
    startDocument,
    endDocument,
    startElement,
    endElement,
    reference,
    characters,
    characters,
    processingInstruction,
    comment,
    xmlParserWarning,
    xmlParserError,
    xmlParserError,
    getParameterEntity,
    cdataBlock,
    externalSubset,
    0
};

/**
 * xmlDefaultSAXLocator:
 *
 * The default SAX Locator
 * { getPublicId, getSystemId, getLineNumber, getColumnNumber}
 */
xmlSAXLocator xmlDefaultSAXLocator = {
    getPublicId, getSystemId, getLineNumber, getColumnNumber
};

#ifdef LIBXML_HTML_ENABLED
/**
 * htmlDefaultSAXHandler:
 *
 * Default handler for HTML, builds the DOM tree
 */
xmlSAXHandler htmlDefaultSAXHandler = {
    internalSubset,
    NULL,
    NULL,
    NULL,
    NULL,
    getEntity,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    setDocumentLocator,
    startDocument,
    endDocument,
    startElement,
    endElement,
    NULL,
    characters,
    ignorableWhitespace,
    NULL,
    comment,
    xmlParserWarning,
    xmlParserError,
    xmlParserError,
    getParameterEntity,
    cdataBlock,
    NULL,
    0
};
#endif /* LIBXML_HTML_ENABLED */

#ifdef LIBXML_DOCB_ENABLED
/**
 * docbDefaultSAXHandler:
 *
 * Default handler for SGML DocBook, builds the DOM tree
 */
xmlSAXHandler docbDefaultSAXHandler = {
    internalSubset,
    isStandalone,
    hasInternalSubset,
    hasExternalSubset,
    resolveEntity,
    getEntity,
    entityDecl,
    NULL,
    NULL,
    NULL,
    NULL,
    setDocumentLocator,
    startDocument,
    endDocument,
    startElement,
    endElement,
    reference,
    characters,
    ignorableWhitespace,
    NULL,
    comment,
    xmlParserWarning,
    xmlParserError,
    xmlParserError,
    getParameterEntity,
    NULL,
    NULL,
    0
};
#endif /* LIBXML_DOCB_ENABLED */

/**
 * xmlInitializeGlobalState:
 * @gs: a pointer to a newly allocated global state
 *
 * xmlInitializeGlobalState() initialize a global state with all the
 * default values of the library.
 */
void
xmlInitializeGlobalState(xmlGlobalStatePtr gs)
{
#ifdef DEBUG_GLOBALS
    fprintf(stderr, "Initializing globals at %lu for thread %d\n",
	    (unsigned long) gs, xmlGetThreadId());
#endif

    /*
     * Perform initialization as required by libxml
     */

#ifdef LIBXML_DOCB_ENABLED
    initdocbDefaultSAXHandler(&gs->docbDefaultSAXHandler);
#endif
#ifdef LIBXML_HTML_ENABLED
    inithtmlDefaultSAXHandler(&gs->htmlDefaultSAXHandler);
#endif
    initGenericErrorDefaultFunc(&gs->xmlGenericError);

    gs->oldXMLWDcompatibility = 0;
    gs->xmlBufferAllocScheme = XML_BUFFER_ALLOC_EXACT;
    gs->xmlDefaultBufferSize = BASE_BUFFER_SIZE;
    initxmlDefaultSAXHandler(&gs->xmlDefaultSAXHandler, 1);
    gs->xmlDefaultSAXLocator.getPublicId = getPublicId;
    gs->xmlDefaultSAXLocator.getSystemId = getSystemId;
    gs->xmlDefaultSAXLocator.getLineNumber = getLineNumber;
    gs->xmlDefaultSAXLocator.getColumnNumber = getColumnNumber;
    gs->xmlDoValidityCheckingDefaultValue = 0;
#if defined(DEBUG_MEMORY_LOCATION) | defined(DEBUG_MEMORY)
    gs->xmlFree = (xmlFreeFunc) xmlMemFree;
    gs->xmlMalloc = (xmlMallocFunc) xmlMemMalloc;
    gs->xmlRealloc = (xmlReallocFunc) xmlMemRealloc;
    gs->xmlMemStrdup = (xmlStrdupFunc) xmlMemoryStrdup;
#else
    gs->xmlFree = (xmlFreeFunc) free;
    gs->xmlMalloc = (xmlMallocFunc) malloc;
    gs->xmlRealloc = (xmlReallocFunc) realloc;
    gs->xmlMemStrdup = (xmlStrdupFunc) xmlStrdup;
#endif
    gs->xmlGenericErrorContext = NULL;
    gs->xmlGetWarningsDefaultValue = 1;
    gs->xmlIndentTreeOutput = 1;
    gs->xmlTreeIndentString = "  ";
    gs->xmlKeepBlanksDefaultValue = 1;
    gs->xmlLineNumbersDefaultValue = 0;
    gs->xmlLoadExtDtdDefaultValue = 0;
    gs->xmlParserDebugEntities = 0;
    gs->xmlParserVersion = LIBXML_VERSION_STRING;
    gs->xmlPedanticParserDefaultValue = 0;
    gs->xmlSaveNoEmptyTags = 0;
    gs->xmlSubstituteEntitiesDefaultValue = 0;

    gs->xmlRegisterNodeDefaultValue = NULL;
    gs->xmlDeregisterNodeDefaultValue = NULL;
}

/**
 * xmlRegisterNodeDefault:
 * @func: function pointer to the new RegisterNodeFunc
 *
 * Returns the previous value of the registration function
 */
xmlRegisterNodeFunc
xmlRegisterNodeDefault(xmlRegisterNodeFunc func)
{
    xmlRegisterNodeFunc old = xmlRegisterNodeDefaultValue;
    
    xmlRegisterNodeDefaultValue = func;
    return(old);
}

/**
 * xmlDeregisterNodeDefault:
 * @func: function pointer to the new DeregisterNodeFunc
 *
 * Returns the previous value of the deregistration function
 */
xmlDeregisterNodeFunc
xmlDeregisterNodeDefault(xmlDeregisterNodeFunc func)
{
    xmlDeregisterNodeFunc old = xmlDeregisterNodeDefaultValue;
    
    xmlDeregisterNodeDefaultValue = func;
    return(old);
}


#ifdef LIBXML_DOCB_ENABLED
#undef	docbDefaultSAXHandler
xmlSAXHandler *
__docbDefaultSAXHandler(void) {
    if (IS_MAIN_THREAD)
	return (&docbDefaultSAXHandler);
    else
	return (&xmlGetGlobalState()->docbDefaultSAXHandler);
}
#endif

#ifdef LIBXML_HTML_ENABLED
#undef	htmlDefaultSAXHandler
xmlSAXHandler *
__htmlDefaultSAXHandler(void) {
    if (IS_MAIN_THREAD)
	return (&htmlDefaultSAXHandler);
    else
	return (&xmlGetGlobalState()->htmlDefaultSAXHandler);
}
#endif

/*
 * Everything starting from the line below is
 * Automatically generated by build_glob.py.
 * Do not modify the previous line.
 */


#undef	oldXMLWDcompatibility
int *
__oldXMLWDcompatibility(void) {
    if (IS_MAIN_THREAD)
	return (&oldXMLWDcompatibility);
    else
	return (&xmlGetGlobalState()->oldXMLWDcompatibility);
}

#undef	xmlBufferAllocScheme
xmlBufferAllocationScheme *
__xmlBufferAllocScheme(void) {
    if (IS_MAIN_THREAD)
	return (&xmlBufferAllocScheme);
    else
	return (&xmlGetGlobalState()->xmlBufferAllocScheme);
}

#undef	xmlDefaultBufferSize
int *
__xmlDefaultBufferSize(void) {
    if (IS_MAIN_THREAD)
	return (&xmlDefaultBufferSize);
    else
	return (&xmlGetGlobalState()->xmlDefaultBufferSize);
}

#undef	xmlDefaultSAXHandler
xmlSAXHandler *
__xmlDefaultSAXHandler(void) {
    if (IS_MAIN_THREAD)
	return (&xmlDefaultSAXHandler);
    else
	return (&xmlGetGlobalState()->xmlDefaultSAXHandler);
}

#undef	xmlDefaultSAXLocator
xmlSAXLocator *
__xmlDefaultSAXLocator(void) {
    if (IS_MAIN_THREAD)
	return (&xmlDefaultSAXLocator);
    else
	return (&xmlGetGlobalState()->xmlDefaultSAXLocator);
}

#undef	xmlDoValidityCheckingDefaultValue
int *
__xmlDoValidityCheckingDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlDoValidityCheckingDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlDoValidityCheckingDefaultValue);
}

#undef	xmlGenericError
xmlGenericErrorFunc *
__xmlGenericError(void) {
    if (IS_MAIN_THREAD)
	return (&xmlGenericError);
    else
	return (&xmlGetGlobalState()->xmlGenericError);
}

#undef	xmlGenericErrorContext
void * *
__xmlGenericErrorContext(void) {
    if (IS_MAIN_THREAD)
	return (&xmlGenericErrorContext);
    else
	return (&xmlGetGlobalState()->xmlGenericErrorContext);
}

#undef	xmlGetWarningsDefaultValue
int *
__xmlGetWarningsDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlGetWarningsDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlGetWarningsDefaultValue);
}

#undef	xmlIndentTreeOutput
int *
__xmlIndentTreeOutput(void) {
    if (IS_MAIN_THREAD)
	return (&xmlIndentTreeOutput);
    else
	return (&xmlGetGlobalState()->xmlIndentTreeOutput);
}

#undef xmlTreeIndentString
const char * *
__xmlTreeIndentString(void) {
    if (IS_MAIN_THREAD)
	return (&xmlTreeIndentString);
    else
	return (&xmlGetGlobalState()->xmlTreeIndentString);
}

#undef	xmlKeepBlanksDefaultValue
int *
__xmlKeepBlanksDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlKeepBlanksDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlKeepBlanksDefaultValue);
}

#undef	xmlLineNumbersDefaultValue
int *
__xmlLineNumbersDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlLineNumbersDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlLineNumbersDefaultValue);
}

#undef	xmlLoadExtDtdDefaultValue
int *
__xmlLoadExtDtdDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlLoadExtDtdDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlLoadExtDtdDefaultValue);
}

#undef	xmlParserDebugEntities
int *
__xmlParserDebugEntities(void) {
    if (IS_MAIN_THREAD)
	return (&xmlParserDebugEntities);
    else
	return (&xmlGetGlobalState()->xmlParserDebugEntities);
}

#undef	xmlParserVersion
const char * *
__xmlParserVersion(void) {
    if (IS_MAIN_THREAD)
	return (&xmlParserVersion);
    else
	return (&xmlGetGlobalState()->xmlParserVersion);
}

#undef	xmlPedanticParserDefaultValue
int *
__xmlPedanticParserDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlPedanticParserDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlPedanticParserDefaultValue);
}

#undef	xmlSaveNoEmptyTags
int *
__xmlSaveNoEmptyTags(void) {
    if (IS_MAIN_THREAD)
	return (&xmlSaveNoEmptyTags);
    else
	return (&xmlGetGlobalState()->xmlSaveNoEmptyTags);
}

#undef	xmlSubstituteEntitiesDefaultValue
int *
__xmlSubstituteEntitiesDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlSubstituteEntitiesDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlSubstituteEntitiesDefaultValue);
}

#undef	xmlRegisterNodeDefaultValue
xmlRegisterNodeFunc *
__xmlRegisterNodeDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlRegisterNodeDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlRegisterNodeDefaultValue);
}

#undef	xmlDeregisterNodeDefaultValue
xmlDeregisterNodeFunc *
__xmlDeregisterNodeDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlDeregisterNodeDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlDeregisterNodeDefaultValue);
}
