# Note that this is NOT a relocatable package
%define ver      0.8.0
%define prefix   /usr

Summary: Library providing XSLT support
Name: libxslt
Version: %ver
Release: 1
Copyright: LGPL
Group: Development/Libraries
Source: ftp://xmlsoft.org/XSLT/libxslt-%{ver}.tar.gz
BuildRoot: /var/tmp/libxslt-%{PACKAGE_VERSION}-root
Requires: libxml2 >= 2.3.3

URL: http://xmlsoft.org/XSLT/
Docdir: %{prefix}/doc

%description
This C library allows to transform XML files into other XML files
(or HTML, text, ...) using the standard XSLT stylesheet transformation
mechanism. To use it you need to have a version of libxml2 >= 2.3.3
installed.

%package devel
Summary: Libraries, includes, etc. to develop XML and HTML applications
Group: Development/Libraries
Requires: libxslt = %{version}
Requires: libxml2-devel >= 2.3.2

%description devel
This C library allows to transform XML files into other XML files
(or HTML, text, ...) using the standard XSLT stylesheet transformation
mechanism. To use it you need to have a version of libxml2 >= 2.3.3
installed.

%changelog

* Mon Jan 22 2001 Daniel.Veillard <Daniel.Veillard@imag.fr>

- created based on libxml2 spec file

%prep
%setup

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
%ifarch alpha
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --host=alpha-redhat-linux --prefix=%prefix --sysconfdir="/etc"
%else
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix --sysconfdir="/etc"
%endif
else
%ifarch alpha
  CFLAGS="$RPM_OPT_FLAGS" ./configure --host=alpha-redhat-linux --prefix=%prefix --sysconfdir="/etc"
%else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix --sysconfdir="/etc"
%endif
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

install -d $RPM_BUILD_ROOT/usr/man/man1
install -d $RPM_BUILD_ROOT/usr/man/man4
make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)

%doc AUTHORS ChangeLog NEWS README COPYING COPYING.LIB TODO FEATURES
%doc doc/*.html doc/html

%{prefix}/lib/lib*.so.*
%{prefix}/bin/xsltproc

%files devel
%defattr(-, root, root)

%{prefix}/lib/lib*.so
%{prefix}/lib/*a
%{prefix}/lib/*.sh
%{prefix}/include/*
%{prefix}/bin/xslt-config
