﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="OxyColors.cs" company="OxyPlot">
//   The MIT License (MIT)
//
//   Copyright (c) 2012 Oystein Bjorke
//
//   Permission is hereby granted, free of charge, to any person obtaining a
//   copy of this software and associated documentation files (the
//   "Software"), to deal in the Software without restriction, including
//   without limitation the rights to use, copy, modify, merge, publish,
//   distribute, sublicense, and/or sell copies of the Software, and to
//   permit persons to whom the Software is furnished to do so, subject to
//   the following conditions:
//
//   The above copyright notice and this permission notice shall be included
//   in all copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
//   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
//   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
//   CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
//   TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
//   SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// </copyright>
// <summary>
//   Implements a set of predefined colors.
// </summary>
// --------------------------------------------------------------------------------------------------------------------
namespace OxyPlot
{
    /// <summary>
    /// Implements a set of predefined colors.
    /// </summary>
    public static class OxyColors
    {
        /// <summary>
        /// The alice blue.
        /// </summary>
        public static readonly OxyColor AliceBlue = OxyColor.FromUInt32(0xFFF0F8FF);

        /// <summary>
        /// The antique white.
        /// </summary>
        public static readonly OxyColor AntiqueWhite = OxyColor.FromUInt32(0xFFFAEBD7);

        /// <summary>
        /// The aqua.
        /// </summary>
        public static readonly OxyColor Aqua = OxyColor.FromUInt32(0xFF00FFFF);

        /// <summary>
        /// The aquamarine.
        /// </summary>
        public static readonly OxyColor Aquamarine = OxyColor.FromUInt32(0xFF7FFFD4);

        /// <summary>
        /// The azure.
        /// </summary>
        public static readonly OxyColor Azure = OxyColor.FromUInt32(0xFFF0FFFF);

        /// <summary>
        /// The beige.
        /// </summary>
        public static readonly OxyColor Beige = OxyColor.FromUInt32(0xFFF5F5DC);

        /// <summary>
        /// The bisque.
        /// </summary>
        public static readonly OxyColor Bisque = OxyColor.FromUInt32(0xFFFFE4C4);

        /// <summary>
        /// The black.
        /// </summary>
        public static readonly OxyColor Black = OxyColor.FromUInt32(0xFF000000);

        /// <summary>
        /// The blanched almond.
        /// </summary>
        public static readonly OxyColor BlanchedAlmond = OxyColor.FromUInt32(0xFFFFEBCD);

        /// <summary>
        /// The blue.
        /// </summary>
        public static readonly OxyColor Blue = OxyColor.FromUInt32(0xFF0000FF);

        /// <summary>
        /// The blue violet.
        /// </summary>
        public static readonly OxyColor BlueViolet = OxyColor.FromUInt32(0xFF8A2BE2);

        /// <summary>
        /// The brown.
        /// </summary>
        public static readonly OxyColor Brown = OxyColor.FromUInt32(0xFFA52A2A);

        /// <summary>
        /// The burly wood.
        /// </summary>
        public static readonly OxyColor BurlyWood = OxyColor.FromUInt32(0xFFDEB887);

        /// <summary>
        /// The cadet blue.
        /// </summary>
        public static readonly OxyColor CadetBlue = OxyColor.FromUInt32(0xFF5F9EA0);

        /// <summary>
        /// The chartreuse.
        /// </summary>
        public static readonly OxyColor Chartreuse = OxyColor.FromUInt32(0xFF7FFF00);

        /// <summary>
        /// The chocolate.
        /// </summary>
        public static readonly OxyColor Chocolate = OxyColor.FromUInt32(0xFFD2691E);

        /// <summary>
        /// The coral.
        /// </summary>
        public static readonly OxyColor Coral = OxyColor.FromUInt32(0xFFFF7F50);

        /// <summary>
        /// The cornflower blue.
        /// </summary>
        public static readonly OxyColor CornflowerBlue = OxyColor.FromUInt32(0xFF6495ED);

        /// <summary>
        /// The cornsilk.
        /// </summary>
        public static readonly OxyColor Cornsilk = OxyColor.FromUInt32(0xFFFFF8DC);

        /// <summary>
        /// The crimson.
        /// </summary>
        public static readonly OxyColor Crimson = OxyColor.FromUInt32(0xFFDC143C);

        /// <summary>
        /// The cyan.
        /// </summary>
        public static readonly OxyColor Cyan = OxyColor.FromUInt32(0xFF00FFFF);

        /// <summary>
        /// The dark blue.
        /// </summary>
        public static readonly OxyColor DarkBlue = OxyColor.FromUInt32(0xFF00008B);

        /// <summary>
        /// The dark cyan.
        /// </summary>
        public static readonly OxyColor DarkCyan = OxyColor.FromUInt32(0xFF008B8B);

        /// <summary>
        /// The dark goldenrod.
        /// </summary>
        public static readonly OxyColor DarkGoldenrod = OxyColor.FromUInt32(0xFFB8860B);

        /// <summary>
        /// The dark gray.
        /// </summary>
        public static readonly OxyColor DarkGray = OxyColor.FromUInt32(0xFFA9A9A9);

        /// <summary>
        /// The dark green.
        /// </summary>
        public static readonly OxyColor DarkGreen = OxyColor.FromUInt32(0xFF006400);

        /// <summary>
        /// The dark khaki.
        /// </summary>
        public static readonly OxyColor DarkKhaki = OxyColor.FromUInt32(0xFFBDB76B);

        /// <summary>
        /// The dark magenta.
        /// </summary>
        public static readonly OxyColor DarkMagenta = OxyColor.FromUInt32(0xFF8B008B);

        /// <summary>
        /// The dark olive green.
        /// </summary>
        public static readonly OxyColor DarkOliveGreen = OxyColor.FromUInt32(0xFF556B2F);

        /// <summary>
        /// The dark orange.
        /// </summary>
        public static readonly OxyColor DarkOrange = OxyColor.FromUInt32(0xFFFF8C00);

        /// <summary>
        /// The dark orchid.
        /// </summary>
        public static readonly OxyColor DarkOrchid = OxyColor.FromUInt32(0xFF9932CC);

        /// <summary>
        /// The dark red.
        /// </summary>
        public static readonly OxyColor DarkRed = OxyColor.FromUInt32(0xFF8B0000);

        /// <summary>
        /// The dark salmon.
        /// </summary>
        public static readonly OxyColor DarkSalmon = OxyColor.FromUInt32(0xFFE9967A);

        /// <summary>
        /// The dark sea green.
        /// </summary>
        public static readonly OxyColor DarkSeaGreen = OxyColor.FromUInt32(0xFF8FBC8F);

        /// <summary>
        /// The dark slate blue.
        /// </summary>
        public static readonly OxyColor DarkSlateBlue = OxyColor.FromUInt32(0xFF483D8B);

        /// <summary>
        /// The dark slate gray.
        /// </summary>
        public static readonly OxyColor DarkSlateGray = OxyColor.FromUInt32(0xFF2F4F4F);

        /// <summary>
        /// The dark turquoise.
        /// </summary>
        public static readonly OxyColor DarkTurquoise = OxyColor.FromUInt32(0xFF00CED1);

        /// <summary>
        /// The dark violet.
        /// </summary>
        public static readonly OxyColor DarkViolet = OxyColor.FromUInt32(0xFF9400D3);

        /// <summary>
        /// The deep pink.
        /// </summary>
        public static readonly OxyColor DeepPink = OxyColor.FromUInt32(0xFFFF1493);

        /// <summary>
        /// The deep sky blue.
        /// </summary>
        public static readonly OxyColor DeepSkyBlue = OxyColor.FromUInt32(0xFF00BFFF);

        /// <summary>
        /// The dim gray.
        /// </summary>
        public static readonly OxyColor DimGray = OxyColor.FromUInt32(0xFF696969);

        /// <summary>
        /// The dodger blue.
        /// </summary>
        public static readonly OxyColor DodgerBlue = OxyColor.FromUInt32(0xFF1E90FF);

        /// <summary>
        /// The firebrick.
        /// </summary>
        public static readonly OxyColor Firebrick = OxyColor.FromUInt32(0xFFB22222);

        /// <summary>
        /// The floral white.
        /// </summary>
        public static readonly OxyColor FloralWhite = OxyColor.FromUInt32(0xFFFFFAF0);

        /// <summary>
        /// The forest green.
        /// </summary>
        public static readonly OxyColor ForestGreen = OxyColor.FromUInt32(0xFF228B22);

        /// <summary>
        /// The fuchsia.
        /// </summary>
        public static readonly OxyColor Fuchsia = OxyColor.FromUInt32(0xFFFF00FF);

        /// <summary>
        /// The gainsboro.
        /// </summary>
        public static readonly OxyColor Gainsboro = OxyColor.FromUInt32(0xFFDCDCDC);

        /// <summary>
        /// The ghost white.
        /// </summary>
        public static readonly OxyColor GhostWhite = OxyColor.FromUInt32(0xFFF8F8FF);

        /// <summary>
        /// The gold.
        /// </summary>
        public static readonly OxyColor Gold = OxyColor.FromUInt32(0xFFFFD700);

        /// <summary>
        /// The goldenrod.
        /// </summary>
        public static readonly OxyColor Goldenrod = OxyColor.FromUInt32(0xFFDAA520);

        /// <summary>
        /// The gray.
        /// </summary>
        public static readonly OxyColor Gray = OxyColor.FromUInt32(0xFF808080);

        /// <summary>
        /// The green.
        /// </summary>
        public static readonly OxyColor Green = OxyColor.FromUInt32(0xFF008000);

        /// <summary>
        /// The green yellow.
        /// </summary>
        public static readonly OxyColor GreenYellow = OxyColor.FromUInt32(0xFFADFF2F);

        /// <summary>
        /// The honeydew.
        /// </summary>
        public static readonly OxyColor Honeydew = OxyColor.FromUInt32(0xFFF0FFF0);

        /// <summary>
        /// The hot pink.
        /// </summary>
        public static readonly OxyColor HotPink = OxyColor.FromUInt32(0xFFFF69B4);

        /// <summary>
        /// The indian red.
        /// </summary>
        public static readonly OxyColor IndianRed = OxyColor.FromUInt32(0xFFCD5C5C);

        /// <summary>
        /// The indigo.
        /// </summary>
        public static readonly OxyColor Indigo = OxyColor.FromUInt32(0xFF4B0082);

        /// <summary>
        /// The ivory.
        /// </summary>
        public static readonly OxyColor Ivory = OxyColor.FromUInt32(0xFFFFFFF0);

        /// <summary>
        /// The khaki.
        /// </summary>
        public static readonly OxyColor Khaki = OxyColor.FromUInt32(0xFFF0E68C);

        /// <summary>
        /// The lavender.
        /// </summary>
        public static readonly OxyColor Lavender = OxyColor.FromUInt32(0xFFE6E6FA);

        /// <summary>
        /// The lavender blush.
        /// </summary>
        public static readonly OxyColor LavenderBlush = OxyColor.FromUInt32(0xFFFFF0F5);

        /// <summary>
        /// The lawn green.
        /// </summary>
        public static readonly OxyColor LawnGreen = OxyColor.FromUInt32(0xFF7CFC00);

        /// <summary>
        /// The lemon chiffon.
        /// </summary>
        public static readonly OxyColor LemonChiffon = OxyColor.FromUInt32(0xFFFFFACD);

        /// <summary>
        /// The light blue.
        /// </summary>
        public static readonly OxyColor LightBlue = OxyColor.FromUInt32(0xFFADD8E6);

        /// <summary>
        /// The light coral.
        /// </summary>
        public static readonly OxyColor LightCoral = OxyColor.FromUInt32(0xFFF08080);

        /// <summary>
        /// The light cyan.
        /// </summary>
        public static readonly OxyColor LightCyan = OxyColor.FromUInt32(0xFFE0FFFF);

        /// <summary>
        /// The light goldenrod yellow.
        /// </summary>
        public static readonly OxyColor LightGoldenrodYellow = OxyColor.FromUInt32(0xFFFAFAD2);

        /// <summary>
        /// The light gray.
        /// </summary>
        public static readonly OxyColor LightGray = OxyColor.FromUInt32(0xFFD3D3D3);

        /// <summary>
        /// The light green.
        /// </summary>
        public static readonly OxyColor LightGreen = OxyColor.FromUInt32(0xFF90EE90);

        /// <summary>
        /// The light pink.
        /// </summary>
        public static readonly OxyColor LightPink = OxyColor.FromUInt32(0xFFFFB6C1);

        /// <summary>
        /// The light salmon.
        /// </summary>
        public static readonly OxyColor LightSalmon = OxyColor.FromUInt32(0xFFFFA07A);

        /// <summary>
        /// The light sea green.
        /// </summary>
        public static readonly OxyColor LightSeaGreen = OxyColor.FromUInt32(0xFF20B2AA);

        /// <summary>
        /// The light sky blue.
        /// </summary>
        public static readonly OxyColor LightSkyBlue = OxyColor.FromUInt32(0xFF87CEFA);

        /// <summary>
        /// The light slate gray.
        /// </summary>
        public static readonly OxyColor LightSlateGray = OxyColor.FromUInt32(0xFF778899);

        /// <summary>
        /// The light steel blue.
        /// </summary>
        public static readonly OxyColor LightSteelBlue = OxyColor.FromUInt32(0xFFB0C4DE);

        /// <summary>
        /// The light yellow.
        /// </summary>
        public static readonly OxyColor LightYellow = OxyColor.FromUInt32(0xFFFFFFE0);

        /// <summary>
        /// The lime.
        /// </summary>
        public static readonly OxyColor Lime = OxyColor.FromUInt32(0xFF00FF00);

        /// <summary>
        /// The lime green.
        /// </summary>
        public static readonly OxyColor LimeGreen = OxyColor.FromUInt32(0xFF32CD32);

        /// <summary>
        /// The linen.
        /// </summary>
        public static readonly OxyColor Linen = OxyColor.FromUInt32(0xFFFAF0E6);

        /// <summary>
        /// The magenta.
        /// </summary>
        public static readonly OxyColor Magenta = OxyColor.FromUInt32(0xFFFF00FF);

        /// <summary>
        /// The maroon.
        /// </summary>
        public static readonly OxyColor Maroon = OxyColor.FromUInt32(0xFF800000);

        /// <summary>
        /// The medium aquamarine.
        /// </summary>
        public static readonly OxyColor MediumAquamarine = OxyColor.FromUInt32(0xFF66CDAA);

        /// <summary>
        /// The medium blue.
        /// </summary>
        public static readonly OxyColor MediumBlue = OxyColor.FromUInt32(0xFF0000CD);

        /// <summary>
        /// The medium orchid.
        /// </summary>
        public static readonly OxyColor MediumOrchid = OxyColor.FromUInt32(0xFFBA55D3);

        /// <summary>
        /// The medium purple.
        /// </summary>
        public static readonly OxyColor MediumPurple = OxyColor.FromUInt32(0xFF9370DB);

        /// <summary>
        /// The medium sea green.
        /// </summary>
        public static readonly OxyColor MediumSeaGreen = OxyColor.FromUInt32(0xFF3CB371);

        /// <summary>
        /// The medium slate blue.
        /// </summary>
        public static readonly OxyColor MediumSlateBlue = OxyColor.FromUInt32(0xFF7B68EE);

        /// <summary>
        /// The medium spring green.
        /// </summary>
        public static readonly OxyColor MediumSpringGreen = OxyColor.FromUInt32(0xFF00FA9A);

        /// <summary>
        /// The medium turquoise.
        /// </summary>
        public static readonly OxyColor MediumTurquoise = OxyColor.FromUInt32(0xFF48D1CC);

        /// <summary>
        /// The medium violet red.
        /// </summary>
        public static readonly OxyColor MediumVioletRed = OxyColor.FromUInt32(0xFFC71585);

        /// <summary>
        /// The midnight blue.
        /// </summary>
        public static readonly OxyColor MidnightBlue = OxyColor.FromUInt32(0xFF191970);

        /// <summary>
        /// The mint cream.
        /// </summary>
        public static readonly OxyColor MintCream = OxyColor.FromUInt32(0xFFF5FFFA);

        /// <summary>
        /// The misty rose.
        /// </summary>
        public static readonly OxyColor MistyRose = OxyColor.FromUInt32(0xFFFFE4E1);

        /// <summary>
        /// The moccasin.
        /// </summary>
        public static readonly OxyColor Moccasin = OxyColor.FromUInt32(0xFFFFE4B5);

        /// <summary>
        /// The navajo white.
        /// </summary>
        public static readonly OxyColor NavajoWhite = OxyColor.FromUInt32(0xFFFFDEAD);

        /// <summary>
        /// The navy.
        /// </summary>
        public static readonly OxyColor Navy = OxyColor.FromUInt32(0xFF000080);

        /// <summary>
        /// The old lace.
        /// </summary>
        public static readonly OxyColor OldLace = OxyColor.FromUInt32(0xFFFDF5E6);

        /// <summary>
        /// The olive.
        /// </summary>
        public static readonly OxyColor Olive = OxyColor.FromUInt32(0xFF808000);

        /// <summary>
        /// The olive drab.
        /// </summary>
        public static readonly OxyColor OliveDrab = OxyColor.FromUInt32(0xFF6B8E23);

        /// <summary>
        /// The orange.
        /// </summary>
        public static readonly OxyColor Orange = OxyColor.FromUInt32(0xFFFFA500);

        /// <summary>
        /// The orange red.
        /// </summary>
        public static readonly OxyColor OrangeRed = OxyColor.FromUInt32(0xFFFF4500);

        /// <summary>
        /// The orchid.
        /// </summary>
        public static readonly OxyColor Orchid = OxyColor.FromUInt32(0xFFDA70D6);

        /// <summary>
        /// The pale goldenrod.
        /// </summary>
        public static readonly OxyColor PaleGoldenrod = OxyColor.FromUInt32(0xFFEEE8AA);

        /// <summary>
        /// The pale green.
        /// </summary>
        public static readonly OxyColor PaleGreen = OxyColor.FromUInt32(0xFF98FB98);

        /// <summary>
        /// The pale turquoise.
        /// </summary>
        public static readonly OxyColor PaleTurquoise = OxyColor.FromUInt32(0xFFAFEEEE);

        /// <summary>
        /// The pale violet red.
        /// </summary>
        public static readonly OxyColor PaleVioletRed = OxyColor.FromUInt32(0xFFDB7093);

        /// <summary>
        /// The papaya whip.
        /// </summary>
        public static readonly OxyColor PapayaWhip = OxyColor.FromUInt32(0xFFFFEFD5);

        /// <summary>
        /// The peach puff.
        /// </summary>
        public static readonly OxyColor PeachPuff = OxyColor.FromUInt32(0xFFFFDAB9);

        /// <summary>
        /// The peru.
        /// </summary>
        public static readonly OxyColor Peru = OxyColor.FromUInt32(0xFFCD853F);

        /// <summary>
        /// The pink.
        /// </summary>
        public static readonly OxyColor Pink = OxyColor.FromUInt32(0xFFFFC0CB);

        /// <summary>
        /// The plum.
        /// </summary>
        public static readonly OxyColor Plum = OxyColor.FromUInt32(0xFFDDA0DD);

        /// <summary>
        /// The powder blue.
        /// </summary>
        public static readonly OxyColor PowderBlue = OxyColor.FromUInt32(0xFFB0E0E6);

        /// <summary>
        /// The purple.
        /// </summary>
        public static readonly OxyColor Purple = OxyColor.FromUInt32(0xFF800080);

        /// <summary>
        /// The red.
        /// </summary>
        public static readonly OxyColor Red = OxyColor.FromUInt32(0xFFFF0000);

        /// <summary>
        /// The rosy brown.
        /// </summary>
        public static readonly OxyColor RosyBrown = OxyColor.FromUInt32(0xFFBC8F8F);

        /// <summary>
        /// The royal blue.
        /// </summary>
        public static readonly OxyColor RoyalBlue = OxyColor.FromUInt32(0xFF4169E1);

        /// <summary>
        /// The saddle brown.
        /// </summary>
        public static readonly OxyColor SaddleBrown = OxyColor.FromUInt32(0xFF8B4513);

        /// <summary>
        /// The salmon.
        /// </summary>
        public static readonly OxyColor Salmon = OxyColor.FromUInt32(0xFFFA8072);

        /// <summary>
        /// The sandy brown.
        /// </summary>
        public static readonly OxyColor SandyBrown = OxyColor.FromUInt32(0xFFF4A460);

        /// <summary>
        /// The sea green.
        /// </summary>
        public static readonly OxyColor SeaGreen = OxyColor.FromUInt32(0xFF2E8B57);

        /// <summary>
        /// The sea shell.
        /// </summary>
        public static readonly OxyColor SeaShell = OxyColor.FromUInt32(0xFFFFF5EE);

        /// <summary>
        /// The sienna.
        /// </summary>
        public static readonly OxyColor Sienna = OxyColor.FromUInt32(0xFFA0522D);

        /// <summary>
        /// The silver.
        /// </summary>
        public static readonly OxyColor Silver = OxyColor.FromUInt32(0xFFC0C0C0);

        /// <summary>
        /// The sky blue.
        /// </summary>
        public static readonly OxyColor SkyBlue = OxyColor.FromUInt32(0xFF87CEEB);

        /// <summary>
        /// The slate blue.
        /// </summary>
        public static readonly OxyColor SlateBlue = OxyColor.FromUInt32(0xFF6A5ACD);

        /// <summary>
        /// The slate gray.
        /// </summary>
        public static readonly OxyColor SlateGray = OxyColor.FromUInt32(0xFF708090);

        /// <summary>
        /// The snow.
        /// </summary>
        public static readonly OxyColor Snow = OxyColor.FromUInt32(0xFFFFFAFA);

        /// <summary>
        /// The spring green.
        /// </summary>
        public static readonly OxyColor SpringGreen = OxyColor.FromUInt32(0xFF00FF7F);

        /// <summary>
        /// The steel blue.
        /// </summary>
        public static readonly OxyColor SteelBlue = OxyColor.FromUInt32(0xFF4682B4);

        /// <summary>
        /// The tan.
        /// </summary>
        public static readonly OxyColor Tan = OxyColor.FromUInt32(0xFFD2B48C);

        /// <summary>
        /// The teal.
        /// </summary>
        public static readonly OxyColor Teal = OxyColor.FromUInt32(0xFF008080);

        /// <summary>
        /// The thistle.
        /// </summary>
        public static readonly OxyColor Thistle = OxyColor.FromUInt32(0xFFD8BFD8);

        /// <summary>
        /// The tomato.
        /// </summary>
        public static readonly OxyColor Tomato = OxyColor.FromUInt32(0xFFFF6347);

        /// <summary>
        /// The transparent.
        /// </summary>
        public static readonly OxyColor Transparent = OxyColor.FromUInt32(0x00FFFFFF);

        /// <summary>
        /// The turquoise.
        /// </summary>
        public static readonly OxyColor Turquoise = OxyColor.FromUInt32(0xFF40E0D0);

        /// <summary>
        /// The violet.
        /// </summary>
        public static readonly OxyColor Violet = OxyColor.FromUInt32(0xFFEE82EE);

        /// <summary>
        /// The wheat.
        /// </summary>
        public static readonly OxyColor Wheat = OxyColor.FromUInt32(0xFFF5DEB3);

        /// <summary>
        /// The white.
        /// </summary>
        public static readonly OxyColor White = OxyColor.FromUInt32(0xFFFFFFFF);

        /// <summary>
        /// The white smoke.
        /// </summary>
        public static readonly OxyColor WhiteSmoke = OxyColor.FromUInt32(0xFFF5F5F5);

        /// <summary>
        /// The yellow.
        /// </summary>
        public static readonly OxyColor Yellow = OxyColor.FromUInt32(0xFFFFFF00);

        /// <summary>
        /// The yellow green.
        /// </summary>
        public static readonly OxyColor YellowGreen = OxyColor.FromUInt32(0xFF9ACD32);

    }
}