'''
Defines global constants.

@var MODE_FOCUS: Requests will be relative to the OS focus
@type MODE_FOCUS: integer
@var MODE_POINTER: Requests will be relative to the LSR focus
@type MODE_POINTER: integer
@var MODE_EVENT: Requests will be relative to the last event L{POR}
@type MODE_EVENT: integer
@var FORMAT_TEXT: Characters of a L{Task.Tools.Word} will be output without 
  additional spelling
@type FORMAT_TEXT: integer
@var FORMAT_PRONOUNCE: Punctuation characters will be spelled using the default 
  spelling table
@type FORMAT_PRONOUNCE: integer
@var FORMAT_SPELL: All characters in a L{Task.Tools.Word} will be spelled
@type FORMAT_SPELL: integer
@var FORMAT_PHONETIC: All characters in a L{Task.Tools.Word} will be spelled 
  using a phonetic spelling table
@type FORMAT_PHONETIC: integer
@var WORD_NON_BLANK: Definition indicating all non-blank characters should be 
  considered the main part of a word
@type WORD_NON_BLANK: integer
@var WORD_ALPHABETIC: Definition indicating all letters should be considered the
  main part of a word
@type WORD_ALPHABETIC: integer
@var WORD_ALPHA_NUMERIC: Definition indicating all letters and numbers should be
  considered the main part of a word
@type WORD_ALPHA_NUMERIC: integer
@var WORD_ALPHA_PUNCT: Definition indicating all letters and punctuation should
  be considered the main part of a word
@type WORD_ALPHA_PUNCT: integer
@var WORD_ALPHA_NUMERIC_PUNCT: Definition indicating all letters, numbers, and
  punctuation should be considered the main part of a word
@type WORD_ALPHA_NUMERIC_PUNCT: integer
@var COLOR_MAP: Mapping from a six bit palette of colors to names describing
  them
@type COLOR_MAP: dictionary

@author: Pete Brunet
@author: Peter Parente
@author: Brett Clippingdale
@organization: IBM Corporation
@copyright: Copyright (c) 2005 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''

import os
from i18n import *

# LSR version numbers
LSR_VERSION = '0.2.0'
LSR_DATE = '2006/05/19'

# name, version, copyright and license notice to print on startup
NAME = 'Linux Screen Reader %s %s' % (LSR_VERSION, LSR_DATE)
COPYRIGHT = 'Copyright (c) 2006 IBM Corporation'
LICENSE = 'All rights reserved. This program and the accompanying ' \
        'materials are made available under the terms of the Common Public ' \
        'License v1.0 which accompanies this distribution, and is available ' \
        'at http://www.opensource.org/licenses/cpl1.0.php'

# LSR home directories
HOME_USER = os.path.join(os.environ['HOME'], '.lsr')
HOME_LSR = os.path.dirname(__file__)

# LSR templates directory
TEMPLATES = os.path.join(HOME_LSR, 'Templates')

# constants for POR mode (focus/pointer/event)
MODE_FOCUS = 0
MODE_POINTER = 1
MODE_EVENT = 2

# constants for State.Format
FORMAT_TEXT = 0
FORMAT_PRONOUNCE = 1
FORMAT_SPELL = 2
FORMAT_PHONETIC = 3

# constants for State.WordDef
WORD_NON_BLANK = 0
WORD_ALPHABETIC = 1
WORD_ALPHA_NUMERIC = 2
WORD_ALPHA_PUNCT = 3
WORD_ALPHA_NUMERIC_PUNCT = 4

# constants for icons, markers, and null
CHAR_NULL = 0
CHAR_ICON = 1
CHAR_VALUE_CHANGER = 2
CHAR_TABLE_CELL = 3
CHAR_PROXY = 4

COLOR_MAP = { 0:_('black'), 1:_('dark purple'), 2:_('dark blue'), 3:_('blue'), 
              4:_('dark green'), 5:_('dark cyan'), 6:_('aqua'), 
              7:_('medium blue'), 8:_('dark green'), 9:_('lime green'), 
              10:_('dark cyan'), 11:_('aqua'), 12:_('green'), 
              13:_('bright green'), 14:_('blue green'), 15:_('cyan'),
              16:_('dark red'), 17:_('magenta'), 18:_('purple'), 19:_('purple'), 
              20:_('olive green'), 21:_('medium grey'), 22:_('steel blue'),
              23:_('blue grey'), 24:_('green'), 25:_('pale green'), 
              26:_('blue grey'), 27:_('light blue'), 28:_('light green'), 
              29:_('light green'), 30:_('cyan'), 31:_('light blue'), 
              32:_('dark red'), 33:_('magenta'), 34:_('dark pink'),
              35:_('purple'), 36:_('light brown'), 37:_('flesh'), 38:_('pink'), 
              39:_('light purple'), 40:_('olive green'), 41:_('light grey'),
              42:_('dark grey'), 43:_('light blue'), 44:_('light green'), 
              45:_('pale green'), 46:_('pale green'), 47:_('light blue'), 
              48:_('red'), 49:_('pink'), 50:_('pink'), 51:_('pink'), 
              52:_('orange'), 53:_('peuce'), 54:_('pink'), 55:_('pink'), 
              56:_('dark yellow'), 57:_('tan'), 58:_('light pink'), 
              59:_('light pink'), 60:_('yellow'), 61:_('pale yellow'), 
              62:_('off white'), 63:_('white') }


#def getColorMap(self):
  #'''
  #Can be used to read/parse an arbitrary tab-delimited color map file, such as
  #the one included in most linux distros (incl FC/RHEL): /usr/share/X11/rgb.txt
  #'''
  #colors = {}
  ##try:
  #filename = "data/larry_colors.txt"
  #try:
    ## open file
    #file = open(filename, "r")
    ## read, parse, and create color map
    #for line in file:
      #key, val = line.split('\t')
      #colors[key] = val.strip()
  #except IOError, io_err:
    #print "I/O error:", io_err
  #except Exception, err:
    #print "Unexpected error:", err
  #file.close()
  #return colors
