'''
Defines the user interface for gaim.

@author: Brett Clippingdale
@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
import Perk, Task

class MetacityPerk(Perk.Perk):
  '''
  Creates and registers L{Task}s to improve the user interface for Metacity.
  '''
  def init(self):
    '''   
    Registers to receive property change events from the little status bar
    containing the name of the currently selected window in the application or 
    workspace switcher.
    '''
    # register event handlers
    self.registerEventTask(HandlePropertyChange(self), tier=True)

    
class HandlePropertyChange(Task.PropertyTask):
  '''  
  Task that handles a L{AEEvent.PropertyChange}.
  '''  
  def execute(self, por, name, value, **kwargs):
    '''
    Announces alt-tab application switching.
    '''
    text = self.getItemText(por)  # get the selected text
    self.stopNow()
    self.say(text)
    return True

