/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

/*
 *  Medusa
 * 
 *  Copyright (C) 1999, 2000 Eazel, Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Rebecca Schulman <rebecka@eazel.com>
 */

/* medusa-rdb-table-async.c:  Functions that do database
   selects asynchronously */

#include <medusa-rdb-table-async.h>



/* This function sends its results to present results as they are created */
void
medusa_rdb_table_select_cancellable (MedusaRDBTable *table,
					    MedusaRDBQuery *query,
					    MedusaSelectKey *key,
					    int number_of_records_to_check_per_interval,
					    MedusaPresentResultsFunc present_results,
					    MedusaCancellationFunc cancelled)
{
  MedusaRDBTable *results;
  MedusaRDBRecordNumbers *record_list;
  int records_checked;

  results = g_new0 (MedusaRDBTable, 1);
  results->file = table->file;
  results->number_of_records = 0;

  if (table->number_of_records == 0) {
    present_results (results, key, NULL);
  }
  /* Now go through n results */

  for (record_list = table->first_record, records_checked = 0;
       record_list->next != NULL; 
       record_list = record_list->next, records_checked++) {
    if ((records_checked % number_of_records_to_check_per_interval) == 0) {
      /* Check if the process has been told to stop,
	 and if so, return what we have gotten so far */
      present_results (results, key, NULL);
      medusa_rdb_table_virtual_free (results);
      if (cancelled (results, key, NULL)) {
	return;
      }
      results = g_new0 (MedusaRDBTable, 1);
      results->file = table->file;
      results->number_of_records = 0;
      
    }
    
    if (medusa_rdb_query_match (query,
				medusa_rdb_record_number_to_record
				(table,
				 *(MedusaRDBRecordNumber *) record_list->data),
				table->file->field_info)) {
	    medusa_rdb_table_virtual_insert_record (results,
							   *(MedusaRDBRecordNumber *) record_list->data);
    }
    
  }
	 
}



