/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

/*
 *  Medusa
 *
 *  Copyright (C) 2000 Eazel, Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Rebecca Schulman <rebecka@eazel.com>
 */

/* medusa-rdb-table-async.h:  the api for doing nondestructive
 database operations asynchronously */

#ifndef MEDUSA_RDB_TABLE_ASYNC_H
#define MEDUSA_RDB_TABLE_ASYNC_H

#include <medusa-rdb-table-private.h>

typedef struct MedusaAsyncSelectResults MedusaAsyncSelectResults;

typedef struct MedusaSelectKey {
  MedusaRDBQuery *query;
  int uid;
  int pid;
  int cookie;
}  MedusaSelectKey;
  

typedef gboolean (* MedusaPresentResultsFunc)            (MedusaRDBTable *results,
							  MedusaSelectKey *key,
							  gpointer data);
typedef gboolean (* MedusaCancellationFunc)              (MedusaRDBTable *results,
							  MedusaSelectKey *key,
							  gpointer data);


void          medusa_rdb_table_select_cancellable         (MedusaRDBTable *table,
							   MedusaRDBQuery *query,
							   MedusaSelectKey *key,
							   int number_of_records_to_check_per_interval,
							   MedusaPresentResultsFunc present_results,
							   MedusaCancellationFunc cancelled);

#endif /* MEDUSA_RDB_TABLE_ASYNC_H */
